/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.crafting;

import java.util.ArrayList;
import java.util.HashMap;
import mod.chiselsandbits.ChiselsAndBits;
import mod.chiselsandbits.bitbag.BagInventory;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseled;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.items.ItemChisel;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ChiselCrafting
implements IRecipe {
    private CCReq getCraftingReqs(InventoryCrafting inv, boolean copy) {
        ItemStack pattern = null;
        for (int x = 0; x < inv.func_70302_i_(); ++x) {
            ItemStack is = inv.func_70301_a(x);
            if (is == null) continue;
            if (is.func_77973_b() == ChiselsAndBits.instance.itemPositiveprint && pattern == null) {
                pattern = is;
                continue;
            }
            if (is.func_77973_b() == ChiselsAndBits.instance.itemBitBag || is.func_77973_b() == ChiselsAndBits.instance.itemBlockBit) continue;
            return null;
        }
        if (pattern == null || !pattern.func_77942_o()) {
            return null;
        }
        CCReq r = new CCReq((IInventory)inv, pattern, copy);
        if (r.isValid()) {
            return r;
        }
        return null;
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        return this.getCraftingReqs(inv, true) != null;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        CCReq req = this.getCraftingReqs(inv, true);
        if (req != null) {
            return ChiselsAndBits.instance.itemPositiveprint.getPatternedItem(req.pattern);
        }
        return null;
    }

    public int func_77570_a() {
        return 9;
    }

    public ItemStack func_77571_b() {
        return null;
    }

    public ItemStack[] func_179532_b(InventoryCrafting inv) {
        ItemStack[] out = new ItemStack[inv.func_70302_i_()];
        CCReq r = this.getCraftingReqs(inv, false);
        if (inv.func_70302_i_() != r.pile.length) {
            throw new RuntimeException("Inventory Changed Size!");
        }
        for (int x = 0; x < r.pile.length; ++x) {
            out[x] = r.pile[x];
            if (out[x] == null || out[x].field_77994_a > 0) continue;
            out[x] = null;
        }
        return out;
    }

    class CCReq {
        private final NBTTagCompound patternTag;
        private final ItemStack pattern;
        private final VoxelBlob voxelBlob;
        private Boolean isValid = null;
        private final ItemStack[] pile;
        private final ArrayList<ItemStack> stacks = new ArrayList();
        private final ArrayList<BagInventory> bags = new ArrayList();

        public CCReq(IInventory inv, ItemStack pattern, boolean copy) {
            this.pile = new ItemStack[inv.func_70302_i_()];
            this.pattern = pattern;
            this.patternTag = pattern.func_77978_p();
            for (int x = 0; x < inv.func_70302_i_(); ++x) {
                ItemStack is;
                this.pile[x] = is = inv.func_70301_a(x);
                if (!copy) {
                    inv.func_70299_a(x, null);
                }
                if (is == null) continue;
                if (is.func_77973_b() == ChiselsAndBits.instance.itemBitBag) {
                    this.bags.add(new BagInventory(copy ? is.func_77946_l() : is));
                }
                if (is.func_77973_b() != ChiselsAndBits.instance.itemBlockBit) continue;
                this.stacks.add(copy ? is.func_77946_l() : is);
            }
            TileEntityBlockChiseled tec = new TileEntityBlockChiseled();
            tec.readChisleData(this.patternTag);
            this.voxelBlob = tec.getBlob();
        }

        public boolean isValid() {
            if (this.isValid != null) {
                return this.isValid;
            }
            HashMap<Integer, VoxelBlob.IntegerRef> count = this.voxelBlob.getBlockCounts();
            this.isValid = true;
            for (VoxelBlob.IntegerRef ref : count.values()) {
                if (ref.ref == 0) continue;
                for (ItemStack is : this.stacks) {
                    if (ItemChisel.getStackState(is) != ref.ref || is.field_77994_a <= 0) continue;
                    int original = is.field_77994_a;
                    is.field_77994_a = Math.max(0, is.field_77994_a - ref.total);
                    ref.total -= original - is.field_77994_a;
                }
                for (BagInventory bag : this.bags) {
                    ref.total -= bag.extractBit(ref.ref, ref.total);
                }
                if (ref.total <= 0) continue;
                this.isValid = false;
                break;
            }
            return this.isValid;
        }
    }
}

