/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseledblock.data;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.chiseledblock.data.VoxelBlobStateRef;

public class VoxelBlobState
implements Comparable<VoxelBlobState> {
    private static WeakHashMap<VoxelBlobStateRef, WeakReference<VoxelBlobStateRef>> refs = new WeakHashMap();
    private final VoxelBlobStateRef data;
    public final long weight;
    WeakReference<VoxelBlob> blob;

    private static VoxelBlobStateRef FindRef(byte[] v) {
        VoxelBlobStateRef t = new VoxelBlobStateRef(v);
        VoxelBlobStateRef ref = null;
        WeakReference<VoxelBlobStateRef> original = refs.get(t);
        if (original != null) {
            ref = (VoxelBlobStateRef)original.get();
        }
        if (ref == null) {
            ref = t;
            refs.put(t, new WeakReference<VoxelBlobStateRef>(t));
        }
        return ref;
    }

    public byte[] getByteArray() {
        return this.data.v;
    }

    public VoxelBlobState(VoxelBlob blob, long weight) {
        this(blob.toByteArray(), weight);
    }

    public VoxelBlobState(byte[] v, long weight) {
        this.data = VoxelBlobState.FindRef(v);
        this.weight = weight;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof VoxelBlobState)) {
            return false;
        }
        VoxelBlobState second = (VoxelBlobState)obj;
        return this.data.equals(second.data) && second.weight == this.weight;
    }

    public int hashCode() {
        return this.data.hash ^ (int)(this.weight ^ this.weight >>> 32);
    }

    @Override
    public int compareTo(VoxelBlobState o) {
        int comp = this.data.compareTo(o.data);
        if (comp == 0) {
            if (this.weight == o.weight) {
                return 0;
            }
            return this.weight < o.weight ? -1 : 1;
        }
        return comp;
    }

    public VoxelBlob getVoxelBlob() {
        try {
            VoxelBlob vb;
            VoxelBlob voxelBlob = vb = this.blob == null ? null : (VoxelBlob)this.blob.get();
            if (vb == null) {
                vb = new VoxelBlob();
                vb.fromByteArray(this.getByteArray());
                this.blob = new WeakReference<VoxelBlob>(vb);
            }
            return new VoxelBlob(vb);
        }
        catch (IOException e) {
            return null;
        }
    }
}

