/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseledblock.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import mod.chiselsandbits.ChiselsAndBits;
import mod.chiselsandbits.chiseledblock.data.IntegerBox;
import mod.chiselsandbits.helpers.LocalStrings;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class VoxelBlob {
    public static final int dim = 16;
    public static final int dim2 = 256;
    public static final int full_size = 4096;
    public static final int dim_minus_one = 15;
    private static final int array_size = 4096;
    private final int[] values = new int[4096];
    public int detail = 16;
    static final int SHORT_BYTES = 2;

    public VoxelBlob() {
    }

    public VoxelBlob(VoxelBlob vb) {
        for (int x = 0; x < this.values.length; ++x) {
            this.values[x] = vb.values[x];
        }
    }

    public boolean canMerge(VoxelBlob second) {
        for (int z = 0; z < 16; ++z) {
            for (int y = 0; y < 16; ++y) {
                for (int x = 0; x < 16; ++x) {
                    if (this.get(x, y, z) == 0 || second.get(x, y, z) == 0) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public VoxelBlob merge(VoxelBlob second) {
        VoxelBlob out = new VoxelBlob();
        for (int z = 0; z < 16; ++z) {
            for (int y = 0; y < 16; ++y) {
                for (int x = 0; x < 16; ++x) {
                    int a = this.get(x, y, z);
                    if (a == 0) {
                        out.set(x, y, z, second.get(x, y, z));
                        continue;
                    }
                    out.set(x, y, z, a);
                }
            }
        }
        return out;
    }

    public BlockPos getCenter() {
        boolean found = false;
        int min_x = 0;
        int min_y = 0;
        int min_z = 0;
        int max_x = 0;
        int max_y = 0;
        int max_z = 0;
        for (int z = 0; z < 16; ++z) {
            for (int y = 0; y < 16; ++y) {
                for (int x = 0; x < 16; ++x) {
                    if (this.get(x, y, z) == 0) continue;
                    if (found) {
                        min_x = Math.min(min_x, x);
                        min_y = Math.min(min_y, y);
                        min_z = Math.min(min_z, z);
                        max_x = Math.max(max_x, x);
                        max_y = Math.max(max_y, y);
                        max_z = Math.max(max_z, z);
                        continue;
                    }
                    found = true;
                    min_x = x;
                    min_y = y;
                    min_z = z;
                    max_x = x;
                    max_y = y;
                    max_z = z;
                }
            }
        }
        return found ? new BlockPos((min_x + max_x) / 2, (min_y + max_y) / 2, (min_z + max_z) / 2) : null;
    }

    public IntegerBox getBounds() {
        boolean found = false;
        int min_x = 0;
        int min_y = 0;
        int min_z = 0;
        int max_x = 0;
        int max_y = 0;
        int max_z = 0;
        for (int z = 0; z < 16; ++z) {
            for (int y = 0; y < 16; ++y) {
                for (int x = 0; x < 16; ++x) {
                    if (this.get(x, y, z) == 0) continue;
                    if (found) {
                        min_x = Math.min(min_x, x);
                        min_y = Math.min(min_y, y);
                        min_z = Math.min(min_z, z);
                        max_x = Math.max(max_x, x + 1);
                        max_y = Math.max(max_y, y + 1);
                        max_z = Math.max(max_z, z + 1);
                        continue;
                    }
                    found = true;
                    min_x = x;
                    min_y = y;
                    min_z = z;
                    max_x = x + 1;
                    max_y = y + 1;
                    max_z = z + 1;
                }
            }
        }
        return found ? new IntegerBox(min_x, min_y, min_z, max_x, max_y, max_z) : null;
    }

    public VoxelBlob flip(BlockLog.EnumAxis axis) {
        VoxelBlob d = new VoxelBlob();
        for (int z = 0; z < 16; ++z) {
            for (int y = 0; y < 16; ++y) {
                block7: for (int x = 0; x < 16; ++x) {
                    switch (axis) {
                        case X: {
                            d.set(15 - x, y, z, this.get(x, y, z));
                            continue block7;
                        }
                        case Y: {
                            d.set(x, 15 - y, z, this.get(x, y, z));
                            continue block7;
                        }
                        case Z: {
                            d.set(x, y, 15 - z, this.get(x, y, z));
                        }
                        default: {
                            throw new NullPointerException();
                        }
                    }
                }
            }
        }
        return d;
    }

    public VoxelBlob spin(EnumFacing.Axis axis) {
        VoxelBlob d = new VoxelBlob();
        for (int z = 0; z < 16; ++z) {
            for (int y = 0; y < 16; ++y) {
                block7: for (int x = 0; x < 16; ++x) {
                    switch (axis) {
                        case X: {
                            d.set(x, 15 - z, y, this.get(x, y, z));
                            continue block7;
                        }
                        case Y: {
                            d.set(z, y, 15 - x, this.get(x, y, z));
                            continue block7;
                        }
                        case Z: {
                            d.set(15 - y, x, z, this.get(x, y, z));
                            continue block7;
                        }
                        default: {
                            throw new NullPointerException();
                        }
                    }
                }
            }
        }
        return d;
    }

    public void fill(int value) {
        for (int x = 0; x < 4096; ++x) {
            this.values[x] = value;
        }
    }

    public void clear() {
        this.fill(0);
    }

    public int air() {
        int p = 0;
        for (int x = 0; x < 4096; ++x) {
            if (this.values[x] != 0) continue;
            ++p;
        }
        return p;
    }

    public void binaryReplacement(int airReplacement, int solidReplacement) {
        for (int x = 0; x < 4096; ++x) {
            this.values[x] = this.values[x] == 0 ? airReplacement : solidReplacement;
        }
    }

    public int light() {
        int p = 0;
        HashMap<Integer, IntegerRef> count = new HashMap<Integer, IntegerRef>();
        for (int x = 0; x < 4096; ++x) {
            int ref = this.values[x];
            IntegerRef tf = (IntegerRef)count.get(ref);
            if (tf == null) {
                IBlockState state = Block.func_176220_d((int)ref);
                int l = 0;
                if (state != null) {
                    l = state.func_177230_c().func_149750_m();
                }
                tf = new IntegerRef(ref, l);
                count.put(ref, tf);
            }
            p += tf.total;
        }
        return p;
    }

    public int solid() {
        int p = 0;
        for (int x = 0; x < 4096; ++x) {
            if (this.values[x] == 0) continue;
            ++p;
        }
        return p;
    }

    private int getBit(int offset) {
        return this.values[offset];
    }

    private void putBit(int offset, int newValue) {
        this.values[offset] = newValue;
    }

    public int get(int x, int y, int z) {
        return this.getBit(x | y << 4 | z << 8);
    }

    public void set(int x, int y, int z, int value) {
        this.putBit(x | y << 4 | z << 8, value);
    }

    public void clear(int x, int y, int z) {
        this.putBit(x | y << 4 | z << 8, 0);
    }

    public void read(ByteArrayInputStream o) throws IOException {
        GZIPInputStream w = new GZIPInputStream(o);
        DataInputStream dio = new DataInputStream(w);
        for (int x = 0; x < 4096; ++x) {
            this.values[x] = dio.readShort();
        }
        w.close();
    }

    public void write(ByteArrayOutputStream o) {
        try {
            GZIPOutputStream w = new GZIPOutputStream(o);
            DataOutputStream dio = new DataOutputStream(w);
            for (int x = 0; x < 4096; ++x) {
                dio.writeShort(this.values[x]);
            }
            dio.close();
            w.finish();
            w.close();
            o.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.write(out);
        return out.toByteArray();
    }

    public void fromByteArray(byte[] i) throws IOException {
        ByteArrayInputStream out = new ByteArrayInputStream(i);
        this.read(out);
    }

    public int getSafe(int x, int y, int z) {
        if (x >= 0 && x < 16 && y >= 0 && y < 16 && z >= 0 && z < 16) {
            return this.get(x, y, z);
        }
        return 0;
    }

    public void visibleFace(EnumFacing face, int x, int y, int z, VisibleFace dest) {
        int solid;
        dest.state = solid = this.get(x, y, z);
        if ((x += face.func_82601_c()) >= 0 && x < 16 && (y += face.func_96559_d()) >= 0 && y < 16 && (z += face.func_82599_e()) >= 0 && z < 16) {
            dest.isEdge = false;
            dest.visibleFace = solid != 0 && this.get(x, y, z) == 0;
        } else {
            dest.isEdge = true;
            dest.visibleFace = solid != 0;
        }
    }

    public HashMap<Integer, IntegerRef> getBlockCounts() {
        HashMap<Integer, IntegerRef> count = new HashMap<Integer, IntegerRef>();
        for (int x = 0; x < 4096; ++x) {
            int ref = this.values[x];
            IntegerRef tf = count.get(ref);
            if (tf == null) {
                count.put(ref, new IntegerRef(ref, 1));
                continue;
            }
            ++tf.total;
        }
        return count;
    }

    public CommonBlock mostCommonBlock() {
        HashMap<Integer, IntegerRef> count = this.getBlockCounts();
        IntegerRef out = new IntegerRef(0, 0);
        for (IntegerRef r : count.values()) {
            if (r.total <= out.total || r.ref == 0) continue;
            out = r;
        }
        CommonBlock cb = new CommonBlock();
        cb.ref = out.ref;
        cb.isFull = out.total == 4096;
        return cb;
    }

    public float getLight() {
        float light_size = ChiselsAndBits.instance.config.bitLightPercentage * 4096.0f * 15.0f / 100.0f;
        float o = (float)this.light() / light_size;
        return o;
    }

    public float getOpacity() {
        float o = (float)this.solid() / 4096.0f;
        return o;
    }

    public VoxelBlob offset(int xx, int yy, int zz) {
        VoxelBlob out = new VoxelBlob();
        for (int z = 0; z < 16; ++z) {
            for (int y = 0; y < 16; ++y) {
                for (int x = 0; x < 16; ++x) {
                    out.set(x, y, z, this.getSafe(x - xx, y - yy, z - zz));
                }
            }
        }
        return out;
    }

    @SideOnly(value=Side.CLIENT)
    public void listContents(List<String> details) {
        HashMap<Integer, Integer> states = new HashMap<Integer, Integer>();
        HashMap<String, Integer> contents = new HashMap<String, Integer>();
        for (int z = 0; z < 16; ++z) {
            for (int y = 0; y < 16; ++y) {
                for (int x = 0; x < 16; ++x) {
                    int state = this.get(x, y, z);
                    if (state == 0) continue;
                    Integer count = (Integer)states.get(state);
                    if (count == null) {
                        count = 1;
                    } else {
                        Integer n = count;
                        Integer n2 = count = Integer.valueOf(count + 1);
                    }
                    states.put(state, count);
                }
            }
        }
        for (Map.Entry e : states.entrySet()) {
            Item what;
            Block blk;
            IBlockState state = Block.func_176220_d((int)((Integer)e.getKey()));
            if (state == null || (blk = state.func_177230_c()) == null || (what = Item.func_150898_a((Block)blk)) == null) continue;
            String name = what.func_77653_i(new ItemStack(what, 1, blk.func_176201_c(state)));
            Integer count = (Integer)contents.get(name);
            count = count == null ? (Integer)e.getValue() : Integer.valueOf(count + (Integer)e.getValue());
            contents.put(name, count);
        }
        if (contents.isEmpty()) {
            details.add(LocalStrings.Empty.getLocal());
        }
        for (Map.Entry e : contents.entrySet()) {
            details.add(e.getValue() + ' ' + (String)e.getKey());
        }
    }

    public int getSideFlags(int minRange, int maxRange, int totalRequired) {
        int output = 0;
        for (EnumFacing face : EnumFacing.field_82609_l) {
            int edge = face.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? 15 : 0;
            int required = totalRequired;
            switch (face.func_176740_k()) {
                case X: {
                    int z;
                    for (z = minRange; z <= maxRange; ++z) {
                        for (int y = minRange; y <= maxRange; ++y) {
                            if (this.get(edge, y, z) == 0) continue;
                            --required;
                        }
                    }
                    break;
                }
                case Y: {
                    int x;
                    int z;
                    for (z = minRange; z <= maxRange; ++z) {
                        for (x = minRange; x <= maxRange; ++x) {
                            if (this.get(x, edge, z) == 0) continue;
                            --required;
                        }
                    }
                    break;
                }
                case Z: {
                    int x;
                    for (int y = minRange; y <= maxRange; ++y) {
                        for (x = minRange; x <= maxRange; ++x) {
                            if (this.get(x, y, edge) == 0) continue;
                            --required;
                        }
                    }
                    break;
                }
                default: {
                    throw new NullPointerException();
                }
            }
            if (required > 0) continue;
            output |= 1 << face.ordinal();
        }
        return output;
    }

    public boolean filter(EnumWorldBlockLayer layer) {
        HashMap<Integer, Boolean> filterState = new HashMap<Integer, Boolean>();
        boolean hasValues = false;
        for (int x = 0; x < 4096; ++x) {
            int ref = this.values[x];
            Boolean state = (Boolean)filterState.get(ref);
            if (state == null) {
                state = this.inLayer(layer, ref);
                filterState.put(ref, state);
                boolean bl = hasValues = hasValues || state != false;
            }
            if (state.booleanValue()) continue;
            this.values[x] = 0;
        }
        return hasValues;
    }

    private Boolean inLayer(EnumWorldBlockLayer layer, int ref) {
        IBlockState state = Block.func_176220_d((int)ref);
        return state.func_177230_c().canRenderInLayer(layer);
    }

    public static class CommonBlock {
        public int ref;
        public boolean isFull;
    }

    public static class IntegerRef {
        public final int ref;
        public int total;

        public IntegerRef(int ref, int total) {
            this.ref = ref;
            this.total = total;
        }
    }

    public static class VisibleFace {
        public boolean isEdge;
        public boolean visibleFace;
        public int state;
    }
}

