/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseledblock;

import java.lang.ref.WeakReference;
import mod.chiselsandbits.ChiselsAndBits;
import mod.chiselsandbits.chiseledblock.BlockChiseled;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.chiseledblock.data.VoxelBlobState;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.render.BlockChisled.ChisledBlockSmartModel;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityBlockChiseled
extends TileEntity {
    public static final String block_prop = "b";
    public static final String side_prop = "s";
    public static final String voxel_prop = "v";
    public static final String light_opacity_prop = "l";
    public static final String light_prop = "lv";
    private IExtendedBlockState state;
    WeakReference<VoxelBlob> blob;

    public IExtendedBlockState getState() {
        if (this.state == null) {
            return (IExtendedBlockState)ChiselsAndBits.instance.getChiseledDefaultState();
        }
        return this.state;
    }

    public Block getBlock(Block alternative) {
        IBlockState state;
        Integer stateID = (Integer)this.getState().getValue(BlockChiseled.block_prop);
        if (stateID != null && (state = Block.func_176220_d((int)stateID)) != null) {
            return state.func_177230_c();
        }
        return alternative;
    }

    public IBlockState getParticleBlockState(Block alternative) {
        IBlockState state = Block.func_176220_d((int)((Integer)this.getState().getValue(BlockChiseled.block_prop)));
        if (state != null) {
            return state;
        }
        return alternative.func_176223_P();
    }

    public void setState(IExtendedBlockState state) {
        this.state = state;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.writeChisleData(nbttagcompound);
        if (nbttagcompound.func_82582_d()) {
            return null;
        }
        return new S35PacketUpdateTileEntity(this.field_174879_c, 255, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.readChisleData(pkt.func_148857_g());
        if (this.field_145850_b != null) {
            this.field_145850_b.func_175689_h(this.field_174879_c);
        }
    }

    public final void writeChisleData(NBTTagCompound compound) {
        Integer b = (Integer)this.getState().getValue(BlockChiseled.block_prop);
        Integer s = (Integer)this.getState().getValue(BlockChiseled.side_prop);
        Float l = (Float)this.getState().getValue(BlockChiseled.opacity_prop);
        Integer lv = (Integer)this.getState().getValue(BlockChiseled.light_prop);
        VoxelBlobState vbs = (VoxelBlobState)this.getState().getValue(BlockChiseled.v_prop);
        if (b == null || vbs == null) {
            return;
        }
        if (b != null && vbs != null) {
            compound.func_74776_a(light_opacity_prop, l == null ? 1.0f : l.floatValue());
            compound.func_74768_a(light_prop, lv == null ? 0 : lv);
            compound.func_74768_a(block_prop, b.intValue());
            compound.func_74768_a(side_prop, s.intValue());
            compound.func_74773_a(voxel_prop, vbs.getByteArray());
        }
    }

    public final void readChisleData(NBTTagCompound compound) {
        Integer oldLV = (Integer)this.getState().getValue(BlockChiseled.light_prop);
        int sideFlags = compound.func_74762_e(side_prop);
        int b = compound.func_74762_e(block_prop);
        float l = compound.func_74760_g(light_opacity_prop);
        int lv = compound.func_74762_e(light_prop);
        byte[] v = compound.func_74770_j(voxel_prop);
        if (b == 0) {
            b = Block.func_176210_f((IBlockState)Blocks.field_150347_e.func_176223_P());
        }
        this.setState(this.getState().withProperty(BlockChiseled.side_prop, (Object)sideFlags).withProperty(BlockChiseled.block_prop, (Object)b).withProperty(BlockChiseled.light_prop, (Object)lv).withProperty(BlockChiseled.opacity_prop, (Object)Float.valueOf(l)).withProperty(BlockChiseled.v_prop, (Object)new VoxelBlobState(v, this.getPositionRandom(this.field_174879_c))));
        if ((oldLV == null || oldLV != lv) && this.field_145850_b != null) {
            this.field_145850_b.func_175664_x(this.field_174879_c);
        }
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        this.writeChisleData(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.readChisleData(compound);
    }

    public void fillWith(IBlockState blockType) {
        VoxelBlob vb = new VoxelBlob();
        vb.fill(Block.func_176210_f((IBlockState)blockType));
        int ref = 0;
        VoxelBlob.CommonBlock cb = vb.mostCommonBlock();
        if (cb != null) {
            ref = cb.ref;
        }
        IExtendedBlockState state = this.getState().withProperty(BlockChiseled.side_prop, (Object)255).withProperty(BlockChiseled.opacity_prop, (Object)Float.valueOf(vb.getOpacity())).withProperty(BlockChiseled.light_prop, (Object)blockType.func_177230_c().func_149750_m()).withProperty(BlockChiseled.v_prop, (Object)new VoxelBlobState(vb, this.getPositionRandom(this.field_174879_c)));
        if (ref != 0) {
            state = state.withProperty(BlockChiseled.block_prop, (Object)ref);
        }
        this.setState(state);
        this.func_70296_d();
    }

    private long getPositionRandom(BlockPos pos) {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            return MathHelper.func_180186_a((Vec3i)pos);
        }
        return 0L;
    }

    public VoxelBlob getBlob() {
        VoxelBlob vb;
        VoxelBlob voxelBlob = vb = this.blob == null ? null : (VoxelBlob)this.blob.get();
        if (vb == null) {
            VoxelBlobState vbs = (VoxelBlobState)this.getState().getValue(BlockChiseled.v_prop);
            if (vbs != null) {
                vb = vbs.getVoxelBlob();
                if (vb == null) {
                    vb = new VoxelBlob();
                    vb.fill(Block.func_176210_f((IBlockState)Blocks.field_150347_e.func_176223_P()));
                }
                this.blob = new WeakReference<VoxelBlob>(vb);
            } else {
                vb = new VoxelBlob();
            }
        }
        return vb;
    }

    public VoxelBlobState getBlobRef() {
        return (VoxelBlobState)this.getState().getValue(BlockChiseled.v_prop);
    }

    public void setBlob(VoxelBlob vb) {
        this.blob = new WeakReference<VoxelBlob>(vb);
        Integer olv = (Integer)this.getState().getValue(BlockChiseled.light_prop);
        VoxelBlob.CommonBlock common = vb.mostCommonBlock();
        float opacity = vb.getOpacity();
        float light = vb.getLight();
        int lv = Math.max(0, Math.min(15, (int)(light * 15.0f)));
        int sideFlags = vb.getSideFlags(5, 11, 16);
        Integer oldSideFlags = (Integer)this.getState().getValue(BlockChiseled.side_prop);
        if (this.field_145850_b == null) {
            if (common.ref == 0) {
                common.ref = (Integer)this.getState().getValue(BlockChiseled.block_prop);
            }
            this.setState(this.getState().withProperty(BlockChiseled.side_prop, (Object)sideFlags).withProperty(BlockChiseled.v_prop, (Object)new VoxelBlobState(vb.toByteArray(), this.getPositionRandom(this.field_174879_c))).withProperty(BlockChiseled.light_prop, (Object)lv).withProperty(BlockChiseled.opacity_prop, (Object)Float.valueOf(opacity)).withProperty(BlockChiseled.block_prop, (Object)common.ref));
            return;
        }
        if (common.isFull) {
            this.field_145850_b.func_175656_a(this.field_174879_c, Block.func_176220_d((int)common.ref));
        } else if (common.ref != 0) {
            this.setState(this.getState().withProperty(BlockChiseled.side_prop, (Object)sideFlags).withProperty(BlockChiseled.v_prop, (Object)new VoxelBlobState(vb.toByteArray(), this.getPositionRandom(this.field_174879_c))).withProperty(BlockChiseled.light_prop, (Object)lv).withProperty(BlockChiseled.opacity_prop, (Object)Float.valueOf(opacity)).withProperty(BlockChiseled.block_prop, (Object)common.ref));
            this.func_70296_d();
            this.field_145850_b.func_175689_h(this.field_174879_c);
            if (oldSideFlags == null || oldSideFlags != sideFlags) {
                this.field_145850_b.func_175685_c(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c());
            }
        } else {
            this.field_145850_b.func_175698_g(this.field_174879_c);
        }
        if (olv == null || olv != lv) {
            this.field_145850_b.func_175664_x(this.field_174879_c);
        }
    }

    public ItemStack getItemStack(Block what, EntityPlayer player) {
        ItemStack itemstack = new ItemStack(what, 1);
        if (player != null) {
            EnumFacing enumfacing = ModUtil.getPlaceFace((EntityLivingBase)player);
            TileEntityBlockChiseled test = new TileEntityBlockChiseled();
            VoxelBlob vb = this.getBlob();
            int rotations = ModUtil.getRotationIndex(enumfacing);
            while (rotations > 0) {
                --rotations;
                enumfacing = enumfacing.func_176735_f();
                vb = vb.spin(EnumFacing.Axis.Y);
            }
            test.setBlob(vb);
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            test.writeChisleData(nbttagcompound);
            itemstack.func_77983_a("BlockEntityTag", (NBTBase)nbttagcompound);
            itemstack.func_77983_a("side", (NBTBase)new NBTTagByte((byte)enumfacing.ordinal()));
        } else {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            this.writeChisleData(nbttagcompound);
            itemstack.func_77983_a("BlockEntityTag", (NBTBase)nbttagcompound);
        }
        return itemstack;
    }

    public boolean isSideSolid(EnumFacing side) {
        Integer sideFlags = (Integer)this.getState().getValue(BlockChiseled.side_prop);
        if (sideFlags == null) {
            return true;
        }
        return (sideFlags & 1 << side.ordinal()) != 0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isSideOpaque(EnumFacing side) {
        Integer sideFlags = ChisledBlockSmartModel.getSides(this);
        return (sideFlags & 1 << side.ordinal()) != 0;
    }
}

