/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseledblock;

import java.util.ArrayList;
import java.util.List;
import mod.chiselsandbits.ChiselsAndBits;
import mod.chiselsandbits.chiseledblock.BlockChiseled;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseled;
import mod.chiselsandbits.chiseledblock.data.IntegerBox;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.helpers.ExceptionNoTileEntity;
import mod.chiselsandbits.helpers.LocalStrings;
import mod.chiselsandbits.helpers.ModUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class ItemBlockChiseled
extends ItemBlock {
    ItemStack cachedInfo;
    List<String> details = new ArrayList<String>();
    public static boolean renderTransparentGhost = false;

    public ItemBlockChiseled(Block block) {
        super(block);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List tooltip, boolean advanced) {
        super.func_77624_a(stack, playerIn, tooltip, advanced);
        ChiselsAndBits.instance.config.helpText(LocalStrings.HelpChiseledBlock, tooltip);
        if (stack.func_77942_o()) {
            if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                if (this.cachedInfo != stack) {
                    this.cachedInfo = stack;
                    this.details.clear();
                    TileEntityBlockChiseled tmp = new TileEntityBlockChiseled();
                    tmp.readChisleData(stack.func_179543_a("BlockEntityTag", false));
                    VoxelBlob blob = tmp.getBlob();
                    blob.listContents(this.details);
                }
                tooltip.addAll(this.details);
            } else {
                tooltip.add(LocalStrings.ShiftDetails.getLocal());
            }
        }
    }

    public int func_82790_a(ItemStack stack, int renderPass) {
        if (!renderTransparentGhost) {
            return super.func_82790_a(stack, renderPass);
        }
        return 0x888888;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_179222_a(World worldIn, BlockPos pos, EnumFacing side, EntityPlayer player, ItemStack stack) {
        return this.canPlaceBlockHere(worldIn, pos, side, player, stack);
    }

    public boolean vanillaStylePlacementTest(World worldIn, BlockPos pos, EnumFacing side, EntityPlayer player, ItemStack stack) {
        Block block = worldIn.func_180495_p(pos).func_177230_c();
        if (block == Blocks.field_150431_aC) {
            side = EnumFacing.UP;
        } else if (!block.func_176200_f(worldIn, pos)) {
            pos = pos.func_177972_a(side);
        }
        return worldIn.func_175716_a(this.field_150939_a, pos, false, side, (Entity)null, stack);
    }

    public boolean canPlaceBlockHere(World worldIn, BlockPos pos, EnumFacing side, EntityPlayer player, ItemStack stack) {
        if (this.vanillaStylePlacementTest(worldIn, pos, side, player, stack)) {
            return true;
        }
        if (player.func_70093_af()) {
            IBlockState state = worldIn.func_180495_p(pos);
            if (state.func_177230_c() instanceof BlockChiseled) {
                return true;
            }
            IBlockState stateb = worldIn.func_180495_p(pos.func_177972_a(side));
            return stateb.func_177230_c() instanceof BlockChiseled;
        }
        return false;
    }

    public boolean func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if (block == Blocks.field_150431_aC && (Integer)iblockstate.func_177229_b((IProperty)BlockSnow.field_176315_a) < 1) {
            side = EnumFacing.UP;
        } else if (!playerIn.func_70093_af() && !block.func_176200_f(worldIn, pos)) {
            pos = pos.func_177972_a(side);
        }
        if (stack.field_77994_a == 0) {
            return false;
        }
        if (!playerIn.func_175151_a(pos, side, stack)) {
            return false;
        }
        if (pos.func_177956_o() == 255 && this.field_150939_a.func_149688_o().func_76220_a()) {
            return false;
        }
        if (this.canPlaceBlockHere(worldIn, pos, side, playerIn, stack)) {
            int i = this.func_77647_b(stack.func_77960_j());
            IBlockState iblockstate1 = this.field_150939_a.func_180642_a(worldIn, pos, side, hitX, hitY, hitZ, i, (EntityLivingBase)playerIn);
            if (this.placeBlockAt(stack, playerIn, worldIn, pos, side, hitX, hitY, hitZ, iblockstate1)) {
                worldIn.func_72908_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), this.field_150939_a.field_149762_H.func_150496_b(), (this.field_150939_a.field_149762_H.func_150497_c() + 1.0f) / 2.0f, this.field_150939_a.field_149762_H.func_150494_d() * 0.8f);
                --stack.field_77994_a;
            }
            return true;
        }
        return false;
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        if (player.func_70093_af()) {
            return ItemBlockChiseled.tryPlaceBlockAt(this.field_150939_a, stack, (EntityLivingBase)player, world, pos, side, new BlockPos((double)(16.0f * hitX), (double)(16.0f * hitY), (double)(16.0f * hitZ)), true);
        }
        return super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState);
    }

    public static boolean tryPlaceBlockAt(Block block, ItemStack stack, EntityLivingBase player, World world, BlockPos pos, EnumFacing side, BlockPos partial, boolean modulateWorld) {
        try {
            int z;
            int y;
            int x;
            VoxelBlob[][][] blobs = new VoxelBlob[2][2][2];
            TileEntityBlockChiseled tebc = new TileEntityBlockChiseled();
            tebc.readChisleData(stack.func_179543_a("BlockEntityTag", false));
            VoxelBlob source = tebc.getBlob();
            int rotations = ModUtil.getRotations(player, stack.func_77978_p().func_74771_c("side"));
            while (rotations-- > 0) {
                source = source.spin(EnumFacing.Axis.Y);
            }
            IntegerBox modelBounds = source.getBounds();
            BlockPos offset = ModUtil.getPartialOffset(side, partial, modelBounds);
            BlockChiseled myBlock = (BlockChiseled)block;
            if (offset.func_177958_n() < 0) {
                pos = pos.func_177982_a(-1, 0, 0);
                offset = offset.func_177982_a(16, 0, 0);
            }
            if (offset.func_177956_o() < 0) {
                pos = pos.func_177982_a(0, -1, 0);
                offset = offset.func_177982_a(0, 16, 0);
            }
            if (offset.func_177952_p() < 0) {
                pos = pos.func_177982_a(0, 0, -1);
                offset = offset.func_177982_a(0, 0, 16);
            }
            for (x = 0; x < 2; ++x) {
                for (y = 0; y < 2; ++y) {
                    for (z = 0; z < 2; ++z) {
                        BlockPos bp;
                        blobs[x][y][z] = source.offset(offset.func_177958_n() - source.detail * x, offset.func_177956_o() - source.detail * y, offset.func_177952_p() - source.detail * z);
                        int solids = blobs[x][y][z].solid();
                        if (solids <= 0 || world.func_175623_d(bp = pos.func_177982_a(x, y, z))) continue;
                        IBlockState state = world.func_180495_p(bp);
                        if (state.func_177230_c() instanceof BlockChiseled) {
                            BlockChiseled blk = (BlockChiseled)state.func_177230_c();
                            TileEntityBlockChiseled target = blk.getTileEntity((IBlockAccess)world, bp);
                            VoxelBlob dest = target.getBlob();
                            if (!dest.canMerge(blobs[x][y][z])) {
                                return false;
                            }
                            blobs[x][y][z] = blobs[x][y][z].merge(dest);
                            continue;
                        }
                        return false;
                    }
                }
            }
            if (modulateWorld) {
                for (x = 0; x < 2; ++x) {
                    for (y = 0; y < 2; ++y) {
                        for (z = 0; z < 2; ++z) {
                            if (blobs[x][y][z].solid() <= 0) continue;
                            BlockPos bp = pos.func_177982_a(x, y, z);
                            IBlockState state = world.func_180495_p(bp);
                            if (world.func_175623_d(bp)) {
                                if (!BlockChiseled.replaceWithChisled(world, bp, state, (Integer)tebc.getState().getValue(BlockChiseled.block_prop))) continue;
                                TileEntityBlockChiseled target = myBlock.getTileEntity((IBlockAccess)world, bp);
                                target.setBlob(blobs[x][y][z]);
                                continue;
                            }
                            if (state.func_177230_c() instanceof BlockChiseled) {
                                BlockChiseled blk = (BlockChiseled)state.func_177230_c();
                                TileEntityBlockChiseled target = blk.getTileEntity((IBlockAccess)world, bp);
                                target.setBlob(blobs[x][y][z]);
                                continue;
                            }
                            return false;
                        }
                    }
                }
            }
            return true;
        }
        catch (ExceptionNoTileEntity e) {
            return false;
        }
    }

    public String func_77653_i(ItemStack stack) {
        int stateid;
        IBlockState state;
        Block blk;
        ItemStack target;
        NBTTagCompound BlockEntityTag;
        NBTTagCompound comp = stack.func_77978_p();
        if (comp != null && (BlockEntityTag = comp.func_74775_l("BlockEntityTag")) != null && (target = new ItemStack(blk = (state = Block.func_176220_d((int)(stateid = BlockEntityTag.func_74762_e("b")))).func_177230_c(), 1, blk.func_176201_c(state))).func_77973_b() != null) {
            return super.func_77653_i(stack) + " - " + target.func_82833_r();
        }
        return super.func_77653_i(stack);
    }
}

