/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseledblock;

import java.util.Iterator;
import mod.chiselsandbits.ChiselMode;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import net.minecraft.util.EnumFacing;

public class ChiselTypeIterator
implements Iterator<ChiselTypeIterator> {
    private final int full_size;
    private final int max_dim;
    private int x_range = 1;
    private int y_range = 1;
    private int z_range = 1;
    private int x;
    private int y;
    private int z;
    private final int original_x;
    private final int original_y;
    private final int original_z;
    public final EnumFacing side;
    final ChiselMode mode;
    private final int parts;
    private int offset = -1;

    public ChiselTypeIterator(int dim, int x, int y, int z, int x_size, int y_size, int z_size, EnumFacing side) {
        this.full_size = dim;
        this.max_dim = dim - 1;
        this.mode = ChiselMode.DRAWN_REGION;
        this.side = side;
        this.x_range = x_size;
        this.y_range = y_size;
        this.z_range = z_size;
        this.parts = this.x_range * this.y_range * this.z_range;
        this.original_x = x;
        this.original_y = y;
        this.original_z = z;
    }

    public ChiselTypeIterator(int dim, int x, int y, int z, VoxelBlob source, ChiselMode mode, EnumFacing side) {
        int offset = 0;
        this.full_size = dim;
        this.max_dim = dim - 1;
        this.side = side;
        this.mode = mode;
        block0 : switch (mode) {
            case CUBE_SMALL: {
                this.x_range = 3;
                this.y_range = 3;
                this.z_range = 3;
                offset = -1;
                this.parts = this.x_range * this.y_range * this.z_range;
                break;
            }
            case SNAP2: {
                x -= x % 2;
                y -= y % 2;
                z -= z % 2;
                this.x_range = 2;
                this.y_range = 2;
                this.z_range = 2;
                this.parts = this.x_range * this.y_range * this.z_range;
                break;
            }
            case SNAP4: {
                x -= x % 4;
                y -= y % 4;
                z -= z % 4;
                this.x_range = 4;
                this.y_range = 4;
                this.z_range = 4;
                this.parts = this.x_range * this.y_range * this.z_range;
                break;
            }
            case SNAP8: {
                x -= x % 8;
                y -= y % 8;
                z -= z % 8;
                this.x_range = 8;
                this.y_range = 8;
                this.z_range = 8;
                this.parts = this.x_range * this.y_range * this.z_range;
                break;
            }
            case LINE: {
                this.parts = this.full_size;
                switch (side) {
                    case DOWN: 
                    case UP: {
                        y = 0;
                        this.y_range = this.full_size;
                        break block0;
                    }
                    case NORTH: 
                    case SOUTH: {
                        z = 0;
                        this.z_range = this.full_size;
                        break block0;
                    }
                    case WEST: 
                    case EAST: {
                        x = 0;
                        this.x_range = this.full_size;
                        break block0;
                    }
                }
                throw new NullPointerException();
            }
            case PLANE: {
                this.parts = this.full_size * this.full_size;
                switch (side) {
                    case DOWN: 
                    case UP: {
                        x = 0;
                        z = 0;
                        this.x_range = this.full_size;
                        this.z_range = this.full_size;
                        break block0;
                    }
                    case NORTH: 
                    case SOUTH: {
                        x = 0;
                        y = 0;
                        this.x_range = this.full_size;
                        this.y_range = this.full_size;
                        break block0;
                    }
                    case WEST: 
                    case EAST: {
                        y = 0;
                        z = 0;
                        this.y_range = this.full_size;
                        this.z_range = this.full_size;
                        break block0;
                    }
                }
                throw new NullPointerException();
            }
            case CONNECTED_PLANE: {
                int ox = x;
                int oy = y;
                int oz = z;
                switch (side) {
                    case DOWN: 
                    case UP: {
                        while (x > 0 && source.getSafe(x - 1, oy, oz) != 0 && source.getSafe(x - 1, oy + side.func_96559_d(), oz) == 0) {
                            --x;
                            ++this.x_range;
                        }
                        while (z > 0 && source.getSafe(ox, oy, z - 1) != 0 && source.getSafe(ox, oy + side.func_96559_d(), z - 1) == 0) {
                            --z;
                            ++this.z_range;
                        }
                        while (this.x_range < this.full_size && source.getSafe(x + this.x_range, oy, oz) != 0 && source.getSafe(x + this.x_range, oy + side.func_96559_d(), oz) == 0) {
                            ++this.x_range;
                        }
                        while (this.z_range < this.full_size && source.getSafe(ox, oy, z + this.z_range) != 0 && source.getSafe(ox, oy + side.func_96559_d(), z + this.z_range) == 0) {
                            ++this.z_range;
                        }
                        break;
                    }
                    case NORTH: 
                    case SOUTH: {
                        while (x > 0 && source.getSafe(x - 1, oy, oz) != 0 && source.getSafe(x - 1, oy, oz + side.func_82599_e()) == 0) {
                            --x;
                            ++this.x_range;
                        }
                        while (y > 0 && source.getSafe(ox, y - 1, oz) != 0 && source.getSafe(ox, y - 1, oz + side.func_82599_e()) == 0) {
                            --y;
                            ++this.y_range;
                        }
                        while (this.x_range < this.full_size && source.getSafe(x + this.x_range, oy, oz) != 0 && source.getSafe(x + this.x_range, oy, oz + side.func_82599_e()) == 0) {
                            ++this.x_range;
                        }
                        while (this.y_range < this.full_size && source.getSafe(ox, y + this.y_range, oz) != 0 && source.getSafe(ox, y + this.y_range, oz + side.func_82599_e()) == 0) {
                            ++this.y_range;
                        }
                        break;
                    }
                    case WEST: 
                    case EAST: {
                        while (y > 0 && source.getSafe(ox, y - 1, oz) != 0 && source.getSafe(ox + side.func_82601_c(), y - 1, oz) == 0) {
                            --y;
                            ++this.y_range;
                        }
                        while (z > 0 && source.getSafe(ox, oy, z - 1) != 0 && source.getSafe(ox + side.func_82601_c(), oy, z - 1) == 0) {
                            --z;
                            ++this.z_range;
                        }
                        while (this.y_range < this.full_size && source.getSafe(ox, y + this.y_range, oz) != 0 && source.getSafe(ox + side.func_82601_c(), y + this.y_range, oz) == 0) {
                            ++this.y_range;
                        }
                        while (this.z_range < this.full_size && source.getSafe(ox, oy, z + this.z_range) != 0 && source.getSafe(ox + side.func_82601_c(), oy, z + this.z_range) == 0) {
                            ++this.z_range;
                        }
                        break;
                    }
                    default: {
                        throw new NullPointerException();
                    }
                }
                this.parts = Math.min(this.full_size, this.x_range) * Math.min(this.full_size, this.y_range) * Math.min(this.full_size, this.z_range);
                break;
            }
            case CUBE_LARGE: {
                this.x_range = 5;
                this.y_range = 5;
                this.z_range = 5;
                offset = -2;
                this.parts = this.x_range * this.y_range * this.z_range;
                break;
            }
            case CUBE_HUGE: {
                this.x_range = 7;
                this.y_range = 7;
                this.z_range = 7;
                offset = -3;
                this.parts = this.x_range * this.y_range * this.z_range;
                break;
            }
            case DRAWN_REGION: 
            case SINGLE: {
                this.parts = 1;
                break;
            }
            default: {
                throw new NullPointerException();
            }
        }
        this.original_x = Math.max(0, Math.min(this.full_size - this.x_range, x + offset));
        this.original_y = Math.max(0, Math.min(this.full_size - this.y_range, y + offset));
        this.original_z = Math.max(0, Math.min(this.full_size - this.z_range, z + offset));
    }

    @Override
    public boolean hasNext() {
        if (++this.offset != 0) {
            ++this.x;
            boolean x_up = false;
            if (this.x >= this.x_range) {
                ++this.y;
                this.x = 0;
                x_up = true;
            }
            if (this.y >= this.y_range && x_up) {
                ++this.z;
                this.y = 0;
            }
        }
        return this.offset < this.parts;
    }

    public int x() {
        return Math.max(0, Math.min(this.max_dim, this.original_x + this.x));
    }

    public int y() {
        return Math.max(0, Math.min(this.max_dim, this.original_y + this.y));
    }

    public int z() {
        return Math.max(0, Math.min(this.max_dim, this.original_z + this.z));
    }

    @Override
    public ChiselTypeIterator next() {
        return this;
    }

    @Override
    public void remove() {
    }
}

