/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseledblock;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import mod.chiselsandbits.ChiselMode;
import mod.chiselsandbits.ChiselsAndBits;
import mod.chiselsandbits.ClientSide;
import mod.chiselsandbits.chiseledblock.ChiselTypeIterator;
import mod.chiselsandbits.chiseledblock.ProxyBlock;
import mod.chiselsandbits.chiseledblock.SubMaterial;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseled;
import mod.chiselsandbits.chiseledblock.data.UnlistedBlockFlags;
import mod.chiselsandbits.chiseledblock.data.UnlistedBlockStateID;
import mod.chiselsandbits.chiseledblock.data.UnlistedLightOpacity;
import mod.chiselsandbits.chiseledblock.data.UnlistedLightValue;
import mod.chiselsandbits.chiseledblock.data.UnlistedVoxelBlob;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.chiseledblock.data.VoxelBlobState;
import mod.chiselsandbits.helpers.ExceptionNoTileEntity;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.items.ItemChiseledBit;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGlass;
import net.minecraft.block.BlockGlowstone;
import net.minecraft.block.BlockSlime;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class BlockChiseled
extends Block
implements ITileEntityProvider {
    public static final IUnlistedProperty<VoxelBlobState> v_prop = new UnlistedVoxelBlob();
    public static final IUnlistedProperty<Integer> block_prop = new UnlistedBlockStateID();
    public static final IUnlistedProperty<Integer> side_prop = new UnlistedBlockFlags("f");
    public static final IUnlistedProperty<Float> opacity_prop = new UnlistedLightOpacity();
    public static final IUnlistedProperty<Integer> light_prop = new UnlistedLightValue();
    public final String name;
    private static HashMap<Block, Boolean> supportedBlocks = new HashMap();
    static ThreadLocal<Integer> replacementLightValue = new ThreadLocal();
    public static IBlockState actingAs = null;

    public boolean func_176200_f(World worldIn, BlockPos pos) {
        try {
            return this.getTileEntity((IBlockAccess)worldIn, pos).getBlob().solid() == 0;
        }
        catch (ExceptionNoTileEntity e) {
            return super.func_176200_f(worldIn, pos);
        }
    }

    public boolean doesSideBlockRendering(IBlockAccess world, BlockPos pos, EnumFacing face) {
        try {
            return this.getTileEntity(world, pos).isSideOpaque(face.func_176734_d());
        }
        catch (ExceptionNoTileEntity e) {
            return false;
        }
    }

    public BlockChiseled(Material mat, String BlockName) {
        super((Material)new SubMaterial(mat));
        this.configureSound(mat);
        if (mat == Material.field_151588_w || mat == Material.field_151598_x) {
            this.field_149765_K = 0.98f;
        }
        this.func_149713_g(0);
        this.func_149711_c(1.0f);
        this.setHarvestLevel("pickaxe", 0);
        this.name = BlockName;
    }

    private void configureSound(Material mat) {
        if (mat == Material.field_151575_d) {
            this.func_149672_a(field_149766_f);
        } else if (mat == Material.field_151576_e) {
            this.func_149672_a(field_149769_e);
        } else if (mat == Material.field_151573_f) {
            this.func_149672_a(field_149777_j);
        } else if (mat == Material.field_151580_n) {
            this.func_149672_a(field_149777_j);
        } else if (mat == Material.field_151588_w) {
            this.func_149672_a(field_149778_k);
        } else if (mat == Material.field_151598_x) {
            this.func_149672_a(field_149778_k);
        } else if (mat == Material.field_151571_B) {
            this.func_149672_a(field_149767_g);
        } else if (mat == Material.field_151592_s) {
            this.func_149672_a(field_149778_k);
        }
    }

    public boolean canRenderInLayer(EnumWorldBlockLayer layer) {
        return true;
    }

    public TileEntityBlockChiseled getTileEntity(TileEntity te) throws ExceptionNoTileEntity {
        if (te instanceof TileEntityBlockChiseled) {
            return (TileEntityBlockChiseled)te;
        }
        throw new ExceptionNoTileEntity();
    }

    public TileEntityBlockChiseled getTileEntity(IBlockAccess world, BlockPos pos) throws ExceptionNoTileEntity {
        return this.getTileEntity(world.func_175625_s(pos));
    }

    public float func_149685_I() {
        return 1.0f;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        try {
            return this.getTileEntity(world, pos).getState();
        }
        catch (ExceptionNoTileEntity e) {
            return state;
        }
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        try {
            BlockChiseled.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)this.getTileEntity((IBlockAccess)worldIn, pos).getItemStack(this, null));
        }
        catch (ExceptionNoTileEntity exceptionNoTileEntity) {
            // empty catch block
        }
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te) {
        try {
            BlockChiseled.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)this.getTileEntity(te).getItemStack(this, player));
        }
        catch (ExceptionNoTileEntity exp) {
            super.func_180657_a(worldIn, player, pos, state, (TileEntity)null);
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        try {
            if (stack == null || placer == null) {
                return;
            }
            TileEntityBlockChiseled bc = this.getTileEntity((IBlockAccess)worldIn, pos);
            int rotations = ModUtil.getRotations(placer, stack.func_77978_p().func_74771_c("side"));
            VoxelBlob blob = bc.getBlob();
            while (rotations-- > 0) {
                blob = blob.spin(EnumFacing.Axis.Y);
            }
            bc.setBlob(blob);
        }
        catch (ExceptionNoTileEntity exceptionNoTileEntity) {
            // empty catch block
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, BlockPos pos) {
        try {
            EntityPlayer player = ClientSide.instance.getPlayer();
            if (player != null && ModUtil.isHoldingChiselTool(player) != null) {
                int z;
                int y;
                int x;
                VoxelBlob vb = this.getTileEntity((IBlockAccess)world, pos).getBlob();
                int itemBlock = vb.get(x = Math.min(15, Math.max(0, (int)((double)vb.detail * (target.field_72307_f.field_72450_a - (double)pos.func_177958_n()) - (double)target.field_178784_b.func_82601_c() * 0.5))), y = Math.min(15, Math.max(0, (int)((double)vb.detail * (target.field_72307_f.field_72448_b - (double)pos.func_177956_o()) - (double)target.field_178784_b.func_96559_d() * 0.5))), z = Math.min(15, Math.max(0, (int)((double)vb.detail * (target.field_72307_f.field_72449_c - (double)pos.func_177952_p()) - (double)target.field_178784_b.func_82599_e() * 0.5))));
                if (itemBlock == 0) {
                    return null;
                }
                return ItemChiseledBit.createStack(itemBlock, 1, false);
            }
            return this.getTileEntity((IBlockAccess)world, pos).getItemStack(this, player);
        }
        catch (ExceptionNoTileEntity e) {
            return null;
        }
    }

    protected BlockState func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[0], new IUnlistedProperty[]{v_prop, block_prop, opacity_prop, side_prop, light_prop});
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityBlockChiseled();
    }

    public boolean addLandingEffects(WorldServer worldObj, BlockPos blockPosition, IBlockState iblockstate, EntityLivingBase entity, int numberOfParticles) {
        try {
            IBlockState texture = this.getTileEntity((IBlockAccess)worldObj, blockPosition).getParticleBlockState(Blocks.field_150348_b);
            worldObj.func_175739_a(EnumParticleTypes.BLOCK_DUST, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, numberOfParticles, 0.0, 0.0, 0.0, (double)0.15f, new int[]{Block.func_176210_f((IBlockState)texture)});
            return true;
        }
        catch (ExceptionNoTileEntity e) {
            return false;
        }
    }

    public boolean addDestroyEffects(World world, BlockPos pos, EffectRenderer effectRenderer) {
        try {
            IBlockState state = this.getTileEntity((IBlockAccess)world, pos).getParticleBlockState(this);
            return ClientSide.instance.addBlockDestroyEffects(world, pos, state, effectRenderer);
        }
        catch (ExceptionNoTileEntity exceptionNoTileEntity) {
            return true;
        }
    }

    public boolean addHitEffects(World world, MovingObjectPosition target, EffectRenderer effectRenderer) {
        try {
            BlockPos pos = target.func_178782_a();
            IBlockState state = this.getTileEntity((IBlockAccess)world, pos).getParticleBlockState(this);
            return ClientSide.instance.addHitEffects(world, target, state, effectRenderer);
        }
        catch (ExceptionNoTileEntity exp) {
            return true;
        }
    }

    public AxisAlignedBB func_180640_a(World worldIn, BlockPos pos, IBlockState state) {
        return null;
    }

    public void func_180638_a(World worldIn, BlockPos pos, IBlockState state, AxisAlignedBB mask, List list, Entity collidingEntity) {
        this.setBounds(worldIn, pos, mask, list);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    private boolean setBounds(World worldIn, BlockPos pos, AxisAlignedBB mask, List<AxisAlignedBB> list) {
        boolean started = false;
        float minX = 0.0f;
        float minY = 0.0f;
        float minZ = 0.0f;
        float maxX = 1.0f;
        float maxY = 1.0f;
        float maxZ = 1.0f;
        try {
            TileEntityBlockChiseled tec = this.getTileEntity((IBlockAccess)worldIn, pos);
            VoxelBlob vb = tec.getBlob();
            float One16thf = 1.0f / (float)vb.detail;
            for (int y = 0; y < vb.detail; ++y) {
                for (int z = 0; z < vb.detail; ++z) {
                    for (int x = 0; x < vb.detail; ++x) {
                        if (vb.get(x, y, z) == 0) continue;
                        if (started) {
                            minX = Math.min(minX, One16thf * (float)x);
                            minY = Math.min(minY, One16thf * (float)y);
                            minZ = Math.min(minZ, One16thf * (float)z);
                            maxX = Math.max(maxX, One16thf * ((float)x + 1.0f));
                            maxY = Math.max(maxY, One16thf * ((float)y + 1.0f));
                            maxZ = Math.max(maxZ, One16thf * ((float)z + 1.0f));
                            continue;
                        }
                        started = true;
                        minX = One16thf * (float)x;
                        minY = One16thf * (float)y;
                        minZ = One16thf * (float)z;
                        maxX = One16thf * ((float)x + 1.0f);
                        maxY = One16thf * ((float)y + 1.0f);
                        maxZ = One16thf * ((float)z + 1.0f);
                    }
                }
                if (list == null || !started || y != 8 && y != 15) continue;
                AxisAlignedBB bb = AxisAlignedBB.func_178781_a((double)((double)minX + (double)pos.func_177958_n()), (double)((double)minY + (double)pos.func_177956_o()), (double)((double)minZ + (double)pos.func_177952_p()), (double)((double)maxX + (double)pos.func_177958_n()), (double)((double)maxY + (double)pos.func_177956_o()), (double)((double)maxZ + (double)pos.func_177952_p()));
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                if (mask.func_72326_a(bb)) {
                    list.add(bb);
                }
                started = false;
                minX = 0.0f;
                minY = 0.0f;
                minZ = 0.0f;
                maxX = 1.0f;
                maxY = 1.0f;
                maxZ = 1.0f;
            }
        }
        catch (ExceptionNoTileEntity exceptionNoTileEntity) {
            // empty catch block
        }
        this.func_149676_a(minX, minY, minZ, maxX, maxY, maxZ);
        return started;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180646_a(World worldIn, BlockPos pos) {
        if (worldIn.field_72995_K) {
            EntityPlayer playerIn = ClientSide.instance.getPlayer();
            ItemStack equiped = playerIn.func_71045_bC();
            ChiselMode chMode = ModUtil.isHoldingChiselTool(playerIn);
            if (equiped == null || null == chMode) {
                this.setBounds(worldIn, pos, null, null);
                AxisAlignedBB r = super.func_180646_a(worldIn, pos);
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                return r;
            }
            try {
                TileEntityBlockChiseled tec = this.getTileEntity((IBlockAccess)worldIn, pos);
                VoxelBlob vb = tec.getBlob();
                return this.getSelectedBoundingBox(playerIn, pos, vb, chMode);
            }
            catch (ExceptionNoTileEntity exceptionNoTileEntity) {
                // empty catch block
            }
        }
        this.setBounds(worldIn, pos, null, null);
        AxisAlignedBB r = super.func_180646_a(worldIn, pos);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        return r;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getSelectedBoundingBox(EntityPlayer playerIn, BlockPos pos, VoxelBlob vb, ChiselMode chMode) {
        Pair<Vec3, Vec3> PlayerRay = ModUtil.getPlayerRay(playerIn);
        Vec3 a = (Vec3)PlayerRay.getLeft();
        Vec3 b = (Vec3)PlayerRay.getRight();
        MovingObjectPosition selectedR = null;
        AxisAlignedBB br = null;
        double lastDist = 0.0;
        float One16thf = 1.0f / (float)vb.detail;
        for (int z = 0; z < vb.detail; ++z) {
            float z_One16thf = One16thf * (float)z;
            float z_One16thf_p1 = z_One16thf + One16thf;
            for (int y = 0; y < vb.detail; ++y) {
                float y_One16thf = One16thf * (float)y;
                float y_One16thf_p1 = y_One16thf + One16thf;
                for (int x = 0; x < vb.detail; ++x) {
                    if (vb.get(x, y, z) == 0) continue;
                    float x_One16thf = One16thf * (float)x;
                    this.func_149676_a(x_One16thf, y_One16thf, z_One16thf, x_One16thf + One16thf, y_One16thf_p1, z_One16thf_p1);
                    MovingObjectPosition r = super.func_180636_a(playerIn.field_70170_p, pos, a, b);
                    if (r == null) continue;
                    double xLen = a.field_72450_a - r.field_72307_f.field_72450_a;
                    double yLen = a.field_72448_b - r.field_72307_f.field_72448_b;
                    double zLen = a.field_72449_c - r.field_72307_f.field_72449_c;
                    double thisDist = xLen * xLen + yLen * yLen + zLen * zLen;
                    if (selectedR != null && !(lastDist > thisDist)) continue;
                    lastDist = thisDist;
                    selectedR = r;
                }
            }
        }
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        if (selectedR != null) {
            float One32ndf = 0.03125f;
            int x = Math.min(15, Math.max(0, (int)(16.0 * (selectedR.field_72307_f.field_72450_a - (double)pos.func_177958_n() - (double)(0.03125f * (float)selectedR.field_178784_b.func_82601_c())))));
            int y = Math.min(15, Math.max(0, (int)(16.0 * (selectedR.field_72307_f.field_72448_b - (double)pos.func_177956_o() - (double)(0.03125f * (float)selectedR.field_178784_b.func_96559_d())))));
            int z = Math.min(15, Math.max(0, (int)(16.0 * (selectedR.field_72307_f.field_72449_c - (double)pos.func_177952_p() - (double)(0.03125f * (float)selectedR.field_178784_b.func_82599_e())))));
            ChiselTypeIterator ci = null;
            BlockPos drawStart = ClientSide.instance.getStartPos();
            if (chMode == ChiselMode.DRAWN_REGION && drawStart != null) {
                if (ClientSide.instance.sameDrawBlock(pos, x, y, z)) {
                    int lowX = Math.max(0, Math.min(x, drawStart.func_177958_n()));
                    int lowY = Math.max(0, Math.min(y, drawStart.func_177956_o()));
                    int lowZ = Math.max(0, Math.min(z, drawStart.func_177952_p()));
                    int highX = Math.min(16, Math.max(x, drawStart.func_177958_n()));
                    int highY = Math.min(16, Math.max(y, drawStart.func_177956_o()));
                    int highZ = Math.min(16, Math.max(z, drawStart.func_177952_p()));
                    ci = new ChiselTypeIterator(16, lowX, lowY, lowZ, 1 + highX - lowX, 1 + highY - lowY, 1 + highZ - lowZ, selectedR.field_178784_b);
                } else {
                    ci = new ChiselTypeIterator(16, 0, 0, 0, 0, 0, 0, selectedR.field_178784_b);
                }
            } else {
                ci = new ChiselTypeIterator(16, x, y, z, vb, chMode, selectedR.field_178784_b);
            }
            boolean started = false;
            while (ci.hasNext()) {
                if (vb.get(ci.x(), ci.y(), ci.z()) == 0) continue;
                if (started) {
                    this.field_149759_B = Math.min(this.field_149759_B, (double)(One16thf * (float)ci.x()));
                    this.field_149760_C = Math.min(this.field_149760_C, (double)(One16thf * (float)ci.y()));
                    this.field_149754_D = Math.min(this.field_149754_D, (double)(One16thf * (float)ci.z()));
                    this.field_149755_E = Math.max(this.field_149755_E, (double)(One16thf * ((float)ci.x() + 1.0f)));
                    this.field_149756_F = Math.max(this.field_149756_F, (double)(One16thf * ((float)ci.y() + 1.0f)));
                    this.field_149757_G = Math.max(this.field_149757_G, (double)(One16thf * ((float)ci.z() + 1.0f)));
                    continue;
                }
                started = true;
                this.field_149759_B = One16thf * (float)ci.x();
                this.field_149760_C = One16thf * (float)ci.y();
                this.field_149754_D = One16thf * (float)ci.z();
                this.field_149755_E = One16thf * ((float)ci.x() + 1.0f);
                this.field_149756_F = One16thf * ((float)ci.y() + 1.0f);
                this.field_149757_G = One16thf * ((float)ci.z() + 1.0f);
            }
            br = AxisAlignedBB.func_178781_a((double)this.field_149759_B, (double)this.field_149760_C, (double)this.field_149754_D, (double)this.field_149755_E, (double)this.field_149756_F, (double)this.field_149757_G);
            br = br.func_72317_d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            return br;
        }
        return AxisAlignedBB.func_178781_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0).func_72317_d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
    }

    public MovingObjectPosition func_180636_a(World worldIn, BlockPos pos, Vec3 a, Vec3 b) {
        if (worldIn.field_72995_K) {
            MovingObjectPosition br = null;
            double lastDist = 0.0;
            try {
                TileEntityBlockChiseled tec = this.getTileEntity((IBlockAccess)worldIn, pos);
                VoxelBlob vb = tec.getBlob();
                float One16thf = 1.0f / (float)vb.detail;
                for (int z = 0; z < vb.detail; ++z) {
                    float z_One16thf = (float)z * One16thf;
                    float z_One16thf_p1 = z_One16thf + One16thf;
                    for (int y = 0; y < vb.detail; ++y) {
                        float y_One16thf = (float)y * One16thf;
                        float y_One16thf_p1 = y_One16thf + One16thf;
                        for (int x = 0; x < vb.detail; ++x) {
                            float x_One16thf = (float)x * One16thf;
                            if (vb.get(x, y, z) == 0) continue;
                            this.func_149676_a(x_One16thf, y_One16thf, z_One16thf, x_One16thf + One16thf, y_One16thf_p1, z_One16thf_p1);
                            MovingObjectPosition r = super.func_180636_a(worldIn, pos, a, b);
                            if (r == null) continue;
                            double xLen = a.field_72450_a - r.field_72307_f.field_72450_a;
                            double yLen = a.field_72448_b - r.field_72307_f.field_72448_b;
                            double zLen = a.field_72449_c - r.field_72307_f.field_72449_c;
                            double thisDist = xLen * xLen + yLen * yLen + zLen * zLen;
                            if (br != null && !(lastDist > thisDist)) continue;
                            lastDist = thisDist;
                            br = r;
                        }
                    }
                }
            }
            catch (ExceptionNoTileEntity exceptionNoTileEntity) {
                // empty catch block
            }
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            return br;
        }
        this.setBounds(worldIn, pos, null, null);
        MovingObjectPosition r = super.func_180636_a(worldIn, pos, a, b);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        return r;
    }

    public float func_176195_g(World worldIn, BlockPos pos) {
        try {
            return this.getTileEntity((IBlockAccess)worldIn, pos).getBlock(this).func_176195_g(worldIn, pos);
        }
        catch (Throwable err) {
            return super.func_176195_g(worldIn, pos);
        }
    }

    public float func_180647_a(EntityPlayer playerIn, World worldIn, BlockPos pos) {
        try {
            return this.getTileEntity((IBlockAccess)worldIn, pos).getBlock(this).func_180647_a(playerIn, worldIn, pos);
        }
        catch (Throwable err) {
            return super.func_180647_a(playerIn, worldIn, pos);
        }
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        try {
            return this.getTileEntity((IBlockAccess)world, pos).getBlock(this).getExplosionResistance(world, pos, exploder, explosion);
        }
        catch (Throwable err) {
            return super.getExplosionResistance(world, pos, exploder, explosion);
        }
    }

    public static boolean replaceWithChisled(World world, BlockPos pos, IBlockState originalState) {
        return BlockChiseled.replaceWithChisled(world, pos, originalState, 0);
    }

    public boolean canPlaceTorchOnTop(IBlockAccess world, BlockPos pos) {
        return this.isSideSolid(world, pos, EnumFacing.UP);
    }

    public boolean isSideSolid(IBlockAccess world, BlockPos pos, EnumFacing side) {
        try {
            return this.getTileEntity(world, pos).isSideSolid(side);
        }
        catch (ExceptionNoTileEntity e) {
            return false;
        }
    }

    public static boolean supportsBlock(IBlockState state) {
        Block blk = state.func_177230_c();
        if (supportedBlocks.containsKey(blk)) {
            return supportedBlocks.get(blk);
        }
        try {
            boolean isFullCube;
            Class<?> blkClass = blk.getClass();
            ProxyBlock pb = new ProxyBlock();
            pb.func_176195_g(null, null);
            Method hardnessMethod = blkClass.getMethod(pb.MethodName, World.class, BlockPos.class);
            boolean test_a = hardnessMethod.getDeclaringClass() == Block.class;
            float blockHardness = ((Float)hardnessMethod.invoke((Object)blk, new Object[]{null, null})).floatValue();
            pb.func_180647_a(null, null, null);
            boolean test_b = blkClass.getMethod(pb.MethodName, EntityPlayer.class, World.class, BlockPos.class).getDeclaringClass() == Block.class;
            pb.getExplosionResistance(null, null, null, null);
            boolean test_c = blkClass.getMethod(pb.MethodName, World.class, BlockPos.class, Entity.class, Explosion.class).getDeclaringClass() == Block.class;
            pb.func_149745_a(null);
            Class<?> wc = blkClass.getMethod(pb.MethodName, Random.class).getDeclaringClass();
            boolean test_d = wc == Block.class || wc == BlockGlowstone.class || wc == BlockStainedGlass.class || wc == BlockGlass.class;
            pb.func_149679_a(0, null);
            boolean test_e = blkClass.getMethod(pb.MethodName, Integer.TYPE, Random.class).getDeclaringClass() == Block.class || wc == BlockGlowstone.class;
            pb.quantityDropped(null, 0, null);
            boolean test_f = blkClass.getMethod(pb.MethodName, IBlockState.class, Integer.TYPE, Random.class).getDeclaringClass() == Block.class;
            pb.func_176199_a(null, null, null);
            boolean test_g = blkClass.getMethod(pb.MethodName, World.class, BlockPos.class, Entity.class).getDeclaringClass() == Block.class || blkClass == BlockSlime.class;
            pb.func_180634_a(null, null, null, null);
            boolean test_h = blkClass.getMethod(pb.MethodName, World.class, BlockPos.class, IBlockState.class, Entity.class).getDeclaringClass() == Block.class || blkClass == BlockSlime.class;
            boolean bl = isFullCube = blk.func_149686_d() || blkClass == BlockStainedGlass.class || blkClass == BlockGlass.class;
            if (test_a && test_b && test_c && test_d && test_e && test_f && test_g && test_h && blockHardness >= -0.01f && isFullCube && !blk.func_149653_t() && !blk.hasTileEntity(state) && ChiselsAndBits.instance.getConversion(blk.func_149688_o()) != null) {
                boolean result = ChiselsAndBits.instance.config.isEnabled(blkClass.getName());
                supportedBlocks.put(blk, result);
                return result;
            }
            supportedBlocks.put(blk, false);
            return false;
        }
        catch (Throwable t) {
            supportedBlocks.put(blk, false);
            return false;
        }
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        try {
            TileEntityBlockChiseled cte = this.getTileEntity((IBlockAccess)world, pos);
            cte.setBlob(cte.getBlob().spin(axis.func_176740_k()));
            return true;
        }
        catch (ExceptionNoTileEntity e) {
            return false;
        }
    }

    public static boolean replaceWithChisled(World world, BlockPos pos, IBlockState originalState, int fragmentBlockStateID) {
        Block target = originalState.func_177230_c();
        boolean isAir = world.func_175623_d(pos);
        if (BlockChiseled.supportsBlock(originalState) || isAir) {
            BlockChiseled blk = ChiselsAndBits.instance.getConversion(target.func_149688_o());
            int BlockID = Block.func_176210_f((IBlockState)originalState);
            if (isAir) {
                originalState = Block.func_176220_d((int)fragmentBlockStateID);
                target = originalState.func_177230_c();
                BlockID = Block.func_176210_f((IBlockState)originalState);
                blk = ChiselsAndBits.instance.getConversion(target.func_149688_o());
                originalState = Blocks.field_150350_a.func_176223_P();
            }
            if (BlockID == 0) {
                return false;
            }
            if (blk != null && blk != target) {
                replacementLightValue.set(originalState.func_177230_c().func_149750_m());
                world.func_175656_a(pos, blk.func_176223_P());
                TileEntity te = world.func_175625_s(pos);
                TileEntityBlockChiseled tec = null;
                if (!(te instanceof TileEntityBlockChiseled)) {
                    tec = (TileEntityBlockChiseled)blk.createTileEntity(world, blk.func_176223_P());
                    world.func_175690_a(pos, (TileEntity)tec);
                } else {
                    tec = (TileEntityBlockChiseled)te;
                }
                tec.fillWith(originalState);
                tec.setState(tec.getState().withProperty(block_prop, (Object)BlockID));
                replacementLightValue.remove();
                return true;
            }
        }
        return false;
    }

    public IBlockState getCommonState(IExtendedBlockState myState) {
        VoxelBlob vb;
        VoxelBlobState data = (VoxelBlobState)myState.getValue(v_prop);
        if (data != null && (vb = data.getVoxelBlob()) != null) {
            return Block.func_176220_d((int)vb.mostCommonBlock().ref);
        }
        return null;
    }

    public int getLightValue(IBlockAccess world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block != this) {
            return block.getLightValue(world, pos);
        }
        if (ChiselsAndBits.instance.config.enableBitLightSource) {
            try {
                Integer rlv = replacementLightValue.get();
                if (rlv != null) {
                    return rlv;
                }
                Integer lv = (Integer)this.getTileEntity(world, pos).getState().getValue(light_prop);
                return lv == null ? 0 : lv;
            }
            catch (ExceptionNoTileEntity exceptionNoTileEntity) {
                // empty catch block
            }
        }
        return 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (ChiselsAndBits.instance.config.enableToolHarvestLevels) {
            try {
                String cname;
                Exception e;
                StackTraceElement[] elements;
                if (state instanceof IExtendedBlockState && worldIn instanceof World && (elements = (e = new Exception()).getStackTrace()) != null && elements.length > 2 && (cname = elements[1].getClassName()).contains("minecraftforge")) {
                    TileEntityBlockChiseled tebc = this.getTileEntity(worldIn, pos);
                    return tebc.getState();
                }
            }
            catch (ExceptionNoTileEntity exceptionNoTileEntity) {
                // empty catch block
            }
        }
        return super.func_176221_a(state, worldIn, pos);
    }

    public String getHarvestTool(IBlockState state) {
        IBlockState blockRef;
        if (actingAs != null && actingAs.func_177230_c() != this) {
            return actingAs.func_177230_c().getHarvestTool(actingAs);
        }
        if (ChiselsAndBits.instance.config.enableToolHarvestLevels && state instanceof IExtendedBlockState && (blockRef = this.getCommonState((IExtendedBlockState)state)) != null) {
            String tool = blockRef.func_177230_c().getHarvestTool(blockRef);
            if (tool == null) {
                tool = "pickaxe";
            }
            return tool;
        }
        return super.getHarvestTool(state);
    }

    public int getHarvestLevel(IBlockState state) {
        IBlockState blockRef;
        if (actingAs != null && actingAs.func_177230_c() != this) {
            return actingAs.func_177230_c().getHarvestLevel(actingAs);
        }
        if (ChiselsAndBits.instance.config.enableToolHarvestLevels && state instanceof IExtendedBlockState && (blockRef = this.getCommonState((IExtendedBlockState)state)) != null) {
            return blockRef.func_177230_c().getHarvestLevel(blockRef);
        }
        return super.getHarvestLevel(state);
    }
}

