/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.bitbag;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mod.chiselsandbits.helpers.LocalStrings;
import mod.chiselsandbits.items.ItemChisel;
import mod.chiselsandbits.items.ItemChiseledBit;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BagInventory
implements IInventory {
    public static final int max_size = 63;
    final int[] slots;
    final ItemStack[] stackSlots;
    final ItemStack target;

    public static int getSlotsUsed(ItemStack target) {
        NBTTagCompound tag = target.func_77978_p();
        if (tag == null) {
            return 0;
        }
        if (!tag.func_74764_b("contents")) {
            return 0;
        }
        int[] slots = tag.func_74759_k("contents");
        int used = 0;
        for (int index = 0; index < slots.length; index += 2) {
            int qty = slots[index + 1];
            int id = slots[index + 0];
            if (qty <= 0 || id <= 0) continue;
            ++used;
        }
        return used;
    }

    public BagInventory(ItemStack is) {
        this.target = is;
        NBTTagCompound tag = this.target.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            is.func_77982_d(tag);
        }
        int slotCount = 63;
        int len = 126;
        this.stackSlots = new ItemStack[63];
        if (!tag.func_74764_b("contents")) {
            tag.func_74783_a("contents", new int[126]);
        }
        if (tag.func_74759_k("contents").length != 126) {
            tag.func_74783_a("contents", new int[126]);
        }
        this.slots = tag.func_74759_k("contents");
    }

    public String func_70005_c_() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public IChatComponent func_145748_c_() {
        return null;
    }

    public int func_70302_i_() {
        return this.stackSlots.length;
    }

    public ItemStack func_70301_a(int index) {
        int qty = this.slots[2 * index + 1];
        int id = this.slots[2 * index + 0];
        if (this.stackSlots[index] != null) {
            this.stackSlots[index].field_77994_a = qty;
            return this.stackSlots[index];
        }
        if (qty == 0 || id == 0) {
            return null;
        }
        this.stackSlots[index] = ItemChiseledBit.createStack(id, qty, false);
        return this.stackSlots[index];
    }

    public ItemStack func_70298_a(int index, int count) {
        int qty = this.slots[2 * index + 1];
        int id = this.slots[2 * index + 0];
        if (qty == 0 || id == 0) {
            return null;
        }
        if (count > qty) {
            count = qty;
        }
        int n = 2 * index + 1;
        this.slots[n] = this.slots[n] - count;
        if (this.stackSlots[index] != null) {
            this.stackSlots[index].field_77994_a -= count;
        }
        return ItemChiseledBit.createStack(id, count, false);
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.stackSlots[index] = null;
        if (stack != null && stack.func_77973_b() instanceof ItemChiseledBit) {
            this.slots[2 * index + 1] = stack.field_77994_a;
            this.slots[2 * index + 0] = ItemChisel.getStackState(stack);
        } else {
            this.slots[2 * index + 1] = 0;
            this.slots[2 * index + 0] = 0;
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        for (int x = 0; x < this.func_70302_i_(); ++x) {
            if (this.stackSlots[x] == null) continue;
            this.slots[2 * x + 1] = this.stackSlots[x].field_77994_a;
            this.stackSlots[x] = null;
        }
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof ItemChiseledBit;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        for (int x = 0; x < this.slots.length; ++x) {
            this.slots[x] = 0;
            this.stackSlots[x] = null;
        }
    }

    public void restockItem(ItemStack target) {
        for (int x = 0; x < this.func_70302_i_(); ++x) {
            ItemStack is = this.func_70301_a(x);
            if (is == null || is.func_77973_b() != target.func_77973_b() || !ItemChiseledBit.sameBit(target, ItemChisel.getStackState(is))) continue;
            target.field_77994_a += is.field_77994_a;
            int total = target.field_77994_a;
            target.field_77994_a = Math.min(is.func_77976_d(), target.field_77994_a);
            int overage = total - target.field_77994_a;
            if (overage > 0) {
                is.field_77994_a = overage;
            } else {
                this.func_70299_a(x, null);
            }
            this.func_70296_d();
        }
    }

    public ItemStack insertItem(ItemStack which) {
        for (int x = 0; x < this.func_70302_i_(); ++x) {
            ItemStack is = this.func_70301_a(x);
            if (is != null && ItemChisel.getStackState(which) == ItemChisel.getStackState(is)) {
                is.field_77994_a += which.field_77994_a;
                int total = is.field_77994_a;
                is.field_77994_a = Math.min(is.func_77976_d(), is.field_77994_a);
                int overage = total - is.field_77994_a;
                if (overage > 0) {
                    which.field_77994_a = overage;
                    this.func_70296_d();
                    continue;
                }
                this.func_70296_d();
                return null;
            }
            if (is != null) continue;
            this.func_70299_a(x, which);
            this.func_70296_d();
            return null;
        }
        return which;
    }

    public int extractBit(int bitMeta, int total) {
        int used = 0;
        for (int index = 0; index < this.stackSlots.length; ++index) {
            int qty_idx = 2 * index + 1;
            int qty = this.slots[qty_idx];
            int id = this.slots[2 * index + 0];
            if (id != bitMeta || qty <= 0) continue;
            int n = qty_idx;
            this.slots[n] = this.slots[n] - total;
            if (this.slots[qty_idx] < 0) {
                this.slots[qty_idx] = 0;
            }
            int diff = qty - this.slots[qty_idx];
            used += diff;
            if (0 != (total -= diff)) continue;
            return used;
        }
        return used;
    }

    @SideOnly(value=Side.CLIENT)
    public void listContents(List<String> details) {
        HashMap<String, Integer> contents = new HashMap<String, Integer>();
        for (int x = 0; x < this.func_70302_i_(); ++x) {
            Item what;
            Block blk;
            IBlockState state;
            ItemStack is = this.func_70301_a(x);
            if (is == null || (state = Block.func_176220_d((int)ItemChisel.getStackState(is))) == null || (blk = state.func_177230_c()) == null || (what = Item.func_150898_a((Block)blk)) == null) continue;
            String name = what.func_77653_i(new ItemStack(what, 1, blk.func_176201_c(state)));
            Integer count = (Integer)contents.get(name);
            count = count == null ? Integer.valueOf(is.field_77994_a) : Integer.valueOf(count + is.field_77994_a);
            contents.put(name, count);
        }
        if (contents.isEmpty()) {
            details.add(LocalStrings.Empty.getLocal());
        }
        for (Map.Entry e : contents.entrySet()) {
            details.add(e.getValue() + ' ' + (String)e.getKey());
        }
    }
}

