/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits;

import java.io.File;
import java.lang.reflect.Field;
import java.util.List;
import mod.chiselsandbits.ChiselMode;
import mod.chiselsandbits.ChiselsAndBits;
import mod.chiselsandbits.Configured;
import mod.chiselsandbits.ForgeBus;
import mod.chiselsandbits.helpers.LocalStrings;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ModConfig
extends Configuration {
    public boolean allowBlockAlternatives = false;
    private final File myPath;
    @Configured(category="Integration Settings")
    private boolean ShowBitsInJEI;
    @Configured(category="Client Settings")
    private boolean showUsage;
    @Configured(category="Client Settings")
    public boolean invertBitBagFullness;
    @Configured(category="Client Settings")
    public boolean enableChiselMode_Plane;
    @Configured(category="Client Settings")
    public boolean enableChiselMode_ConnectedPlane;
    @Configured(category="Client Settings")
    public boolean enableChiselMode_Line;
    @Configured(category="Client Settings")
    public boolean enableChiselMode_SmallCube;
    @Configured(category="Client Settings")
    public boolean enableChiselMode_LargeCube;
    @Configured(category="Client Settings")
    public boolean enableChiselMode_HugeCube;
    @Configured(category="Client Settings")
    public boolean enableChiselMode_DrawnRegion;
    @Configured(category="Client Settings")
    public boolean enableChiselMode_Snap2;
    @Configured(category="Client Settings")
    public boolean enableChiselMode_Snap4;
    @Configured(category="Client Settings")
    public boolean enableChiselMode_Snap8;
    @Configured(category="Client Settings")
    public boolean enableToolbarIcons;
    @Configured(category="Client Settings")
    public boolean perChiselMode;
    @Configured(category="Client Settings")
    public boolean chatModeNotification;
    @Configured(category="Client Settings")
    public boolean itemNameModeDisplay;
    @Configured(category="Balance Settings")
    public boolean damageTools;
    @Configured(category="Balance Settings")
    public long availableUsesMultiplier;
    @Configured(category="Crafting")
    boolean enablePositivePrintCrafting;
    @Configured(category="Crafting")
    public boolean enableStackableCrafting;
    @Configured(category="Crafting")
    public boolean enableNegativePrintInversionCrafting;
    @Configured(category="Items")
    boolean enableBitBag;
    @Configured(category="Items")
    boolean enableNegativePrint;
    @Configured(category="Items")
    boolean enablePositivePrint;
    @Configured(category="Items")
    boolean enableChisledBits;
    @Configured(category="Items")
    boolean enableStoneChisel;
    @Configured(category="Items")
    boolean enableIronChisel;
    @Configured(category="Items")
    boolean enableGoldChisel;
    @Configured(category="Items")
    boolean enableDiamondChisel;
    @Configured(category="Items")
    boolean enableWoodenWrench;
    @Configured(category="Balance Settings")
    public boolean enableChiselToolHarvestCheck;
    @Configured(category="Balance Settings")
    public String enableChiselToolHarvestCheckTools;
    @Configured(category="Balance Settings")
    public boolean enableToolHarvestLevels;
    @Configured(category="Balance Settings")
    public boolean enableBitLightSource;
    @Configured(category="Balance Settings")
    public float bitLightPercentage;

    public boolean isEnabled(String className) {
        Property p = this.get("Enabled Blocks", className, true);
        boolean out = p.getBoolean(true);
        if (this.hasChanged()) {
            this.save();
        }
        return out;
    }

    private void setDefaults() {
        this.enableChiselMode_ConnectedPlane = !ChiselMode.CONNECTED_PLANE.isDisabled;
        this.enableChiselMode_HugeCube = !ChiselMode.CUBE_HUGE.isDisabled;
        this.enableChiselMode_LargeCube = !ChiselMode.CUBE_LARGE.isDisabled;
        this.enableChiselMode_SmallCube = !ChiselMode.CUBE_SMALL.isDisabled;
        this.enableChiselMode_Line = !ChiselMode.LINE.isDisabled;
        this.enableChiselMode_Plane = !ChiselMode.PLANE.isDisabled;
        this.enableChiselMode_DrawnRegion = !ChiselMode.DRAWN_REGION.isDisabled;
        this.enableChiselMode_Snap2 = !ChiselMode.SNAP2.isDisabled;
        this.enableChiselMode_Snap4 = !ChiselMode.SNAP4.isDisabled;
        this.enableChiselMode_Snap8 = !ChiselMode.SNAP8.isDisabled;
        this.perChiselMode = true;
        this.chatModeNotification = false;
        this.itemNameModeDisplay = true;
        this.enableToolbarIcons = true;
        this.showUsage = true;
        this.invertBitBagFullness = false;
        this.damageTools = true;
        this.availableUsesMultiplier = 32L;
        this.enablePositivePrintCrafting = true;
        this.enableStackableCrafting = true;
        this.enableNegativePrintInversionCrafting = true;
        this.enableChiselToolHarvestCheck = true;
        this.enableToolHarvestLevels = true;
        this.enableChiselToolHarvestCheckTools = "pickaxe,axe,shovel";
        this.enableBitLightSource = true;
        this.bitLightPercentage = 6.25f;
        this.enableBitBag = true;
        this.enableNegativePrint = true;
        this.enablePositivePrint = true;
        this.enableChisledBits = true;
        this.enableStoneChisel = true;
        this.enableIronChisel = true;
        this.enableGoldChisel = true;
        this.enableDiamondChisel = true;
        this.enableWoodenWrench = true;
        this.ShowBitsInJEI = false;
    }

    public ModConfig(File path) {
        super(path);
        this.myPath = path;
        ChiselsAndBits.registerWithBus((Object)this, ForgeBus.FML);
        this.setDefaults();
        this.populateSettings();
        this.save();
    }

    void populateSettings() {
        Class<ModConfig> me = ModConfig.class;
        for (Field f : me.getDeclaredFields()) {
            Configured c = f.getAnnotation(Configured.class);
            if (c == null) continue;
            try {
                if (f.getType() == Long.TYPE || f.getType() == Long.class) {
                    long defaultValue = f.getLong((Object)this);
                    long value = this.get(c.category(), f.getName(), (int)defaultValue).getInt();
                    f.set((Object)this, value);
                    continue;
                }
                if (f.getType() == String.class) {
                    String defaultValue = (String)f.get((Object)this);
                    String value = this.get(c.category(), f.getName(), defaultValue).getString();
                    f.set((Object)this, value);
                    continue;
                }
                if (f.getType() == Integer.TYPE || f.getType() == Integer.class) {
                    int defaultValue = f.getInt((Object)this);
                    int value = this.get(c.category(), f.getName(), defaultValue).getInt();
                    f.set((Object)this, value);
                    continue;
                }
                if (f.getType() == Float.TYPE || f.getType() == Float.class) {
                    float defaultValue = f.getFloat((Object)this);
                    float value = (float)this.get(c.category(), f.getName(), defaultValue).getDouble();
                    f.set((Object)this, Float.valueOf(value));
                    continue;
                }
                if (f.getType() != Boolean.TYPE && f.getType() != Boolean.class) continue;
                boolean defaultValue = f.getBoolean((Object)this);
                boolean value = this.get(c.category(), f.getName(), defaultValue).getBoolean();
                f.set((Object)this, value);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        this.sync();
    }

    private void sync() {
        ChiselMode.CONNECTED_PLANE.isDisabled = !this.enableChiselMode_ConnectedPlane;
        ChiselMode.CUBE_HUGE.isDisabled = !this.enableChiselMode_HugeCube;
        ChiselMode.CUBE_LARGE.isDisabled = !this.enableChiselMode_LargeCube;
        ChiselMode.CUBE_SMALL.isDisabled = !this.enableChiselMode_SmallCube;
        ChiselMode.LINE.isDisabled = !this.enableChiselMode_Line;
        ChiselMode.PLANE.isDisabled = !this.enableChiselMode_Plane;
        ChiselMode.DRAWN_REGION.isDisabled = !this.enableChiselMode_DrawnRegion;
        ChiselMode.SNAP2.isDisabled = !this.enableChiselMode_Snap2;
        ChiselMode.SNAP4.isDisabled = !this.enableChiselMode_Snap4;
        ChiselMode.SNAP8.isDisabled = !this.enableChiselMode_Snap8;
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if (eventArgs.modID.equals("chiselsandbits")) {
            this.populateSettings();
            this.save();
        }
    }

    public void save() {
        if (this.hasChanged()) {
            super.save();
        }
    }

    public Property get(String category, String key, String defaultValue, String comment, Property.Type type) {
        Property prop = super.get(category, key, defaultValue, comment, type);
        if (prop != null && !category.equals("Client Settings")) {
            prop.setRequiresMcRestart(true);
        }
        return prop;
    }

    public void helpText(LocalStrings string, List tooltip) {
        if (this.showUsage) {
            String[] lines;
            for (String a : lines = string.getLocal().split(";")) {
                tooltip.add(a);
            }
        }
    }

    public String getFilePath() {
        return this.myPath.getAbsolutePath();
    }
}

