/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import mod.chiselsandbits.ChiselMode;
import mod.chiselsandbits.ChiselsAndBits;
import mod.chiselsandbits.ForgeBus;
import mod.chiselsandbits.ReflectionWrapper;
import mod.chiselsandbits.chiseledblock.BlockChiseled;
import mod.chiselsandbits.chiseledblock.ItemBlockChiseled;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseled;
import mod.chiselsandbits.chiseledblock.data.IntegerBox;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.chiseledblock.data.VoxelBlobState;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.items.ItemChisel;
import mod.chiselsandbits.items.ItemChiseledBit;
import mod.chiselsandbits.network.NetworkRouter;
import mod.chiselsandbits.network.packets.ChiselPacket;
import mod.chiselsandbits.render.SculptureModelGenerator;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ISmartBlockModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class ClientSide {
    public static final ClientSide instance = new ClientSide();
    private final Random rand = new Random();
    HashMap<ChiselMode, TextureAtlasSprite> jo = new HashMap();
    private ItemStack previousItem;
    private int previousRotations;
    private Object previousModel;
    private Object previousCacheRef;
    private IntegerBox modelBounds;
    private boolean isVisible = true;
    private BlockPos lastPartial;
    public static HashMap<Integer, String> blockToTexture = new HashMap();
    private BlockPos drawBlock;
    private BlockPos drawStart;
    private boolean loopDeath = false;

    public void preinit(ChiselsAndBits mod) {
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new SculptureModelGenerator());
    }

    public void init(ChiselsAndBits chiselsandbits) {
        for (ChiselMode mode : ChiselMode.values()) {
            KeyBinding binding = new KeyBinding(mode.string.toString(), 0, "itemGroup.chiselsandbits");
            ClientRegistry.registerKeyBinding((KeyBinding)binding);
            mode.binding = binding;
        }
        ChiselsAndBits.registerWithBus(instance, ForgeBus.BOTH);
    }

    public void postinit(ChiselsAndBits mod) {
        ItemModelMesher mesher = Minecraft.func_71410_x().func_175599_af().func_175037_a();
        String MODID = "chiselsandbits";
        this.registerMesh(mesher, (Item)mod.itemChiselStone, 0, new ModelResourceLocation(new ResourceLocation("chiselsandbits", "chisel_stone"), "inventory"));
        this.registerMesh(mesher, (Item)mod.itemChiselIron, 0, new ModelResourceLocation(new ResourceLocation("chiselsandbits", "chisel_iron"), "inventory"));
        this.registerMesh(mesher, (Item)mod.itemChiselGold, 0, new ModelResourceLocation(new ResourceLocation("chiselsandbits", "chisel_gold"), "inventory"));
        this.registerMesh(mesher, (Item)mod.itemChiselDiamond, 0, new ModelResourceLocation(new ResourceLocation("chiselsandbits", "chisel_diamond"), "inventory"));
        this.registerMesh(mesher, mod.itemBitBag, 0, new ModelResourceLocation(new ResourceLocation("chiselsandbits", "bit_bag"), "inventory"));
        this.registerMesh(mesher, mod.itemWrench, 0, new ModelResourceLocation(new ResourceLocation("chiselsandbits", "wrench_wood"), "inventory"));
        if (mod.itemPositiveprint != null) {
            ModelBakery.addVariantName((Item)mod.itemPositiveprint, (String[])new String[]{"chiselsandbits:positiveprint", "chiselsandbits:positiveprint_written"});
            mesher.func_178080_a((Item)mod.itemPositiveprint, new ItemMeshDefinition(){

                public ModelResourceLocation func_178113_a(ItemStack stack) {
                    return new ModelResourceLocation(new ResourceLocation("chiselsandbits", stack.func_77942_o() ? "positiveprint_written_preview" : "positiveprint"), "inventory");
                }
            });
        }
        if (mod.itemNegativeprint != null) {
            ModelBakery.addVariantName((Item)mod.itemNegativeprint, (String[])new String[]{"chiselsandbits:negativeprint", "chiselsandbits:negativeprint_written"});
            mesher.func_178080_a((Item)mod.itemNegativeprint, new ItemMeshDefinition(){

                public ModelResourceLocation func_178113_a(ItemStack stack) {
                    return new ModelResourceLocation(new ResourceLocation("chiselsandbits", stack.func_77942_o() ? "negativeprint_written_preview" : "negativeprint"), "inventory");
                }
            });
        }
        if (mod.itemBlockBit != null) {
            mesher.func_178080_a((Item)mod.itemBlockBit, new ItemMeshDefinition(){

                public ModelResourceLocation func_178113_a(ItemStack stack) {
                    return new ModelResourceLocation(new ResourceLocation("chiselsandbits", "block_bit"), "inventory");
                }
            });
        }
        for (BlockChiseled blk : mod.conversions.values()) {
            Item item = Item.func_150898_a((Block)blk);
            mesher.func_178086_a(item, 0, new ModelResourceLocation(new ResourceLocation("chiselsandbits", "block_chiseled"), "inventory"));
        }
        ChiselsAndBits.instance.config.allowBlockAlternatives = Minecraft.func_71410_x().field_71474_y.field_178880_u;
    }

    private void registerMesh(ItemModelMesher mesher, Item item, int i, ModelResourceLocation loctaion) {
        if (item != null) {
            mesher.func_178086_a(item, i, loctaion);
        }
    }

    @SubscribeEvent
    void registerIconTextures(TextureStitchEvent.Pre ev) {
        for (ChiselMode mode : ChiselMode.values()) {
            this.jo.put(mode, ev.map.func_174942_a(new ResourceLocation("chiselsandbits", "icons/" + mode.name().toLowerCase())));
        }
    }

    @SubscribeEvent
    public void onRenderGUI(RenderGameOverlayEvent.Post event) {
        if (event.type == RenderGameOverlayEvent.ElementType.HOTBAR && ChiselsAndBits.instance.config.enableToolbarIcons) {
            Minecraft mc = Minecraft.func_71410_x();
            GuiIngame sc = mc.field_71456_v;
            for (int slot = 0; slot < 9; ++slot) {
                ItemStack stack = mc.field_71439_g.field_71071_by.field_70462_a[slot];
                if (stack == null || !(stack.func_77973_b() instanceof ItemChisel)) continue;
                ChiselMode mode = ChiselMode.getMode(stack);
                int x = event.resolution.func_78326_a() / 2 - 90 + slot * 20 + 2;
                int y = event.resolution.func_78328_b() - 16 - 3;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
                TextureAtlasSprite sprite = this.jo.get((Object)mode);
                GlStateManager.func_179147_l();
                sc.func_175175_a(x + 1, y + 1, sprite, 8, 8);
                GlStateManager.func_179084_k();
            }
        }
    }

    @SubscribeEvent
    public void interaction(TickEvent.ClientTickEvent event) {
        if (event.side == Side.CLIENT && event.type == TickEvent.Type.CLIENT && event.phase == TickEvent.Phase.START && !Minecraft.func_71410_x().field_71474_y.field_74312_F.func_151470_d()) {
            ItemChisel.resetDelay();
        }
        if (!Minecraft.func_71410_x().field_71474_y.field_74312_F.func_151470_d()) {
            if (this.loopDeath) {
                this.drawBlock = null;
                this.drawStart = null;
            } else {
                this.loopDeath = true;
            }
        } else {
            this.loopDeath = false;
        }
        for (ChiselMode mode : ChiselMode.values()) {
            KeyBinding kb = (KeyBinding)mode.binding;
            if (!kb.func_151470_d()) continue;
            ItemChisel.changeChiselMode(ItemChisel.getChiselMode(), mode);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void updateConfig(GuiScreenEvent.ActionPerformedEvent.Pre ev) {
        Minecraft.func_71410_x().func_152344_a(new Runnable(){

            @Override
            public void run() {
                ChiselsAndBits.instance.config.allowBlockAlternatives = Minecraft.func_71410_x().field_71474_y.field_178880_u;
            }
        });
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void drawHighlight(DrawBlockHighlightEvent event) {
        EntityPlayer player = event.player;
        float partialTicks = event.partialTicks;
        MovingObjectPosition mop = event.target;
        World theWorld = player.field_70170_p;
        double x = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        double y = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        double z = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        ChiselMode chMode = ModUtil.isHoldingChiselTool(event.player);
        if (chMode != null) {
            if (mop.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
                return;
            }
            BlockPos blockpos = mop.func_178782_a();
            IBlockState state = theWorld.func_180495_p(blockpos);
            Block block = state.func_177230_c();
            if (BlockChiseled.supportsBlock(state) && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                GlStateManager.func_179147_l();
                GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
                GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                GL11.glLineWidth((float)2.0f);
                GlStateManager.func_179090_x();
                GlStateManager.func_179132_a((boolean)false);
                if (block.func_149688_o() != Material.field_151579_a && theWorld.func_175723_af().func_177746_a(blockpos)) {
                    VoxelBlob vb = new VoxelBlob();
                    vb.fill(1);
                    BlockChiseled chiselBlock = ChiselsAndBits.instance.getConversion(block.func_149688_o());
                    RenderGlobal.func_147590_a((AxisAlignedBB)chiselBlock.getSelectedBoundingBox(player, blockpos, vb, chMode).func_72314_b((double)0.002f, (double)0.002f, (double)0.002f).func_72317_d(-x, -y, -z), (int)-1);
                }
                GlStateManager.func_179132_a((boolean)true);
                GlStateManager.func_179098_w();
                GlStateManager.func_179084_k();
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void drawLast(RenderWorldLastEvent event) {
        if (Minecraft.func_71410_x().field_71474_y.field_74319_N) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        float partialTicks = event.partialTicks;
        MovingObjectPosition mop = Minecraft.func_71410_x().field_71476_x;
        World theWorld = player.field_70170_p;
        ItemStack currentItem = player.func_71045_bC();
        double x = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        double y = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        double z = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        if (mop == null) {
            return;
        }
        if (ModUtil.isHoldingPattern((EntityPlayer)player)) {
            if (mop.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
                return;
            }
            IBlockState s = theWorld.func_180495_p(mop.func_178782_a());
            if (!(s.func_177230_c() instanceof BlockChiseled) && !BlockChiseled.supportsBlock(s)) {
                return;
            }
            if (!currentItem.func_77942_o()) {
                return;
            }
            ItemStack item = ChiselsAndBits.instance.itemNegativeprint.getPatternedItem(currentItem);
            if (!item.func_77942_o()) {
                return;
            }
            int rotations = ModUtil.getRotations((EntityLivingBase)player, currentItem.func_77978_p().func_74771_c("side"));
            if (item != null) {
                Object cacheRef;
                Object object = cacheRef = s.func_177230_c() instanceof BlockChiseled ? theWorld.func_175625_s(mop.func_178782_a()) : s;
                if (cacheRef instanceof TileEntityBlockChiseled) {
                    cacheRef = ((TileEntityBlockChiseled)((Object)cacheRef)).getBlobRef();
                }
                GlStateManager.func_179143_c((int)519);
                this.showGhost(currentItem, item, mop.func_178782_a(), (EntityPlayer)player, rotations, x, y, z, mop.field_178784_b, null, cacheRef);
                GlStateManager.func_179143_c((int)515);
            }
        } else if (ModUtil.isHoldingChiseledBlock((EntityPlayer)player)) {
            if (mop.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
                return;
            }
            ItemStack item = currentItem;
            if (!item.func_77942_o()) {
                return;
            }
            int rotations = ModUtil.getRotations((EntityLivingBase)player, item.func_77978_p().func_74771_c("side"));
            BlockPos offset = mop.func_178782_a();
            Block cb = theWorld.func_180495_p(offset).func_177230_c();
            if (player.func_70093_af()) {
                BlockPos blockpos = mop.func_178782_a();
                BlockPos partial = new BlockPos(Math.floor(16.0 * (mop.field_72307_f.field_72450_a - (double)blockpos.func_177958_n())), Math.floor(16.0 * (mop.field_72307_f.field_72448_b - (double)blockpos.func_177956_o())), Math.floor(16.0 * (mop.field_72307_f.field_72449_c - (double)blockpos.func_177952_p())));
                this.showGhost(currentItem, item, offset, (EntityPlayer)player, rotations, x, y, z, mop.field_178784_b, partial, null);
            } else if (cb.func_176200_f(theWorld, offset)) {
                this.showGhost(currentItem, item, offset, (EntityPlayer)player, rotations, x, y, z, mop.field_178784_b, null, null);
            } else if (theWorld.func_175623_d(offset.func_177972_a(mop.field_178784_b))) {
                this.showGhost(currentItem, item, offset.func_177972_a(mop.field_178784_b), (EntityPlayer)player, rotations, x, y, z, mop.field_178784_b, null, null);
            }
        }
    }

    private void showGhost(ItemStack refItem, ItemStack item, BlockPos blockPos, EntityPlayer player, int rotations, double x, double y, double z, EnumFacing side, BlockPos partial, Object cacheRef) {
        IBakedModel baked;
        block10: {
            VoxelBlob blob;
            TileEntityBlockChiseled bc;
            block11: {
                VoxelBlob pattern;
                block13: {
                    block12: {
                        block9: {
                            if (this.previousCacheRef != cacheRef || this.previousItem != refItem || this.previousRotations != rotations || this.previousModel == null || !this.samePartial(this.lastPartial, partial)) break block9;
                            baked = (IBakedModel)this.previousModel;
                            break block10;
                        }
                        this.previousItem = refItem;
                        this.previousRotations = rotations;
                        this.previousCacheRef = cacheRef;
                        bc = new TileEntityBlockChiseled();
                        bc.readChisleData(item.func_179543_a("BlockEntityTag", false));
                        blob = bc.getBlob();
                        while (rotations-- > 0) {
                            blob = blob.spin(EnumFacing.Axis.Y);
                        }
                        this.modelBounds = blob.getBounds();
                        if (refItem.func_77973_b() != ChiselsAndBits.instance.itemNegativeprint) break block11;
                        pattern = blob;
                        if (!(cacheRef instanceof VoxelBlobState)) break block12;
                        blob = ((VoxelBlobState)cacheRef).getVoxelBlob();
                        break block13;
                    }
                    if (!(cacheRef instanceof IBlockState)) break block11;
                    blob = new VoxelBlob();
                    blob.fill(Block.func_176210_f((IBlockState)((IBlockState)cacheRef)));
                }
                for (int zz = 0; zz < pattern.detail; ++zz) {
                    for (int yy = 0; yy < pattern.detail; ++yy) {
                        for (int xx = 0; xx < pattern.detail; ++xx) {
                            if (pattern.get(xx, yy, zz) != 0) continue;
                            blob.set(xx, yy, zz, 0);
                        }
                    }
                }
            }
            bc.setBlob(blob);
            Block blk = Block.func_149634_a((Item)item.func_77973_b());
            baked = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(bc.getItemStack(blk, null));
            this.previousModel = baked;
            this.isVisible = partial != null ? ItemBlockChiseled.tryPlaceBlockAt(blk, item, (EntityLivingBase)player, player.func_130014_f_(), blockPos, side, partial, false) : true;
        }
        if (!this.isVisible) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(0.5 + (double)blockPos.func_177958_n() - x), (double)(0.5 + (double)blockPos.func_177956_o() - y), (double)(0.5 + (double)blockPos.func_177952_p() - z));
        if (partial != null) {
            BlockPos t = ModUtil.getPartialOffset(side, partial, this.modelBounds);
            double fullScale = 0.0625;
            GlStateManager.func_179137_b((double)((double)t.func_177958_n() * 0.0625), (double)((double)t.func_177956_o() * 0.0625), (double)((double)t.func_177952_p() * 0.0625));
        }
        GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        ItemBlockChiseled.renderTransparentGhost = true;
        Minecraft.func_71410_x().func_175599_af().func_180454_a(item, baked);
        GlStateManager.func_179143_c((int)515);
        Minecraft.func_71410_x().func_175599_af().func_180454_a(item, baked);
        ItemBlockChiseled.renderTransparentGhost = false;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    private boolean samePartial(BlockPos lastPartial2, BlockPos partial) {
        if (lastPartial2 == partial) {
            return true;
        }
        if (lastPartial2 == null || partial == null) {
            return false;
        }
        return partial.equals((Object)lastPartial2);
    }

    public EntityPlayer getPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public boolean addHitEffects(World world, MovingObjectPosition target, IBlockState state, EffectRenderer effectRenderer) {
        ItemStack hitWith = this.getPlayer().func_71045_bC();
        if (hitWith != null && (hitWith.func_77973_b() instanceof ItemChisel || hitWith.func_77973_b() instanceof ItemChiseledBit)) {
            return true;
        }
        BlockPos pos = target.func_178782_a();
        Block block = state.func_177230_c();
        int posX = pos.func_177958_n();
        int posY = pos.func_177956_o();
        int posZ = pos.func_177952_p();
        float boxOffset = 0.1f;
        double x = (double)posX + this.rand.nextDouble() * (block.func_149753_y() - block.func_149704_x() - (double)0.2f) + (double)0.1f + block.func_149704_x();
        double y = (double)posY + this.rand.nextDouble() * (block.func_149669_A() - block.func_149665_z() - (double)0.2f) + (double)0.1f + block.func_149665_z();
        double z = (double)posZ + this.rand.nextDouble() * (block.func_149693_C() - block.func_149706_B() - (double)0.2f) + (double)0.1f + block.func_149706_B();
        switch (target.field_178784_b) {
            case DOWN: {
                y = (double)posY + block.func_149665_z() - (double)0.1f;
                break;
            }
            case EAST: {
                x = (double)posX + block.func_149753_y() + (double)0.1f;
                break;
            }
            case NORTH: {
                z = (double)posZ + block.func_149706_B() - (double)0.1f;
                break;
            }
            case SOUTH: {
                z = (double)posZ + block.func_149693_C() + (double)0.1f;
                break;
            }
            case UP: {
                y = (double)posY + block.func_149669_A() + (double)0.1f;
                break;
            }
            case WEST: {
                x = (double)posX + block.func_149704_x() - (double)0.1f;
                break;
            }
        }
        EntityFX fx = effectRenderer.func_178927_a(EnumParticleTypes.BLOCK_DUST.func_179348_c(), x, y, z, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)state)});
        if (fx != null) {
            fx.func_70543_e(0.2f).func_70541_f(0.6f);
        }
        return true;
    }

    @SubscribeEvent
    public void wheelEvent(MouseEvent me) {
        if (me.isCanceled() || me.dwheel == 0) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        ItemStack is = player.func_70694_bm();
        if (is != null && is.func_77973_b() instanceof ItemChisel && player.func_70093_af()) {
            ChiselMode mode = ItemChisel.getChiselMode();
            ItemChisel.scrollOption(mode, mode, me.dwheel);
            me.setCanceled(true);
        }
    }

    public static void placeSound(World world, BlockPos pos, int metadata) {
        IBlockState state = Block.func_176220_d((int)metadata);
        Block block = state.func_177230_c();
        world.func_72980_b((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), block.field_149762_H.func_150496_b(), (block.field_149762_H.func_150497_c() + 1.0f) / 16.0f, block.field_149762_H.func_150494_d() * 0.9f, false);
    }

    public static void breakSound(World world, BlockPos pos, int extractedState) {
        IBlockState state = Block.func_176220_d((int)extractedState);
        Block block = state.func_177230_c();
        world.func_72980_b((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), block.field_149762_H.func_150495_a(), (block.field_149762_H.func_150497_c() + 1.0f) / 16.0f, block.field_149762_H.func_150494_d() * 0.9f, false);
    }

    private static TextureAtlasSprite findTexture(TextureAtlasSprite texture, List<BakedQuad> faceQuads) throws IllegalArgumentException, IllegalAccessException, NullPointerException {
        if (texture == null) {
            TextureMap map = Minecraft.func_71410_x().func_147117_R();
            Map<String, TextureAtlasSprite> mapRegisteredSprites = ReflectionWrapper.instance.getRegSprite(map);
            if (mapRegisteredSprites == null) {
                throw new RuntimeException("Unable to lookup textures.");
            }
            for (BakedQuad q : faceQuads) {
                int offsetSize = q.func_178209_a().length / 4;
                int[] data = q.func_178209_a();
                float UA = Float.intBitsToFloat(data[4]);
                float VA = Float.intBitsToFloat(data[5]);
                float UB = Float.intBitsToFloat(data[offsetSize + 4]);
                float VB = Float.intBitsToFloat(data[offsetSize + 5]);
                float UC = Float.intBitsToFloat(data[offsetSize * 2 + 4]);
                float VC = Float.intBitsToFloat(data[offsetSize * 2 + 5]);
                float U = (UA + UB + UC) / 3.0f;
                float V = (VA + VB + VC) / 3.0f;
                for (TextureAtlasSprite sprite : mapRegisteredSprites.values()) {
                    if (!(sprite.func_94209_e() <= U) || !(U <= sprite.func_94212_f()) || !(sprite.func_94206_g() <= V) || !(V <= sprite.func_94210_h())) continue;
                    texture = sprite;
                    return texture;
                }
            }
        }
        return texture;
    }

    public static TextureAtlasSprite findTexture(int BlockRef, IBakedModel originalModel) {
        TextureAtlasSprite texture = null;
        if (originalModel != null) {
            try {
                IBakedModel newModel;
                if (originalModel instanceof ISmartBlockModel && (newModel = ((ISmartBlockModel)originalModel).handleBlockState(Block.func_176220_d((int)BlockRef))) != null) {
                    originalModel = newModel;
                }
            }
            catch (Exception newModel) {
                // empty catch block
            }
            try {
                texture = originalModel.func_177554_e();
            }
            catch (Exception err) {
                if (blockToTexture.containsKey(BlockRef)) {
                    String textureName = blockToTexture.get(BlockRef);
                    if (textureName != null) {
                        texture = Minecraft.func_71410_x().func_147117_R().func_110572_b(textureName);
                    }
                }
                try {
                    for (EnumFacing side : EnumFacing.field_82609_l) {
                        texture = ClientSide.findTexture(texture, originalModel.func_177551_a(side));
                    }
                    texture = ClientSide.findTexture(texture, originalModel.func_177550_a());
                    blockToTexture.put(BlockRef, texture == null ? null : texture.func_94215_i());
                }
                catch (Exception errr) {
                    blockToTexture.put(BlockRef, null);
                }
            }
        }
        if (texture == null) {
            texture = Minecraft.func_71410_x().func_147117_R().func_174944_f();
        }
        return texture;
    }

    public BlockPos getStartPos() {
        return this.drawStart;
    }

    public void pointAt(BlockPos pos, int x, int y, int z) {
        if (this.drawBlock == null || this.drawBlock.equals((Object)pos)) {
            this.drawBlock = pos;
            if (this.drawStart == null) {
                this.drawStart = new BlockPos(x, y, z);
            }
        }
    }

    public boolean sameDrawBlock(BlockPos pos, int x, int y, int z) {
        ChiselPacket pc;
        int extractedState;
        if (Minecraft.func_71410_x().field_71474_y.field_74312_F.func_151470_d()) {
            return this.drawBlock != null && this.drawBlock.equals((Object)pos);
        }
        if (this.drawBlock != null && this.drawBlock.equals((Object)pos) && (extractedState = (pc = new ChiselPacket(pos, this.drawStart.func_177958_n(), this.drawStart.func_177956_o(), this.drawStart.func_177952_p(), x, y, z, EnumFacing.UP, ChiselMode.DRAWN_REGION)).doAction((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) != 0) {
            ClientSide.breakSound((World)Minecraft.func_71410_x().field_71441_e, pos, extractedState);
            NetworkRouter.instance.sendToServer(pc);
        }
        this.drawBlock = null;
        this.drawStart = null;
        return false;
    }

    public boolean addBlockDestroyEffects(World world, BlockPos pos, IBlockState state, EffectRenderer effectRenderer) {
        if (!state.func_177230_c().isAir((IBlockAccess)world, pos)) {
            state = state.func_177230_c().func_176221_a(state, (IBlockAccess)world, pos);
            int StateID = Block.func_176210_f((IBlockState)state);
            int i = 4;
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    for (int l = 0; l < 4; ++l) {
                        double d0 = (double)pos.func_177958_n() + ((double)j + 0.5) / 4.0;
                        double d1 = (double)pos.func_177956_o() + ((double)k + 0.5) / 4.0;
                        double d2 = (double)pos.func_177952_p() + ((double)l + 0.5) / 4.0;
                        effectRenderer.func_178927_a(EnumParticleTypes.BLOCK_CRACK.func_179348_c(), d0, d1, d2, d0 - (double)pos.func_177958_n() - 0.5, d1 - (double)pos.func_177956_o() - 0.5, d2 - (double)pos.func_177952_p() - 0.5, new int[]{StateID});
                    }
                }
            }
        }
        return true;
    }
}

