/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits;

import java.util.HashMap;
import java.util.Iterator;
import mod.chiselsandbits.ClientSide;
import mod.chiselsandbits.CreativeTab;
import mod.chiselsandbits.ForgeBus;
import mod.chiselsandbits.ModConfig;
import mod.chiselsandbits.chiseledblock.BlockChiseled;
import mod.chiselsandbits.chiseledblock.ItemBlockChiseled;
import mod.chiselsandbits.chiseledblock.MaterialType;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseled;
import mod.chiselsandbits.crafting.ChiselCrafting;
import mod.chiselsandbits.crafting.NegativeInversionCrafting;
import mod.chiselsandbits.crafting.StackableCrafting;
import mod.chiselsandbits.gui.ModGuiRouter;
import mod.chiselsandbits.integration.IntegerationJEI;
import mod.chiselsandbits.items.ItemBitBag;
import mod.chiselsandbits.items.ItemChisel;
import mod.chiselsandbits.items.ItemChiseledBit;
import mod.chiselsandbits.items.ItemNegativePrint;
import mod.chiselsandbits.items.ItemPositivePrint;
import mod.chiselsandbits.items.ItemWrench;
import mod.chiselsandbits.network.NetworkRouter;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.RecipeSorter;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

@Mod(name="Chisels & Bits", modid="chiselsandbits", version="1.6.5", acceptedMinecraftVersions="[1.8]", dependencies="required-after:Forge@[11.14.2.1423,)", guiFactory="mod.chiselsandbits.gui.ModConfigGuiFactory")
public class ChiselsAndBits {
    public static final String MODNAME = "Chisels & Bits";
    public static final String MODID = "chiselsandbits";
    public static final String VERSION = "1.6.5";
    public static final String DEPENDENCIES = "required-after:Forge@[11.14.2.1423,)";
    public static final String unlocalizedPrefix = "mod.chiselsandbits.";
    public static CreativeTab creativeTab = new CreativeTab();
    public static ChiselsAndBits instance;
    public static final MaterialType[] validMaterials;
    final HashMap<Material, BlockChiseled> conversions = new HashMap();
    public ItemChisel itemChiselStone;
    public ItemChisel itemChiselIron;
    public ItemChisel itemChiselGold;
    public ItemChisel itemChiselDiamond;
    public ItemChiseledBit itemBlockBit;
    public ItemPositivePrint itemPositiveprint;
    public ItemNegativePrint itemNegativeprint;
    public ItemBitBag itemBitBag;
    public ItemWrench itemWrench;
    public ModConfig config;
    private final IntegerationJEI jei = new IntegerationJEI();

    public IBlockState getChiseledDefaultState() {
        Iterator<BlockChiseled> iterator = this.conversions.values().iterator();
        if (iterator.hasNext()) {
            BlockChiseled bc = iterator.next();
            return bc.func_176223_P();
        }
        return null;
    }

    public BlockChiseled getConversion(Material material) {
        return this.conversions.get(material);
    }

    public ChiselsAndBits() {
        instance = this;
    }

    private void registerItem(Item item, String name) {
        GameRegistry.registerItem((Item)item.func_77655_b(unlocalizedPrefix + name), (String)name);
    }

    private void registerBlock(Block block, Class<? extends ItemBlock> itemBlock, String name) {
        GameRegistry.registerBlock((Block)block.func_149663_c(unlocalizedPrefix + name), itemBlock == null ? ItemBlock.class : itemBlock, (String)name);
    }

    @Mod.EventHandler
    public void preinit(FMLPreInitializationEvent event) {
        this.config = new ModConfig(event.getSuggestedConfigurationFile());
        this.initVersionChecker();
        if (this.config.enableStoneChisel) {
            this.itemChiselStone = new ItemChisel(Item.ToolMaterial.STONE);
            this.registerItem((Item)this.itemChiselStone, "chisel_stone");
        }
        if (this.config.enableIronChisel) {
            this.itemChiselIron = new ItemChisel(Item.ToolMaterial.IRON);
            this.registerItem((Item)this.itemChiselIron, "chisel_iron");
        }
        if (this.config.enableGoldChisel) {
            this.itemChiselGold = new ItemChisel(Item.ToolMaterial.GOLD);
            this.registerItem((Item)this.itemChiselGold, "chisel_gold");
        }
        if (this.config.enableDiamondChisel) {
            this.itemChiselDiamond = new ItemChisel(Item.ToolMaterial.EMERALD);
            this.registerItem((Item)this.itemChiselDiamond, "chisel_diamond");
        }
        if (this.config.enablePositivePrint) {
            this.itemPositiveprint = new ItemPositivePrint();
            this.registerItem(this.itemPositiveprint, "positiveprint");
        }
        if (this.config.enableNegativePrint) {
            this.itemNegativeprint = new ItemNegativePrint();
            this.registerItem(this.itemNegativeprint, "negativeprint");
        }
        if (this.config.enableBitBag) {
            this.itemBitBag = new ItemBitBag();
            this.registerItem(this.itemBitBag, "bit_bag");
        }
        if (this.config.enableWoodenWrench) {
            this.itemWrench = new ItemWrench();
            this.registerItem(this.itemWrench, "wrench_wood");
        }
        if (this.config.enableChisledBits) {
            this.itemBlockBit = new ItemChiseledBit();
            this.registerItem(this.itemBlockBit, "block_bit");
            this.jei.blackListItem(this.itemBlockBit);
        }
        GameRegistry.registerTileEntity(TileEntityBlockChiseled.class, (String)"mod.chiselsandbits.TileEntityChiseled");
        for (MaterialType mat : validMaterials) {
            BlockChiseled blk = new BlockChiseled(mat.type, "chiseled_" + mat.name);
            this.conversions.put(mat.type, blk);
            this.registerBlock(blk, ItemBlockChiseled.class, blk.name);
        }
        if (event.getSide() == Side.CLIENT) {
            ClientSide.instance.preinit(this);
        }
    }

    private void initVersionChecker() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("curseProjectName", "chisels-bits");
        compound.func_74778_a("curseFilenameParser", "chiselsandbits-[].jar");
        FMLInterModComms.sendRuntimeMessage((Object)MODID, (String)"VersionChecker", (String)"addCurseCheck", (NBTTagCompound)compound);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (event.getSide() == Side.CLIENT) {
            ClientSide.instance.init(this);
        }
        this.jei.init();
        ChiselsAndBits.registerWithBus(this, ForgeBus.BOTH);
        this.ShapedOreRecipe((Item)this.itemChiselDiamond, "TS", Character.valueOf('T'), "gemDiamond", Character.valueOf('S'), "stickWood");
        this.ShapedOreRecipe((Item)this.itemChiselGold, "TS", Character.valueOf('T'), "ingotGold", Character.valueOf('S'), "stickWood");
        this.ShapedOreRecipe((Item)this.itemChiselIron, "TS", Character.valueOf('T'), "ingotIron", Character.valueOf('S'), "stickWood");
        this.ShapedOreRecipe((Item)this.itemChiselStone, "TS", Character.valueOf('T'), "cobblestone", Character.valueOf('S'), "stickWood");
        this.ShapedOreRecipe(this.itemWrench, " W ", "WS ", "  S", Character.valueOf('W'), "plankWood", Character.valueOf('S'), "stickWood");
        this.ShapelessOreRecipe(this.itemPositiveprint, Items.field_151131_as, Items.field_151121_aF, "gemLapis");
        this.ShapelessOreRecipe(this.itemNegativeprint, Items.field_151131_as, Items.field_151121_aF, "dustRedstone");
        this.ShapelessOreRecipe(this.itemPositiveprint, new ItemStack((Item)this.itemPositiveprint, 1, Short.MAX_VALUE));
        this.ShapelessOreRecipe(this.itemNegativeprint, new ItemStack((Item)this.itemNegativeprint, 1, Short.MAX_VALUE));
        if (this.itemBlockBit != null) {
            this.ShapedOreRecipe(this.itemBitBag, "WWW", "WbW", "WWW", Character.valueOf('W'), new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE), Character.valueOf('b'), new ItemStack((Item)this.itemBlockBit, 1, Short.MAX_VALUE));
        }
        if (this.config.enablePositivePrintCrafting) {
            GameRegistry.addRecipe((IRecipe)new ChiselCrafting());
            RecipeSorter.register((String)"chiselsandbits:chiselcrafting", ChiselCrafting.class, (RecipeSorter.Category)RecipeSorter.Category.UNKNOWN, (String)"after:minecraft:shapeless");
        }
        if (this.config.enableStackableCrafting) {
            GameRegistry.addRecipe((IRecipe)new StackableCrafting());
            RecipeSorter.register((String)"chiselsandbits:stackablecrafting", StackableCrafting.class, (RecipeSorter.Category)RecipeSorter.Category.UNKNOWN, (String)"after:minecraft:shapeless");
        }
        if (this.config.enableNegativePrintInversionCrafting) {
            GameRegistry.addRecipe((IRecipe)new NegativeInversionCrafting());
            RecipeSorter.register((String)"chiselsandbits:negativepatterncrafting", NegativeInversionCrafting.class, (RecipeSorter.Category)RecipeSorter.Category.UNKNOWN, (String)"after:minecraft:shapeless");
        }
    }

    private void ShapedOreRecipe(Item result, Object ... recipe) {
        if (result == null) {
            return;
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(result, recipe));
    }

    private void ShapelessOreRecipe(Item result, Object ... recipe) {
        if (result == null) {
            return;
        }
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(result, recipe));
    }

    @Mod.EventHandler
    public void postinit(FMLPostInitializationEvent event) {
        if (event.getSide() == Side.CLIENT) {
            ClientSide.instance.postinit(this);
        }
        NetworkRouter.instance = new NetworkRouter();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new ModGuiRouter());
    }

    @SubscribeEvent
    public void interaction(PlayerInteractEvent event) {
        ItemStack is;
        if (event.action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK && event.entityPlayer != null && (is = event.entityPlayer.field_71071_by.func_70448_g()) != null && (is.func_77973_b() instanceof ItemChisel || is.func_77973_b() instanceof ItemChiseledBit)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void breakSpeed(PlayerEvent.BreakSpeed event) {
        ItemStack is;
        if (event.entityPlayer != null && (is = event.entityPlayer.field_71071_by.func_70448_g()) != null && (is.func_77973_b() instanceof ItemChisel || is.func_77973_b() instanceof ItemChiseledBit)) {
            event.newSpeed = 9999.0f;
        }
    }

    public static void registerWithBus(Object obj, ForgeBus bus) {
        switch (bus) {
            case FML: {
                FMLCommonHandler.instance().bus().register(obj);
                break;
            }
            case FORGE: {
                MinecraftForge.EVENT_BUS.register(obj);
                break;
            }
            default: {
                MinecraftForge.EVENT_BUS.register(obj);
                FMLCommonHandler.instance().bus().register(obj);
            }
        }
    }

    static {
        validMaterials = new MaterialType[]{new MaterialType("wood", Material.field_151575_d), new MaterialType("rock", Material.field_151576_e), new MaterialType("iron", Material.field_151573_f), new MaterialType("cloth", Material.field_151580_n), new MaterialType("ice", Material.field_151588_w), new MaterialType("packedIce", Material.field_151598_x), new MaterialType("clay", Material.field_151571_B), new MaterialType("glass", Material.field_151592_s)};
    }
}

