/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.integration.mcmultipart;

import com.google.common.base.Predicate;
import java.util.Collection;
import mcmultipart.block.TileMultipartContainer;
import mcmultipart.client.multipart.MultipartRegistryClient;
import mcmultipart.client.multipart.MultipartSpecialRenderer;
import mcmultipart.microblock.MicroblockClass;
import mcmultipart.microblock.MicroblockRegistry;
import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.IMultipartContainer;
import mcmultipart.multipart.IPartConverter;
import mcmultipart.multipart.IReversePartConverter;
import mcmultipart.multipart.MultipartHelper;
import mcmultipart.multipart.MultipartRegistry;
import mcmultipart.multipart.OcclusionHelper;
import mcmultipart.raytrace.PartMOP;
import mcmultipart.raytrace.RayTraceUtils;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseled;
import mod.chiselsandbits.chiseledblock.data.BitCollisionIterator;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.integration.ChiselsAndBitsIntegration;
import mod.chiselsandbits.integration.IntegrationBase;
import mod.chiselsandbits.integration.mcmultipart.ChiseledBlockConverter;
import mod.chiselsandbits.integration.mcmultipart.ChiseledBlockPart;
import mod.chiselsandbits.integration.mcmultipart.ChiseledBlockRenderChunkMPSR;
import mod.chiselsandbits.integration.mcmultipart.ChiseledMicroblock;
import mod.chiselsandbits.integration.mcmultipart.IMCMultiPart;
import mod.chiselsandbits.integration.mcmultipart.MCMultipartProxy;
import mod.chiselsandbits.integration.mcmultipart.MultipartContainerBuilder;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;

@ChiselsAndBitsIntegration(value="mcmultipart")
public class MCMultiPart
extends IntegrationBase
implements IMCMultiPart {
    public static final String block_name = "chiselsandbits:chisledblock";

    @Override
    public void preinit() {
        MCMultipartProxy.proxyMCMultiPart.setRelay(this);
        MultipartRegistry.registerPart(ChiseledBlockPart.class, (String)block_name);
        MicroblockRegistry.registerMicroClass((MicroblockClass)ChiseledMicroblock.instance);
        ChiseledBlockConverter converter = new ChiseledBlockConverter();
        MultipartRegistry.registerPartConverter((IPartConverter)converter);
        MultipartRegistry.registerReversePartConverter((IReversePartConverter)converter);
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            MultipartRegistryClient.bindMultipartSpecialRenderer(ChiseledBlockPart.class, (MultipartSpecialRenderer)new ChiseledBlockRenderChunkMPSR());
        }
    }

    @Override
    public void removePartIfPossible(TileEntity te) {
        if (te instanceof IMultipartContainer && !te.func_145831_w().field_72995_K) {
            IMultipartContainer container = (IMultipartContainer)te;
            for (IMultipart part : container.getParts()) {
                if (!(part instanceof ChiseledBlockPart)) continue;
                container.removePart(part);
                return;
            }
        }
    }

    @Override
    public void triggerPartChange(TileEntity te) {
        if (te instanceof IMultipartContainer && !te.func_145831_w().field_72995_K) {
            for (IMultipart part : ((IMultipartContainer)te).getParts()) {
                if (!(part instanceof ChiseledBlockPart)) continue;
                ((ChiseledBlockPart)part).notifyPartUpdate();
            }
        }
    }

    @Override
    public void swapRenderIfPossible(TileEntity current, TileEntityBlockChiseled newTileEntity) {
        if (current instanceof IMultipartContainer) {
            IMultipartContainer container = (IMultipartContainer)current;
            for (IMultipart part : container.getParts()) {
                if (!(part instanceof ChiseledBlockPart)) continue;
                ((ChiseledBlockPart)part).swapTile(newTileEntity);
                return;
            }
        }
    }

    @Override
    public TileEntityBlockChiseled getPartIfPossible(World w, BlockPos pos, boolean create) {
        IMultipartContainer container = MultipartHelper.getOrConvertPartContainer((World)w, (BlockPos)pos, (boolean)false);
        if (container != null) {
            for (IMultipart part : container.getParts()) {
                if (!(part instanceof ChiseledBlockPart)) continue;
                return ((ChiseledBlockPart)part).getTile();
            }
            ChiseledBlockPart part = new ChiseledBlockPart();
            if (MultipartHelper.canAddPart((World)w, (BlockPos)pos, (IMultipart)part)) {
                TileEntityBlockChiseled tx;
                if (create && !w.field_72995_K) {
                    tx = part.getTile();
                    tx.occlusionState = new MultipartContainerBuilder(w, pos, part, container);
                    part.setContainer(container);
                    tx.func_145834_a(w);
                    tx.func_174878_a(pos);
                    return tx;
                }
                if (create) {
                    tx = part.getTile();
                    part.setContainer(container);
                    tx.func_145834_a(w);
                    tx.func_174878_a(pos);
                    return tx;
                }
            }
        }
        return null;
    }

    @Override
    public boolean isMultiPart(World w, BlockPos pos) {
        return MultipartHelper.getPartContainer((IBlockAccess)w, (BlockPos)pos) != null || MultipartHelper.canAddPart((World)w, (BlockPos)pos, (IMultipart)new ChiseledBlockPart());
    }

    @Override
    public void populateBlobWithUsedSpace(World w, BlockPos pos, VoxelBlob vb) {
        if (this.isMultiPart(w, pos)) {
            IMultipartContainer mc = MultipartHelper.getOrConvertPartContainer((World)w, (BlockPos)pos, (boolean)false);
            BitCollisionIterator bci = new BitCollisionIterator();
            Collection parts = mc.getParts();
            IMultipart ignore = null;
            for (IMultipart part : parts) {
                if (!(part instanceof ChiseledBlockPart)) continue;
                ignore = part;
            }
            IgnorePred ignorep = new IgnorePred(ignore);
            while (bci.hasNext()) {
                AxisAlignedBB aabb = new AxisAlignedBB((double)bci.physicalX, (double)bci.physicalY, (double)bci.physicalZ, (double)(bci.physicalX + 0.0625f), (double)bci.physicalYp1, (double)bci.physicalZp1);
                if (OcclusionHelper.occlusionTest((IMultipart)OcclusionHelper.boxes((AxisAlignedBB[])new AxisAlignedBB[]{aabb}), (Predicate)ignorep, (Iterable)parts)) continue;
                bci.setNext(vb, 1);
            }
        }
    }

    @Override
    public boolean rotate(World world, BlockPos pos, EntityPlayer player) {
        IMultipartContainer container = MultipartHelper.getPartContainer((IBlockAccess)world, (BlockPos)pos);
        if (container != null) {
            Vec3d start = RayTraceUtils.getStart((EntityPlayer)player);
            Vec3d end = RayTraceUtils.getEnd((EntityPlayer)player);
            RayTraceUtils.AdvancedRayTraceResultPart result = ((TileMultipartContainer)world.func_175625_s(pos)).getPartContainer().collisionRayTrace(start, end);
            if (result != null && result.hit != null && ((PartMOP)result.hit).partHit != null) {
                return ((PartMOP)result.hit).partHit.rotatePart(((PartMOP)result.hit).field_178784_b);
            }
        }
        return false;
    }

    private static class IgnorePred
    implements Predicate<IMultipart> {
        final IMultipart ignore;

        public IgnorePred(IMultipart i) {
            this.ignore = i;
        }

        public boolean apply(IMultipart input) {
            return this.ignore == input;
        }
    }
}

