/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseledblock;

import java.io.IOException;
import mod.chiselsandbits.chiseledblock.BlockChiseled;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseled;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.chiseledblock.data.VoxelBlobStateReference;
import mod.chiselsandbits.core.ChiselsAndBits;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class NBTBlobConverter {
    public static final String NBT_SIDE_FLAGS = "s";
    public static final String NBT_NORMALCUBE_FLAG = "nc";
    public static final String NBT_LIGHTVALUE = "lv";
    public static final String NBT_PRIMARY_STATE = "b";
    public static final String NBT_LEGACY_VOXEL = "v";
    public static final String NBT_VERSIONED_VOXEL = "X";
    TileEntityBlockChiseled tile;
    private int sideState;
    private int lightValue;
    private boolean isNormalCube;
    private int primaryBlockState;
    private VoxelBlobStateReference voxelBlobRef;
    private int format = -1;
    private final boolean triggerUpdates;

    public int getSideState() {
        return this.sideState;
    }

    public int getLightValue() {
        return this.lightValue;
    }

    public boolean isNormalCube() {
        return this.isNormalCube;
    }

    public int getPrimaryBlockStateID() {
        return this.primaryBlockState;
    }

    public IBlockState getPrimaryBlockState() {
        return Block.func_176220_d((int)this.primaryBlockState);
    }

    public VoxelBlobStateReference getVoxelRef(int version, long weight) {
        VoxelBlobStateReference voxelRef = this.getRef();
        if (this.format == version) {
            return new VoxelBlobStateReference(voxelRef.getByteArray(), weight);
        }
        return new VoxelBlobStateReference(voxelRef.getVoxelBlob().blobToBytes(version), weight);
    }

    public NBTBlobConverter() {
        this.triggerUpdates = false;
    }

    public NBTBlobConverter(boolean triggerBlockUpdates, TileEntityBlockChiseled tile) {
        this.tile = tile;
        this.triggerUpdates = triggerBlockUpdates;
        this.sideState = tile.sideState;
        this.lightValue = tile.getLightValue();
        this.isNormalCube = tile.isNormalCube;
        this.primaryBlockState = Block.func_176210_f((IBlockState)tile.getBlockState(Blocks.field_150347_e));
        this.voxelBlobRef = tile.getBlobStateReference();
        this.format = this.voxelBlobRef == null ? -1 : this.voxelBlobRef.getFormat();
    }

    public void fillWith(IBlockState state) {
        this.voxelBlobRef = new VoxelBlobStateReference(Block.func_176210_f((IBlockState)state), 0L);
        this.updateFromBlob();
    }

    public void setBlob(VoxelBlob vb) {
        this.voxelBlobRef = new VoxelBlobStateReference(vb, 0L);
        this.format = this.voxelBlobRef.getFormat();
        this.updateFromBlob();
    }

    public final void writeChisleData(NBTTagCompound compound, boolean crossWorld) {
        VoxelBlobStateReference voxelRef = this.getRef();
        if (this.primaryBlockState == 0) {
            return;
        }
        int newFormat = crossWorld ? VoxelBlob.VERSION_CROSSWORLD : VoxelBlob.VERSION_COMPACT;
        byte[] voxelBytes = newFormat == this.format ? voxelRef.getByteArray() : voxelRef.getVoxelBlob().blobToBytes(newFormat);
        compound.func_74768_a(NBT_LIGHTVALUE, this.lightValue);
        compound.func_74768_a(NBT_PRIMARY_STATE, this.primaryBlockState);
        compound.func_74768_a(NBT_SIDE_FLAGS, this.sideState);
        compound.func_74757_a(NBT_NORMALCUBE_FLAG, this.isNormalCube);
        compound.func_74773_a(NBT_VERSIONED_VOXEL, voxelBytes);
    }

    public final boolean readChisleData(NBTTagCompound compound) {
        this.sideState = compound.func_74762_e(NBT_SIDE_FLAGS);
        this.primaryBlockState = compound.func_74762_e(NBT_PRIMARY_STATE);
        this.lightValue = compound.func_74762_e(NBT_LIGHTVALUE);
        this.isNormalCube = compound.func_74767_n(NBT_NORMALCUBE_FLAG);
        byte[] v = compound.func_74770_j(NBT_VERSIONED_VOXEL);
        if (v == null || v.length == 0) {
            byte[] vx = compound.func_74770_j(NBT_LEGACY_VOXEL);
            if (v != null && vx.length > 0) {
                VoxelBlob bx = new VoxelBlob();
                try {
                    bx.fromLegacyByteArray(vx);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                v = bx.blobToBytes(VoxelBlob.VERSION_COMPACT);
                this.format = VoxelBlob.VERSION_COMPACT;
            }
        }
        if (this.primaryBlockState == 0) {
            this.primaryBlockState = Block.func_176210_f((IBlockState)Blocks.field_150347_e.func_176223_P());
        }
        this.voxelBlobRef = new VoxelBlobStateReference(v, 0L);
        this.format = this.voxelBlobRef.getFormat();
        if (this.tile != null) {
            return this.tile.updateBlob(this, this.triggerUpdates);
        }
        return true;
    }

    public void updateFromBlob() {
        VoxelBlob vb = this.getRef().getVoxelBlob();
        VoxelBlob.BlobStats common = vb.getVoxelStats();
        float floatLight = common.blockLight;
        this.isNormalCube = common.isNormalBlock;
        this.lightValue = Math.max(0, Math.min(15, (int)(floatLight * 15.0f)));
        this.sideState = vb.getSideFlags(5, 11, 16);
        this.primaryBlockState = common.mostCommonState;
    }

    public ItemStack getItemStack(boolean crossWorld) {
        BlockChiseled blk = ChiselsAndBits.getBlocks().getConversion(this.getPrimaryBlockState());
        if (blk != null) {
            ItemStack is = new ItemStack((Block)blk);
            NBTTagCompound compound = is.func_179543_a("BlockEntityTag", true);
            this.writeChisleData(compound, crossWorld);
            if (!compound.func_82582_d()) {
                return is;
            }
        }
        return null;
    }

    private VoxelBlobStateReference getRef() {
        if (this.voxelBlobRef == null) {
            this.voxelBlobRef = new VoxelBlobStateReference(0, 0L);
        }
        return this.voxelBlobRef;
    }

    public VoxelBlob getBlob() {
        return this.getRef().getVoxelBlob();
    }
}

