/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseledblock;

import java.util.Collection;
import java.util.Iterator;
import net.minecraft.util.math.AxisAlignedBB;

public class BoxCollection
implements Collection<AxisAlignedBB> {
    private final AxisAlignedBB[][] arrays;

    public BoxCollection(AxisAlignedBB[] a) {
        this.arrays = new AxisAlignedBB[1][];
        this.arrays[0] = a;
    }

    public BoxCollection(AxisAlignedBB[] a, AxisAlignedBB[] b) {
        this.arrays = new AxisAlignedBB[2][];
        this.arrays[0] = a;
        this.arrays[1] = b;
    }

    public BoxCollection(AxisAlignedBB[] a, AxisAlignedBB[] b, AxisAlignedBB[] c) {
        this.arrays = new AxisAlignedBB[3][];
        this.arrays[0] = a;
        this.arrays[1] = b;
        this.arrays[2] = c;
    }

    @Override
    public boolean add(AxisAlignedBB e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends AxisAlignedBB> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<AxisAlignedBB> iterator() {
        return new BoxIterator(this.arrays);
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        int size = 0;
        for (AxisAlignedBB[] bb : this.arrays) {
            if (bb == null) continue;
            size += bb.length;
        }
        return size;
    }

    @Override
    public Object[] toArray() {
        int s = this.size();
        Object[] storage = new AxisAlignedBB[s];
        s = 0;
        for (AxisAlignedBB bb : this) {
            storage[s++] = bb;
        }
        return storage;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int s = 0;
        for (AxisAlignedBB bb : this) {
            a[s++] = bb;
        }
        return a;
    }

    static class BoxIterator
    implements Iterator<AxisAlignedBB> {
        private int arrayOffset = 0;
        private int idx = -1;
        private final AxisAlignedBB[][] arrays;

        public BoxIterator(AxisAlignedBB[][] a) {
            this.arrays = a;
            this.findNextItem();
        }

        private void findNextItem() {
            ++this.idx;
            if (this.arrays[this.arrayOffset] == null || this.idx >= this.arrays[this.arrayOffset].length) {
                this.idx = -1;
                ++this.arrayOffset;
                if (this.hasNext()) {
                    this.findNextItem();
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.arrays.length > this.arrayOffset;
        }

        @Override
        public AxisAlignedBB next() {
            AxisAlignedBB box = this.arrays[this.arrayOffset][this.idx];
            this.findNextItem();
            return box;
        }

        @Override
        public void remove() {
            throw new RuntimeException("Not Implemented.");
        }
    }
}

