/*
 * Decompiled with CFR 0.152.
 */
package com.blocklings.core.entities.ai;

import com.blocklings.core.entities.EntityBlockling;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class EntityBlocklingAIChop
extends EntityAIBase {
    Random rand = new Random();
    EntityBlockling blockling;
    World world;
    ArrayList<Block> whitelist = new ArrayList();
    ArrayList<BlockPos> tree = new ArrayList();
    ArrayList<ArrayList<BlockPos>> trees = new ArrayList();
    int searchRadiusX = 8;
    int intervalX = 1;
    int searchRadiusY = 8;
    int intervalY = 1;
    int searchRadiusZ = 8;
    int intervalZ = 1;
    int retry = 1;
    boolean xDone = false;
    boolean yDone = false;
    boolean zDone = false;

    public EntityBlocklingAIChop(EntityBlockling entityBlockling) {
        this.blockling = entityBlockling;
        this.world = this.blockling.field_70170_p;
        this.whitelist.add(Blocks.field_150364_r);
        this.whitelist.add(Blocks.field_150363_s);
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        if (this.blockling.func_184614_ca() != null && this.blockling.func_184614_ca().func_77973_b() instanceof ItemAxe || this.blockling.func_184592_cb() != null && this.blockling.func_184592_cb().func_77973_b() instanceof ItemAxe) {
            double startX = this.blockling.field_70165_t;
            double startY = this.blockling.field_70163_u + 0.5;
            double startZ = this.blockling.field_70161_v;
            Vec3d blocklingVec = new Vec3d(startX, startY, startZ);
            Vec3d testVec = null;
            BlockPos testPos = null;
            Block testBlock = null;
            this.tree.clear();
            this.trees.clear();
            this.searchRadiusY = this.retry;
            this.searchRadiusX = this.retry;
            this.searchRadiusZ = this.retry;
            if (this.yDone && this.xDone && this.zDone) {
                this.yDone = false;
                this.xDone = false;
                this.zDone = false;
            }
            if (!(this.yDone || this.xDone || this.zDone)) {
                this.intervalY = this.searchRadiusY * 2;
                this.intervalX = 1;
                this.intervalZ = 1;
            } else if (this.yDone && !this.xDone && !this.zDone) {
                this.intervalY = 1;
                this.intervalX = this.searchRadiusX * 2;
                this.intervalZ = 1;
            } else if (this.yDone && this.xDone && !this.zDone) {
                this.intervalY = 1;
                this.intervalX = 1;
                this.intervalZ = this.searchRadiusZ * 2;
            }
            for (double y = Math.floor(startY) - (double)this.searchRadiusY - 0.5; y <= Math.floor(startY) + (double)this.searchRadiusY + 0.5; y += (double)this.intervalY) {
                for (double x = Math.floor(startX) + (double)this.searchRadiusX + 0.5; x >= Math.floor(startX) - (double)this.searchRadiusX - 0.5; x -= (double)this.intervalX) {
                    for (double z = Math.floor(startZ) + (double)this.searchRadiusZ + 0.5; z >= Math.floor(startZ) - (double)this.searchRadiusZ - 0.5; z -= (double)this.intervalZ) {
                        testVec = new Vec3d(x, y, z);
                        testPos = new BlockPos(testVec);
                        testBlock = this.world.func_180495_p(testPos).func_177230_c();
                        if (!this.whitelist.contains(testBlock)) continue;
                        boolean shouldFindTree = true;
                        for (ArrayList<BlockPos> testTree : this.trees) {
                            if (!testTree.contains(testPos)) continue;
                            shouldFindTree = false;
                        }
                        if (!shouldFindTree) continue;
                        int breakTimer = 0;
                        ArrayList<BlockPos> newTree = new ArrayList<BlockPos>();
                        ArrayList<BlockPos> positionsToTest = new ArrayList<BlockPos>();
                        ArrayList<BlockPos> positionsTested = new ArrayList<BlockPos>();
                        positionsToTest.add(testPos);
                        while (shouldFindTree) {
                            if (!positionsToTest.isEmpty()) {
                                BlockPos treeTestPos = (BlockPos)positionsToTest.get(0);
                                for (int i = -1; i <= 1; ++i) {
                                    for (int j = -1; j <= 1; ++j) {
                                        for (int k = -1; k <= 1; ++k) {
                                            BlockPos surroundingPos = new BlockPos(treeTestPos.func_177958_n() + i, treeTestPos.func_177956_o() + j, treeTestPos.func_177952_p() + k);
                                            Block surroundingBlock = this.world.func_180495_p(surroundingPos).func_177230_c();
                                            if (surroundingBlock != testBlock) continue;
                                            if (!newTree.contains(surroundingPos)) {
                                                Vec3d surroundingVec = new Vec3d((double)surroundingPos.func_177958_n() + 0.5, (double)surroundingPos.func_177956_o() + 0.5, (double)surroundingPos.func_177952_p() + 0.5);
                                                double testDistance = blocklingVec.func_72438_d(surroundingVec);
                                                for (int p = 0; p < newTree.size(); ++p) {
                                                    BlockPos treeBlockPos = (BlockPos)newTree.get(p);
                                                    Vec3d treeBlockVec = new Vec3d((double)treeBlockPos.func_177958_n() + 0.5, (double)treeBlockPos.func_177956_o() + 0.5, (double)treeBlockPos.func_177952_p() + 0.5);
                                                    double treeBlockDistance = blocklingVec.func_72438_d(treeBlockVec);
                                                    if (!(testDistance <= treeBlockDistance) || newTree.contains(surroundingPos)) continue;
                                                    newTree.add(p, surroundingPos);
                                                    p = 10000;
                                                }
                                                if (!newTree.contains(surroundingPos)) {
                                                    newTree.add(surroundingPos);
                                                }
                                            }
                                            if (positionsToTest.contains(surroundingPos) || positionsTested.contains(surroundingPos)) continue;
                                            positionsToTest.add(surroundingPos);
                                        }
                                    }
                                }
                                positionsToTest.remove(treeTestPos);
                                positionsTested.add(treeTestPos);
                            } else {
                                shouldFindTree = false;
                            }
                            if (++breakTimer < 50) continue;
                            shouldFindTree = false;
                        }
                        if (newTree.isEmpty()) continue;
                        this.trees.add(newTree);
                        if (!this.tree.isEmpty()) {
                            double distance;
                            BlockPos closestTestPos = (BlockPos)newTree.get(0);
                            Vec3d closestTestVec = new Vec3d((double)closestTestPos.func_177958_n() + 0.5, (double)closestTestPos.func_177956_o() + 0.5, (double)closestTestPos.func_177952_p() + 0.5);
                            BlockPos closestPos = this.tree.get(0);
                            Vec3d closestVec = new Vec3d((double)closestPos.func_177958_n() + 0.5, (double)closestPos.func_177956_o() + 0.5, (double)closestPos.func_177952_p() + 0.5);
                            double testDistance = blocklingVec.func_72438_d(closestTestVec);
                            if (!(testDistance <= (distance = blocklingVec.func_72438_d(closestVec)))) continue;
                            this.tree.clear();
                            this.tree.addAll((Collection<BlockPos>)newTree);
                            continue;
                        }
                        this.tree.clear();
                        this.tree.addAll((Collection<BlockPos>)newTree);
                    }
                }
            }
            if (!(this.yDone || this.xDone || this.zDone)) {
                this.yDone = true;
            } else if (this.yDone && !this.xDone && !this.zDone) {
                this.xDone = true;
            } else if (this.yDone && this.xDone && !this.zDone) {
                this.zDone = true;
            }
            if (this.tree.isEmpty() && this.retry <= 8 && this.yDone && this.xDone && this.zDone) {
                ++this.retry;
            } else if (this.retry > 8) {
                this.retry = 1;
            }
        }
        return !this.tree.isEmpty();
    }

    public boolean func_75253_b() {
        boolean flag = false;
        if (this.blockling.func_184614_ca() != null && this.blockling.func_184614_ca().func_77973_b() instanceof ItemAxe || this.blockling.func_184592_cb() != null && this.blockling.func_184592_cb().func_77973_b() instanceof ItemAxe) {
            NBTTagCompound enchantment;
            int e;
            NBTTagList enchantments;
            ItemStack mainStack = this.blockling.func_184614_ca();
            ItemStack offStack = this.blockling.func_184592_cb();
            double efficiency = 1.0;
            if (mainStack != null && (enchantments = mainStack.func_77986_q()) != null) {
                for (e = 0; e < enchantments.func_74745_c(); ++e) {
                    enchantment = enchantments.func_150305_b(e);
                    if (enchantment.func_74762_e("id") != 32) continue;
                    efficiency += (double)enchantment.func_74762_e("lvl") / 3.0;
                }
            }
            if (offStack != null && (enchantments = offStack.func_77986_q()) != null) {
                for (e = 0; e < enchantments.func_74745_c(); ++e) {
                    enchantment = enchantments.func_150305_b(e);
                    if (enchantment.func_74762_e("id") != 32) continue;
                    efficiency += (double)enchantment.func_74762_e("lvl") / 3.0;
                }
            }
            if (!this.tree.isEmpty()) {
                PathEntity bestPath;
                Vec3d targetVec = new Vec3d((double)this.tree.get(0).func_177958_n() + 0.5, (double)this.tree.get(0).func_177956_o() + 0.5, (double)this.tree.get(0).func_177952_p() + 0.5);
                BlockPos targetPos = new BlockPos(targetVec);
                if (targetPos != null) {
                    this.blockling.setTargetPos(targetPos);
                }
                if ((bestPath = this.getBestPath()) != null) {
                    PathPoint point = bestPath.func_75870_c();
                    Vec3d pointVec = new Vec3d((double)point.field_75839_a + 0.5, (double)point.field_75837_b + 0.5, (double)point.field_75838_c + 0.5);
                    if (!this.isBlocklingInRange(1.5, pointVec)) {
                        this.blockling.func_70661_as().func_75492_a(pointVec.field_72450_a, pointVec.field_72448_b, pointVec.field_72449_c, 1.0);
                    }
                    if (this.isBlocklingInRange(3.0, targetVec)) {
                        this.blockling.func_70671_ap().func_75650_a(targetVec.field_72450_a, targetVec.field_72448_b, targetVec.field_72449_c, 0.0f, 0.0f);
                        this.world.func_175715_c(0, this.tree.get(this.tree.size() - 1), (int)Math.ceil(8.0 * (this.blockling.chopTimer / (1.0 / this.blockling.getWoodcuttingSpeed() * 20.0 / efficiency))));
                        this.blockling.startChopping();
                        if (this.blockling.chopTimer > 1.0 / this.blockling.getWoodcuttingSpeed() * 20.0 / efficiency && this.mineBlock(this.tree.get(this.tree.size() - 1))) {
                            this.tree.remove(this.tree.size() - 1);
                        }
                    } else {
                        this.blockling.func_70661_as().func_75484_a(bestPath, 1.0);
                    }
                }
                flag = true;
            }
        } else {
            flag = false;
        }
        if (!flag) {
            this.blockling.stopChopping();
        }
        return flag;
    }

    private boolean mineBlock(BlockPos pos) {
        Block block = this.world.func_180495_p(pos).func_177230_c();
        this.blockling.stopChopping();
        if (!this.world.field_72995_K && block != null) {
            ItemStack stack = new ItemStack(Item.func_150898_a((Block)block), 1, this.world.func_180495_p(pos).func_177230_c().func_176201_c(this.world.func_180495_p(pos)));
            int meta = this.world.func_180495_p(pos).func_177230_c().func_176201_c(this.world.func_180495_p(pos));
            if (block == Blocks.field_150364_r) {
                if (meta == 0 || meta == 4 || meta == 8) {
                    stack = new ItemStack(Item.func_150898_a((Block)Blocks.field_150364_r), 1, 0);
                } else if (meta == 1 || meta == 5 || meta == 9) {
                    stack = new ItemStack(Item.func_150898_a((Block)Blocks.field_150364_r), 1, 1);
                } else if (meta == 2 || meta == 6 || meta == 10) {
                    stack = new ItemStack(Item.func_150898_a((Block)Blocks.field_150364_r), 1, 2);
                } else if (meta == 3 || meta == 7 || meta == 11) {
                    stack = new ItemStack(Item.func_150898_a((Block)Blocks.field_150364_r), 1, 3);
                }
            } else if (block == Blocks.field_150363_s) {
                if (meta == 0 || meta == 4 || meta == 8) {
                    stack = new ItemStack(Item.func_150898_a((Block)Blocks.field_150363_s), 1, 0);
                } else if (meta == 1 || meta == 5 || meta == 9) {
                    stack = new ItemStack(Item.func_150898_a((Block)Blocks.field_150363_s), 1, 1);
                }
            }
            if (!this.blockling.inv.addItemStackToInventory(stack)) {
                this.world.func_72838_d((Entity)new EntityItem(this.world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack));
            }
            this.world.func_175655_b(pos, false);
            this.blockling.checkHeldItemDamage();
            this.blockling.setWoodcuttingXP((int)((double)this.blockling.getWoodcuttingXP() + 3.0 * (this.rand.nextDouble() + 0.5)));
            return true;
        }
        return false;
    }

    private PathEntity getBestPath() {
        PathEntity path = null;
        BlockPos closestBlock = this.tree.get(0);
        double startX = this.blockling.field_70165_t;
        double startY = this.blockling.field_70163_u + 0.5;
        double startZ = this.blockling.field_70161_v;
        Vec3d blocklingVec = new Vec3d(startX, startY, startZ);
        double closestDistanceToBlock = 1000.0;
        double closestDistanceToBlockling = 1000.0;
        if (closestBlock != null) {
            Vec3d closestVec = new Vec3d((Vec3i)closestBlock);
            for (double x = closestVec.field_72450_a - 1.0; x <= closestVec.field_72450_a + 1.0; x += 1.0) {
                for (double y = closestVec.field_72448_b + 1.0; y >= closestVec.field_72448_b - 1.0; y -= 1.0) {
                    for (double z = closestVec.field_72449_c - 1.0; z <= closestVec.field_72449_c + 1.0; z += 1.0) {
                        PathEntity testPath;
                        Vec3d surroundingVec = new Vec3d(x, y, z);
                        BlockPos surroundingPos = new BlockPos(surroundingVec);
                        Block surroundingBlock = this.world.func_180495_p(surroundingPos).func_177230_c();
                        if (surroundingBlock != Blocks.field_150350_a || (testPath = this.blockling.func_70661_as().func_179680_a(surroundingPos)) == null) continue;
                        PathPoint testPoint = testPath.func_75870_c();
                        Vec3d pointVec = new Vec3d((double)testPoint.field_75839_a + 0.5, (double)testPoint.field_75837_b + 0.5, (double)testPoint.field_75838_c + 0.5);
                        double testDistanceToBlock = pointVec.func_72438_d(closestVec);
                        double testDistanceToBlockling = pointVec.func_72438_d(blocklingVec);
                        if (testDistanceToBlock == closestDistanceToBlock) {
                            if (!(testDistanceToBlockling < closestDistanceToBlockling)) continue;
                            path = testPath;
                            closestDistanceToBlockling = testDistanceToBlockling;
                            closestDistanceToBlock = testDistanceToBlock;
                            continue;
                        }
                        if (!(testDistanceToBlock < closestDistanceToBlock)) continue;
                        path = testPath;
                        closestDistanceToBlockling = testDistanceToBlockling;
                        closestDistanceToBlock = testDistanceToBlock;
                    }
                }
            }
        }
        return path;
    }

    private boolean isBlocklingInRange(double distance, Vec3d targetVec) {
        double startX = this.blockling.field_70165_t;
        double startY = this.blockling.field_70163_u + 0.5;
        double startZ = this.blockling.field_70161_v;
        Vec3d blocklingVec = new Vec3d(startX, startY, startZ);
        return blocklingVec.func_72438_d(targetVec) <= distance;
    }
}

