/*
 * Decompiled with CFR 0.152.
 */
package com.blocklings.core.entities;

import com.blocklings.Blocklings;
import com.blocklings.core.entities.ai.EntityBlocklingAIAttackMelee;
import com.blocklings.core.entities.ai.EntityBlocklingAIChop;
import com.blocklings.core.entities.ai.EntityBlocklingAIFarm;
import com.blocklings.core.entities.ai.EntityBlocklingAIHunt;
import com.blocklings.core.entities.ai.EntityBlocklingAIMine;
import com.blocklings.core.inventories.InventoryBlockling;
import com.blocklings.core.packets.AttackMessage;
import com.blocklings.core.packets.AttackSpeedMessage;
import com.blocklings.core.packets.AutoswitchIDMessage;
import com.blocklings.core.packets.CombatLevelMessage;
import com.blocklings.core.packets.CombatXPMessage;
import com.blocklings.core.packets.DamageMessage;
import com.blocklings.core.packets.DualMessage;
import com.blocklings.core.packets.FarmingLevelMessage;
import com.blocklings.core.packets.FarmingSpeedMessage;
import com.blocklings.core.packets.FarmingXPMessage;
import com.blocklings.core.packets.GuiIDMessage;
import com.blocklings.core.packets.MiningLevelMessage;
import com.blocklings.core.packets.MiningSpeedMessage;
import com.blocklings.core.packets.MiningXPMessage;
import com.blocklings.core.packets.ScaleMessage;
import com.blocklings.core.packets.ShouldGuardMessage;
import com.blocklings.core.packets.SkinMessage;
import com.blocklings.core.packets.SpeedMessage;
import com.blocklings.core.packets.TargetPosMessage;
import com.blocklings.core.packets.TaskIDMessage;
import com.blocklings.core.packets.TimerMessage;
import com.blocklings.core.packets.WoodcuttingLevelMessage;
import com.blocklings.core.packets.WoodcuttingSpeedMessage;
import com.blocklings.core.packets.WoodcuttingXPMessage;
import com.blocklings.ref.Ref;
import com.blocklings.util.Util;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEndermite;
import net.minecraft.entity.monster.EntityGiantZombie;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInvBasic;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityBlockling
extends EntityTameable
implements IEntityAdditionalSpawnData,
IInvBasic {
    private Util util = new Util();
    public InventoryBlockling inv;
    private float scale = 1.0f;
    private int guiID = 0;
    private int autoswitchID = 0;
    public double mineTimer = -1.0;
    public double chopTimer = -1.0;
    public double farmTimer = -1.0;
    private boolean shouldRenderName = true;
    private double maxHealth;
    private double damage;
    private double syncedDamage;
    private double speed;
    private double syncedSpeed;
    private double attackSpeed;
    private double miningSpeed;
    private double woodcuttingSpeed;
    private double farmingSpeed;
    private double baseMiningSpeed = 0.2;
    private double baseWoodcuttingSpeed = 0.2;
    private double baseFarmingSpeed = 0.2;
    private int combatLevel;
    private int miningLevel;
    private int woodcuttingLevel;
    private int farmingLevel;
    private int combatXP;
    private int miningXP;
    private int woodcuttingXP;
    private int farmingXP;
    private int skin;
    private int taskID;
    private int attack;
    private boolean shouldGuard;
    private boolean dual;
    private BlockPos targetPos;
    private EntityAIFollowOwner followClose = new EntityAIFollowOwner((EntityTameable)this, 1.0, 2.0f, 2.0f);
    private EntityAIFollowOwner followMed = new EntityAIFollowOwner((EntityTameable)this, 1.0, 4.0f, 2.0f);
    private EntityAIFollowOwner followFar = new EntityAIFollowOwner((EntityTameable)this, 1.0, 8.0f, 2.0f);
    private EntityBlocklingAIHunt aiHunt = new EntityBlocklingAIHunt(this);
    private EntityBlocklingAIMine aiMine = new EntityBlocklingAIMine(this);
    private EntityBlocklingAIChop aiChop = new EntityBlocklingAIChop(this);
    private EntityBlocklingAIFarm aiFarm = new EntityBlocklingAIFarm(this);

    public EntityBlockling(World world) {
        super(world);
        this.func_96094_a("Blockling");
        this.combatLevel = 1;
        this.miningLevel = 1;
        this.woodcuttingLevel = 1;
        this.farmingLevel = 1;
        this.miningSpeed = 0.2;
        this.woodcuttingSpeed = 0.2;
        this.farmingSpeed = 0.2;
        this.scale = (float)(1.5 - this.field_70146_Z.nextDouble() * this.field_70146_Z.nextDouble() / 1.6);
        this.func_70105_a(0.45f * this.scale, 0.53f * this.scale);
        this.setupInventory();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.maxHealth = 10.0;
        this.damage = 1.0;
        this.speed = 0.2;
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.maxHealth);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(this.damage);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.speed);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70911_d = new EntityAISit((EntityTameable)this);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityBlocklingAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand, ItemStack stack) {
        boolean main = hand.equals((Object)EnumHand.MAIN_HAND);
        boolean off = hand.equals((Object)EnumHand.OFF_HAND);
        boolean hasSpace = false;
        for (int i = 0; i < player.field_71071_by.func_70302_i_() - 5; ++i) {
            if (player.field_71071_by.func_70301_a(i) != null) continue;
            hasSpace = true;
        }
        if (main) {
            if (!player.func_70093_af()) {
                if (stack != null) {
                    Item item = stack.func_77973_b();
                    if (item == Item.func_150898_a((Block)Blocks.field_150328_O) || item == Item.func_150898_a((Block)Blocks.field_150327_N) || item == Item.func_150898_a((Block)Blocks.field_150398_cm)) {
                        if (!this.func_70909_n()) {
                            if (!this.field_70170_p.field_72995_K) {
                                if (!player.field_71075_bZ.field_75098_d) {
                                    --stack.field_77994_a;
                                }
                                if (this.field_70146_Z.nextInt(3) == 0) {
                                    this.func_70903_f(true);
                                    this.field_70699_by.func_75499_g();
                                    this.func_70624_b(null);
                                    this.func_184754_b(player.func_110124_au());
                                    this.func_70908_e(true);
                                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                                    this.func_184185_a(SoundEvents.field_187537_bA, 1.0f, 1.0f);
                                    this.setTaskID(1);
                                } else {
                                    this.func_70908_e(false);
                                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                                    this.func_184185_a(SoundEvents.field_187537_bA, 1.0f, 1.0f);
                                }
                            }
                        } else if (this.func_70909_n() && player == this.func_70902_q() && (double)this.func_110143_aJ() < this.maxHealth - 1.0E-4 && !this.field_70170_p.field_72995_K) {
                            int healAmount = this.field_70146_Z.nextInt(3) + 1;
                            if (item == Item.func_150898_a((Block)Blocks.field_150398_cm)) {
                                healAmount = this.field_70146_Z.nextInt(6) + 1;
                            }
                            if ((double)(this.func_110143_aJ() + (float)healAmount) <= this.maxHealth) {
                                this.func_70691_i(healAmount);
                            } else if ((double)(this.func_110143_aJ() + (float)healAmount) > this.maxHealth) {
                                this.func_70606_j((float)this.maxHealth);
                            }
                            this.func_184185_a(SoundEvents.field_187537_bA, 1.0f, 1.0f);
                            this.func_70908_e(true);
                            if (!player.field_71075_bZ.field_75098_d) {
                                --stack.field_77994_a;
                            }
                        }
                    } else if (item instanceof ItemSword || item instanceof ItemPickaxe || item instanceof ItemAxe || item instanceof ItemHoe) {
                        if (this.func_70909_n() && player == this.func_70902_q() && !this.field_70170_p.field_72995_K) {
                            ItemStack copy = stack.func_77946_l();
                            stack.field_77994_a = 0;
                            if (this.func_184614_ca() != null) {
                                if (hasSpace) {
                                    player.field_71071_by.func_70441_a(this.func_184614_ca());
                                } else {
                                    this.func_145779_a(this.func_184614_ca().func_77973_b(), this.func_184614_ca().field_77994_a);
                                }
                            }
                            this.setHeldItemstack(EnumHand.MAIN_HAND, copy);
                        }
                    } else if (!this.field_70170_p.field_72995_K && this.func_70909_n() && this.func_70902_q() == player && (item == Item.func_150898_a((Block)Blocks.field_150346_d) || item == Item.func_150898_a((Block)Blocks.field_150349_c) || item == Item.func_150898_a((Block)Blocks.field_150364_r) || item == Item.func_150898_a((Block)Blocks.field_150363_s) || item == Item.func_150898_a((Block)Blocks.field_150348_b) || item == Items.field_151042_j || item == Items.field_151043_k || item == Items.field_151045_i || item == Item.func_150898_a((Block)Blocks.field_150343_Z))) {
                        if (this.field_70146_Z.nextInt(5) == 0) {
                            if (this.skin != 0 && item == Item.func_150898_a((Block)Blocks.field_150346_d) || item == Item.func_150898_a((Block)Blocks.field_150349_c)) {
                                this.setSkin(0);
                                this.func_70656_aK();
                                this.func_184185_a(SoundEvents.field_187689_f, 1.0f, 1.0f);
                            } else if (this.skin != 1 && item == Item.func_150898_a((Block)Blocks.field_150364_r) || item == Item.func_150898_a((Block)Blocks.field_150363_s)) {
                                this.setSkin(1);
                                this.func_70656_aK();
                                this.func_184185_a(SoundEvents.field_187689_f, 1.0f, 1.0f);
                            } else if (this.skin != 2 && item == Item.func_150898_a((Block)Blocks.field_150348_b)) {
                                this.setSkin(2);
                                this.func_70656_aK();
                                this.func_184185_a(SoundEvents.field_187689_f, 1.0f, 1.0f);
                            } else if (this.skin != 3 && item == Items.field_151042_j) {
                                this.setSkin(3);
                                this.func_70656_aK();
                                this.func_184185_a(SoundEvents.field_187689_f, 1.0f, 1.0f);
                            } else if (this.skin != 4 && item == Items.field_151043_k) {
                                this.setSkin(4);
                                this.func_70656_aK();
                                this.func_184185_a(SoundEvents.field_187689_f, 1.0f, 1.0f);
                            } else if (this.skin != 5 && item == Items.field_151045_i) {
                                this.setSkin(5);
                                this.func_70656_aK();
                                this.func_184185_a(SoundEvents.field_187689_f, 1.0f, 1.0f);
                            } else if (this.skin != 6 && item == Item.func_150898_a((Block)Blocks.field_150343_Z)) {
                                this.setSkin(6);
                                this.func_70656_aK();
                                this.func_184185_a(SoundEvents.field_187689_f, 1.0f, 1.0f);
                            }
                        }
                        if (this.skin != 0 && item == Item.func_150898_a((Block)Blocks.field_150346_d) || item == Item.func_150898_a((Block)Blocks.field_150349_c)) {
                            this.func_184185_a(SoundEvents.field_187537_bA, 1.0f, 1.0f);
                            if (!player.field_71075_bZ.field_75098_d) {
                                --stack.field_77994_a;
                            }
                        } else if (this.skin != 1 && item == Item.func_150898_a((Block)Blocks.field_150364_r) || item == Item.func_150898_a((Block)Blocks.field_150363_s)) {
                            this.func_184185_a(SoundEvents.field_187537_bA, 1.0f, 1.0f);
                            if (!player.field_71075_bZ.field_75098_d) {
                                --stack.field_77994_a;
                            }
                        } else if (this.skin != 2 && item == Item.func_150898_a((Block)Blocks.field_150348_b)) {
                            this.func_184185_a(SoundEvents.field_187537_bA, 1.0f, 1.0f);
                            if (!player.field_71075_bZ.field_75098_d) {
                                --stack.field_77994_a;
                            }
                        } else if (this.skin != 3 && item == Items.field_151042_j) {
                            this.func_184185_a(SoundEvents.field_187537_bA, 1.0f, 1.0f);
                            if (!player.field_71075_bZ.field_75098_d) {
                                --stack.field_77994_a;
                            }
                        } else if (this.skin != 4 && item == Items.field_151043_k) {
                            this.func_184185_a(SoundEvents.field_187537_bA, 1.0f, 1.0f);
                            if (!player.field_71075_bZ.field_75098_d) {
                                --stack.field_77994_a;
                            }
                        } else if (this.skin != 5 && item == Items.field_151045_i) {
                            this.func_184185_a(SoundEvents.field_187537_bA, 1.0f, 1.0f);
                            if (!player.field_71075_bZ.field_75098_d) {
                                --stack.field_77994_a;
                            }
                        } else if (this.skin != 6 && item == Item.func_150898_a((Block)Blocks.field_150343_Z)) {
                            this.func_184185_a(SoundEvents.field_187537_bA, 1.0f, 1.0f);
                            if (!player.field_71075_bZ.field_75098_d) {
                                --stack.field_77994_a;
                            }
                        }
                    } else if (!this.field_70170_p.field_72995_K) {
                        this.setTaskID(this.taskID == 1 ? 0 : 1);
                    }
                } else if (stack == null && this.func_70909_n() && player == this.func_70902_q() && !this.field_70170_p.field_72995_K) {
                    this.setTaskID(this.taskID == 1 ? 0 : 1);
                }
            } else if (player.func_70093_af()) {
                if (stack != null) {
                    Item item = stack.func_77973_b();
                    if (item instanceof ItemSword || item instanceof ItemPickaxe || item instanceof ItemAxe || item instanceof ItemHoe) {
                        if (this.func_70909_n() && player == this.func_70902_q() && !this.field_70170_p.field_72995_K) {
                            ItemStack copy = stack.func_77946_l();
                            stack.field_77994_a = 0;
                            if (this.func_184592_cb() != null) {
                                if (hasSpace) {
                                    player.field_71071_by.func_70441_a(this.func_184592_cb());
                                } else {
                                    this.func_145779_a(this.func_184592_cb().func_77973_b(), this.func_184592_cb().field_77994_a);
                                }
                            }
                            this.setHeldItemstack(EnumHand.OFF_HAND, copy);
                        }
                    } else if (this.field_70170_p.field_72995_K && this.guiID == 0 && this.func_70909_n() && player == this.func_70902_q()) {
                        player.openGui((Object)Blocklings.instance, 0, this.field_70170_p, this.func_145782_y(), 0, 0);
                    } else if (!this.field_70170_p.field_72995_K && this.guiID != 0 && this.func_70909_n() && player == this.func_70902_q()) {
                        player.openGui((Object)Blocklings.instance, 1, this.field_70170_p, this.func_145782_y(), 0, 0);
                    }
                } else if (stack == null && this.func_70909_n() && player == this.func_70902_q()) {
                    if (this.field_70170_p.field_72995_K && this.guiID == 0 && this.func_70909_n() && player == this.func_70902_q()) {
                        player.openGui((Object)Blocklings.instance, 0, this.field_70170_p, this.func_145782_y(), 0, 0);
                    } else if (!this.field_70170_p.field_72995_K && this.guiID != 0 && this.func_70909_n() && player == this.func_70902_q()) {
                        player.openGui((Object)Blocklings.instance, 1, this.field_70170_p, this.func_145782_y(), 0, 0);
                    }
                }
            }
        } else if (!off || (!player.func_70093_af() ? stack == null && stack == null : !player.func_70093_af() || stack != null || stack == null)) {
            // empty if block
        }
        return false;
    }

    public void startMining() {
        if (this.mineTimer < 0.0) {
            this.mineTimer = 0.0;
        }
    }

    public void stopMining() {
        this.mineTimer = -1.0;
    }

    public void startChopping() {
        if (this.chopTimer < 0.0) {
            this.chopTimer = 0.0;
        }
    }

    public void stopChopping() {
        this.chopTimer = -1.0;
    }

    public void startFarming() {
        if (this.farmTimer < 0.0) {
            this.farmTimer = 0.0;
        }
    }

    public void stopFarming() {
        this.farmTimer = -1.0;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.checkAutoswitch();
        }
        this.field_70178_ae = this.skin == 6;
        if (this.mineTimer > 1.0 / this.miningSpeed * 20.0) {
            this.mineTimer = -1.0;
        } else if (this.mineTimer >= 0.0) {
            this.mineTimer += 1.0;
        }
        if (this.chopTimer > 1.0 / this.woodcuttingSpeed * 20.0) {
            this.chopTimer = -1.0;
        } else if (this.chopTimer >= 0.0) {
            this.chopTimer += 1.0;
        }
        if (this.farmTimer > 1.0 / this.farmingSpeed * 20.0) {
            this.farmTimer = -1.0;
        } else if (this.farmTimer >= 0.0) {
            this.farmTimer += 1.0;
        }
        if (this.func_70638_az() != null) {
            this.stopMining();
            this.stopChopping();
            this.stopFarming();
        }
        this.checkLevel();
        this.checkHeldItems();
        this.updateStatsFromSkinAndLevel();
        if (!this.field_70170_p.field_72995_K) {
            this.setDamage(this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
        }
        if (!this.field_70170_p.field_72995_K) {
            this.setSpeed(this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
        }
        Ref.network.sendToAll((IMessage)new TimerMessage(this.mineTimer, this.chopTimer, this.farmTimer, this.func_145782_y()));
        if (this.targetPos != null && this.mineTimer == -1.0 && this.chopTimer == -1.0 && this.farmTimer == -1.0) {
            this.field_70170_p.func_175715_c(0, this.targetPos, -1);
        }
    }

    public boolean func_70652_k(Entity entity) {
        NBTTagCompound enchantment;
        int e;
        NBTTagList enchantments;
        ItemStack mainStack = this.func_184614_ca();
        ItemStack offStack = this.func_184592_cb();
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        this.checkHeldItems();
        if (this.attack == 0) {
            this.setAttack(1);
        }
        if (mainStack != null && (enchantments = mainStack.func_77986_q()) != null) {
            for (e = 0; e < enchantments.func_74745_c(); ++e) {
                enchantment = enchantments.func_150305_b(e);
                if (enchantment.func_74762_e("id") == 16) {
                    f += 1.0f + (float)(enchantment.func_74762_e("lvl") - 1) * 0.5f;
                    continue;
                }
                if (enchantment.func_74762_e("id") == 17) {
                    if (!(entity instanceof EntityZombie) && !(entity instanceof EntityPigZombie) && !(entity instanceof EntityGiantZombie) && !(entity instanceof EntityWither) && !(entity instanceof EntitySkeleton)) continue;
                    f += 2.5f * (float)enchantment.func_74762_e("lvl");
                    continue;
                }
                if (enchantment.func_74762_e("id") == 18) {
                    if (!(entity instanceof EntitySpider) && !(entity instanceof EntityCaveSpider) && !(entity instanceof EntitySilverfish) && !(entity instanceof EntityEndermite)) continue;
                    f += 2.5f * (float)enchantment.func_74762_e("lvl");
                    continue;
                }
                if (enchantment.func_74762_e("id") == 19) {
                    if (!(entity instanceof EntityLivingBase)) continue;
                    ((EntityLivingBase)entity).func_70653_a((Entity)this, (float)enchantment.func_74762_e("lvl") * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                    continue;
                }
                if (enchantment.func_74762_e("id") != 20) continue;
                entity.func_70015_d(enchantment.func_74762_e("lvl") * 4);
            }
        }
        if (offStack != null && (enchantments = offStack.func_77986_q()) != null) {
            for (e = 0; e < enchantments.func_74745_c(); ++e) {
                enchantment = enchantments.func_150305_b(e);
                if (enchantment.func_74762_e("id") == 16) {
                    f += 1.0f + (float)(enchantment.func_74762_e("lvl") - 1) * 0.5f;
                    continue;
                }
                if (enchantment.func_74762_e("id") == 17) {
                    if (!(entity instanceof EntityZombie) && !(entity instanceof EntityPigZombie) && !(entity instanceof EntityGiantZombie) && !(entity instanceof EntityWither) && !(entity instanceof EntitySkeleton)) continue;
                    f += 2.5f * (float)enchantment.func_74762_e("lvl");
                    continue;
                }
                if (enchantment.func_74762_e("id") == 18) {
                    if (!(entity instanceof EntitySpider) && !(entity instanceof EntityCaveSpider) && !(entity instanceof EntitySilverfish) && !(entity instanceof EntityEndermite)) continue;
                    f += 2.5f * (float)enchantment.func_74762_e("lvl");
                    continue;
                }
                if (enchantment.func_74762_e("id") == 19) {
                    if (!(entity instanceof EntityLivingBase)) continue;
                    ((EntityLivingBase)entity).func_70653_a((Entity)this, (float)enchantment.func_74762_e("lvl") * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                    continue;
                }
                if (enchantment.func_74762_e("id") != 20) continue;
                entity.func_70015_d(enchantment.func_74762_e("lvl") * 4);
            }
        }
        boolean flag = entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f);
        if (this.func_70909_n()) {
            this.setCombatXP((int)((double)this.combatXP + this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() * (this.field_70146_Z.nextDouble() + 0.5)));
        }
        this.checkHeldItemDamage();
        return flag;
    }

    public boolean func_142018_a(EntityLivingBase entity, EntityLivingBase player) {
        if (this.taskID == 2 || this.shouldGuard) {
            if (player != null && player instanceof EntityPlayer && !(entity instanceof EntityCreeper) && !(entity instanceof EntityFlying)) {
                EntityBlockling blockling;
                if (entity instanceof EntityBlockling && (blockling = (EntityBlockling)entity).func_70909_n() && blockling.func_70902_q() == player) {
                    return false;
                }
                return !(entity instanceof EntityPlayer) || !(player instanceof EntityPlayer) || ((EntityPlayer)player).func_96122_a((EntityPlayer)entity);
            }
            return false;
        }
        return false;
    }

    public void checkHeldItemDamage() {
        Item offItem;
        Item mainItem;
        NBTTagCompound enchantment;
        int e;
        NBTTagList enchantments;
        ItemStack mainStack = this.func_184614_ca();
        ItemStack offStack = this.func_184592_cb();
        int mainUnbreaking = 0;
        int offUnbreaking = 0;
        if (mainStack != null && (enchantments = mainStack.func_77986_q()) != null) {
            for (e = 0; e < enchantments.func_74745_c(); ++e) {
                enchantment = enchantments.func_150305_b(e);
                if (enchantment.func_74762_e("id") != 34) continue;
                mainUnbreaking = enchantment.func_74762_e("lvl");
            }
        }
        if (offStack != null && (enchantments = offStack.func_77986_q()) != null) {
            for (e = 0; e < enchantments.func_74745_c(); ++e) {
                enchantment = enchantments.func_150305_b(e);
                if (enchantment.func_74762_e("id") != 34) continue;
                offUnbreaking = enchantment.func_74762_e("lvl");
            }
        }
        if (this.taskID == 2 || this.shouldGuard) {
            if (mainStack != null && mainStack.func_77958_k() > 1) {
                if (this.field_70146_Z.nextInt(100) <= 100 / (mainUnbreaking + 1)) {
                    mainStack.func_77964_b(mainStack.func_77952_i() + 1);
                }
                if (mainStack.func_77952_i() >= mainStack.func_77958_k()) {
                    this.func_184611_a(EnumHand.MAIN_HAND, null);
                    this.func_70656_aK();
                    this.func_184185_a(SoundEvents.field_187635_cQ, 1.0f, 1.0f);
                }
            }
            if (offStack != null && offStack.func_77958_k() > 1) {
                if (this.field_70146_Z.nextInt(100) <= 100 / (offUnbreaking + 1)) {
                    offStack.func_77964_b(offStack.func_77952_i() + 1);
                }
                if (offStack.func_77952_i() >= offStack.func_77958_k()) {
                    this.func_184611_a(EnumHand.OFF_HAND, null);
                    this.func_70656_aK();
                    this.func_184185_a(SoundEvents.field_187635_cQ, 1.0f, 1.0f);
                }
            }
        } else if (this.taskID == 3) {
            if (mainStack != null && mainStack.func_77958_k() > 1 && (mainItem = mainStack.func_77973_b()) instanceof ItemPickaxe) {
                if (this.field_70146_Z.nextInt(100) <= 100 / (mainUnbreaking + 1)) {
                    mainStack.func_77964_b(mainStack.func_77952_i() + 1);
                }
                if (mainStack.func_77952_i() >= mainStack.func_77958_k()) {
                    this.func_184611_a(EnumHand.MAIN_HAND, null);
                    this.func_70656_aK();
                    this.func_184185_a(SoundEvents.field_187635_cQ, 1.0f, 1.0f);
                }
            }
            if (offStack != null && offStack.func_77958_k() > 1 && (offItem = offStack.func_77973_b()) instanceof ItemPickaxe) {
                if (this.field_70146_Z.nextInt(100) <= 100 / (offUnbreaking + 1)) {
                    offStack.func_77964_b(offStack.func_77952_i() + 1);
                }
                if (offStack.func_77952_i() >= offStack.func_77958_k()) {
                    this.func_184611_a(EnumHand.OFF_HAND, null);
                    this.func_70656_aK();
                    this.func_184185_a(SoundEvents.field_187635_cQ, 1.0f, 1.0f);
                }
            }
        } else if (this.taskID == 4) {
            if (mainStack != null && mainStack.func_77958_k() > 1 && (mainItem = mainStack.func_77973_b()) instanceof ItemAxe) {
                if (this.field_70146_Z.nextInt(100) <= 100 / (mainUnbreaking + 1)) {
                    mainStack.func_77964_b(mainStack.func_77952_i() + 1);
                }
                if (mainStack.func_77952_i() >= mainStack.func_77958_k()) {
                    this.func_184611_a(EnumHand.MAIN_HAND, null);
                    this.func_70656_aK();
                    this.func_184185_a(SoundEvents.field_187635_cQ, 1.0f, 1.0f);
                }
            }
            if (offStack != null && offStack.func_77958_k() > 1 && (offItem = offStack.func_77973_b()) instanceof ItemAxe) {
                if (this.field_70146_Z.nextInt(100) <= 100 / (offUnbreaking + 1)) {
                    offStack.func_77964_b(offStack.func_77952_i() + 1);
                }
                if (offStack.func_77952_i() >= offStack.func_77958_k()) {
                    this.func_184611_a(EnumHand.OFF_HAND, null);
                    this.func_70656_aK();
                    this.func_184185_a(SoundEvents.field_187635_cQ, 1.0f, 1.0f);
                }
            }
        } else if (this.taskID == 5) {
            if (mainStack != null && mainStack.func_77958_k() > 1 && (mainItem = mainStack.func_77973_b()) instanceof ItemHoe) {
                if (this.field_70146_Z.nextInt(100) <= 100 / (mainUnbreaking + 1)) {
                    mainStack.func_77964_b(mainStack.func_77952_i() + 1);
                }
                if (mainStack.func_77952_i() >= mainStack.func_77958_k()) {
                    this.func_184611_a(EnumHand.MAIN_HAND, null);
                    this.func_70656_aK();
                    this.func_184185_a(SoundEvents.field_187635_cQ, 1.0f, 1.0f);
                }
            }
            if (offStack != null && offStack.func_77958_k() > 1 && (offItem = offStack.func_77973_b()) instanceof ItemHoe) {
                if (this.field_70146_Z.nextInt(100) <= 100 / (offUnbreaking + 1)) {
                    offStack.func_77964_b(offStack.func_77952_i() + 1);
                }
                if (offStack.func_77952_i() >= offStack.func_77958_k()) {
                    this.func_184611_a(EnumHand.OFF_HAND, null);
                    this.func_70656_aK();
                    this.func_184185_a(SoundEvents.field_187635_cQ, 1.0f, 1.0f);
                }
            }
        }
    }

    public void setHeldItemstack(EnumHand hand, ItemStack stack) {
        int slot = hand.equals((Object)EnumHand.MAIN_HAND) ? 0 : 1;
        this.inv.func_70299_a(slot, stack);
    }

    public void checkHeldItems() {
        Item item;
        if (!this.field_70170_p.field_72995_K) {
            this.func_184611_a(EnumHand.MAIN_HAND, this.inv.func_70301_a(0));
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_184611_a(EnumHand.OFF_HAND, this.inv.func_70301_a(1));
        }
        ItemStack main = this.func_184614_ca();
        ItemStack off = this.func_184592_cb();
        this.setAttackSpeed(10.0);
        this.setMiningSpeed(this.baseMiningSpeed + 0.25 * Math.log(0.4 * (double)this.miningLevel + 0.8));
        this.setWoodcuttingSpeed(this.baseWoodcuttingSpeed + 0.25 * Math.log(0.4 * (double)this.woodcuttingLevel + 0.8));
        this.setFarmingSpeed(this.baseFarmingSpeed + 0.25 * Math.log(0.4 * (double)this.farmingLevel + 0.8));
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_142049_d();
        if (main != null && ((item = main.func_77973_b()) instanceof ItemSword || item instanceof ItemPickaxe || item instanceof ItemAxe || item instanceof ItemHoe)) {
            this.setAttackSpeed(5.4 * Math.pow(Math.abs(((AttributeModifier)item.func_111205_h(EntityEquipmentSlot.MAINHAND).get((Object)"generic.attackSpeed").toArray()[0]).func_111164_d()), 1.5));
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(new AttributeModifier("Main modifier", ((AttributeModifier)item.func_111205_h(EntityEquipmentSlot.MAINHAND).get((Object)"generic.attackDamage").toArray()[0]).func_111164_d(), 0));
        }
        if (off != null && ((item = off.func_77973_b()) instanceof ItemSword || item instanceof ItemPickaxe || item instanceof ItemAxe || item instanceof ItemHoe)) {
            this.setAttackSpeed(5.4 * Math.pow(Math.abs(((AttributeModifier)item.func_111205_h(EntityEquipmentSlot.MAINHAND).get((Object)"generic.attackSpeed").toArray()[0]).func_111164_d()), 1.5));
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(new AttributeModifier("Off modifier", ((AttributeModifier)item.func_111205_h(EntityEquipmentSlot.MAINHAND).get((Object)"generic.attackDamage").toArray()[0]).func_111164_d(), 0));
        }
        if (main != null && off != null) {
            Item itemMain = main.func_77973_b();
            Item itemOff = off.func_77973_b();
            if ((itemMain instanceof ItemSword || itemMain instanceof ItemPickaxe || itemMain instanceof ItemAxe || itemMain instanceof ItemHoe) && (itemOff instanceof ItemSword || itemOff instanceof ItemPickaxe || itemOff instanceof ItemAxe || itemOff instanceof ItemHoe)) {
                this.setAttackSpeed((5.4 * Math.pow(Math.abs(((AttributeModifier)itemMain.func_111205_h(EntityEquipmentSlot.MAINHAND).get((Object)"generic.attackSpeed").toArray()[0]).func_111164_d()), 1.5) + 5.4 * Math.pow(Math.abs(((AttributeModifier)itemOff.func_111205_h(EntityEquipmentSlot.MAINHAND).get((Object)"generic.attackSpeed").toArray()[0]).func_111164_d()), 1.5)) / 3.0);
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_142049_d();
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(new AttributeModifier("Off modifier", (((AttributeModifier)itemMain.func_111205_h(EntityEquipmentSlot.MAINHAND).get((Object)"generic.attackDamage").toArray()[0]).func_111164_d() + ((AttributeModifier)itemOff.func_111205_h(EntityEquipmentSlot.MAINHAND).get((Object)"generic.attackDamage").toArray()[0]).func_111164_d()) / 4.0, 0));
                if (itemMain instanceof ItemPickaxe && itemOff instanceof ItemPickaxe) {
                    this.setMiningSpeed(2.0 * (this.baseMiningSpeed + 0.25 * Math.log(0.4 * (double)this.miningLevel + 0.8)));
                } else if (itemMain instanceof ItemAxe && itemOff instanceof ItemAxe) {
                    this.setWoodcuttingSpeed(2.0 * (this.baseWoodcuttingSpeed + 0.25 * Math.log(0.4 * (double)this.woodcuttingLevel + 0.8)));
                } else if (itemMain instanceof ItemHoe && itemOff instanceof ItemHoe) {
                    this.setFarmingSpeed(2.0 * (this.baseFarmingSpeed + 0.25 * Math.log(0.4 * (double)this.farmingLevel + 0.8)));
                }
            }
        }
    }

    public void checkLevel() {
        int reqCombatXP = (int)(30.0 * Math.exp(0.25 * (double)this.combatLevel) - 30.0);
        int reqMiningXP = (int)(30.0 * Math.exp(0.25 * (double)this.miningLevel) - 30.0);
        int reqWoodcuttingXP = (int)(30.0 * Math.exp(0.25 * (double)this.woodcuttingLevel) - 30.0);
        int reqFarmingXP = (int)(30.0 * Math.exp(0.25 * (double)this.farmingLevel) - 30.0);
        if (this.combatXP >= reqCombatXP) {
            this.setCombatLevel(this.combatLevel + 1);
            this.setCombatXP(this.combatXP - reqCombatXP);
            if (this.combatLevel != 1) {
                this.func_184185_a(SoundEvents.field_187802_ec, 1.0f, 1.0f);
            }
        }
        if (this.miningXP >= reqMiningXP) {
            this.setMiningLevel(this.miningLevel + 1);
            this.setMiningXP(this.miningXP - reqMiningXP);
            this.setMiningSpeed(this.baseMiningSpeed + 0.25 * Math.log(0.4 * (double)this.miningLevel + 0.8));
            if (this.miningLevel != 1) {
                this.func_184185_a(SoundEvents.field_187802_ec, 1.0f, 1.0f);
            }
        }
        if (this.woodcuttingXP >= reqWoodcuttingXP) {
            this.setWoodcuttingLevel(this.woodcuttingLevel + 1);
            this.setWoodcuttingXP(this.woodcuttingXP - reqWoodcuttingXP);
            this.setWoodcuttingSpeed(this.baseWoodcuttingSpeed + 0.25 * Math.log(0.4 * (double)this.woodcuttingLevel + 0.8));
            if (this.woodcuttingLevel != 1) {
                this.func_184185_a(SoundEvents.field_187802_ec, 1.0f, 1.0f);
            }
        }
        if (this.farmingXP >= reqFarmingXP) {
            this.setFarmingLevel(this.farmingLevel + 1);
            this.setFarmingXP(this.farmingXP - reqFarmingXP);
            this.setFarmingSpeed(this.baseFarmingSpeed + 0.25 * Math.log(0.4 * (double)this.farmingLevel + 0.8));
            if (this.farmingLevel != 1) {
                this.func_184185_a(SoundEvents.field_187802_ec, 1.0f, 1.0f);
            }
        }
    }

    public void updateStatsFromSkinAndLevel() {
        this.maxHealth = 4.0;
        this.damage = 0.0;
        this.speed = 0.2;
        if (this.skin == 0) {
            this.maxHealth = 4.0;
            this.damage = 0.0;
            this.speed = 0.2;
        } else if (this.skin == 1) {
            this.maxHealth = 9.0;
            this.damage = 2.0;
            this.speed = 0.3;
        } else if (this.skin == 2) {
            this.maxHealth = 19.0;
            this.damage = 3.0;
            this.speed = 0.2;
        } else if (this.skin == 3) {
            this.maxHealth = 24.0;
            this.damage = 5.0;
            this.speed = 0.2;
        } else if (this.skin == 4) {
            this.maxHealth = 14.0;
            this.damage = 6.0;
            this.speed = 0.3;
        } else if (this.skin == 5) {
            this.maxHealth = 36.0;
            this.damage = 8.0;
            this.speed = 0.25;
        } else if (this.skin == 6) {
            this.maxHealth = 74.0;
            this.damage = 6.0;
            this.speed = 0.15;
        }
        this.maxHealth += 13.0 * Math.log(0.5 * (double)this.combatLevel + 1.0);
        this.damage += 4.0 * Math.log(0.5 * (double)this.combatLevel + 1.0);
        this.speed += 0.01 * Math.log(0.5 * (double)this.combatLevel + 1.0) + 0.01 * Math.log(0.5 * (double)this.miningLevel + 1.0) + 0.01 * Math.log(0.5 * (double)this.woodcuttingLevel + 1.0) + 0.01 * Math.log(0.5 * (double)this.farmingLevel + 1.0);
        if ((double)this.func_110143_aJ() > this.maxHealth) {
            this.func_70606_j((float)this.maxHealth);
        }
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.maxHealth);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.speed);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(this.damage);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74776_a("scale", this.scale);
        compound.func_74768_a("guiID", this.guiID);
        compound.func_74768_a("autoswitchID", this.autoswitchID);
        compound.func_74768_a("combatLevel", this.combatLevel);
        compound.func_74768_a("miningLevel", this.miningLevel);
        compound.func_74768_a("woodcuttingLevel", this.woodcuttingLevel);
        compound.func_74768_a("farmingLevel", this.farmingLevel);
        compound.func_74768_a("combatXP", this.combatXP);
        compound.func_74768_a("miningXP", this.miningXP);
        compound.func_74768_a("woodcuttingXP", this.woodcuttingXP);
        compound.func_74768_a("farmingXP", this.farmingXP);
        compound.func_74768_a("skin", this.skin);
        compound.func_74768_a("taskID", this.taskID);
        compound.func_74757_a("shouldGuard", this.shouldGuard);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.inv.func_70302_i_(); ++i) {
            ItemStack itemstack = this.inv.func_70301_a(i);
            if (itemstack != null) {
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                nbttagcompound1.func_74774_a("slot", (byte)i);
                itemstack.func_77955_b(nbttagcompound1);
                nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
            }
            compound.func_74782_a("items", (NBTBase)nbttaglist);
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setScalee(compound.func_74760_g("scale"));
        this.setGuiID(compound.func_74762_e("guiID"));
        this.setAutoswitchID(compound.func_74762_e("autoswitchID"));
        this.setCombatLevel(compound.func_74762_e("combatLevel"));
        this.setMiningLevel(compound.func_74762_e("miningLevel"));
        this.setWoodcuttingLevel(compound.func_74762_e("woodcuttingLevel"));
        this.setFarmingLevel(compound.func_74762_e("farmingLevel"));
        this.setCombatXP(compound.func_74762_e("combatXP"));
        this.setMiningXP(compound.func_74762_e("miningXP"));
        this.setWoodcuttingXP(compound.func_74762_e("woodcuttingXP"));
        this.setFarmingXP(compound.func_74762_e("farmingXP"));
        this.setSkin(compound.func_74762_e("skin"));
        this.setTaskID(compound.func_74762_e("taskID"));
        this.setGuard(compound.func_74767_n("shouldGuard"));
        NBTTagList nbttaglist = compound.func_150295_c("items", 10);
        this.setupInventory();
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            int j = nbttagcompound1.func_74771_c("slot") & 0xFF;
            if (j < 0 || j >= this.inv.func_70302_i_()) continue;
            this.inv.func_70299_a(j, ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1));
        }
    }

    public void writeSpawnData(ByteBuf buf) {
        buf.writeInt(this.autoswitchID);
        buf.writeFloat(this.scale);
        buf.writeInt(this.skin);
        buf.writeInt(this.taskID);
        buf.writeInt(this.guiID);
        buf.writeBoolean(this.shouldGuard);
    }

    public void readSpawnData(ByteBuf buf) {
        this.setAutoswitchID(buf.readInt());
        this.setScalee(buf.readFloat());
        this.setSkin(buf.readInt());
        this.setTaskID(buf.readInt());
        this.setGuiID(buf.readInt());
        this.setGuard(buf.readBoolean());
        this.func_70105_a(0.45f * this.scale, 0.53f * this.scale);
    }

    private void setupInventory() {
        InventoryBlockling gear1 = this.inv;
        this.inv = new InventoryBlockling("Inventory", 17);
        this.inv.func_110133_a("" + this.func_184753_b());
        if (gear1 != null) {
            gear1.func_110134_a(this);
            int i = Math.min(gear1.func_70302_i_(), this.inv.func_70302_i_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = gear1.func_70301_a(j);
                if (itemstack == null) continue;
                this.inv.func_70299_a(j, itemstack.func_77946_l());
            }
            gear1 = null;
        }
    }

    public void func_70645_a(DamageSource cause) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.skin == 0) {
                this.func_70099_a(new ItemStack(Item.func_150898_a((Block)Blocks.field_150346_d)), 0.0f);
            }
            if (this.skin == 1) {
                this.func_70099_a(new ItemStack(Item.func_150898_a((Block)Blocks.field_150364_r)), 0.0f);
            }
            if (this.skin == 2) {
                this.func_70099_a(new ItemStack(Item.func_150898_a((Block)Blocks.field_150348_b)), 0.0f);
            }
            if (this.skin == 3) {
                this.func_70099_a(new ItemStack(Items.field_151042_j), 0.0f);
            }
            if (this.skin == 4) {
                this.func_70099_a(new ItemStack(Items.field_151043_k), 0.0f);
            }
            if (this.skin == 5) {
                this.func_70099_a(new ItemStack(Items.field_151045_i), 0.0f);
            }
            if (this.skin == 6) {
                this.func_70099_a(new ItemStack(Item.func_150898_a((Block)Blocks.field_150343_Z)), 0.0f);
            }
        }
        for (int i = 0; i < this.inv.func_70302_i_(); ++i) {
            if (this.inv.func_70301_a(i) == null) continue;
            this.func_70099_a(this.inv.func_70301_a(i), 0.0f);
        }
        this.func_184611_a(EnumHand.MAIN_HAND, null);
        this.func_184611_a(EnumHand.OFF_HAND, null);
        super.func_70645_a(cause);
    }

    private void checkAutoswitch() {
        int tool = this.taskID - 2;
        if (this.func_70638_az() != null && this.shouldGuard) {
            tool = 0;
        }
        if (tool >= 0 && tool <= 3) {
            for (int hand = 0; hand <= 1; ++hand) {
                if (!(hand == 0 && this.autoswitchID == 1 || hand == 1 && this.autoswitchID == 2) && this.autoswitchID != 3) continue;
                for (int slot = 2; slot <= this.inv.func_70302_i_(); ++slot) {
                    ItemStack testStack = this.inv.func_70301_a(slot);
                    ItemStack heldStack = this.inv.func_70301_a(hand);
                    if (testStack == null) continue;
                    Item testItem = testStack.func_77973_b();
                    if (heldStack == null) {
                        if (!this.util.items.get(tool).contains(testItem)) continue;
                        this.inv.func_70299_a(hand, testStack);
                        this.inv.func_70299_a(slot, null);
                        continue;
                    }
                    Item heldItem = heldStack.func_77973_b();
                    if (!this.util.items.get(tool).contains(heldItem)) {
                        if (!this.util.items.get(tool).contains(testItem)) continue;
                        this.inv.func_70299_a(hand, testStack);
                        this.inv.func_70299_a(slot, heldStack);
                        continue;
                    }
                    if (!this.util.items.get(tool).contains(testItem)) continue;
                    int heldTier = this.util.items.get(tool).indexOf(heldItem);
                    int testTier = this.util.items.get(tool).indexOf(testItem);
                    if (testTier <= heldTier) continue;
                    this.inv.func_70299_a(hand, testStack);
                    this.inv.func_70299_a(slot, heldStack);
                }
            }
        }
    }

    public void func_76316_a(InventoryBasic inv) {
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return null;
    }

    public float getScale() {
        return this.scale;
    }

    public void setScalee(float newValue) {
        this.scale = newValue;
        Ref.network.sendToAll((IMessage)new ScaleMessage(newValue, this.func_145782_y()));
        Ref.network.sendToServer((IMessage)new ScaleMessage(newValue, this.func_145782_y()));
    }

    public void setScaleFromPacket(float newValue) {
        this.scale = newValue;
    }

    public int getAttack() {
        return this.attack;
    }

    public void setAttack(int newValue) {
        this.attack = newValue;
        Ref.network.sendToAll((IMessage)new AttackMessage(newValue, this.func_145782_y()));
        Ref.network.sendToServer((IMessage)new AttackMessage(newValue, this.func_145782_y()));
    }

    public void setAttackFromPacket(int newValue) {
        this.attack = newValue;
    }

    public BlockPos getTargetPos() {
        return this.targetPos;
    }

    public void setTargetPos(BlockPos newValue) {
        this.targetPos = newValue;
        Ref.network.sendToAll((IMessage)new TargetPosMessage(newValue, this.func_145782_y()));
        Ref.network.sendToServer((IMessage)new TargetPosMessage(newValue, this.func_145782_y()));
    }

    public void setTargetPosFromPacket(BlockPos newValue) {
        this.targetPos = newValue;
    }

    public boolean getShouldRender() {
        return this.shouldRenderName;
    }

    public void setShouldRender(boolean newValue) {
        this.shouldRenderName = newValue;
    }

    public int getGuiID() {
        return this.guiID;
    }

    public void setGuiID(int newValue) {
        this.guiID = newValue;
        Ref.network.sendToAll((IMessage)new GuiIDMessage(newValue, this.func_145782_y()));
        Ref.network.sendToServer((IMessage)new GuiIDMessage(newValue, this.func_145782_y()));
    }

    public void setGuiIDFromPacket(int newValue, EntityPlayer player) {
        this.guiID = newValue;
        if (newValue == 0 && this.field_70170_p.field_72995_K && this.func_70909_n() && this.func_70902_q() == player) {
            player.openGui((Object)Blocklings.instance, newValue, player.field_70170_p, this.func_145782_y(), 0, 0);
        } else if (newValue != 0 && !this.field_70170_p.field_72995_K && this.func_70909_n() && this.func_70902_q() == player) {
            player.openGui((Object)Blocklings.instance, newValue, player.field_70170_p, this.func_145782_y(), 0, 0);
        }
    }

    public int getAutoswitchID() {
        return this.autoswitchID;
    }

    public void setAutoswitchID(int newValue) {
        this.autoswitchID = newValue;
        Ref.network.sendToAll((IMessage)new AutoswitchIDMessage(newValue, this.func_145782_y()));
        Ref.network.sendToServer((IMessage)new AutoswitchIDMessage(newValue, this.func_145782_y()));
    }

    public void setAutoswitchIDFromPacket(int newValue) {
        this.autoswitchID = newValue;
    }

    public double getDamage() {
        return this.syncedDamage;
    }

    public void setDamage(double newValue) {
        this.syncedDamage = newValue;
        Ref.network.sendToAll((IMessage)new DamageMessage(newValue, this.func_145782_y()));
        Ref.network.sendToServer((IMessage)new DamageMessage(newValue, this.func_145782_y()));
    }

    public void setDamageFromPacket(double newValue) {
        this.syncedDamage = newValue;
    }

    public double getSpeed() {
        return this.syncedSpeed;
    }

    public void setSpeed(double newValue) {
        this.syncedSpeed = newValue;
        Ref.network.sendToAll((IMessage)new SpeedMessage(newValue, this.func_145782_y()));
        Ref.network.sendToServer((IMessage)new SpeedMessage(newValue, this.func_145782_y()));
    }

    public void setSpeedFromPacket(double newValue) {
        this.syncedSpeed = newValue;
    }

    public double getAttackSpeed() {
        return this.attackSpeed;
    }

    public void setAttackSpeed(double newValue) {
        this.attackSpeed = newValue;
        Ref.network.sendToAll((IMessage)new AttackSpeedMessage(newValue, this.func_145782_y()));
        Ref.network.sendToServer((IMessage)new AttackSpeedMessage(newValue, this.func_145782_y()));
    }

    public void setAttackSpeedFromPacket(double newValue) {
        this.attackSpeed = newValue;
    }

    public double getMiningSpeed() {
        return this.miningSpeed;
    }

    public void setMiningSpeed(double newValue) {
        this.miningSpeed = newValue;
        Ref.network.sendToAll((IMessage)new MiningSpeedMessage(newValue, this.func_145782_y()));
        Ref.network.sendToServer((IMessage)new MiningSpeedMessage(newValue, this.func_145782_y()));
    }

    public void setMiningSpeedFromPacket(double newValue) {
        this.miningSpeed = newValue;
    }

    public double getWoodcuttingSpeed() {
        return this.woodcuttingSpeed;
    }

    public void setWoodcuttingSpeed(double newValue) {
        this.woodcuttingSpeed = newValue;
        Ref.network.sendToAll((IMessage)new WoodcuttingSpeedMessage(newValue, this.func_145782_y()));
        Ref.network.sendToServer((IMessage)new WoodcuttingSpeedMessage(newValue, this.func_145782_y()));
    }

    public void setWoodcuttingSpeedFromPacket(double newValue) {
        this.woodcuttingSpeed = newValue;
    }

    public double getFarmingSpeed() {
        return this.farmingSpeed;
    }

    public void setFarmingSpeed(double newValue) {
        this.farmingSpeed = newValue;
        Ref.network.sendToAll((IMessage)new FarmingSpeedMessage(newValue, this.func_145782_y()));
        Ref.network.sendToServer((IMessage)new FarmingSpeedMessage(newValue, this.func_145782_y()));
    }

    public void setFarmingSpeedFromPacket(double newValue) {
        this.farmingSpeed = newValue;
    }

    public int getCombatLevel() {
        return this.combatLevel;
    }

    public void setCombatLevel(int newValue) {
        this.combatLevel = newValue;
        Ref.network.sendToAll((IMessage)new CombatLevelMessage(newValue, this.func_145782_y()));
        Ref.network.sendToServer((IMessage)new CombatLevelMessage(newValue, this.func_145782_y()));
        this.updateStatsFromSkinAndLevel();
    }

    public void setCombatLevelFromPacket(int newValue) {
        this.combatLevel = newValue;
    }

    public int getMiningLevel() {
        return this.miningLevel;
    }

    public void setMiningLevel(int newValue) {
        this.miningLevel = newValue;
        Ref.network.sendToAll((IMessage)new MiningLevelMessage(newValue, this.func_145782_y()));
        Ref.network.sendToServer((IMessage)new MiningLevelMessage(newValue, this.func_145782_y()));
        this.updateStatsFromSkinAndLevel();
    }

    public void setMiningLevelFromPacket(int newValue) {
        this.miningLevel = newValue;
    }

    public int getWoodcuttingLevel() {
        return this.woodcuttingLevel;
    }

    public void setWoodcuttingLevel(int newValue) {
        this.woodcuttingLevel = newValue;
        Ref.network.sendToAll((IMessage)new WoodcuttingLevelMessage(newValue, this.func_145782_y()));
        Ref.network.sendToServer((IMessage)new WoodcuttingLevelMessage(newValue, this.func_145782_y()));
        this.updateStatsFromSkinAndLevel();
    }

    public void setWoodcuttingLevelFromPacket(int newValue) {
        this.woodcuttingLevel = newValue;
    }

    public int getFarmingLevel() {
        return this.farmingLevel;
    }

    public void setFarmingLevel(int newValue) {
        this.farmingLevel = newValue;
        Ref.network.sendToAll((IMessage)new FarmingLevelMessage(newValue, this.func_145782_y()));
        Ref.network.sendToServer((IMessage)new FarmingLevelMessage(newValue, this.func_145782_y()));
        this.updateStatsFromSkinAndLevel();
    }

    public void setFarmingLevelFromPacket(int newValue) {
        this.farmingLevel = newValue;
    }

    public int getCombatXP() {
        return this.combatXP;
    }

    public void setCombatXP(int newValue) {
        this.combatXP = newValue;
        Ref.network.sendToAll((IMessage)new CombatXPMessage(newValue, this.func_145782_y()));
        Ref.network.sendToServer((IMessage)new CombatXPMessage(newValue, this.func_145782_y()));
        this.checkLevel();
    }

    public void setCombatXPFromPacket(int newValue) {
        this.combatXP = newValue;
    }

    public int getMiningXP() {
        return this.miningXP;
    }

    public void setMiningXP(int newValue) {
        this.miningXP = newValue;
        Ref.network.sendToAll((IMessage)new MiningXPMessage(newValue, this.func_145782_y()));
        Ref.network.sendToServer((IMessage)new MiningXPMessage(newValue, this.func_145782_y()));
        this.checkLevel();
    }

    public void setMiningXPFromPacket(int newValue) {
        this.miningXP = newValue;
    }

    public int getWoodcuttingXP() {
        return this.woodcuttingXP;
    }

    public void setWoodcuttingXP(int newValue) {
        this.woodcuttingXP = newValue;
        Ref.network.sendToAll((IMessage)new WoodcuttingXPMessage(newValue, this.func_145782_y()));
        Ref.network.sendToServer((IMessage)new WoodcuttingXPMessage(newValue, this.func_145782_y()));
        this.checkLevel();
    }

    public void setWoodcuttingXPFromPacket(int newValue) {
        this.woodcuttingXP = newValue;
    }

    public int getFarmingXP() {
        return this.farmingXP;
    }

    public void setFarmingXP(int newValue) {
        this.farmingXP = newValue;
        Ref.network.sendToAll((IMessage)new FarmingXPMessage(newValue, this.func_145782_y()));
        Ref.network.sendToServer((IMessage)new FarmingXPMessage(newValue, this.func_145782_y()));
        this.checkLevel();
    }

    public void setFarmingXPFromPacket(int newValue) {
        this.farmingXP = newValue;
    }

    public int getSkin() {
        return this.skin;
    }

    public void setSkin(int newValue) {
        this.skin = newValue;
        Ref.network.sendToAll((IMessage)new SkinMessage(newValue, this.func_145782_y()));
        Ref.network.sendToServer((IMessage)new SkinMessage(newValue, this.func_145782_y()));
        this.updateStatsFromSkinAndLevel();
    }

    public void setSkinFromPacket(int newValue) {
        this.skin = newValue;
    }

    public boolean getGuard() {
        return this.shouldGuard;
    }

    public void setGuard(boolean newValue) {
        this.shouldGuard = newValue;
        Ref.network.sendToAll((IMessage)new ShouldGuardMessage(newValue, this.func_145782_y()));
        Ref.network.sendToServer((IMessage)new ShouldGuardMessage(newValue, this.func_145782_y()));
    }

    public void setGuardFromPacket(boolean newValue) {
        this.shouldGuard = newValue;
    }

    public boolean getDual() {
        return this.dual;
    }

    public void setDual(boolean newValue) {
        this.dual = newValue;
        Ref.network.sendToAll((IMessage)new DualMessage(newValue, this.func_145782_y()));
        Ref.network.sendToServer((IMessage)new DualMessage(newValue, this.func_145782_y()));
    }

    public void setDualFromPacket(boolean newValue) {
        this.dual = newValue;
    }

    public int getTaskID() {
        return this.taskID;
    }

    public void setTaskID(int newValue) {
        this.taskID = newValue;
        Ref.network.sendToAll((IMessage)new TaskIDMessage(newValue, this.func_145782_y()));
        Ref.network.sendToServer((IMessage)new TaskIDMessage(newValue, this.func_145782_y()));
    }

    public void setTaskIDFromPacket(int newValue) {
        this.taskID = newValue;
        if (!this.field_70170_p.field_72995_K) {
            if (this.taskID != 0) {
                this.field_70714_bg.func_85156_a((EntityAIBase)this.followClose);
                this.field_70714_bg.func_85156_a((EntityAIBase)this.followMed);
                this.field_70714_bg.func_85156_a((EntityAIBase)this.followFar);
                this.field_70715_bh.func_85156_a((EntityAIBase)this.aiHunt);
                this.field_70714_bg.func_85156_a((EntityAIBase)this.aiMine);
                this.field_70714_bg.func_85156_a((EntityAIBase)this.aiChop);
                this.field_70714_bg.func_85156_a((EntityAIBase)this.aiFarm);
                if (this.taskID == 1) {
                    this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.followClose);
                }
                if (this.taskID == 2) {
                    this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.followFar);
                    this.field_70715_bh.func_75776_a(3, (EntityAIBase)this.aiHunt);
                }
                if (this.taskID == 3) {
                    this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.followFar);
                    this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiMine);
                }
                if (this.taskID == 4) {
                    this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.followFar);
                    this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiChop);
                }
                if (this.taskID == 5) {
                    this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.followFar);
                    this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiFarm);
                }
                this.field_70911_d.func_75270_a(false);
                this.field_70703_bu = false;
                this.field_70699_by.func_75499_g();
                this.func_70624_b(null);
            } else {
                this.field_70911_d.func_75270_a(true);
                this.field_70703_bu = false;
                this.field_70699_by.func_75499_g();
                this.func_70624_b(null);
            }
        }
    }
}

