/*
 * Decompiled with CFR 0.152.
 */
package com.blocklings.network;

import com.blocklings.entities.EntityBlockling;
import com.blocklings.main.Blocklings;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;

public class BlocklingStatMessage
implements IMessage {
    private int entityID;
    private double maxHealth;
    private double damage;
    private double speed;
    private double armour;

    public BlocklingStatMessage() {
    }

    public BlocklingStatMessage(int entityID, double maxHealth, double damage, double speed, double armour) {
        this.entityID = entityID;
        this.maxHealth = maxHealth;
        this.damage = damage;
        this.speed = speed;
        this.armour = armour;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityID = buf.readInt();
        this.maxHealth = buf.readDouble();
        this.damage = buf.readDouble();
        this.speed = buf.readDouble();
        this.armour = buf.readDouble();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityID);
        buf.writeDouble(this.maxHealth);
        buf.writeDouble(this.damage);
        buf.writeDouble(this.speed);
        buf.writeDouble(this.armour);
    }

    public static class Handler
    implements IMessageHandler<BlocklingStatMessage, IMessage> {
        public IMessage onMessage(BlocklingStatMessage message, MessageContext ctx) {
            Entity entity = null;
            if (ctx.side.isClient()) {
                entity = Blocklings.proxy.getPlayerEntity((MessageContext)ctx).field_70170_p.func_73045_a(message.entityID);
            }
            if (entity instanceof EntityBlockling) {
                EntityBlockling blockling = (EntityBlockling)entity;
                blockling.setMaximumHealth(message.maxHealth);
                blockling.setDamage(message.damage);
                blockling.setSpeed(message.speed);
                blockling.setArmour(message.armour);
            }
            return null;
        }
    }
}

