/*
 * Decompiled with CFR 0.152.
 */
package com.blocklings.network;

import com.blocklings.entities.EntityBlockling;
import com.blocklings.main.Blocklings;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;

public class BlocklingShrunkMessage
implements IMessage {
    private int entityID;
    private boolean isShrunk;

    public BlocklingShrunkMessage() {
    }

    public BlocklingShrunkMessage(int entityID, boolean isShrunk) {
        this.entityID = entityID;
        this.isShrunk = isShrunk;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityID = buf.readInt();
        this.isShrunk = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityID);
        buf.writeBoolean(this.isShrunk);
    }

    public static class Handler
    implements IMessageHandler<BlocklingShrunkMessage, IMessage> {
        public IMessage onMessage(BlocklingShrunkMessage message, MessageContext ctx) {
            Entity entity = null;
            if (ctx.side.isClient()) {
                entity = Blocklings.proxy.getPlayerEntity((MessageContext)ctx).field_70170_p.func_73045_a(message.entityID);
            }
            if (entity instanceof EntityBlockling) {
                EntityBlockling blockling = (EntityBlockling)entity;
                blockling.setShrunk(message.isShrunk);
            }
            return null;
        }
    }
}

