/*
 * Decompiled with CFR 0.152.
 */
package com.blocklings.core.packets;

import com.blocklings.Blocklings;
import com.blocklings.core.entities.EntityBlockling;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class TimerMessage
implements IMessage {
    double mineTimer;
    double chopTimer;
    double farmTimer;
    int id;

    public TimerMessage() {
    }

    public TimerMessage(double mineTimerValue, double chopTimerValue, double farmTimerValue, int entityID) {
        this.mineTimer = mineTimerValue;
        this.chopTimer = chopTimerValue;
        this.farmTimer = farmTimerValue;
        this.id = entityID;
    }

    public void fromBytes(ByteBuf buf) {
        this.mineTimer = buf.readDouble();
        this.chopTimer = buf.readDouble();
        this.farmTimer = buf.readDouble();
        this.id = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.mineTimer);
        buf.writeDouble(this.chopTimer);
        buf.writeDouble(this.farmTimer);
        buf.writeInt(this.id);
    }

    public static class Handler
    implements IMessageHandler<TimerMessage, IMessage> {
        public IMessage onMessage(TimerMessage message, MessageContext ctx) {
            Entity entity = null;
            if (ctx.side.isClient()) {
                entity = Blocklings.proxy.getPlayer((MessageContext)ctx).field_70170_p.func_73045_a(message.id);
                if (entity instanceof EntityBlockling) {
                    EntityBlockling blockling = (EntityBlockling)entity;
                    blockling.mineTimer = message.mineTimer;
                    blockling.chopTimer = message.chopTimer;
                    blockling.farmTimer = message.farmTimer;
                }
            } else if (ctx.side.isServer() && (entity = Blocklings.proxy.getPlayer((MessageContext)ctx).field_70170_p.func_73045_a(message.id)) instanceof EntityBlockling) {
                EntityBlockling blockling = (EntityBlockling)entity;
                blockling.mineTimer = message.mineTimer;
                blockling.chopTimer = message.chopTimer;
                blockling.farmTimer = message.farmTimer;
            }
            return null;
        }
    }
}

