/*
 * Decompiled with CFR 0.152.
 */
package com.blocklings.core.packets;

import com.blocklings.Blocklings;
import com.blocklings.core.entities.EntityBlockling;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MiningSpeedMessage
implements IMessage {
    double miningSpeed;
    int id;

    public MiningSpeedMessage() {
    }

    public MiningSpeedMessage(double miningSpeedValue, int entityID) {
        this.miningSpeed = miningSpeedValue;
        this.id = entityID;
    }

    public void fromBytes(ByteBuf buf) {
        this.miningSpeed = buf.readDouble();
        this.id = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.miningSpeed);
        buf.writeInt(this.id);
    }

    public static class Handler
    implements IMessageHandler<MiningSpeedMessage, IMessage> {
        public IMessage onMessage(MiningSpeedMessage message, MessageContext ctx) {
            Entity entity = null;
            if (ctx.side.isClient()) {
                entity = Blocklings.proxy.getPlayer((MessageContext)ctx).field_70170_p.func_73045_a(message.id);
                if (entity instanceof EntityBlockling) {
                    EntityBlockling blockling = (EntityBlockling)entity;
                    blockling.setMiningSpeedFromPacket(message.miningSpeed);
                }
            } else if (ctx.side.isServer() && (entity = Blocklings.proxy.getPlayer((MessageContext)ctx).field_70170_p.func_73045_a(message.id)) instanceof EntityBlockling) {
                EntityBlockling blockling = (EntityBlockling)entity;
                blockling.setMiningSpeedFromPacket(message.miningSpeed);
            }
            return null;
        }
    }
}

