/*
 * Decompiled with CFR 0.152.
 */
package com.blocklings.core.packets;

import com.blocklings.Blocklings;
import com.blocklings.core.entities.EntityBlockling;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MiningLevelMessage
implements IMessage {
    int miningLevel;
    int id;

    public MiningLevelMessage() {
    }

    public MiningLevelMessage(int miningLevelValue, int entityID) {
        this.miningLevel = miningLevelValue;
        this.id = entityID;
    }

    public void fromBytes(ByteBuf buf) {
        this.miningLevel = buf.readInt();
        this.id = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.miningLevel);
        buf.writeInt(this.id);
    }

    public static class Handler
    implements IMessageHandler<MiningLevelMessage, IMessage> {
        public IMessage onMessage(MiningLevelMessage message, MessageContext ctx) {
            Entity entity = null;
            if (ctx.side.isClient()) {
                entity = Blocklings.proxy.getPlayer((MessageContext)ctx).field_70170_p.func_73045_a(message.id);
                if (entity instanceof EntityBlockling) {
                    EntityBlockling blockling = (EntityBlockling)entity;
                    blockling.setMiningLevelFromPacket(message.miningLevel);
                }
            } else if (ctx.side.isServer() && (entity = Blocklings.proxy.getPlayer((MessageContext)ctx).field_70170_p.func_73045_a(message.id)) instanceof EntityBlockling) {
                EntityBlockling blockling = (EntityBlockling)entity;
                blockling.setMiningLevelFromPacket(message.miningLevel);
            }
            return null;
        }
    }
}

