/*
 * Decompiled with CFR 0.152.
 */
package com.blocklings.core.entities.ai;

import com.blocklings.core.entities.EntityBlockling;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityBlocklingAIMine
extends EntityAIBase {
    private Random rand = new Random();
    private EntityBlockling blockling;
    private World world;
    private ArrayList<Block> whitelist = new ArrayList();
    private Vec3d targetVec;
    private BlockPos targetPos;
    private Block targetBlock;
    private int searchRadiusX = 8;
    private int searchRadiusY = 4;
    private int searchRadiusZ = 8;

    public EntityBlocklingAIMine(EntityBlockling entityBlockling) {
        this.blockling = entityBlockling;
        this.world = this.blockling.field_70170_p;
        this.whitelist.add(Blocks.field_150365_q);
        this.whitelist.add(Blocks.field_150366_p);
        this.whitelist.add(Blocks.field_150352_o);
        this.whitelist.add(Blocks.field_150369_x);
        this.whitelist.add(Blocks.field_150450_ax);
        this.whitelist.add(Blocks.field_150439_ay);
        this.whitelist.add(Blocks.field_150482_ag);
        this.whitelist.add(Blocks.field_150412_bA);
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        if (this.blockling.func_184614_ca() != null && this.blockling.func_184614_ca().func_77973_b() instanceof ItemPickaxe || this.blockling.func_184592_cb() != null && this.blockling.func_184592_cb().func_77973_b() instanceof ItemPickaxe) {
            Vec3d testVec = null;
            BlockPos testPos = null;
            Block testBlock = null;
            this.targetVec = null;
            this.targetPos = null;
            this.targetBlock = null;
            double blocklingX = this.blockling.field_70165_t;
            double blocklingY = this.blockling.field_70163_u + 0.5;
            double blocklingZ = this.blockling.field_70161_v;
            Vec3d blocklingVec = new Vec3d(blocklingX, blocklingY, blocklingZ);
            double closestDistance = 1000.0;
            for (double y = Math.floor(blocklingY) + (double)this.searchRadiusY + 0.5; y > Math.floor(blocklingY) - (double)this.searchRadiusY - 0.5; y -= 1.0) {
                for (double x = Math.floor(blocklingX) + (double)this.searchRadiusX + 0.5; x > Math.floor(blocklingX) - (double)this.searchRadiusX - 0.5; x -= 1.0) {
                    for (double z = Math.floor(blocklingZ) + (double)this.searchRadiusZ + 0.5; z > Math.floor(blocklingZ) - (double)this.searchRadiusZ - 0.5; z -= 1.0) {
                        double testDistance;
                        ItemStack heldItem;
                        testVec = new Vec3d(x, y, z);
                        testPos = new BlockPos(testVec);
                        testBlock = this.world.func_180495_p(testPos).func_177230_c();
                        if (!this.whitelist.contains(testBlock) || (heldItem = this.blockling.func_184614_ca()) == null || !heldItem.func_150998_b(testBlock.func_176223_P()) || !this.canSeeBlock(blocklingVec, testVec)) continue;
                        Path testPath = this.getBestPathTo(blocklingVec, testVec);
                        if (testPath != null) {
                            PathPoint testPoint = testPath.func_75870_c();
                            double testDistance2 = blocklingVec.func_72438_d(testVec);
                            double distanceToTarget = testVec.func_72438_d(new Vec3d((double)testPoint.field_75839_a + 0.5, (double)testPoint.field_75837_b + 0.5, (double)testPoint.field_75838_c + 0.5));
                            if (!(distanceToTarget <= 2.0) && !(testDistance2 <= 2.0) || !(testDistance2 < closestDistance)) continue;
                            if (this.targetVec != null) {
                                if (!(testVec.field_72448_b >= this.targetVec.field_72448_b)) continue;
                                this.targetVec = testVec;
                                this.targetPos = testPos;
                                this.targetBlock = testBlock;
                                this.blockling.func_70661_as().func_75484_a(testPath, 1.0);
                                closestDistance = testDistance2;
                                continue;
                            }
                            this.targetVec = testVec;
                            this.targetPos = testPos;
                            this.targetBlock = testBlock;
                            this.blockling.func_70661_as().func_75484_a(testPath, 1.0);
                            closestDistance = testDistance2;
                            continue;
                        }
                        if (testPath != null || !((testDistance = blocklingVec.func_72438_d(testVec)) <= 2.0) || !(testDistance < closestDistance)) continue;
                        if (this.targetVec != null) {
                            if (!(testVec.field_72448_b >= this.targetVec.field_72448_b)) continue;
                            this.targetVec = testVec;
                            this.targetPos = testPos;
                            this.targetBlock = testBlock;
                            closestDistance = testDistance;
                            continue;
                        }
                        this.targetVec = testVec;
                        this.targetPos = testPos;
                        this.targetBlock = testBlock;
                        closestDistance = testDistance;
                    }
                }
            }
        }
        if (this.targetPos != null) {
            this.blockling.setTargetPos(this.targetPos);
        }
        return this.targetVec != null && this.targetPos != null && this.targetBlock != null;
    }

    public boolean func_75253_b() {
        boolean flag = false;
        double x = this.blockling.field_70165_t;
        double y = this.blockling.field_70163_u + 0.5;
        double z = this.blockling.field_70161_v;
        Vec3d blocklingVec = new Vec3d(x, y, z);
        Path testPath = this.getBestPathTo(blocklingVec, this.targetVec);
        Block testBlock = this.world.func_180495_p(this.targetPos).func_177230_c();
        if (this.blockling.func_184614_ca() != null && this.blockling.func_184614_ca().func_77973_b() instanceof ItemPickaxe || this.blockling.func_184592_cb() != null && this.blockling.func_184592_cb().func_77973_b() instanceof ItemPickaxe) {
            NBTTagCompound enchantment;
            int e;
            NBTTagList enchantments;
            ItemStack mainStack = this.blockling.func_184614_ca();
            ItemStack offStack = this.blockling.func_184592_cb();
            double efficiency = 1.0;
            if (mainStack != null && (enchantments = mainStack.func_77986_q()) != null) {
                for (e = 0; e < enchantments.func_74745_c(); ++e) {
                    enchantment = enchantments.func_150305_b(e);
                    if (enchantment.func_74762_e("id") != 32) continue;
                    efficiency += (double)enchantment.func_74762_e("lvl") / 3.0;
                }
            }
            if (offStack != null && (enchantments = offStack.func_77986_q()) != null) {
                for (e = 0; e < enchantments.func_74745_c(); ++e) {
                    enchantment = enchantments.func_150305_b(e);
                    if (enchantment.func_74762_e("id") != 32) continue;
                    efficiency += (double)enchantment.func_74762_e("lvl") / 3.0;
                }
            }
            if (testBlock == this.targetBlock) {
                ItemStack heldItemMain = this.blockling.func_184614_ca();
                ItemStack heldItemOff = this.blockling.func_184592_cb();
                if (heldItemMain != null && heldItemMain.func_150998_b(testBlock.func_176223_P()) || heldItemOff != null && heldItemOff.func_150998_b(testBlock.func_176223_P())) {
                    if (testPath != null) {
                        PathPoint testPoint = testPath.func_75870_c();
                        double distanceToTarget = blocklingVec.func_72438_d(this.targetVec);
                        if (distanceToTarget <= 2.2) {
                            this.blockling.startMining();
                            this.blockling.func_70671_ap().func_75650_a(this.targetVec.field_72450_a, this.targetVec.field_72448_b, this.targetVec.field_72449_c, 0.0f, 0.0f);
                            this.world.func_175715_c(0, this.targetPos, (int)Math.ceil(8.0 * (this.blockling.mineTimer / (1.0 / this.blockling.getMiningSpeed() * 20.0 / efficiency))));
                            if (this.blockling.mineTimer >= 1.0 / this.blockling.getMiningSpeed() * 20.0 / efficiency) {
                                this.mineBlock(this.targetVec);
                                flag = false;
                            }
                            flag = true;
                        } else {
                            this.blockling.func_70661_as().func_75484_a(testPath, 1.0);
                            flag = true;
                        }
                    } else if (testPath == null) {
                        double distanceToTarget = blocklingVec.func_72438_d(this.targetVec);
                        if (distanceToTarget <= 2.2) {
                            this.blockling.startMining();
                            this.blockling.func_70671_ap().func_75650_a(this.targetVec.field_72450_a, this.targetVec.field_72448_b, this.targetVec.field_72449_c, 0.0f, 0.0f);
                            this.world.func_175715_c(0, this.targetPos, (int)Math.ceil(8.0 * (this.blockling.mineTimer / (1.0 / this.blockling.getMiningSpeed() * 20.0 / efficiency))));
                            if (this.blockling.mineTimer >= 1.0 / this.blockling.getMiningSpeed() * 20.0 / efficiency) {
                                this.mineBlock(this.targetVec);
                                flag = false;
                            }
                            flag = true;
                        }
                        flag = false;
                    }
                } else {
                    flag = false;
                }
            } else {
                flag = false;
            }
        } else {
            flag = false;
        }
        if (!flag) {
            this.blockling.stopMining();
        }
        return flag;
    }

    private void mineBlock(Vec3d blockVec) {
        BlockPos pos = new BlockPos(blockVec);
        Block block = this.world.func_180495_p(pos).func_177230_c();
        this.blockling.stopMining();
        if (block != null && this.whitelist.contains(block) && !this.world.field_72995_K) {
            ItemStack stack;
            NBTTagCompound enchantment;
            int e;
            NBTTagList enchantments;
            ItemStack mainStack = this.blockling.func_184614_ca();
            ItemStack offStack = this.blockling.func_184592_cb();
            double fortune = 0.0;
            boolean silk = false;
            if (mainStack != null && (enchantments = mainStack.func_77986_q()) != null) {
                for (e = 0; e < enchantments.func_74745_c(); ++e) {
                    enchantment = enchantments.func_150305_b(e);
                    if (enchantment.func_74762_e("id") == 35) {
                        fortune += (double)enchantment.func_74762_e("lvl");
                        continue;
                    }
                    if (enchantment.func_74762_e("id") != 33) continue;
                    silk = true;
                }
            }
            if (offStack != null && (enchantments = offStack.func_77986_q()) != null) {
                for (e = 0; e < enchantments.func_74745_c(); ++e) {
                    enchantment = enchantments.func_150305_b(e);
                    if (enchantment.func_74762_e("id") == 35) {
                        fortune += (double)enchantment.func_74762_e("lvl");
                        continue;
                    }
                    if (enchantment.func_74762_e("id") != 33) continue;
                    silk = true;
                }
            }
            if ((stack = new ItemStack(block.func_180660_a(this.world.func_180495_p(pos), this.rand, 1))) != null) {
                if (stack.func_77973_b().equals(Items.field_151044_h)) {
                    stack = new ItemStack(Items.field_151044_h, 1);
                }
                if (stack.func_77973_b().equals(Items.field_151100_aR)) {
                    stack = new ItemStack(Items.field_151100_aR, this.rand.nextInt(4) + 1, 4);
                }
                if (stack.func_77973_b().equals(Items.field_151137_ax)) {
                    stack = new ItemStack(Items.field_151137_ax, this.rand.nextInt(3) + 1);
                }
                if (stack.func_77973_b().equals(Items.field_151045_i)) {
                    stack = new ItemStack(Items.field_151045_i, 1);
                }
                if (stack.func_77973_b().equals(Items.field_151166_bC)) {
                    stack = new ItemStack(Items.field_151166_bC, 1);
                }
                if (block == Blocks.field_150365_q || block == Blocks.field_150369_x || block == Blocks.field_150450_ax || block == Blocks.field_150439_ay || block == Blocks.field_150482_ag || block == Blocks.field_150412_bA) {
                    if (fortune == 1.0) {
                        if (this.rand.nextInt(100) < 33) {
                            stack.field_77994_a *= 2;
                        }
                    } else if (fortune == 2.0) {
                        if (this.rand.nextInt(100) < 25) {
                            stack.field_77994_a *= 2;
                        } else if (this.rand.nextInt(100) >= 25 && this.rand.nextInt(100) < 50) {
                            stack.field_77994_a *= 3;
                        }
                    } else if (fortune == 3.0) {
                        if (this.rand.nextInt(100) < 20) {
                            stack.field_77994_a *= 2;
                        } else if (this.rand.nextInt(100) >= 20 && this.rand.nextInt(100) < 40) {
                            stack.field_77994_a *= 3;
                        } else if (this.rand.nextInt(100) >= 40 && this.rand.nextInt(100) < 60) {
                            stack.field_77994_a *= 4;
                        }
                    } else if (fortune == 4.0) {
                        if (this.rand.nextInt(100) < 15) {
                            stack.field_77994_a *= 2;
                        } else if (this.rand.nextInt(100) >= 15 && this.rand.nextInt(100) < 30) {
                            stack.field_77994_a *= 3;
                        } else if (this.rand.nextInt(100) >= 30 && this.rand.nextInt(100) < 45) {
                            stack.field_77994_a *= 4;
                        } else if (this.rand.nextInt(100) >= 45 && this.rand.nextInt(100) < 60) {
                            stack.field_77994_a *= 5;
                        }
                    } else if (fortune >= 5.0) {
                        if (this.rand.nextInt(100) < 10) {
                            stack.field_77994_a *= 2;
                        } else if (this.rand.nextInt(100) >= 10 && this.rand.nextInt(100) < 20) {
                            stack.field_77994_a *= 3;
                        } else if (this.rand.nextInt(100) >= 20 && this.rand.nextInt(100) < 30) {
                            stack.field_77994_a *= 4;
                        } else if (this.rand.nextInt(100) >= 30 && this.rand.nextInt(100) < 40) {
                            stack.field_77994_a *= 5;
                        } else if (this.rand.nextInt(100) >= 40 && this.rand.nextInt(100) < 50) {
                            stack.field_77994_a *= 6;
                        }
                    }
                }
                if (silk) {
                    stack = this.targetBlock == Blocks.field_150439_ay ? new ItemStack(Item.func_150898_a((Block)Blocks.field_150450_ax)) : new ItemStack(Item.func_150898_a((Block)this.targetBlock));
                }
                if (!this.blockling.inv.addItemStackToInventory(stack)) {
                    this.world.func_72838_d((Entity)new EntityItem(this.world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack));
                }
                this.world.func_175655_b(pos, false);
                this.blockling.func_70661_as().func_75492_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 1.0);
                this.blockling.checkHeldItemDamage();
                this.blockling.setMiningXP((int)((double)this.blockling.getMiningXP() + 3.0 * (this.rand.nextDouble() + 0.5)));
            }
        }
    }

    public boolean canSeeBlock(Vec3d blocklingVec, Vec3d blockVecCentre) {
        if (blockVecCentre != null) {
            for (double i = 0.01; i <= 0.99; i += 0.98) {
                for (double j = 0.01; j <= 0.99; j += 0.98) {
                    for (double k = 0.01; k <= 0.99; k += 0.98) {
                        BlockPos pos;
                        Vec3d blockVec = new Vec3d(Math.floor(blockVecCentre.field_72450_a) + i, Math.floor(blockVecCentre.field_72448_b) + j, Math.floor(blockVecCentre.field_72449_c) + k);
                        RayTraceResult result = this.world.func_147447_a(blocklingVec, blockVec, true, true, true);
                        if (result == null || !(pos = result.func_178782_a()).equals((Object)new BlockPos(blockVecCentre))) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public Path getBestPathTo(Vec3d blocklingVec, Vec3d targetVec) {
        Path bestPath = null;
        double closestDistanceToBlock = 1000.0;
        double closestDistanceToBlockling = 1000.0;
        if (targetVec != null) {
            for (double x = targetVec.field_72450_a - 2.0; x <= targetVec.field_72450_a + 2.0; x += 1.0) {
                for (double y = targetVec.field_72448_b - 2.0; y <= targetVec.field_72448_b + 2.0; y += 1.0) {
                    for (double z = targetVec.field_72449_c - 2.0; z <= targetVec.field_72449_c + 2.0; z += 1.0) {
                        Path testPath;
                        Vec3d testVec = new Vec3d(x, y, z);
                        BlockPos testPos = new BlockPos(testVec);
                        Block testBlock = this.world.func_180495_p(testPos).func_177230_c();
                        if (testBlock != Blocks.field_150350_a || (testPath = this.blockling.func_70661_as().func_179680_a(testPos)) == null) continue;
                        PathPoint testPoint = testPath.func_75870_c();
                        Vec3d pointVec = new Vec3d((double)testPoint.field_75839_a + 0.5, (double)testPoint.field_75837_b + 0.5, (double)testPoint.field_75838_c + 0.5);
                        double testDistanceToBlock = pointVec.func_72438_d(targetVec);
                        double testDistanceToBlockling = pointVec.func_72438_d(blocklingVec);
                        if (testDistanceToBlock == closestDistanceToBlock) {
                            if (!(testDistanceToBlockling < closestDistanceToBlockling)) continue;
                            bestPath = testPath;
                            closestDistanceToBlockling = testDistanceToBlockling;
                            closestDistanceToBlock = testDistanceToBlock;
                            continue;
                        }
                        if (!(testDistanceToBlock < closestDistanceToBlock)) continue;
                        bestPath = testPath;
                        closestDistanceToBlockling = testDistanceToBlockling;
                        closestDistanceToBlock = testDistanceToBlock;
                    }
                }
            }
        }
        return bestPath;
    }
}

