/*
 * Decompiled with CFR 0.152.
 */
package com.blocklings.core.guis;

import com.blocklings.core.entities.EntityBlockling;
import com.blocklings.core.packets.NameMessage;
import com.blocklings.ref.Ref;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemSword;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;

public class GuiBlocklingStats
extends GuiScreen {
    private EntityBlockling blockling;
    private EntityPlayer player;
    private static final ResourceLocation TEXTURE = new ResourceLocation("blocklings:textures/gui/overiew_background.png");
    private int textureWidth = 256;
    private int textureHeight = 186;
    private int spacing = 3;
    private int offsetY = -12;
    private GuiTextField nameField;
    private int nameFieldWidth = 119;
    private int nameFieldHeight = 20;
    private GuiButton left;
    private GuiButton right;
    private GuiButton taskLeft;
    private GuiButton taskRight;
    private GuiButton guard;
    private float mouseX;
    private float oldMouseX;
    private float mouseY;
    private float oldMouseY;
    private int taskID;

    public GuiBlocklingStats(EntityBlockling blockling, EntityPlayer player) {
        this.blockling = blockling;
        this.player = player;
    }

    public void func_73866_w_() {
        this.blockling.setShouldRender(false);
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146292_n.clear();
        this.left = new GuiButton(0, this.field_146294_l / 2 - 160, this.field_146295_m / 2 - 10, 20, 20, "<");
        this.field_146292_n.add(this.left);
        this.right = new GuiButton(1, this.field_146294_l / 2 + 140, this.field_146295_m / 2 - 10, 20, 20, ">");
        this.field_146292_n.add(this.right);
        this.taskLeft = new GuiButton(2, this.field_146294_l / 2 - 122, this.field_146295_m / 2 + 67 + this.offsetY, 40, 20, "<");
        this.field_146292_n.add(this.taskLeft);
        this.taskRight = new GuiButton(3, this.field_146294_l / 2 + 82, this.field_146295_m / 2 + 67 + this.offsetY, 40, 20, ">");
        this.field_146292_n.add(this.taskRight);
        this.guard = new GuiButton(4, this.field_146294_l / 2 - 30, this.field_146295_m / 2 + 90 + this.offsetY, 60, 20, "\u8b66\u6212: \u5426");
        this.field_146292_n.add(this.guard);
        this.nameField = new GuiTextField(4, this.field_146289_q, (this.field_146294_l - this.textureWidth) / 2 + this.spacing + 4, (this.field_146295_m - this.textureHeight) / 2 + this.spacing + 4 + this.offsetY, this.nameFieldWidth, this.nameFieldHeight);
        this.nameField.func_146203_f(16);
        this.nameField.func_146195_b(true);
        this.nameField.func_146180_a(this.blockling.func_95999_t());
        this.taskID = this.blockling.getTaskID();
    }

    public void func_73876_c() {
        if (this.nameField != null) {
            this.nameField.func_146178_a();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        ((GuiButton)this.field_146292_n.get((int)4)).field_146126_j = this.blockling.getGuard() ? "\u8b66\u6212: \u662f" : "\u8b66\u6212: \u5426";
        this.func_146276_q_();
        int reqCombatXP = (int)(30.0 * Math.exp(0.25 * (double)this.blockling.getCombatLevel()) - 30.0);
        int reqMiningXP = (int)(30.0 * Math.exp(0.25 * (double)this.blockling.getMiningLevel()) - 30.0);
        int reqWoodcuttingXP = (int)(30.0 * Math.exp(0.25 * (double)this.blockling.getWoodcuttingLevel()) - 30.0);
        int reqFarmingXP = (int)(30.0 * Math.exp(0.25 * (double)this.blockling.getFarmingLevel()) - 30.0);
        String task = "Idle";
        if (this.taskID == 0) {
            task = "\u5750\u4e0b";
        } else if (this.taskID == 1) {
            task = "\u8ddf\u968f";
        } else if (this.taskID == 2) {
            task = "\u72e9\u730e";
        } else if (this.taskID == 3) {
            task = "\u6316\u77ff";
        } else if (this.taskID == 4) {
            task = "\u4f10\u6728";
        } else if (this.taskID == 5) {
            task = "\u8015\u4f5c";
        }
        int healthColour = 0xFFFFFF;
        healthColour = this.blockling.func_110143_aJ() / this.blockling.func_110138_aP() >= 0.66666f ? 0x339936 : (this.blockling.func_110143_aJ() / this.blockling.func_110138_aP() < 0.66666f && this.blockling.func_110143_aJ() / this.blockling.func_110138_aP() >= 0.33333f ? 16052305 : 0xFF4D4D);
        int displacement = 24;
        if ((this.blockling.getTaskID() == 2 || this.blockling.getGuard()) && (this.blockling.func_184614_ca() != null && !(this.blockling.func_184614_ca().func_77973_b() instanceof ItemSword) || this.blockling.func_184592_cb() != null && !(this.blockling.func_184592_cb().func_77973_b() instanceof ItemSword))) {
            displacement = 40;
        } else if (this.blockling.func_184614_ca() != null || this.blockling.func_184592_cb() != null) {
            displacement = 36;
        }
        GuiBlocklingStats.drawEntityOnScreen(this.field_146294_l / 2 - 62, this.field_146295_m / 2 + displacement + this.offsetY, 80, -this.oldMouseX + (float)(this.field_146294_l / 2) - 62.0f, -this.oldMouseY + (float)(this.field_146295_m / 2) + (float)displacement - 18.0f, (EntityLivingBase)this.blockling);
        this.drawGuiContainerBackgroundLayer(partialTicks, mouseX, mouseY);
        this.nameField.func_146194_f();
        this.func_73732_a(this.field_146289_q, "\u7edf\u8ba1", this.field_146294_l / 2 + 60, (this.field_146295_m - this.textureHeight) / 2 + 13 + this.offsetY, 15187506);
        this.func_73732_a(this.field_146289_q, "\u7b49\u7ea7 ", this.field_146294_l / 2 + 30 - this.field_146289_q.func_78256_a("" + this.blockling.getCombatLevel()) / 2, this.field_146295_m / 2 - 38 + this.offsetY, 0xB30000);
        this.func_73732_a(this.field_146289_q, "" + this.blockling.getCombatLevel(), this.field_146294_l / 2 + 30 + this.field_146289_q.func_78256_a("\u7b49\u7ea7 ") / 2, this.field_146295_m / 2 - 38 + this.offsetY, 0xFF4D4D);
        this.func_73732_a(this.field_146289_q, "\u7b49\u7ea7 ", this.field_146294_l / 2 + 92 - this.field_146289_q.func_78256_a("" + this.blockling.getMiningLevel()) / 2, this.field_146295_m / 2 - 38 + this.offsetY, 2708131);
        this.func_73732_a(this.field_146289_q, "" + this.blockling.getMiningLevel(), this.field_146294_l / 2 + 92 + this.field_146289_q.func_78256_a("\u7b49\u7ea7 ") / 2, this.field_146295_m / 2 - 38 + this.offsetY, 7378139);
        this.func_73732_a(this.field_146289_q, "\u7b49\u7ea7 ", this.field_146294_l / 2 + 30 - this.field_146289_q.func_78256_a("" + this.blockling.getWoodcuttingLevel()) / 2, this.field_146295_m / 2 - 1 + this.offsetY, 692998);
        this.func_73732_a(this.field_146289_q, "" + this.blockling.getWoodcuttingLevel(), this.field_146294_l / 2 + 30 + this.field_146289_q.func_78256_a("\u7b49\u7ea7 ") / 2, this.field_146295_m / 2 - 1 + this.offsetY, 5744219);
        this.func_73732_a(this.field_146289_q, "\u7b49\u7ea7 ", this.field_146294_l / 2 + 92 - this.field_146289_q.func_78256_a("" + this.blockling.getFarmingLevel()) / 2, this.field_146295_m / 2 - 1 + this.offsetY, 8998160);
        this.func_73732_a(this.field_146289_q, "" + this.blockling.getFarmingLevel(), this.field_146294_l / 2 + 92 + this.field_146289_q.func_78256_a("\u7b49\u7ea7 ") / 2, this.field_146295_m / 2 - 1 + this.offsetY, 10317130);
        this.func_73731_b(this.field_146289_q, "\u751f\u547d: ", this.field_146294_l / 2 + 17, (this.field_146295_m - this.textureHeight) / 2 + 114 + this.offsetY, 15187506);
        this.func_73731_b(this.field_146289_q, "" + (int)Math.ceil(this.blockling.func_110143_aJ()) + "/" + (int)Math.ceil(this.blockling.func_110138_aP()), (this.field_146294_l + this.textureWidth) / 2 - 10 - this.field_146289_q.func_78256_a((int)Math.ceil(this.blockling.func_110143_aJ()) + "/" + (int)Math.ceil(this.blockling.func_110138_aP())), (this.field_146295_m - this.textureHeight) / 2 + 114 + this.offsetY, healthColour);
        this.func_73731_b(this.field_146289_q, "\u4f24\u5bb3: ", this.field_146294_l / 2 + 17, (this.field_146295_m - this.textureHeight) / 2 + 128 + this.offsetY, 15187506);
        this.func_73731_b(this.field_146289_q, "" + (int)Math.ceil(this.blockling.getDamage()), (this.field_146294_l + this.textureWidth) / 2 - 10 - this.field_146289_q.func_78256_a("" + (int)Math.ceil(this.blockling.getDamage())), (this.field_146295_m - this.textureHeight) / 2 + 128 + this.offsetY, 0xFF4D4D);
        this.func_73731_b(this.field_146289_q, "\u901f\u5ea6: ", this.field_146294_l / 2 + 17, (this.field_146295_m - this.textureHeight) / 2 + 142 + this.offsetY, 15187506);
        this.func_73731_b(this.field_146289_q, "" + (int)Math.ceil(this.blockling.getSpeed() * 50.0), (this.field_146294_l + this.textureWidth) / 2 - 10 - this.field_146289_q.func_78256_a("" + (int)Math.ceil(this.blockling.getSpeed() * 50.0)), (this.field_146295_m - this.textureHeight) / 2 + 142 + this.offsetY, 0x6699FF);
        this.func_73732_a(this.field_146289_q, "\u5f53\u524d\u72b6\u6001: ", this.field_146294_l / 2 - this.field_146289_q.func_78256_a(task) / 2, this.field_146295_m / 2 + 74 + this.offsetY, 15102720);
        this.func_73732_a(this.field_146289_q, task, this.field_146294_l / 2 + this.field_146289_q.func_78256_a("\u5f53\u524d\u72b6\u6001: ") / 2, this.field_146295_m / 2 + 74 + this.offsetY, 0xFF9933);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        String[] combatText = new String[]{ChatFormatting.BOLD + "Combat", ChatFormatting.DARK_AQUA + "\u7ecf\u9a8c: " + this.blockling.getCombatXP() + "/" + reqCombatXP, ChatFormatting.BLUE + "\u901f\u5ea6: " + (int)this.blockling.getAttackSpeed()};
        this.drawToolTipCentered(combatText, this.field_146294_l / 2 + 14, this.field_146295_m / 2 - 58 + this.offsetY, 32, 16, 8, -6);
        String[] miningText = new String[]{ChatFormatting.BOLD + "\u6316\u77ff", ChatFormatting.DARK_AQUA + "\u7ecf\u9a8c: " + this.blockling.getMiningXP() + "/" + reqMiningXP, ChatFormatting.BLUE + "\u901f\u5ea6: " + (int)(this.blockling.getMiningSpeed() * 60.0)};
        this.drawToolTipCentered(miningText, this.field_146294_l / 2 + 76, this.field_146295_m / 2 - 58 + this.offsetY, 32, 16, 8, -6);
        String[] woodcuttingText = new String[]{ChatFormatting.BOLD + "\u4f10\u6728", ChatFormatting.DARK_AQUA + "\u7ecf\u9a8c: " + this.blockling.getWoodcuttingXP() + "/" + reqWoodcuttingXP, ChatFormatting.BLUE + "\u901f\u5ea6: " + (int)(this.blockling.getWoodcuttingSpeed() * 60.0)};
        this.drawToolTipCentered(woodcuttingText, this.field_146294_l / 2 + 14, this.field_146295_m / 2 - 21 + this.offsetY, 32, 16, 8, -6);
        String[] farmingText = new String[]{ChatFormatting.BOLD + "\u8015\u4f5c", ChatFormatting.DARK_AQUA + "\u7ecf\u9a8c: " + this.blockling.getFarmingXP() + "/" + reqFarmingXP, ChatFormatting.BLUE + "\u901f\u5ea6: " + (int)(this.blockling.getFarmingSpeed() * 60.0)};
        this.drawToolTipCentered(farmingText, this.field_146294_l / 2 + 76, this.field_146295_m / 2 - 21 + this.offsetY, 32, 16, 8, -6);
        this.oldMouseX = mouseX;
        this.oldMouseY = mouseY;
    }

    private void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        int i = (this.field_146294_l - this.textureWidth) / 2;
        int j = (this.field_146295_m - this.textureHeight) / 2;
        this.func_73729_b(i, j + this.offsetY, 0, 0, this.textureWidth, this.textureHeight + 23);
        this.func_73729_b(this.field_146294_l / 2 + 22, this.field_146295_m / 2 - 58 + this.offsetY, 0, this.textureHeight + 23, 16, 16);
        this.func_73729_b(this.field_146294_l / 2 + 84, this.field_146295_m / 2 - 58 + this.offsetY, 16, this.textureHeight + 23, 16, 16);
        this.func_73729_b(this.field_146294_l / 2 + 22, this.field_146295_m / 2 - 21 + this.offsetY, 32, this.textureHeight + 23, 16, 16);
        this.func_73729_b(this.field_146294_l / 2 + 84, this.field_146295_m / 2 - 21 + this.offsetY, 48, this.textureHeight + 23, 16, 16);
        this.func_73729_b(this.field_146294_l / 2 + 6, this.field_146295_m / 2 + 21 + this.offsetY, 0, this.textureHeight + 23 + 16, 8, 8);
        this.func_73729_b(this.field_146294_l / 2 + 6, this.field_146295_m / 2 + 35 + this.offsetY, 8, this.textureHeight + 23 + 16, 8, 8);
        this.func_73729_b(this.field_146294_l / 2 + 6, this.field_146295_m / 2 + 49 + this.offsetY, 16, this.textureHeight + 23 + 16, 8, 8);
    }

    private void drawToolTipCentered(String[] text, int x, int y, int width, int height, int offsetX, int offsetY) {
        if (text != null && this.mouseX >= (float)x && this.mouseY >= (float)y && this.mouseX <= (float)(x + width) && this.mouseY <= (float)(height + y)) {
            List<String> list = Arrays.asList(text);
            this.drawHoveringText(list, x + offsetX - (this.field_146289_q.func_78256_a(this.getLongestString(text)) + 10) / 2, y + offsetY, this.field_146289_q);
        }
    }

    private void drawToolTip(String[] text, int x, int y, int width, int height, int offsetX, int offsetY) {
        if (text != null && this.mouseX >= (float)x && this.mouseY >= (float)y && this.mouseX <= (float)(x + width) && this.mouseY <= (float)(height + y)) {
            List<String> list = Arrays.asList(text);
            this.drawHoveringText(list, x + offsetX, y + offsetY, this.field_146289_q);
        }
    }

    private String getLongestString(String[] strings) {
        int length = 0;
        String str = null;
        for (String string : strings) {
            if (this.field_146289_q.func_78256_a(string) < length) continue;
            str = string;
            length = this.field_146289_q.func_78256_a(string);
        }
        return str;
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k == 2) {
            this.taskID = this.taskID > 0 ? --this.taskID : 5;
        } else if (button.field_146127_k == 3) {
            this.taskID = this.taskID < 5 ? ++this.taskID : 0;
        }
        if (button.field_146127_k == 0) {
            this.blockling.setGuiID(1);
        } else if (button.field_146127_k == 1) {
            this.blockling.setGuiID(1);
        }
        if (button.field_146127_k == 4) {
            this.blockling.setGuard(!this.blockling.getGuard());
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        this.nameField.func_146201_a(typedChar, keyCode);
        if (keyCode == 28) {
            Ref.network.sendToServer((IMessage)new NameMessage(this.nameField.func_146179_b(), this.blockling.func_145782_y()));
        }
        super.func_73869_a(typedChar, keyCode);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.nameField.func_146192_a(mouseX, mouseY, mouseButton);
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
        this.blockling.setTaskID(this.taskID);
        this.blockling.setShouldRender(true);
    }

    public static void drawEntityOnScreen(int posX, int posY, int scale, float mouseX, float mouseY, EntityLivingBase ent) {
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)posX, (float)posY, (float)50.0f);
        GlStateManager.func_179152_a((float)(-scale), (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f = ent.field_70761_aq;
        float f1 = ent.field_70177_z;
        float f2 = ent.field_70125_A;
        float f3 = ent.field_70758_at;
        float f4 = ent.field_70759_as;
        GlStateManager.func_179114_b((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.func_179114_b((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-((float)Math.atan(mouseY / 40.0f)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        ent.field_70761_aq = (float)Math.atan(mouseX / 40.0f) * 20.0f;
        ent.field_70177_z = (float)Math.atan(mouseX / 40.0f) * 40.0f;
        ent.field_70125_A = -((float)Math.atan(mouseY / 40.0f)) * 20.0f;
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
        RenderManager rendermanager = Minecraft.func_71410_x().func_175598_ae();
        rendermanager.func_178631_a(180.0f);
        rendermanager.func_178633_a(false);
        rendermanager.func_188391_a((Entity)ent, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        rendermanager.func_178633_a(true);
        ent.field_70761_aq = f;
        ent.field_70177_z = f1;
        ent.field_70125_A = f2;
        ent.field_70758_at = f3;
        ent.field_70759_as = f4;
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    public boolean func_73868_f() {
        return false;
    }
}

