/*
 * Decompiled with CFR 0.152.
 */
package com.blocklings.helper;

import com.blocklings.entities.EntityBlockling;
import com.blocklings.main.Blocklings;
import com.blocklings.network.BlocklingAttackTimerMessage;
import com.blocklings.network.BlocklingGrownMessage;
import com.blocklings.network.BlocklingLevelMessage;
import com.blocklings.network.BlocklingShrunkMessage;
import com.blocklings.network.BlocklingSpecialMessage;
import com.blocklings.network.BlocklingStatMessage;
import com.blocklings.network.BlocklingUpgradeArrayMessage;
import com.blocklings.network.BlocklingUpgradeMessage;
import com.blocklings.network.BlocklingWeaponMessage;
import com.blocklings.network.BlocklingXPMessage;
import com.blocklings.network.BlocklingXPReqMessage;
import com.blocklings.references.References;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class Helper {
    public static void initialiseBiomes() {
        References.forest = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.FOREST);
        References.plains = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS);
    }

    public static void registerEntity(Class entityClass, String entityName, int primaryColour, int secondaryColour, BiomeGenBase[] ... biomeType) {
        int ID = EntityRegistry.findGlobalUniqueEntityId();
        EntityRegistry.registerGlobalEntityID((Class)entityClass, (String)entityName, (int)ID);
        EntityRegistry.registerModEntity((Class)entityClass, (String)entityName, (int)ID, (Object)Blocklings.instance, (int)64, (int)1, (boolean)true);
        for (BiomeGenBase[] type : biomeType) {
            EntityRegistry.addSpawn((String)entityName, (int)References.spawnRate, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])type);
        }
        Helper.createEgg(ID, primaryColour, secondaryColour);
    }

    public static void createEgg(int ID, int primaryColour, int secondaryColour) {
        EntityList.field_75627_a.put(ID, new EntityList.EntityEggInfo(ID, primaryColour, secondaryColour));
    }

    public static void sendAllPackets(EntityBlockling blockling) {
        References.network.sendToAll((IMessage)new BlocklingAttackTimerMessage(blockling.func_145782_y(), blockling.getAttackTimer()));
        References.network.sendToAll((IMessage)new BlocklingXPMessage(blockling.func_145782_y(), blockling.getXP()));
        References.network.sendToAll((IMessage)new BlocklingLevelMessage(blockling.func_145782_y(), blockling.getLevel()));
        References.network.sendToAll((IMessage)new BlocklingUpgradeMessage(blockling.func_145782_y(), blockling.getUpgrade()));
        References.network.sendToAll((IMessage)new BlocklingUpgradeArrayMessage(blockling.func_145782_y(), blockling.getUpgradeArray1(), blockling.getUpgradeArray2(), blockling.getUpgradeArray3()));
        References.network.sendToAll((IMessage)new BlocklingShrunkMessage(blockling.func_145782_y(), blockling.getShrunk()));
        References.network.sendToAll((IMessage)new BlocklingGrownMessage(blockling.func_145782_y(), blockling.getGrown()));
        References.network.sendToAll((IMessage)new BlocklingXPReqMessage(blockling.func_145782_y(), blockling.getXPReq()));
        References.network.sendToAll((IMessage)new BlocklingSpecialMessage(blockling.func_145782_y(), blockling.getSpecial1(), blockling.getSpecial2(), blockling.getSpecial3(), blockling.getSpecial4()));
        References.network.sendToAll((IMessage)new BlocklingStatMessage(blockling.func_145782_y(), blockling.getMaximumHealth(), blockling.getDamage(), blockling.getSpeed(), blockling.getArmour()));
        References.network.sendToAll((IMessage)new BlocklingWeaponMessage(blockling.func_145782_y(), blockling.getWeapon()));
    }
}

