/*
 * Decompiled with CFR 0.152.
 */
package com.sixonethree.colorfulstars.handler;

import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigurationHandler {
    public static Configuration configuration;
    private static boolean enabled;
    private static int numStars;

    public static void init(File configFile) {
        if (configuration == null) {
            configuration = new Configuration(configFile);
            ConfigurationHandler.loadConfiguration();
        }
    }

    private static void loadConfiguration() {
        enabled = configuration.getBoolean("Enabled", "general", true, "Enable the colorful stars?");
        numStars = configuration.getInt("Number of Stars", "general", 1500, 0, 20000, "How many stars are in the sky?");
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("ColorfulStars")) {
            ConfigurationHandler.loadConfiguration();
        }
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static int getNumStars() {
        return numStars;
    }

    static {
        enabled = true;
        numStars = 1500;
    }
}

