/*
 * Decompiled with CFR 0.152.
 */
package squeek.applecore.network;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import squeek.applecore.api.AppleCoreAPI;
import squeek.applecore.network.MessageDifficultySync;
import squeek.applecore.network.MessageExhaustionSync;
import squeek.applecore.network.MessageSaturationSync;

public class SyncHandler {
    public static final SimpleNetworkWrapper CHANNEL = NetworkRegistry.INSTANCE.newSimpleChannel("AppleCore");
    private float lastSaturationLevel = 0.0f;
    private float lastExhaustionLevel = 0.0f;
    private EnumDifficulty lastDifficultySetting = null;

    public static void init() {
        CHANNEL.registerMessage(MessageDifficultySync.class, MessageDifficultySync.class, 0, Side.CLIENT);
        CHANNEL.registerMessage(MessageExhaustionSync.class, MessageExhaustionSync.class, 1, Side.CLIENT);
        CHANNEL.registerMessage(MessageSaturationSync.class, MessageSaturationSync.class, 2, Side.CLIENT);
        MinecraftForge.EVENT_BUS.register((Object)new SyncHandler());
    }

    @SubscribeEvent
    public void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        float exhaustionLevel;
        if (!(event.getEntity() instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.getEntity();
        if (this.lastSaturationLevel != player.func_71024_bL().func_75115_e()) {
            CHANNEL.sendTo((IMessage)new MessageSaturationSync(player.func_71024_bL().func_75115_e()), player);
            this.lastSaturationLevel = player.func_71024_bL().func_75115_e();
        }
        if (Math.abs(this.lastExhaustionLevel - (exhaustionLevel = AppleCoreAPI.accessor.getExhaustion((EntityPlayer)player))) >= 0.01f) {
            CHANNEL.sendTo((IMessage)new MessageExhaustionSync(exhaustionLevel), player);
            this.lastExhaustionLevel = exhaustionLevel;
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (event.world instanceof WorldServer && this.lastDifficultySetting != event.world.func_175659_aa()) {
            CHANNEL.sendToAll((IMessage)new MessageDifficultySync(event.world.func_175659_aa()));
            this.lastDifficultySetting = event.world.func_175659_aa();
        }
    }
}

