/*
 * Decompiled with CFR 0.152.
 */
package squeek.applecore.client;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import squeek.applecore.AppleCore;
import squeek.applecore.ModConfig;
import squeek.applecore.ModInfo;
import squeek.applecore.api.AppleCoreAPI;
import squeek.applecore.api.food.FoodValues;
import squeek.applecore.asm.Hooks;
import squeek.applecore.helpers.KeyHelper;

@SideOnly(value=Side.CLIENT)
public class TooltipOverlayHandler {
    private static ResourceLocation modIcons = new ResourceLocation(ModInfo.MODID_LOWER, "textures/icons.png");
    public static final Field THE_SLOT = ReflectionHelper.findField(GuiContainer.class, (String[])ObfuscationReflectionHelper.remapFieldNames((String)GuiContainer.class.getName(), (String[])new String[]{"theSlot", "field_147006_u", "u"}));
    private static Method getStackMouseOver = null;
    private static Field itemPanel = null;
    private static boolean neiLoaded = false;
    private static Method jeiGetRuntime = null;
    private static Class<?> JeiRuntime = null;
    private static Method jeiGetItemListOverlay = null;
    private static Method jeiGetRecipesGui = null;
    private static Class<?> RecipesGui = null;
    private static Method jeiGetFocusUnderMouse = null;
    private static Method jeiRecipesGetFocusUnderMouse = null;
    private static Field jeiFocus_itemStack = null;
    private static Field jeiRecipeLayouts = null;
    private static Field jeiRecipesGui_guiLeft = null;
    private static Field jeiRecipesGui_guiTop = null;
    private static Field jeiRecipeLayoutPosX = null;
    private static Field jeiRecipeLayoutPosY = null;
    private static Method jeiRecipeLayout_getFocusUnderMouse = null;
    private static boolean jeiLoaded = false;
    private static Class<?> foodJournalGui = null;
    private static Field foodJournalHoveredStack = null;

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new TooltipOverlayHandler());
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (ModConfig.SHOW_FOOD_VALUES_IN_TOOLTIP && KeyHelper.isShiftKeyDown() || ModConfig.ALWAYS_SHOW_FOOD_VALUES_TOOLTIP) {
            Minecraft mc = Minecraft.func_71410_x();
            EntityPlayerSP player = mc.field_71439_g;
            GuiScreen curScreen = mc.field_71462_r;
            ScaledResolution scale = new ScaledResolution(mc);
            boolean isFoodJournalGui = foodJournalGui != null && foodJournalGui.isInstance(curScreen);
            boolean isJEIRecipesGui = RecipesGui != null && RecipesGui.isInstance(curScreen);
            boolean isValidContainerGui = curScreen instanceof GuiContainer;
            if (isValidContainerGui || isJEIRecipesGui) {
                GuiScreen gui = curScreen;
                int mouseX = Mouse.getX() * scale.func_78326_a() / mc.field_71443_c;
                int mouseY = scale.func_78328_b() - Mouse.getY() * scale.func_78328_b() / mc.field_71440_d;
                ItemStack hoveredStack = null;
                try {
                    Slot hoveredSlot;
                    if (jeiFocus_itemStack != null) {
                        Object recipesFocus;
                        GuiScreen recipesGui;
                        Object jeiRuntime = jeiGetRuntime.invoke(null, new Object[0]);
                        Object object = recipesGui = isJEIRecipesGui ? curScreen : jeiGetRecipesGui.invoke(jeiRuntime, new Object[0]);
                        if (isJEIRecipesGui && (recipesFocus = jeiRecipesGetFocusUnderMouse.invoke((Object)curScreen, mouseX, mouseY)) != null) {
                            hoveredStack = (ItemStack)jeiFocus_itemStack.get(recipesFocus);
                        }
                        if (hoveredStack == null) {
                            Object itemList = jeiGetItemListOverlay.invoke(jeiRuntime, new Object[0]);
                            Object listFocus = jeiGetFocusUnderMouse.invoke(itemList, mouseX, mouseY);
                            if (listFocus != null) {
                                hoveredStack = (ItemStack)jeiFocus_itemStack.get(listFocus);
                            }
                        } else {
                            Object hoveredLayout = null;
                            int guiLeft = jeiRecipesGui_guiLeft.getInt(recipesGui);
                            int guiTop = jeiRecipesGui_guiTop.getInt(recipesGui);
                            int recipeMouseX = mouseX - guiLeft;
                            int recipeMouseY = mouseY - guiTop;
                            List recipeLayouts = (List)jeiRecipeLayouts.get(recipesGui);
                            for (Object recipeLayout : recipeLayouts) {
                                if (jeiRecipeLayout_getFocusUnderMouse.invoke(recipeLayout, recipeMouseX, recipeMouseY) == null) continue;
                                hoveredLayout = recipeLayout;
                                break;
                            }
                            if (hoveredLayout != null) {
                                Hooks.toolTipX += jeiRecipeLayoutPosX.getInt(hoveredLayout) + guiLeft;
                                Hooks.toolTipY += jeiRecipeLayoutPosY.getInt(hoveredLayout) + guiTop;
                            }
                        }
                    }
                    if (hoveredStack == null && isJEIRecipesGui) {
                        return;
                    }
                    if (hoveredStack == null && (hoveredSlot = (Slot)THE_SLOT.get(gui)) != null) {
                        hoveredStack = hoveredSlot.func_75211_c();
                    }
                    if (hoveredStack == null && getStackMouseOver != null) {
                        hoveredStack = (ItemStack)getStackMouseOver.invoke(itemPanel.get(null), mouseX, mouseY);
                    }
                    if (hoveredStack == null && isFoodJournalGui) {
                        hoveredStack = (ItemStack)foodJournalHoveredStack.get(gui);
                    }
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (player.field_71071_by.func_70445_o() == null && hoveredStack != null && AppleCoreAPI.accessor.isFood(hoveredStack)) {
                    int x;
                    String saturationText;
                    boolean saturationOverflow;
                    FoodValues modifiedFoodValues;
                    FoodValues defaultFoodValues = FoodValues.get(hoveredStack);
                    if (defaultFoodValues.equals(modifiedFoodValues = FoodValues.get(hoveredStack, (EntityPlayer)player)) && defaultFoodValues.hunger == 0 && defaultFoodValues.saturationModifier == 0.0f) {
                        return;
                    }
                    int biggestHunger = Math.max(defaultFoodValues.hunger, modifiedFoodValues.hunger);
                    float biggestSaturationIncrement = Math.max(defaultFoodValues.getSaturationIncrement(), modifiedFoodValues.getSaturationIncrement());
                    int barsNeeded = (int)Math.ceil((float)Math.abs(biggestHunger) / 2.0f);
                    int saturationBarsNeeded = (int)Math.max(1.0, Math.ceil(Math.abs(biggestSaturationIncrement) / 2.0f));
                    boolean bl = saturationOverflow = saturationBarsNeeded > 10;
                    String string = saturationOverflow ? (defaultFoodValues.saturationModifier < 0.0f ? -1 : 1) * saturationBarsNeeded + "x " : (saturationText = null);
                    if (saturationOverflow) {
                        saturationBarsNeeded = 1;
                    }
                    boolean needsCoordinateShift = !neiLoaded || isFoodJournalGui;
                    int toolTipBottomY = Hooks.toolTipY + Hooks.toolTipH + 1 + (needsCoordinateShift ? 3 : 0);
                    int toolTipRightX = Hooks.toolTipX + Hooks.toolTipW + 1 + (needsCoordinateShift ? 3 : 0);
                    boolean shouldDrawBelow = toolTipBottomY + 20 < scale.func_78328_b() - 3;
                    int rightX = toolTipRightX - 3;
                    int leftX = rightX - Math.max(barsNeeded * 9, saturationBarsNeeded * 6 + (int)((float)mc.field_71466_p.func_78256_a(saturationText) * 0.75f)) - 4;
                    int topY = shouldDrawBelow ? toolTipBottomY : Hooks.toolTipY - 20 + (needsCoordinateShift ? -4 : 0);
                    int bottomY = topY + 20;
                    GlStateManager.func_179140_f();
                    GlStateManager.func_179097_i();
                    Gui.func_73734_a((int)(leftX - 1), (int)topY, (int)(rightX + 1), (int)bottomY, (int)-267386864);
                    Gui.func_73734_a((int)leftX, (int)(shouldDrawBelow ? bottomY : topY - 1), (int)rightX, (int)(shouldDrawBelow ? bottomY + 1 : topY), (int)-267386864);
                    Gui.func_73734_a((int)leftX, (int)topY, (int)rightX, (int)bottomY, (int)0x66FFFFFF);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GlStateManager.func_179147_l();
                    GlStateManager.func_179112_b((int)770, (int)771);
                    int startX = x = rightX - 2;
                    int y = bottomY - 19;
                    mc.func_110434_K().func_110577_a(Gui.field_110324_m);
                    for (int i = 0; i < barsNeeded * 2; i += 2) {
                        x -= 9;
                        if (modifiedFoodValues.hunger < 0) {
                            gui.func_73729_b(x, y, 34, 27, 9, 9);
                        } else if (modifiedFoodValues.hunger > defaultFoodValues.hunger && defaultFoodValues.hunger <= i) {
                            gui.func_73729_b(x, y, 133, 27, 9, 9);
                        } else if (modifiedFoodValues.hunger > i + 1 || defaultFoodValues.hunger == modifiedFoodValues.hunger) {
                            gui.func_73729_b(x, y, 16, 27, 9, 9);
                        } else if (modifiedFoodValues.hunger == i + 1) {
                            gui.func_73729_b(x, y, 124, 27, 9, 9);
                        } else {
                            gui.func_73729_b(x, y, 34, 27, 9, 9);
                        }
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.25f);
                        gui.func_73729_b(x, y, defaultFoodValues.hunger - 1 == i ? 115 : 106, 27, 9, 9);
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        if (modifiedFoodValues.hunger <= i) continue;
                        gui.func_73729_b(x, y, modifiedFoodValues.hunger - 1 == i ? 61 : 52, 27, 9, 9);
                    }
                    y += 11;
                    x = startX;
                    float modifiedSaturationIncrement = modifiedFoodValues.getSaturationIncrement();
                    float absModifiedSaturationIncrement = Math.abs(modifiedSaturationIncrement);
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179152_a((float)0.75f, (float)0.75f, (float)0.75f);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    for (int i = 0; i < saturationBarsNeeded * 2; i += 2) {
                        boolean shouldBeFaded;
                        float effectiveSaturationOfBar = (absModifiedSaturationIncrement - (float)i) / 2.0f;
                        x -= 6;
                        boolean bl2 = shouldBeFaded = absModifiedSaturationIncrement <= (float)i;
                        if (shouldBeFaded) {
                            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                        }
                        mc.func_110434_K().func_110577_a(Gui.field_110324_m);
                        gui.func_73729_b(x * 4 / 3, y * 4 / 3, 16, 27, 9, 9);
                        mc.func_110434_K().func_110577_a(modIcons);
                        gui.func_73729_b(x * 4 / 3, y * 4 / 3, effectiveSaturationOfBar >= 1.0f ? 27 : ((double)effectiveSaturationOfBar > 0.5 ? 18 : ((double)effectiveSaturationOfBar > 0.25 ? 9 : (effectiveSaturationOfBar > 0.0f ? 0 : 36))), modifiedSaturationIncrement >= 0.0f ? 0 : 9, 9, 9);
                        if (!shouldBeFaded) continue;
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    }
                    if (saturationText != null) {
                        mc.field_71466_p.func_175063_a(saturationText, (float)(x * 4 / 3 - mc.field_71466_p.func_78256_a(saturationText) + 2), (float)(y * 4 / 3 + 1), -65536);
                    }
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179084_k();
                    GlStateManager.func_179126_j();
                    GlStateManager.func_179145_e();
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
            }
        }
    }

    static {
        try {
            jeiLoaded = Loader.isModLoaded((String)"JEI");
            if (jeiLoaded) {
                Class<?> jeiInternal = Class.forName("mezz.jei.Internal");
                jeiGetRuntime = jeiInternal.getDeclaredMethod("getRuntime", new Class[0]);
                JeiRuntime = Class.forName("mezz.jei.JeiRuntime");
                jeiGetItemListOverlay = JeiRuntime.getDeclaredMethod("getItemListOverlay", new Class[0]);
                jeiGetRecipesGui = JeiRuntime.getDeclaredMethod("getRecipesGui", new Class[0]);
                Class<?> ItemListOverlay = Class.forName("mezz.jei.gui.ItemListOverlay");
                jeiGetFocusUnderMouse = ItemListOverlay.getDeclaredMethod("getFocusUnderMouse", Integer.TYPE, Integer.TYPE);
                RecipesGui = Class.forName("mezz.jei.gui.RecipesGui");
                jeiRecipesGetFocusUnderMouse = RecipesGui.getDeclaredMethod("getFocusUnderMouse", Integer.TYPE, Integer.TYPE);
                jeiRecipeLayouts = RecipesGui.getDeclaredField("recipeLayouts");
                jeiRecipeLayouts.setAccessible(true);
                jeiRecipesGui_guiLeft = RecipesGui.getDeclaredField("guiLeft");
                jeiRecipesGui_guiLeft.setAccessible(true);
                jeiRecipesGui_guiTop = RecipesGui.getDeclaredField("guiTop");
                jeiRecipesGui_guiTop.setAccessible(true);
                Class<?> RecipeLayout = Class.forName("mezz.jei.gui.RecipeLayout");
                jeiRecipeLayoutPosX = RecipeLayout.getDeclaredField("posX");
                jeiRecipeLayoutPosX.setAccessible(true);
                jeiRecipeLayoutPosY = RecipeLayout.getDeclaredField("posY");
                jeiRecipeLayoutPosY.setAccessible(true);
                jeiRecipeLayout_getFocusUnderMouse = RecipeLayout.getDeclaredMethod("getFocusUnderMouse", Integer.TYPE, Integer.TYPE);
                Class<?> Focus = Class.forName("mezz.jei.gui.Focus");
                jeiFocus_itemStack = Focus.getDeclaredField("stack");
                jeiFocus_itemStack.setAccessible(true);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            AppleCore.Log.error("Unable to integrate the food values tooltip overlay with JEI: ");
            e.printStackTrace();
        }
        try {
            neiLoaded = Loader.isModLoaded((String)"NotEnoughItems");
            if (neiLoaded) {
                Class<?> LayoutManager = Class.forName("codechicken.nei.LayoutManager");
                itemPanel = LayoutManager.getDeclaredField("itemPanel");
                getStackMouseOver = Class.forName("codechicken.nei.ItemPanel").getDeclaredMethod("getStackMouseOver", Integer.TYPE, Integer.TYPE);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            AppleCore.Log.error("Unable to integrate the food values tooltip overlay with NEI: ");
            e.printStackTrace();
        }
        try {
            if (Loader.isModLoaded((String)"SpiceOfLife")) {
                foodJournalGui = ReflectionHelper.getClass((ClassLoader)TooltipOverlayHandler.class.getClassLoader(), (String[])new String[]{"squeek.spiceoflife.gui.GuiScreenFoodJournal"});
                foodJournalHoveredStack = ReflectionHelper.findField(foodJournalGui, (String[])new String[]{"hoveredStack"});
            }
        }
        catch (Exception e) {
            AppleCore.Log.error("Unable to integrate the food values tooltip overlay with The Spice of Life: ");
            e.printStackTrace();
        }
    }
}

