/*
 * Decompiled with CFR 0.152.
 */
package squeek.applecore.asm.module;

import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import squeek.applecore.asm.IClassTransformerModule;
import squeek.asmhelper.applecore.ASMHelper;

public class ModulePlantGrowth
implements IClassTransformerModule {
    @Override
    public String[] getClassesToTransform() {
        return new String[]{"net.minecraft.block.BlockCrops", "net.minecraft.block.BlockReed", "net.minecraft.block.BlockCactus", "net.minecraft.block.BlockCocoa", "net.minecraft.block.BlockMushroom", "net.minecraft.block.BlockNetherWart", "net.minecraft.block.BlockSapling", "net.minecraft.block.BlockStem"};
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        ClassNode classNode = ASMHelper.readClassFromBytes(basicClass);
        MethodNode methodNode = ASMHelper.findMethodNodeOfClass(classNode, "func_180650_b", "updateTick", ASMHelper.toMethodDescriptor("V", "net.minecraft.world.World", "net.minecraft.util.math.BlockPos", "net.minecraft.block.state.IBlockState", "java.util.Random"));
        if (methodNode == null) {
            methodNode = ASMHelper.findMethodNodeOfClass(classNode, "func_180650_b", "updateTick", ASMHelper.toMethodDescriptor("V", "net.minecraft.world.World", "net.minecraft.util.math.BlockPos", "net.minecraft.block.state.IBlockState", "java.util.Random"));
        }
        if (methodNode == null) {
            throw new RuntimeException(classNode.name + ": updateTick method not found");
        }
        if (transformedName.equals("net.minecraft.block.BlockCrops")) {
            this.hookBlockCrops(methodNode);
        } else if (transformedName.equals("net.minecraft.block.BlockReed")) {
            this.hookBlockReed(methodNode);
        } else if (transformedName.equals("net.minecraft.block.BlockCactus")) {
            this.hookBlockCactus(methodNode);
        } else if (transformedName.equals("net.minecraft.block.BlockCocoa")) {
            this.hookBlockCocoa(methodNode);
        } else if (transformedName.equals("net.minecraft.block.BlockMushroom")) {
            this.hookBlockMushroom(methodNode);
        } else if (transformedName.equals("net.minecraft.block.BlockNetherWart")) {
            this.hookBlockNetherWart(methodNode);
        } else if (transformedName.equals("net.minecraft.block.BlockSapling")) {
            this.hookBlockSapling(methodNode);
        } else if (transformedName.equals("net.minecraft.block.BlockStem")) {
            this.hookBlockStem(methodNode);
        } else {
            throw new RuntimeException("Unexpected class passed to transformer : " + transformedName);
        }
        return ASMHelper.writeClassToBytes(classNode);
    }

    private void hookBlockCrops(MethodNode method) {
        JumpInsnNode ifJumpInsn = (JumpInsnNode)ASMHelper.findFirstInstructionWithOpcode(method, 161);
        AbstractInsnNode ifStartPoint = ASMHelper.findNextInstruction(ASMHelper.findFirstInstructionWithOpcode(method, 183));
        if (ifStartPoint == null) {
            throw new RuntimeException("Failed to transform BlockCrops, INVOKESPECIAL instruction not found");
        }
        LabelNode endLabel = ASMHelper.findEndLabel(method);
        LabelNode ifFailedLabel = ifJumpInsn.label;
        LabelNode ifAllowedLabel = new LabelNode();
        method.instructions.insert((AbstractInsnNode)ifJumpInsn, (AbstractInsnNode)ifAllowedLabel);
        int resultIndex = this.fireAllowGrowthEventAndStoreResultBefore(method, ifStartPoint, endLabel);
        this.injectAllowedOrDefaultCheckBefore(method, ifStartPoint, resultIndex, ifAllowedLabel, ifFailedLabel);
        ifStartPoint = ASMHelper.findPreviousLabelOrLineNumber(ASMHelper.findNextInstructionWithOpcode((AbstractInsnNode)ifJumpInsn, 18)).getNext();
        ifJumpInsn = (JumpInsnNode)ASMHelper.findNextInstructionWithOpcode(ifStartPoint, 154);
        ifFailedLabel = ifJumpInsn.label;
        ifAllowedLabel = new LabelNode();
        method.instructions.insert((AbstractInsnNode)ifJumpInsn, (AbstractInsnNode)ifAllowedLabel);
        this.injectAllowedOrDefaultCheckBefore(method, ifStartPoint, resultIndex, ifAllowedLabel, ifFailedLabel);
        this.injectOnGrowthEventBefore(method, (AbstractInsnNode)ifFailedLabel);
    }

    private void hookBlockReed(MethodNode method) {
        JumpInsnNode ifJumpInsn = (JumpInsnNode)ASMHelper.findFirstInstructionWithOpcode(method, 162);
        LabelNode ifDeniedLabel = ifJumpInsn.label;
        this.injectNotDeniedCheckBefore(method, ifJumpInsn.getNext(), ifDeniedLabel);
        LabelNode newGotoLabel = new LabelNode();
        JumpInsnNode gotoInsn = (JumpInsnNode)ASMHelper.findNextInstructionWithOpcode((AbstractInsnNode)ifJumpInsn, 167);
        gotoInsn.label = newGotoLabel;
        method.instructions.insertBefore((AbstractInsnNode)ifDeniedLabel, (AbstractInsnNode)newGotoLabel);
        this.injectOnGrowthEventBefore(method, (AbstractInsnNode)ifDeniedLabel);
    }

    private void hookBlockCactus(MethodNode method) {
        JumpInsnNode ifJumpInsn = (JumpInsnNode)ASMHelper.findFirstInstructionWithOpcode(method, 162);
        LabelNode ifDeniedLabel = ifJumpInsn.label;
        this.injectNotDeniedCheckBefore(method, ifJumpInsn.getNext(), ifDeniedLabel);
        LabelNode newGotoLabel = new LabelNode();
        JumpInsnNode gotoInsn = (JumpInsnNode)ASMHelper.findNextInstructionWithOpcode((AbstractInsnNode)ifJumpInsn, 167);
        gotoInsn.label = newGotoLabel;
        method.instructions.insertBefore((AbstractInsnNode)ifDeniedLabel, (AbstractInsnNode)newGotoLabel);
        this.injectOnGrowthEventBefore(method, (AbstractInsnNode)ifDeniedLabel);
    }

    private void hookBlockCocoa(MethodNode method) {
        int resultIndex = this.fireAllowGrowthEventAndStoreResultBefore(method, ASMHelper.findFirstInstruction(method), ASMHelper.findEndLabel(method));
        JumpInsnNode ifJumpInsn = (JumpInsnNode)ASMHelper.findFirstInstructionWithOpcode(method, 154);
        ifJumpInsn = (JumpInsnNode)ASMHelper.findNextInstructionWithOpcode((AbstractInsnNode)ifJumpInsn, 154);
        AbstractInsnNode ifStartPoint = ASMHelper.findPreviousLabelOrLineNumber((AbstractInsnNode)ifJumpInsn).getNext();
        LabelNode ifFailedLabel = ifJumpInsn.label;
        LabelNode ifAllowedLabel = new LabelNode();
        method.instructions.insert((AbstractInsnNode)ifJumpInsn, (AbstractInsnNode)ifAllowedLabel);
        this.injectAllowedOrDefaultCheckBefore(method, ifStartPoint, resultIndex, ifAllowedLabel, ifFailedLabel);
        this.injectOnGrowthEventBefore(method, (AbstractInsnNode)ifFailedLabel);
    }

    private void hookBlockMushroom(MethodNode method) {
        int resultIndex = this.fireAllowGrowthEventAndStoreResultBefore(method, ASMHelper.findFirstInstruction(method), ASMHelper.findEndLabel(method));
        JumpInsnNode ifJumpInsn = (JumpInsnNode)ASMHelper.findFirstInstructionWithOpcode(method, 154);
        AbstractInsnNode ifStartPoint = ASMHelper.findPreviousLabelOrLineNumber((AbstractInsnNode)ifJumpInsn).getNext();
        LabelNode ifFailedLabel = ifJumpInsn.label;
        LabelNode ifAllowedLabel = new LabelNode();
        method.instructions.insert((AbstractInsnNode)ifJumpInsn, (AbstractInsnNode)ifAllowedLabel);
        this.injectAllowedOrDefaultCheckBefore(method, ifStartPoint, resultIndex, ifAllowedLabel, ifFailedLabel);
        this.fixPrecedingIfsToNotSkipInjectedInstructions(method, ifFailedLabel);
        this.injectOnGrowthEventBefore(method, (AbstractInsnNode)ifFailedLabel);
    }

    private void hookBlockNetherWart(MethodNode method) {
        int previousStateIndex = this.storeBlockStateInNewVariable(method);
        int resultIndex = this.fireAllowGrowthEventAndStoreResultBefore(method, ASMHelper.findFirstInstruction(method), ASMHelper.findEndLabel(method));
        JumpInsnNode ifJumpInsn = (JumpInsnNode)ASMHelper.findFirstInstructionWithOpcode(method, 154);
        AbstractInsnNode ifStartPoint = ASMHelper.findPreviousInstructionWithOpcode((AbstractInsnNode)ifJumpInsn, 162).getNext();
        LabelNode ifFailedLabel = ifJumpInsn.label;
        LabelNode ifAllowedLabel = new LabelNode();
        method.instructions.insert((AbstractInsnNode)ifJumpInsn, (AbstractInsnNode)ifAllowedLabel);
        this.injectAllowedOrDefaultCheckBefore(method, ifStartPoint, resultIndex, ifAllowedLabel, ifFailedLabel);
        this.injectOnGrowthEventBefore(method, (AbstractInsnNode)ifFailedLabel, previousStateIndex);
    }

    private void hookBlockSapling(MethodNode method) {
        JumpInsnNode lightValueIf = (JumpInsnNode)ASMHelper.findFirstInstructionWithOpcode(method, 161);
        JumpInsnNode randomIf = (JumpInsnNode)ASMHelper.findNextInstructionWithOpcode((AbstractInsnNode)lightValueIf, 154);
        AbstractInsnNode ifStartPoint = ASMHelper.findNextInstruction(ASMHelper.findFirstInstructionWithOpcode(method, 183));
        if (ifStartPoint == null) {
            throw new RuntimeException("Failed to transform BlockSapling, INVOKESPECIAL instruction not found");
        }
        LabelNode ifFailedLabel = lightValueIf.label;
        LabelNode ifAllowedLabel = new LabelNode();
        method.instructions.insert((AbstractInsnNode)randomIf, (AbstractInsnNode)ifAllowedLabel);
        int resultIndex = this.fireAllowGrowthEventAndStoreResultBefore(method, ifStartPoint, ifFailedLabel);
        this.injectAllowedOrDefaultCheckBefore(method, ifStartPoint, resultIndex, ifAllowedLabel, ifFailedLabel);
        this.injectOnGrowthEventBefore(method, (AbstractInsnNode)ifFailedLabel);
    }

    private void hookBlockStem(MethodNode method) {
        int previousStateIndex = this.storeBlockStateInNewVariable(method);
        JumpInsnNode lightValueIf = (JumpInsnNode)ASMHelper.findFirstInstructionWithOpcode(method, 161);
        AbstractInsnNode ifStartPoint = ASMHelper.getOrFindInstructionOfType((AbstractInsnNode)lightValueIf, 15, true).getNext();
        LabelNode ifFailedLabel = lightValueIf.label;
        LabelNode ifAllowedLabel = new LabelNode();
        method.instructions.insert((AbstractInsnNode)lightValueIf, (AbstractInsnNode)ifAllowedLabel);
        int resultIndex = this.fireAllowGrowthEventAndStoreResultBefore(method, ifStartPoint, ASMHelper.findEndLabel(method));
        this.injectAllowedOrDefaultCheckBefore(method, ifStartPoint, resultIndex, ifAllowedLabel, ifFailedLabel);
        JumpInsnNode randomIf = (JumpInsnNode)ASMHelper.findNextInstructionWithOpcode((AbstractInsnNode)lightValueIf, 154);
        ifStartPoint = ASMHelper.getOrFindInstructionOfType((AbstractInsnNode)randomIf, 15, true).getNext();
        ifFailedLabel = randomIf.label;
        ifAllowedLabel = new LabelNode();
        method.instructions.insert((AbstractInsnNode)randomIf, (AbstractInsnNode)ifAllowedLabel);
        this.injectAllowedOrDefaultCheckBefore(method, ifStartPoint, resultIndex, ifAllowedLabel, ifFailedLabel);
        LabelNode newGotoLabel = new LabelNode();
        JumpInsnNode gotoInsn = (JumpInsnNode)ASMHelper.findNextInstructionWithOpcode((AbstractInsnNode)randomIf, 167);
        gotoInsn.label = newGotoLabel;
        method.instructions.insertBefore((AbstractInsnNode)ifFailedLabel, (AbstractInsnNode)newGotoLabel);
        this.fixPrecedingIfsToNotSkipInjectedInstructions(method, ifFailedLabel);
        this.injectOnGrowthEventBefore(method, (AbstractInsnNode)ifFailedLabel, previousStateIndex);
    }

    private int storeBlockStateInNewVariable(MethodNode method) {
        LabelNode previousStateStart = new LabelNode();
        LabelNode previousStateEnd = ASMHelper.findEndLabel(method);
        LocalVariableNode previousState = new LocalVariableNode("previousState", ASMHelper.toDescriptor("net.minecraft.block.state.IBlockState"), null, previousStateStart, previousStateEnd, method.maxLocals);
        ++method.maxLocals;
        method.localVariables.add(previousState);
        InsnList toInject = new InsnList();
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 3));
        toInject.add((AbstractInsnNode)new VarInsnNode(58, previousState.index));
        toInject.add((AbstractInsnNode)previousStateStart);
        method.instructions.insert(ASMHelper.findFirstInstruction(method), toInject);
        return previousState.index;
    }

    private int fireAllowGrowthEventAndStoreResultBefore(MethodNode method, AbstractInsnNode injectPoint, LabelNode endLabel) {
        LabelNode allowGrowthResultStart = new LabelNode();
        LocalVariableNode allowGrowthResult = new LocalVariableNode("allowGrowthResult", ASMHelper.toDescriptor("net.minecraftforge.fml.common.eventhandler.Event$Result"), null, allowGrowthResultStart, endLabel, method.maxLocals);
        ++method.maxLocals;
        method.localVariables.add(allowGrowthResult);
        InsnList toInject = new InsnList();
        this.addFireGrowthEventInsnsToList(toInject);
        toInject.add((AbstractInsnNode)new VarInsnNode(58, allowGrowthResult.index));
        toInject.add((AbstractInsnNode)allowGrowthResultStart);
        method.instructions.insertBefore(injectPoint, toInject);
        return allowGrowthResult.index;
    }

    private void addFireGrowthEventInsnsToList(InsnList insnList) {
        insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
        insnList.add((AbstractInsnNode)new VarInsnNode(25, 1));
        insnList.add((AbstractInsnNode)new VarInsnNode(25, 2));
        insnList.add((AbstractInsnNode)new VarInsnNode(25, 3));
        insnList.add((AbstractInsnNode)new VarInsnNode(25, 4));
        insnList.add((AbstractInsnNode)new MethodInsnNode(184, ASMHelper.toInternalClassName("squeek.applecore.asm.Hooks"), "fireAllowPlantGrowthEvent", ASMHelper.toMethodDescriptor("net.minecraftforge.fml.common.eventhandler.Event$Result", "net.minecraft.block.Block", "net.minecraft.world.World", "net.minecraft.util.math.BlockPos", "net.minecraft.block.state.IBlockState", "java.util.Random"), false));
    }

    private void injectAllowedOrDefaultCheckBefore(MethodNode method, AbstractInsnNode injectPoint, int resultIndex, LabelNode ifAllowedLabel, LabelNode ifFailedLabel) {
        InsnList toInject = new InsnList();
        toInject.add((AbstractInsnNode)new VarInsnNode(25, resultIndex));
        toInject.add((AbstractInsnNode)new FieldInsnNode(178, ASMHelper.toInternalClassName("net.minecraftforge.fml.common.eventhandler.Event$Result"), "ALLOW", ASMHelper.toDescriptor("net.minecraftforge.fml.common.eventhandler.Event$Result")));
        toInject.add((AbstractInsnNode)new JumpInsnNode(165, ifAllowedLabel));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, resultIndex));
        toInject.add((AbstractInsnNode)new FieldInsnNode(178, ASMHelper.toInternalClassName("net.minecraftforge.fml.common.eventhandler.Event$Result"), "DEFAULT", ASMHelper.toDescriptor("net.minecraftforge.fml.common.eventhandler.Event$Result")));
        toInject.add((AbstractInsnNode)new JumpInsnNode(166, ifFailedLabel));
        method.instructions.insertBefore(injectPoint, toInject);
    }

    private void injectNotDeniedCheckBefore(MethodNode method, AbstractInsnNode injectPoint, LabelNode ifDeniedLabel) {
        InsnList toInject = new InsnList();
        this.addFireGrowthEventInsnsToList(toInject);
        toInject.add((AbstractInsnNode)new FieldInsnNode(178, ASMHelper.toInternalClassName("net.minecraftforge.fml.common.eventhandler.Event$Result"), "DENY", ASMHelper.toDescriptor("net.minecraftforge.fml.common.eventhandler.Event$Result")));
        toInject.add((AbstractInsnNode)new JumpInsnNode(165, ifDeniedLabel));
        method.instructions.insertBefore(injectPoint, toInject);
    }

    private void injectOnGrowthEventBefore(MethodNode method, AbstractInsnNode injectPoint, int previousStateIndex) {
        InsnList toInject = new InsnList();
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 1));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 2));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, previousStateIndex));
        toInject.add((AbstractInsnNode)new MethodInsnNode(184, ASMHelper.toInternalClassName("squeek.applecore.asm.Hooks"), "fireOnGrowthEvent", ASMHelper.toMethodDescriptor("V", "net.minecraft.block.Block", "net.minecraft.world.World", "net.minecraft.util.math.BlockPos", "net.minecraft.block.state.IBlockState"), false));
        method.instructions.insertBefore(injectPoint, toInject);
    }

    private void injectOnGrowthEventBefore(MethodNode method, AbstractInsnNode injectPoint) {
        this.injectOnGrowthEventBefore(method, injectPoint, 3);
    }

    private void fixPrecedingIfsToNotSkipInjectedInstructions(MethodNode method, LabelNode labelJumpedTo) {
        LabelNode beforeOnGrowthEvent = new LabelNode();
        method.instructions.insertBefore((AbstractInsnNode)labelJumpedTo, (AbstractInsnNode)beforeOnGrowthEvent);
        for (AbstractInsnNode curInsn = labelJumpedTo.getPrevious(); curInsn != null; curInsn = curInsn.getPrevious()) {
            boolean isJump = curInsn instanceof JumpInsnNode;
            if (isJump && ((JumpInsnNode)curInsn).label == labelJumpedTo) {
                ((JumpInsnNode)curInsn).label = beforeOnGrowthEvent;
                continue;
            }
            if (isJump) break;
        }
    }
}

