/*
 * Decompiled with CFR 0.152.
 */
package squeek.applecore.asm.module;

import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import squeek.applecore.AppleCore;
import squeek.applecore.asm.ASMConstants;
import squeek.applecore.asm.IClassTransformerModule;
import squeek.asmhelper.applecore.ASMHelper;

public class ModuleDrawTooltip
implements IClassTransformerModule {
    @Override
    public String[] getClassesToTransform() {
        return new String[]{"net.minecraftforge.fml.client.config.GuiUtils", "codechicken.lib.gui.GuiDraw"};
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] transform(String name, String transformedName, byte[] bytes) {
        ClassNode classNode = ASMHelper.readClassFromBytes(bytes);
        if (transformedName.equals("net.minecraftforge.fml.client.config.GuiUtils")) {
            MethodNode methodNode = ASMHelper.findMethodNodeOfClass(classNode, "drawHoveringText", ASMHelper.toMethodDescriptor("V", "java.util.List", "I", "I", "I", "I", "I", "net.minecraft.client.gui.FontRenderer"));
            if (methodNode == null) throw new RuntimeException("GuiUtils.drawHoveringText not found");
            this.addDrawHoveringTextHook(methodNode, "onDrawHoveringText", ASMHelper.toMethodDescriptor("V", "I", "I", "I", "I"));
            return ASMHelper.writeClassToBytes(classNode);
        } else {
            if (!name.equals("codechicken.lib.gui.GuiDraw")) return ASMHelper.writeClassToBytes(classNode);
            MethodNode methodNode = ASMHelper.findMethodNodeOfClass(classNode, "drawTooltipBox", ASMHelper.toMethodDescriptor("V", "I", "I", "I", "I"));
            if (methodNode != null) {
                this.addCodeChickenDrawHoveringTextHook(methodNode, "onDrawHoveringText", ASMHelper.toMethodDescriptor("V", "I", "I", "I", "I"));
                return ASMHelper.writeClassToBytes(classNode);
            } else {
                AppleCore.Log.error("drawTooltipBox method in codechicken.lib.gui.GuiDraw not found");
            }
        }
        return ASMHelper.writeClassToBytes(classNode);
    }

    private void addDrawHoveringTextHook(MethodNode method, String hookMethod, String hookDesc) {
        AbstractInsnNode targetNode = null;
        for (AbstractInsnNode instruction : method.instructions.toArray()) {
            if (instruction.getOpcode() != 184) continue;
            MethodInsnNode methodInsn = (MethodInsnNode)instruction;
            if (!methodInsn.desc.equals(ASMHelper.toMethodDescriptor("V", "I", "I", "I", "I", "I", "I", "I"))) continue;
            targetNode = instruction;
        }
        if (targetNode == null) {
            throw new RuntimeException("Unexpected instruction pattern encountered in " + method.name);
        }
        LocalVariableNode x = ASMHelper.findLocalVariableOfMethod(method, "tooltipX", "I");
        LocalVariableNode y = ASMHelper.findLocalVariableOfMethod(method, "tooltipY", "I");
        LocalVariableNode w = ASMHelper.findLocalVariableOfMethod(method, "tooltipTextWidth", "I");
        LocalVariableNode h = ASMHelper.findLocalVariableOfMethod(method, "tooltipHeight", "I");
        if (x == null || y == null || w == null || h == null) {
            AppleCore.Log.warn("Could not patch " + method.name + "; local variables not found");
            return;
        }
        InsnList toInject = new InsnList();
        toInject.add((AbstractInsnNode)new VarInsnNode(21, x.index));
        toInject.add((AbstractInsnNode)new VarInsnNode(21, y.index));
        toInject.add((AbstractInsnNode)new VarInsnNode(21, w.index));
        toInject.add((AbstractInsnNode)new VarInsnNode(21, h.index));
        toInject.add((AbstractInsnNode)new MethodInsnNode(184, ASMConstants.HOOKS_INTERNAL_CLASS, hookMethod, hookDesc, false));
        method.instructions.insert(targetNode, toInject);
    }

    public void addCodeChickenDrawHoveringTextHook(MethodNode method, String hookMethod, String hookDesc) {
        AbstractInsnNode targetNode = ASMHelper.findFirstInstruction(method);
        InsnList toInject = new InsnList();
        toInject.add((AbstractInsnNode)new VarInsnNode(21, 0));
        toInject.add((AbstractInsnNode)new VarInsnNode(21, 1));
        toInject.add((AbstractInsnNode)new VarInsnNode(21, 2));
        toInject.add((AbstractInsnNode)new VarInsnNode(21, 3));
        toInject.add((AbstractInsnNode)new MethodInsnNode(184, ASMConstants.HOOKS_INTERNAL_CLASS, hookMethod, hookDesc, false));
        method.instructions.insertBefore(targetNode, toInject);
    }
}

