/*
 * Decompiled with CFR 0.152.
 */
package squeek.applecore.asm.module;

import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import squeek.applecore.asm.ASMConstants;
import squeek.applecore.asm.IClassTransformerModule;
import squeek.asmhelper.applecore.ASMHelper;
import squeek.asmhelper.applecore.ObfHelper;

public class ModuleBlockFood
implements IClassTransformerModule {
    @Override
    public String[] getClassesToTransform() {
        return new String[]{"net.minecraft.block.BlockCake"};
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        ClassNode classNode = ASMHelper.readClassFromBytes(basicClass);
        MethodNode methodNode = ASMHelper.findMethodNodeOfClass(classNode, "func_180682_b", "eatCake", ASMHelper.toMethodDescriptor("V", "net.minecraft.world.World", "net.minecraft.util.math.BlockPos", "net.minecraft.block.state.IBlockState", "net.minecraft.entity.player.EntityPlayer"));
        if (methodNode != null) {
            this.addOnBlockFoodEatenHook(classNode, methodNode);
            return ASMHelper.writeClassToBytes(classNode);
        }
        throw new RuntimeException("BlockCake: eatCake (func_180682_b) method not found");
    }

    private void addOnBlockFoodEatenHook(ClassNode classNode, MethodNode method) {
        AbstractInsnNode firstUniqueInsnInsideIf = ASMHelper.find(method.instructions, (AbstractInsnNode)new FieldInsnNode(178, ASMHelper.toInternalClassName("net.minecraft.stats.StatList"), "*", ASMHelper.toDescriptor("net.minecraft.stats.StatBase")));
        if (firstUniqueInsnInsideIf == null) {
            throw new RuntimeException("Target instruction not found in " + classNode.name + "." + method.name);
        }
        AbstractInsnNode returnInsn = ASMHelper.findPreviousInstructionWithOpcode(method.instructions.getLast(), 177);
        AbstractInsnNode prevLabel = ASMHelper.findPreviousLabelOrLineNumber(returnInsn);
        while (prevLabel != null && prevLabel.getType() != 8) {
            prevLabel = ASMHelper.findPreviousLabelOrLineNumber(prevLabel);
        }
        LabelNode ifEndLabel = (LabelNode)prevLabel;
        InsnList toInject = new InsnList();
        AbstractInsnNode targetNode = firstUniqueInsnInsideIf.getPrevious();
        LabelNode modifiedFoodValuesStart = new LabelNode();
        LocalVariableNode modifiedFoodValues = new LocalVariableNode("modifiedFoodValues", ASMHelper.toDescriptor("squeek.applecore.api.food.FoodValues"), null, modifiedFoodValuesStart, ifEndLabel, method.maxLocals);
        ++method.maxLocals;
        method.localVariables.add(modifiedFoodValues);
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 1));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 4));
        toInject.add((AbstractInsnNode)new MethodInsnNode(184, ASMConstants.HOOKS_INTERNAL_CLASS, "onBlockFoodEaten", ASMHelper.toMethodDescriptor("squeek.applecore.api.food.FoodValues", "net.minecraft.block.Block", "net.minecraft.world.World", "net.minecraft.entity.player.EntityPlayer"), false));
        toInject.add((AbstractInsnNode)new VarInsnNode(58, modifiedFoodValues.index));
        toInject.add((AbstractInsnNode)modifiedFoodValuesStart);
        LabelNode prevFoodLevelStart = new LabelNode();
        LocalVariableNode prevFoodLevel = new LocalVariableNode("prevFoodLevel", "I", null, prevFoodLevelStart, ifEndLabel, method.maxLocals);
        ++method.maxLocals;
        method.localVariables.add(prevFoodLevel);
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 4));
        toInject.add((AbstractInsnNode)new MethodInsnNode(182, ObfHelper.getInternalClassName("net.minecraft.entity.player.EntityPlayer"), ObfHelper.isObfuscated() ? "func_71024_bL" : "getFoodStats", ASMHelper.toMethodDescriptor("net.minecraft.util.FoodStats", new String[0]), false));
        toInject.add((AbstractInsnNode)new MethodInsnNode(182, ObfHelper.getInternalClassName("net.minecraft.util.FoodStats"), ObfHelper.isObfuscated() ? "func_75116_a" : "getFoodLevel", ASMHelper.toMethodDescriptor("I", new String[0]), false));
        toInject.add((AbstractInsnNode)new VarInsnNode(54, prevFoodLevel.index));
        toInject.add((AbstractInsnNode)prevFoodLevelStart);
        LabelNode prevSaturationLevelStart = new LabelNode();
        LocalVariableNode prevSaturationLevel = new LocalVariableNode("prevSaturationLevel", "F", null, prevSaturationLevelStart, ifEndLabel, method.maxLocals);
        ++method.maxLocals;
        method.localVariables.add(prevSaturationLevel);
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 4));
        toInject.add((AbstractInsnNode)new MethodInsnNode(182, ObfHelper.getInternalClassName("net.minecraft.entity.player.EntityPlayer"), ObfHelper.isObfuscated() ? "func_71024_bL" : "getFoodStats", ASMHelper.toMethodDescriptor("net.minecraft.util.FoodStats", new String[0]), false));
        toInject.add((AbstractInsnNode)new MethodInsnNode(182, ObfHelper.getInternalClassName("net.minecraft.util.FoodStats"), ObfHelper.isObfuscated() ? "func_75115_e" : "getSaturationLevel", ASMHelper.toMethodDescriptor("F", new String[0]), false));
        toInject.add((AbstractInsnNode)new VarInsnNode(56, prevSaturationLevel.index));
        toInject.add((AbstractInsnNode)prevSaturationLevelStart);
        method.instructions.insertBefore(targetNode, toInject);
        InsnList hungerNeedle = new InsnList();
        hungerNeedle.add((AbstractInsnNode)new InsnNode(5));
        InsnList hungerReplacement = new InsnList();
        hungerReplacement.add((AbstractInsnNode)new VarInsnNode(25, modifiedFoodValues.index));
        hungerReplacement.add((AbstractInsnNode)new FieldInsnNode(180, ASMHelper.toInternalClassName("squeek.applecore.api.food.FoodValues"), "hunger", "I"));
        InsnList saturationNeedle = new InsnList();
        saturationNeedle.add((AbstractInsnNode)new LdcInsnNode((Object)Float.valueOf(0.1f)));
        InsnList saturationReplacement = new InsnList();
        saturationReplacement.add((AbstractInsnNode)new VarInsnNode(25, modifiedFoodValues.index));
        saturationReplacement.add((AbstractInsnNode)new FieldInsnNode(180, ASMHelper.toInternalClassName("squeek.applecore.api.food.FoodValues"), "saturationModifier", "F"));
        ASMHelper.findAndReplace(method.instructions, hungerNeedle, hungerReplacement, targetNode);
        ASMHelper.findAndReplace(method.instructions, saturationNeedle, saturationReplacement, targetNode);
        AbstractInsnNode targetNodeAfter = ASMHelper.find(targetNode, (AbstractInsnNode)new MethodInsnNode(182, ASMHelper.toInternalClassName("net.minecraft.util.FoodStats"), "*", ASMHelper.toMethodDescriptor("V", "I", "F"), false));
        InsnList toInjectAfter = new InsnList();
        toInjectAfter.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInjectAfter.add((AbstractInsnNode)new VarInsnNode(25, modifiedFoodValues.index));
        toInjectAfter.add((AbstractInsnNode)new VarInsnNode(21, prevFoodLevel.index));
        toInjectAfter.add((AbstractInsnNode)new VarInsnNode(23, prevSaturationLevel.index));
        toInjectAfter.add((AbstractInsnNode)new VarInsnNode(25, 4));
        toInjectAfter.add((AbstractInsnNode)new MethodInsnNode(184, ASMHelper.toInternalClassName("squeek.applecore.asm.Hooks"), "onPostBlockFoodEaten", ASMHelper.toMethodDescriptor("V", "net.minecraft.block.Block", "squeek.applecore.api.food.FoodValues", "I", "F", "net.minecraft.entity.player.EntityPlayer"), false));
        method.instructions.insert(targetNodeAfter, toInjectAfter);
    }
}

