/*
 * Decompiled with CFR 0.152.
 */
package squeek.applecore.asm;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCake;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.FoodStats;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import squeek.applecore.api.AppleCoreAPI;
import squeek.applecore.api.food.FoodEvent;
import squeek.applecore.api.food.FoodValues;
import squeek.applecore.api.hunger.ExhaustionEvent;
import squeek.applecore.api.hunger.HealthRegenEvent;
import squeek.applecore.api.hunger.HungerRegenEvent;
import squeek.applecore.api.hunger.StarvationEvent;
import squeek.applecore.api.plants.FertilizationEvent;
import squeek.applecore.asm.util.IAppleCoreFertilizable;
import squeek.applecore.asm.util.IAppleCoreFoodStats;

public class Hooks {
    private static final Random fertilizeRandom = new Random();
    public static int toolTipX;
    public static int toolTipY;
    public static int toolTipW;
    public static int toolTipH;

    public static boolean onAppleCoreFoodStatsUpdate(FoodStats foodStats, EntityPlayer player) {
        Event.Result allowStarvationResult;
        boolean shouldDoRegen;
        if (!(foodStats instanceof IAppleCoreFoodStats)) {
            return false;
        }
        IAppleCoreFoodStats appleCoreFoodStats = (IAppleCoreFoodStats)foodStats;
        appleCoreFoodStats.setPrevFoodLevel(foodStats.func_75116_a());
        Event.Result allowExhaustionResult = Hooks.fireAllowExhaustionEvent(player);
        float maxExhaustion = Hooks.fireExhaustionTickEvent(player, appleCoreFoodStats.getExhaustion());
        if (allowExhaustionResult == Event.Result.ALLOW || allowExhaustionResult == Event.Result.DEFAULT && appleCoreFoodStats.getExhaustion() >= maxExhaustion) {
            ExhaustionEvent.Exhausted exhaustedEvent = Hooks.fireExhaustionMaxEvent(player, maxExhaustion, appleCoreFoodStats.getExhaustion());
            appleCoreFoodStats.setExhaustion(appleCoreFoodStats.getExhaustion() + exhaustedEvent.deltaExhaustion);
            if (!exhaustedEvent.isCanceled()) {
                appleCoreFoodStats.setSaturation(Math.max(foodStats.func_75115_e() + exhaustedEvent.deltaSaturation, 0.0f));
                foodStats.func_75114_a(Math.max(foodStats.func_75116_a() + exhaustedEvent.deltaHunger, 0));
            }
        }
        boolean hasNaturalRegen = player.field_70170_p.func_82736_K().func_82765_e("naturalRegeneration");
        Event.Result allowSaturatedRegenResult = Hooks.fireAllowSaturatedRegenEvent(player);
        boolean shouldDoSaturatedRegen = allowSaturatedRegenResult == Event.Result.ALLOW || allowSaturatedRegenResult == Event.Result.DEFAULT && hasNaturalRegen && foodStats.func_75115_e() > 0.0f && player.func_70996_bM() && foodStats.func_75116_a() >= 20;
        Event.Result allowRegenResult = shouldDoSaturatedRegen ? Event.Result.DENY : Hooks.fireAllowRegenEvent(player);
        boolean bl = shouldDoRegen = allowRegenResult == Event.Result.ALLOW || allowRegenResult == Event.Result.DEFAULT && hasNaturalRegen && foodStats.func_75116_a() >= 18 && player.func_70996_bM();
        if (shouldDoSaturatedRegen) {
            appleCoreFoodStats.setFoodTimer(appleCoreFoodStats.getFoodTimer() + 1);
            if (appleCoreFoodStats.getFoodTimer() >= Hooks.fireSaturatedRegenTickEvent(player)) {
                HealthRegenEvent.SaturatedRegen saturatedRegenEvent = Hooks.fireSaturatedRegenEvent(player);
                if (!saturatedRegenEvent.isCanceled()) {
                    player.func_70691_i(saturatedRegenEvent.deltaHealth);
                    foodStats.func_75113_a(saturatedRegenEvent.deltaExhaustion);
                }
                appleCoreFoodStats.setFoodTimer(0);
            }
        } else if (shouldDoRegen) {
            appleCoreFoodStats.setFoodTimer(appleCoreFoodStats.getFoodTimer() + 1);
            if (appleCoreFoodStats.getFoodTimer() >= Hooks.fireRegenTickEvent(player)) {
                HealthRegenEvent.Regen regenEvent = Hooks.fireRegenEvent(player);
                if (!regenEvent.isCanceled()) {
                    player.func_70691_i(regenEvent.deltaHealth);
                    foodStats.func_75113_a(regenEvent.deltaExhaustion);
                }
                appleCoreFoodStats.setFoodTimer(0);
            }
        } else {
            appleCoreFoodStats.setFoodTimer(0);
        }
        if ((allowStarvationResult = Hooks.fireAllowStarvation(player)) == Event.Result.ALLOW || allowStarvationResult == Event.Result.DEFAULT && foodStats.func_75116_a() <= 0) {
            appleCoreFoodStats.setStarveTimer(appleCoreFoodStats.getStarveTimer() + 1);
            if (appleCoreFoodStats.getStarveTimer() >= Hooks.fireStarvationTickEvent(player)) {
                StarvationEvent.Starve starveEvent = Hooks.fireStarveEvent(player);
                if (!starveEvent.isCanceled()) {
                    player.func_70097_a(DamageSource.field_76366_f, starveEvent.starveDamage);
                }
                appleCoreFoodStats.setStarveTimer(0);
            }
        } else {
            appleCoreFoodStats.setStarveTimer(0);
        }
        return true;
    }

    public static FoodValues onFoodStatsAdded(FoodStats foodStats, ItemFood itemFood, ItemStack itemStack, EntityPlayer player) {
        return AppleCoreAPI.accessor.getFoodValuesForPlayer(itemStack, player);
    }

    public static void onPostFoodStatsAdded(FoodStats foodStats, ItemFood itemFood, ItemStack itemStack, FoodValues foodValues, int hungerAdded, float saturationAdded, EntityPlayer player) {
        MinecraftForge.EVENT_BUS.post((Event)new FoodEvent.FoodEaten(player, itemStack, foodValues, hungerAdded, saturationAdded));
    }

    public static int getItemInUseMaxCount(EntityLivingBase entityLiving, int savedMaxDuration) {
        EnumAction useAction = entityLiving.func_184607_cu().func_77975_n();
        if (useAction == EnumAction.EAT || useAction == EnumAction.DRINK) {
            return savedMaxDuration;
        }
        return entityLiving.func_184607_cu().func_77988_m();
    }

    private static ItemStack getFoodFromBlock(Block block) {
        if (block instanceof BlockCake) {
            return new ItemStack(Items.field_151105_aU);
        }
        return null;
    }

    public static FoodValues onBlockFoodEaten(Block block, World world, EntityPlayer player) {
        ItemStack itemStack = Hooks.getFoodFromBlock(block);
        if (itemStack != null) {
            return AppleCoreAPI.accessor.getFoodValuesForPlayer(itemStack, player);
        }
        return null;
    }

    public static void onPostBlockFoodEaten(Block block, FoodValues foodValues, int prevFoodLevel, float prevSaturationLevel, EntityPlayer player) {
        ItemStack itemStack = Hooks.getFoodFromBlock(block);
        int hungerAdded = player.func_71024_bL().func_75116_a() - prevFoodLevel;
        float saturationAdded = player.func_71024_bL().func_75115_e() - prevSaturationLevel;
        if (itemStack != null) {
            MinecraftForge.EVENT_BUS.post((Event)new FoodEvent.FoodEaten(player, itemStack, foodValues, hungerAdded, saturationAdded));
        }
    }

    public static Event.Result fireAllowExhaustionEvent(EntityPlayer player) {
        ExhaustionEvent.AllowExhaustion event = new ExhaustionEvent.AllowExhaustion(player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getResult();
    }

    public static float fireExhaustionTickEvent(EntityPlayer player, float foodExhaustionLevel) {
        return AppleCoreAPI.accessor.getMaxExhaustion(player);
    }

    public static ExhaustionEvent.Exhausted fireExhaustionMaxEvent(EntityPlayer player, float maxExhaustionLevel, float foodExhaustionLevel) {
        ExhaustionEvent.Exhausted event = new ExhaustionEvent.Exhausted(player, maxExhaustionLevel, foodExhaustionLevel);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event;
    }

    public static Event.Result fireAllowRegenEvent(EntityPlayer player) {
        HealthRegenEvent.AllowRegen event = new HealthRegenEvent.AllowRegen(player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getResult();
    }

    public static Event.Result fireAllowSaturatedRegenEvent(EntityPlayer player) {
        HealthRegenEvent.AllowSaturatedRegen event = new HealthRegenEvent.AllowSaturatedRegen(player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getResult();
    }

    public static int fireRegenTickEvent(EntityPlayer player) {
        return AppleCoreAPI.accessor.getHealthRegenTickPeriod(player);
    }

    public static int fireSaturatedRegenTickEvent(EntityPlayer player) {
        return AppleCoreAPI.accessor.getSaturatedHealthRegenTickPeriod(player);
    }

    public static HealthRegenEvent.Regen fireRegenEvent(EntityPlayer player) {
        HealthRegenEvent.Regen event = new HealthRegenEvent.Regen(player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event;
    }

    public static HealthRegenEvent.SaturatedRegen fireSaturatedRegenEvent(EntityPlayer player) {
        HealthRegenEvent.SaturatedRegen event = new HealthRegenEvent.SaturatedRegen(player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event;
    }

    public static HealthRegenEvent.PeacefulRegen firePeacefulRegenEvent(EntityPlayer player) {
        HealthRegenEvent.PeacefulRegen event = new HealthRegenEvent.PeacefulRegen(player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event;
    }

    public static HungerRegenEvent.PeacefulRegen firePeacefulHungerRegenEvent(EntityPlayer player) {
        HungerRegenEvent.PeacefulRegen event = new HungerRegenEvent.PeacefulRegen(player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event;
    }

    public static Event.Result fireAllowStarvation(EntityPlayer player) {
        StarvationEvent.AllowStarvation event = new StarvationEvent.AllowStarvation(player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getResult();
    }

    public static int fireStarvationTickEvent(EntityPlayer player) {
        return AppleCoreAPI.accessor.getStarveDamageTickPeriod(player);
    }

    public static StarvationEvent.Starve fireStarveEvent(EntityPlayer player) {
        StarvationEvent.Starve event = new StarvationEvent.Starve(player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event;
    }

    public static boolean fireFoodStatsAdditionEvent(EntityPlayer player, FoodValues foodValuesToBeAdded) {
        FoodEvent.FoodStatsAddition event = new FoodEvent.FoodStatsAddition(player, foodValuesToBeAdded);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.isCancelable() ? event.isCanceled() : false;
    }

    public static Event.Result fireAllowPlantGrowthEvent(Block block, World world, BlockPos pos, IBlockState state, Random random) {
        return AppleCoreAPI.dispatcher.validatePlantGrowth(block, world, pos, state, random);
    }

    public static void fireOnGrowthEvent(Block block, World world, BlockPos pos, IBlockState currentState, IBlockState previousState) {
        AppleCoreAPI.dispatcher.announcePlantGrowth(block, world, pos, currentState, previousState);
    }

    public static void fireOnGrowthEvent(Block block, World world, BlockPos pos, IBlockState previousState) {
        AppleCoreAPI.dispatcher.announcePlantGrowth(block, world, pos, previousState);
    }

    public static void fireAppleCoreFertilizeEvent(Block block, World world, BlockPos pos, IBlockState state, Random random) {
        if (!(block instanceof IAppleCoreFertilizable)) {
            return;
        }
        if (random == null) {
            random = fertilizeRandom;
        }
        IBlockState previousState = state;
        FertilizationEvent.Fertilize event = new FertilizationEvent.Fertilize(block, world, pos, state, random);
        MinecraftForge.EVENT_BUS.post((Event)event);
        Event.Result fertilizeResult = event.getResult();
        if (fertilizeResult == Event.Result.DENY) {
            return;
        }
        if (fertilizeResult == Event.Result.DEFAULT) {
            IAppleCoreFertilizable fertilizableBlock = (IAppleCoreFertilizable)block;
            try {
                fertilizableBlock.AppleCore_fertilize(world, random, pos, state);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        Hooks.fireFertilizedEvent(block, world, pos, previousState);
    }

    public static void fireFertilizedEvent(Block block, World world, BlockPos pos, IBlockState previousState) {
        FertilizationEvent.Fertilized event = new FertilizationEvent.Fertilized(block, world, pos, previousState);
        MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static void onDrawHoveringText(int x, int y, int w, int h) {
        toolTipX = x;
        toolTipY = y;
        toolTipW = w;
        toolTipH = h;
    }
}

