/*
 * Decompiled with CFR 0.152.
 */
package squeek.applecore.api.hunger;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.EnumDifficulty;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class ExhaustionEvent
extends Event {
    public final EntityPlayer player;

    public ExhaustionEvent(EntityPlayer player) {
        this.player = player;
    }

    @Cancelable
    public static class Exhausted
    extends ExhaustionEvent {
        public final float currentExhaustionLevel;
        public float deltaExhaustion;
        public int deltaHunger = -1;
        public float deltaSaturation = -1.0f;

        public Exhausted(EntityPlayer player, float exhaustionToRemove, float currentExhaustionLevel) {
            super(player);
            boolean shouldDecreaseFoodLevel;
            boolean shouldDecreaseSaturationLevel;
            this.deltaExhaustion = -exhaustionToRemove;
            this.currentExhaustionLevel = currentExhaustionLevel;
            boolean bl = shouldDecreaseSaturationLevel = player.func_71024_bL().func_75115_e() > 0.0f;
            if (!shouldDecreaseSaturationLevel) {
                this.deltaSaturation = 0.0f;
            }
            EnumDifficulty difficulty = player.field_70170_p.func_175659_aa();
            boolean bl2 = shouldDecreaseFoodLevel = !shouldDecreaseSaturationLevel && difficulty != EnumDifficulty.PEACEFUL;
            if (!shouldDecreaseFoodLevel) {
                this.deltaHunger = 0;
            }
        }
    }

    public static class GetMaxExhaustion
    extends ExhaustionEvent {
        public float maxExhaustionLevel = 4.0f;

        public GetMaxExhaustion(EntityPlayer player) {
            super(player);
        }
    }

    @Event.HasResult
    public static class AllowExhaustion
    extends ExhaustionEvent {
        public AllowExhaustion(EntityPlayer player) {
            super(player);
        }
    }
}

