#version 120

varying vec4 texcoord;
varying vec3 sunlight;
varying vec3 lightVector;
varying vec3 ambient_color;

uniform int worldTime;
uniform float rainStrength;
uniform vec3 sunPosition;
uniform vec3 moonPosition;

	const ivec4 ToD[25] = ivec4[25](ivec4(0,15,25,30), //hour,r,g,b
							ivec4(1,15,25,30),
							ivec4(2,15,25,30),
							ivec4(3,15,25,30),
							ivec4(4,15,25,30),
							ivec4(5,15,25,30),
							ivec4(6,90,45,25),
							ivec4(7,85,45,25),
							ivec4(8,80,45,25),
							ivec4(9,75,45,25),
							ivec4(10,75,35,10),
							ivec4(11,75,35,10),
							ivec4(12,70,35,10),
							ivec4(13,75,35,10),
							ivec4(14,75,35,10),
							ivec4(15,75,45,25),
							ivec4(16,80,45,25),
							ivec4(17,85,45,25),
							ivec4(18,90,45,25),
							ivec4(19,15,25,30),
							ivec4(20,15,25,30),
							ivec4(21,15,25,30),
							ivec4(22,15,25,30),
							ivec4(23,15,25,30),
							ivec4(24,15,25,30));
							
							
	////////////////////ambient color////////////////////
	////////////////////ambient color////////////////////
	////////////////////ambient color////////////////////
	const ivec4 ToD2[25] = ivec4[25](ivec4(0,45,60,90), //hour,r,g,b
							ivec4(1,45,60,90),
							ivec4(2,45,60,90),
							ivec4(3,45,60,90),
							ivec4(4,45,60,90),
							ivec4(5,45,60,90),
							ivec4(6,90,120,230),
							ivec4(7,150,200,250),
							ivec4(8,195,210,250),
							ivec4(9,195,220,270),
							ivec4(10,200,235,280),
							ivec4(11,205,250,290),
							ivec4(12,205,250,300),
							ivec4(13,205,250,290),
							ivec4(14,200,235,280),
							ivec4(15,195,220,270),
							ivec4(16,195,210,250),
							ivec4(17,150,200,250),
							ivec4(18,90,120,230),
							ivec4(19,45,60,90),
							ivec4(20,45,60,90),
							ivec4(21,45,60,90),
							ivec4(22,45,60,90),
							ivec4(23,45,60,90),
							ivec4(24,45,60,90));
							
							
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////

void main() {
	
		if (worldTime < 12700 || worldTime > 23250) {
		lightVector = normalize(sunPosition);
	}
	
	else {
		lightVector = normalize(moonPosition);
	}
	
	gl_Position = ftransform();
	
	texcoord = gl_MultiTexCoord0;
	
	//sunlight color
	float hour = worldTime/1000.0+6.0;
	if (hour > 24.0) hour = hour - 24.0;

							
	ivec4 temp = ToD[int(floor(hour))];
	ivec4 temp2 = ToD[int(floor(hour)) + 1];
	
	sunlight = mix(vec3(temp.yzw),vec3(temp2.yzw),(hour-float(temp.x))/float(temp2.x-temp.x))/255.0f;
	
	
	ivec4 tempa = ToD2[int(floor(hour))];
	ivec4 tempa2 = ToD2[int(floor(hour)) + 1];
	
	ambient_color = mix(vec3(tempa.yzw),vec3(tempa2.yzw),(hour-float(tempa.x))/float(tempa2.x-tempa.x))/255.0f;

	
}
