#version 120

//go to line 96 for changing sunlight/ambient color balance

varying vec4 texcoord;
varying vec3 lightVector;
varying vec3 sunlight_color;
varying vec3 ambient_color;
varying float handItemLight;

uniform vec3 sunPosition;
uniform vec3 moonPosition;
uniform int worldTime;
uniform int heldItemId;
uniform int heldBlockLightValue;
uniform float rainStrength;
uniform float wetness;


	////////////////////sunlight color////////////////////
	////////////////////sunlight color////////////////////
	////////////////////sunlight color////////////////////
	const ivec4 ToD[25] = ivec4[25](ivec4(0,10,15,27), //hour,r,g,b
							ivec4(1,10,15,27),
							ivec4(2,10,15,27),
							ivec4(3,10,15,27),
							ivec4(4,10,15,27),
							ivec4(5,10,15,27),
							ivec4(6,390,150,0),
							ivec4(7,395,150,0),
							ivec4(8,395,150,0),
							ivec4(9,395,150,50),
							ivec4(10,250,150,100),
							ivec4(11,250,155,100),
							ivec4(12,250,155,100),
							ivec4(13,250,155,100),
							ivec4(14,250,155,100),
							ivec4(15,250,150,100),
							ivec4(16,395,150,50),
							ivec4(17,395,155,0),
							ivec4(18,395,150,0),
							ivec4(19,10,15,27),
							ivec4(20,10,15,27),
							ivec4(21,10,15,27),
							ivec4(22,10,15,27),
							ivec4(23,10,15,27),
							ivec4(24,10,15,27)); 

	////////////////////ambient color////////////////////
	////////////////////ambient color////////////////////
	////////////////////ambient color////////////////////
	const ivec4 ToD2[25] = ivec4[25](ivec4(0,45,130.25,240), //hour,r,g,b
							ivec4(1,45,130.25,240),
							ivec4(2,45,130.25,240),
							ivec4(3,45,130.25,240),
							ivec4(4,45,130.25,240),
							ivec4(5,45,130.25,240),
							ivec4(6,160,200,265),
							ivec4(7,160,205,265),
							ivec4(8,160,210,260),
							ivec4(9,165,220,280),
							ivec4(10,190,235,290),
							ivec4(11,205,250,300),
							ivec4(12,220,250,310),
							ivec4(13,205,250,300),
							ivec4(14,190,235,390),
							ivec4(15,165,220,280),
							ivec4(16,150,210,270),
							ivec4(17,140,200,265),
							ivec4(18,120,140,230),
							ivec4(19,35,130.25,240),
							ivec4(20,35,130.25,240),
							ivec4(21,35,130.25,240),
							ivec4(22,35,130.25,240),
							ivec4(23,35,130.25,240),
							ivec4(24,45,130.25,240));

//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
void main() {
	
	gl_Position = ftransform();
	
	texcoord = gl_MultiTexCoord0;

	if (worldTime < 12700 || worldTime > 23250) {
		lightVector = normalize(sunPosition);
	}
	
	else {
		lightVector = normalize(moonPosition);
	}

	handItemLight = 0.0;
	if (heldItemId == 50) {
		// torch
		handItemLight = 0.5;
	}
	
	else if (heldItemId == 76 || heldItemId == 94) {
		// active redstone torch / redstone repeater
		handItemLight = 0.1;
	}
	
	else if (heldItemId == 89) {
		// lightstone
		handItemLight = 1.0;
	}
	
	else if (heldItemId == 10 || heldItemId == 11 || heldItemId == 51) {
		// lava / lava / fire
		handItemLight = 0.5;
	}
	
	else if (heldItemId == 91) {
		// jack-o-lantern
		handItemLight = 0.7;
	}
	
	
	else if (heldItemId == 327) {
		//lave bucket
		handItemLight = 0.4;
	}
	
		else if (heldItemId == 385) {
		//fire charger
		handItemLight = 0.2;
	}
	
	

	

	float hour = worldTime/1000.0+6.0;
	if (hour > 24.0) hour = hour - 24.0;

							
	ivec4 temp = ToD[int(floor(hour))];
	ivec4 temp2 = ToD[int(floor(hour)) + 1];
	
	sunlight_color = mix(vec3(temp.yzw),vec3(temp2.yzw),(hour-float(temp.x))/float(temp2.x-temp.x))/255.0f;
	
	

							
	ivec4 tempa = ToD2[int(floor(hour))];
	ivec4 tempa2 = ToD2[int(floor(hour)) + 1];
	
	ambient_color = mix(vec3(tempa.yzw),vec3(tempa2.yzw),(hour-float(tempa.x))/float(tempa2.x-tempa.x))/255.0f;
	
	vec3 ambient_color_rain = vec3(0.4, 0.4, 0.2); //rain

	ambient_color = sqrt(pow(mix(ambient_color, ambient_color_rain, rainStrength*0.75),vec3(2.0))*2.0*ambient_color); //rain
	
}

