#version 120

varying vec4 texcoord;
varying vec3 sunlight;
varying vec3 lightVector;
varying vec3 ambient_color;

uniform int worldTime;
uniform float rainStrength;
uniform vec3 sunPosition;
uniform vec3 moonPosition;

	const ivec4 ToD[25] = ivec4[25](ivec4(0,15,15,20), //hour,r,g,b 	(godrays)
							ivec4(1,15,15,20),
							ivec4(2,15,15,20),
							ivec4(3,15,15,20),
							ivec4(4,15,15,20),
							ivec4(5,15,15,20),
							ivec4(6,380,100,40),
							ivec4(7,355,195,80),
							ivec4(8,255,200,97),
							ivec4(9,255,200,110),
							ivec4(10,255,200,110),
							ivec4(11,255,200,110),
							ivec4(12,255,200,110),
							ivec4(13,255,200,110),
							ivec4(14,255,200,110),
							ivec4(15,255,195,80),
							ivec4(16,250,150,70),
							ivec4(17,450,110,30),
							ivec4(18,450,110,30),
							ivec4(19,15,15,20),
							ivec4(20,15,15,20),
							ivec4(21,15,15,20),
							ivec4(22,15,15,20),
							ivec4(23,15,15,20),
							ivec4(24,15,15,20)); 
							
							
/*------------AMBIENT COLOR------------*/
/*------------AMBIENT COLOR------------*/
/*------------AMBIENT COLOR------------*/
	const ivec4 ToD2[25] = ivec4[25](ivec4(0,10,20,45), //hour,r,g,b
							ivec4(1,10,20,45),
							ivec4(2,10,20,45),
							ivec4(3,10,20,45),
							ivec4(4,10,20,45),
							ivec4(5,60,120,180),
							ivec4(6,620,200,30),
							ivec4(7,160,205,255),
							ivec4(8,160,210,260),
							ivec4(9,165,220,270),
							ivec4(10,190,235,280),
							ivec4(11,205,250,290),
							ivec4(12,220,250,300),
							ivec4(13,205,250,290),
							ivec4(14,190,235,280),
							ivec4(15,165,220,270),
							ivec4(16,150,210,260),
							ivec4(17,140,200,255),
							ivec4(18,120,140,220),
							ivec4(19,50,55,110),
							ivec4(20,10,20,45),
							ivec4(21,10,20,45),
							ivec4(22,10,20,45),
							ivec4(23,10,20,45),
							ivec4(24,10,20,45));
							
							
/*------------------------MAIN------------------------*/
/*------------------------MAIN------------------------*/
/*------------------------MAIN------------------------*/
/*------------------------MAIN------------------------*/
/*------------------------MAIN------------------------*/
/*------------------------MAIN------------------------*/


void main() {
	
		if (worldTime < 12700 || worldTime > 23250) {
		lightVector = normalize(sunPosition);
	}
	
	else {
		lightVector = normalize(moonPosition);
	}
	
	gl_Position = ftransform();
	
	texcoord = gl_MultiTexCoord0;
	
	//sunlight color
	float hour = worldTime/1000.0+6.0;
	if (hour > 24.0) hour = hour - 24.0;

							
	ivec4 temp = ToD[int(floor(hour))];
	ivec4 temp2 = ToD[int(floor(hour)) + 1];
	
	sunlight = mix(vec3(temp.yzw),vec3(temp2.yzw),(hour-float(temp.x))/float(temp2.x-temp.x))/255.0f;
	
	
		ivec4 tempa = ToD2[int(floor(hour))];
	ivec4 tempa2 = ToD2[int(floor(hour)) + 1];
	
	ambient_color = mix(vec3(tempa.yzw),vec3(tempa2.yzw),(hour-float(tempa.x))/float(tempa2.x-tempa.x))/255.0f;

	
}
