#version 120

varying vec4 texcoord;
varying vec3 lightVector;
varying vec3 sunlight_color;
varying vec3 ambient_color;
varying float handItemLight;

uniform vec3 sunPosition;
uniform vec3 moonPosition;
uniform int worldTime;
uniform int heldItemId;
uniform int heldBlockLightValue;
uniform float rainStrength;
uniform float wetness;


/*------------SUNLIGHT COLOR------------*/
/*------------SUNLIGHT COLOR------------*/
/*------------SUNLIGHT COLOR------------*/
	const ivec4 ToD[25] = ivec4[25](ivec4(0,2,2,2), //hour,r,g,b	(sunlight color)
							ivec4(1,2,2,2),
							ivec4(2,2,2,2),
							ivec4(3,2,2,2),
							ivec4(4,2,2,2),
							ivec4(5,2,2,2),
							ivec4(6,450,110,35),
							ivec4(7,255,230,80),
							ivec4(8,255,225,97),
							ivec4(9,305,210,110),
							ivec4(10,355,215,135),
							ivec4(11,355,215,135),
							ivec4(12,355,215,135),
							ivec4(13,295,215,135),
							ivec4(14,250,210,130),
							ivec4(15,250,200,130),
							ivec4(16,265,170,110),
							ivec4(17,330,150,85),
							ivec4(18,420,110,55),
							ivec4(19,2,2,2),
							ivec4(20,2,2,2),
							ivec4(21,2,2,2),
							ivec4(22,2,2,2),
							ivec4(23,2,2,2),
							ivec4(24,2,2,2));

/*------------AMBIENT COLOR------------*/
/*------------AMBIENT COLOR------------*/
/*------------AMBIENT COLOR------------*/
	const ivec4 ToD2[25] = ivec4[25](ivec4(0,30,40,45), 	//	(Color of shadows)
							ivec4(1,30,40,45),
							ivec4(2,30,40,45),
							ivec4(3,30,40,45),
							ivec4(4,30,40,45),
							ivec4(5,60,120,180),
							ivec4(6,95,105,280),
							ivec4(7,95,105,280),
							ivec4(8,100,105,285),
							ivec4(9,110,120,280),
							ivec4(10,130,135,320),
							ivec4(11,130,135,320),
							ivec4(12,130,135,320),
							ivec4(13,130,135,320),
							ivec4(14,130,135,320),
							ivec4(15,105,120,290),
							ivec4(16,100,105,295),
							ivec4(17,95,105,280),
							ivec4(18,95,105,280),
							ivec4(19,50,55,110),
							ivec4(20,30,40,45),
							ivec4(21,30,40,45),
							ivec4(22,30,40,45),
							ivec4(23,30,40,45),
							ivec4(24,30,40,45));

/*------------------------MAIN------------------------*/
/*------------------------MAIN------------------------*/
/*------------------------MAIN------------------------*/
/*------------------------MAIN------------------------*/
/*------------------------MAIN------------------------*/
void main() {
	
	gl_Position = ftransform();
	
	texcoord = gl_MultiTexCoord0;

	if (worldTime < 12700 || worldTime > 23250) {
		lightVector = normalize(sunPosition);
	}
	
	else {
		lightVector = normalize(moonPosition);
	}

	handItemLight = 0.0;
	if (heldItemId == 50) {
		// torch
		handItemLight = 1.5;
	}
/*		
	else if (heldItemId == 76 || heldItemId == 94) {
		// active redstone torch / redstone repeater
		handItemLight = 0.1;
	}
	
	else if (heldItemId == 89) {
		// lightstone
		handItemLight = 0.6;
	}
	
	else if (heldItemId == 10 || heldItemId == 11 || heldItemId == 51) {
		// lava / lava / fire
		handItemLight = 0.5;
	}
	
	else if (heldItemId == 91) {
		// jack-o-lantern
		handItemLight = 0.6;
	}
	
	
	else if (heldItemId == 327) {
		handItemLight = 0.2;
	}

*/

	float hour = worldTime/1000.0+6.0;
	if (hour > 24.0) hour = hour - 24.0;


	ivec4 temp = ToD[int(floor(hour))];
	ivec4 temp2 = ToD[int(floor(hour)) + 1];
	
	sunlight_color = mix(vec3(temp.yzw),vec3(temp2.yzw),(hour-float(temp.x))/float(temp2.x-temp.x))/255.0f;




	ivec4 tempa = ToD2[int(floor(hour))];
	ivec4 tempa2 = ToD2[int(floor(hour)) + 1];
	
	ambient_color = mix(vec3(tempa.yzw),vec3(tempa2.yzw),(hour-float(tempa.x))/float(tempa2.x-tempa.x))/255.0f;
	
	vec3 ambient_color_rain = vec3(0.2, 0.2, 0.2); //rain

	//ambient_color.g *= 1.2;
	ambient_color = sqrt(pow(mix(ambient_color, ambient_color_rain, rainStrength*0.75),vec3(2.0))*2.0*ambient_color); //rain
	
}
