// Parallax occlusion shader by daxnitro.  This shader requires terrain_nh.png to be included in the current texture pack.

// To enable world curvature, remove the slashes from the next line.

//#define ENABLE_WORLD_CURVATURE

varying vec4 vertColor;
varying vec3 viewVector;

uniform int renderType;

const int RENDER_TYPE_UNKNOWN = 0;

#ifdef ENABLE_WORLD_CURVATURE
	const float WORLD_RADIUS         = 2500.0;
	const float WORLD_RADIUS_SQUARED = 6250000.0;
#endif

void main() {
	
	#ifdef ENABLE_WORLD_CURVATURE
		vec4 position = gl_ModelViewMatrix * gl_Vertex;
		
		if (gl_Color.a != 0.8) {
			// Not a cloud.
			
			float distanceSquared = position.x * position.x + position.z * position.z;
			
			position.y -= WORLD_RADIUS - sqrt(max(1.0 - distanceSquared / WORLD_RADIUS_SQUARED, 0.0)) * WORLD_RADIUS;
		}
		
		gl_Position = gl_ProjectionMatrix * position;
	#else
		gl_Position = ftransform();
	#endif

	gl_TexCoord[0] = gl_MultiTexCoord0;
		
	vertColor = gl_Color;
	
	if (renderType != RENDER_TYPE_UNKNOWN) {
		vec3 normal = normalize(gl_NormalMatrix * gl_Normal);
		vec3 tangent;
		vec3 binormal;
	
		if (gl_Normal.x == 1.0) {
			//  1.0,  0.0,  0.0
			tangent  = normalize(gl_NormalMatrix * vec3( 0.0,  0.0,  1.0));
			binormal = normalize(gl_NormalMatrix * vec3( 0.0,  1.0,  0.0));
		} else if (gl_Normal.x < 0.0) {
			// -1.0,  0.0,  0.0
			tangent  = normalize(gl_NormalMatrix * vec3( 0.0,  0.0, -1.0));
			binormal = normalize(gl_NormalMatrix * vec3( 0.0,  1.0,  0.0));
		} else if (gl_Normal.y == 1.0) {
			//  0.0,  1.0,  0.0
			tangent  = normalize(gl_NormalMatrix * vec3( 1.0,  0.0,  0.0));
			binormal = normalize(gl_NormalMatrix * vec3( 0.0,  0.0,  1.0));
		} else if (gl_Normal.y < 0.0) {
			//  0.0, -1.0,  0.0
			tangent  = normalize(gl_NormalMatrix * vec3(-1.0,  0.0,  0.0));
			binormal = normalize(gl_NormalMatrix * vec3( 0.0,  0.0, -1.0));
		} else if (gl_Normal.z == 1.0) {
			//  0.0,  0.0,  1.0
			tangent  = normalize(gl_NormalMatrix * vec3(-1.0,  0.0,  0.0));
			binormal = normalize(gl_NormalMatrix * vec3( 0.0,  1.0,  0.0));
		} else if (gl_Normal.z < 0.0) {
			//  0.0,  0.0, -1.0
			tangent  = normalize(gl_NormalMatrix * vec3( 1.0,  0.0,  0.0));
			binormal = normalize(gl_NormalMatrix * vec3( 0.0,  1.0,  0.0));
		}
		
		mat3 tbnMatrix = mat3(tangent.x, binormal.x, normal.x,
	                          tangent.y, binormal.y, normal.y,
	                          tangent.z, binormal.z, normal.z);
		
		viewVector = (gl_ModelViewMatrix * gl_Vertex).xyz;
		viewVector = normalize(tbnMatrix * viewVector);
	} else {
		viewVector = vec3(0.0, 0.0, 0.0);
	}
	
	gl_FogFragCoord = gl_Position.z;
}