

uniform sampler2D sampler0;
uniform sampler2D sampler1;

varying vec4 vertColor;
varying vec3 viewVector;

uniform int renderType;

uniform int fogMode;

const int GL_LINEAR = 9729;
const int GL_EXP = 2048;

const int RENDER_TYPE_UNKNOWN = 0;

const float MAX_DISTANCE = 100.0;

const int MAX_POINTS = 50;

void main() {
	
	if (gl_FogFragCoord > MAX_DISTANCE || renderType == RENDER_TYPE_UNKNOWN || viewVector.z >= 0.0) {
		
		gl_FragColor = texture2D(sampler0, gl_TexCoord[0].st) * vertColor;
		
	} else {

		vec3 coord = vec3(gl_TexCoord[0].st, 1.0);
		vec2 minCoord = vec2(gl_TexCoord[0].s - mod(gl_TexCoord[0].s, 0.0625), gl_TexCoord[0].t - mod(gl_TexCoord[0].t, 0.0625));
		vec2 maxCoord = vec2(minCoord.s + 0.0624609375, minCoord.t + 0.0624609375);
	
		// These numbers might need to be tweaked per texture pack.  In particular, the third number is inversely proportional to the range of the height-map.
		vec3 interval = viewVector * vec3(0.0039, 0.0039, 4.5);   // Fine for 16x16 tile size
		//vec3 interval = viewVector * vec3(0.0019, 0.0019, 0.5); // Fine for 32x32 tile size
		//vec3 interval = viewVector * vec3(0.00048828125, 0.00048828125, 0.2); // Fine for 128x128 tile size
	
		for (int loopCount = 0; texture2D(sampler1, coord.st).a < coord.z && loopCount < MAX_POINTS; ++loopCount) {
			coord += interval;
			if (coord.s < minCoord.s) {
				coord.s += 0.0625;
			} else if (coord.s > maxCoord.s) {
				coord.s -= 0.0625;
			}
			if (coord.t < minCoord.t) {
				coord.t += 0.0625;
			} else if (coord.t > maxCoord.t) {
				coord.t -= 0.0625;
			}
		}
	
		gl_FragColor = texture2D(sampler0, coord.st) * vertColor;
	
	}
	
	if (gl_FragColor.a != 0.0) {
		if (fogMode == GL_EXP) {
			gl_FragColor = mix(gl_FragColor, gl_Fog.color, 1.0 - clamp(exp(-gl_Fog.density * gl_FogFragCoord), 0.0, 1.0));
		} else if (fogMode == GL_LINEAR) {
			gl_FragColor = mix(gl_FragColor, gl_Fog.color, clamp((gl_FogFragCoord - gl_Fog.start) * gl_Fog.scale, 0.0, 1.0));
		}
	}
	
}
