#version 120

/*
Chocapic13' shaders, derived from SonicEther v10 rc6
Place two leading Slashes in front of the following '#define' lines in order to disable an option.
*/

//disabling is done by adding "//" to the beginning of a line.

//////////////////////////////ADJUSTABLE VARIABLES
//////////////////////////////ADJUSTABLE VARIABLES
//////////////////////////////ADJUSTABLE VARIABLES

#define VIGNETTE
#define VIGNETTE_STRENGTH 1.2

//#define LENS_EFFECTS
#define LENS_STRENGTH 0.5

//#define BLOOM								//do the "fog blur" in the same time
	//#define B_HQ					
	#define B_LQ			
	#define B_TRESH 0.0				
	#define B_RAD 10.0					//sampling circle size multiplier, don't affect performance
	#define B_INTENSITY 0.7		//basic multiplier

//#define DOF
	//lens properties
const float focal = 0.015;
float aperture = 0.009;	
const float sizemult = 50.0;



/*
Try different setting by replacing the values above by the values here
----------------------------------
"Near to human eye (for gameplay,default)":

const float focal = 0.024;
float aperture = 0.009;	
const float sizemult = 100.0;
----------------------------------
"Tilt shift (cinematics)":

const float focal = 0.3;
float aperture = 0.3;	
const float sizemult = 1.0;
----------------------------------
"Camera (cinematics)":

const float focal = 0.05;
float aperture = focal/7.0;	
const float sizemult = 100.0;
---------------------------------- 
*/
//#define TONEMAP
#define TONEMAP_CURVE 2.0
#define CONTRAST 0.3
#define GAMMA 1.2							//1.0 = default Gamma. Higher values mean darker.
#define CROSSPROCESS
#define BRIGHTMULT 1.0 
#define DARKMULT 0.0	
#define COLOR_BOOST	0.1	
#define HIGHDESATURATE
//////////////////////////////END OF ADJUSTABLE VARIABLES
//////////////////////////////END OF ADJUSTABLE VARIABLES
//////////////////////////////END OF ADJUSTABLE VARIABLES



varying vec4 texcoord;
varying vec3 sunlight;

uniform sampler2D depthtex0;
uniform sampler2D gaux1;
uniform sampler2D gaux2;
uniform sampler2D gaux4;
uniform sampler2D texture;
uniform sampler2D gcolor;
uniform sampler2D gdepth;
uniform sampler2D composite;
uniform sampler2D gnormal;
uniform vec3 cameraPosition;
uniform vec3 previousCameraPosition;
uniform vec3 sunPosition;
uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferPreviousProjection;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferPreviousModelView;
uniform ivec2 eyeBrightness;
uniform int isEyeInWater;
uniform int worldTime;
uniform float aspectRatio;
uniform float near;
uniform float far;
uniform float viewWidth;
uniform float viewHeight;
uniform float rainStrength;
uniform float wetness;
uniform float frameTimeCounter;
vec3 sunPos = sunPosition;
uniform int fogMode;
float pw = 1.0/ viewWidth;
float ph = 1.0/ viewHeight;
float timefract = worldTime;

//Raining
float rainx = clamp(rainStrength, 0.0f, 1.0f)/1.0f;
float wetx  = clamp(wetness, 0.0f, 1.0f);

//Calculate Time of Day
float TimeSunrise  = ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0) + (1.0 - (clamp(timefract, 0.0, 4000.0)/4000.0));
float TimeNoon     = ((clamp(timefract, 0.0, 4000.0)) / 4000.0) - ((clamp(timefract, 8000.0, 12000.0) - 8000.0) / 4000.0);
float TimeSunset   = ((clamp(timefract, 8000.0, 12000.0) - 8000.0) / 4000.0) - ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0);
float TimeMidnight = ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0) - ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0);

// Standard depth function.
float getDepth(float depth) {
    return 2.0 * near * far / (far + near - (2.0 * depth - 1.0) * (far - near));
}

float ld(float depth) {
    return (2.0 * near) / (far + near - depth * (far - near));
}

float luma(vec3 color) {
	return dot(color,vec3(0.299, 0.587, 0.114));
}

#ifdef BLOOM
	#ifdef B_LQ
		const vec2 offsets[25] = vec2[25](vec2(-0.4894566f,-0.3586783f),
									vec2(-0.1717194f,0.6272162f),
									vec2(-0.4709477f,-0.01774091f),
									vec2(-0.9910634f,0.03831699f),
									vec2(-0.2101292f,0.2034733f),
									vec2(-0.7889516f,-0.5671548f),
									vec2(-0.1037751f,-0.1583221f),
									vec2(-0.5728408f,0.3416965f),
									vec2(-0.1863332f,0.5697952f),
									vec2(0.3561834f,0.007138769f),
									vec2(0.2868255f,-0.5463203f),
									vec2(-0.4640967f,-0.8804076f),
									vec2(0.1969438f,0.6236954f),
									vec2(0.6999109f,0.6357007f),
									vec2(-0.3462536f,0.8966291f),
									vec2(0.172607f,0.2832828f),
									vec2(0.4149241f,0.8816f),
									vec2(0.136898f,-0.9716249f),
									vec2(-0.6272043f,0.6721309f),
									vec2(-0.8974028f,0.4271871f),
									vec2(0.5551881f,0.324069f),
									vec2(0.9487136f,0.2605085f),
									vec2(0.7140148f,-0.312601f),
									vec2(0.0440252f,0.9363738f),
									vec2(0.620311f,-0.6673451f)
									);
	#endif
	
	#ifdef B_HQ
		const vec2 offsets[60] = vec2[60](vec2( 0.0000, 0.2500 ),
									vec2( -0.2165, 0.1250 ),
									vec2( -0.2165, -0.1250 ),
									vec2( -0.0000, -0.2500 ),
									vec2( 0.2165, -0.1250 ),
									vec2( 0.2165, 0.1250 ),
									vec2( 0.0000, 0.5000 ),
									vec2( -0.2500, 0.4330 ),
									vec2( -0.4330, 0.2500 ),
									vec2( -0.5000, 0.0000 ),
									vec2( -0.4330, -0.2500 ),
									vec2( -0.2500, -0.4330 ),
									vec2( -0.0000, -0.5000 ),
									vec2( 0.2500, -0.4330 ),
									vec2( 0.4330, -0.2500 ),
									vec2( 0.5000, -0.0000 ),
									vec2( 0.4330, 0.2500 ),
									vec2( 0.2500, 0.4330 ),
									vec2( 0.0000, 0.7500 ),
									vec2( -0.2565, 0.7048 ),
									vec2( -0.4821, 0.5745 ),
									vec2( -0.6495, 0.3750 ),
									vec2( -0.7386, 0.1302 ),
									vec2( -0.7386, -0.1302 ),
									vec2( -0.6495, -0.3750 ),
									vec2( -0.4821, -0.5745 ),
									vec2( -0.2565, -0.7048 ),
									vec2( -0.0000, -0.7500 ),
									vec2( 0.2565, -0.7048 ),
									vec2( 0.4821, -0.5745 ),
									vec2( 0.6495, -0.3750 ),
									vec2( 0.7386, -0.1302 ),
									vec2( 0.7386, 0.1302 ),
									vec2( 0.6495, 0.3750 ),
									vec2( 0.4821, 0.5745 ),
									vec2( 0.2565, 0.7048 ),
									vec2( 0.0000, 1.0000 ),
									vec2( -0.2588, 0.9659 ),
									vec2( -0.5000, 0.8660 ),
									vec2( -0.7071, 0.7071 ),
									vec2( -0.8660, 0.5000 ),
									vec2( -0.9659, 0.2588 ),
									vec2( -1.0000, 0.0000 ),
									vec2( -0.9659, -0.2588 ),
									vec2( -0.8660, -0.5000 ),
									vec2( -0.7071, -0.7071 ),
									vec2( -0.5000, -0.8660 ),
									vec2( -0.2588, -0.9659 ),
									vec2( -0.0000, -1.0000 ),
									vec2( 0.2588, -0.9659 ),
									vec2( 0.5000, -0.8660 ),
									vec2( 0.7071, -0.7071 ),
									vec2( 0.8660, -0.5000 ),
									vec2( 0.9659, -0.2588 ),
									vec2( 1.0000, -0.0000 ),
									vec2( 0.9659, 0.2588 ),
									vec2( 0.8660, 0.5000 ),
									vec2( 0.7071, 0.7071 ),
									vec2( 0.5000, 0.8660 ),
									vec2( 0.2588, 0.9659 ));
	#endif
	
#endif


#ifdef DOF

//hexagon pattern
const vec2 hex_offsets[60] = vec2[60] (	vec2(  0.2165,  0.1250 ),
									vec2(  0.0000,  0.2500 ),
									vec2( -0.2165,  0.1250 ),
									vec2( -0.2165, -0.1250 ),
									vec2( -0.0000, -0.2500 ),
									vec2(  0.2165, -0.1250 ),
									vec2(  0.4330,  0.2500 ),
									vec2(  0.0000,  0.5000 ),
									vec2( -0.4330,  0.2500 ),
									vec2( -0.4330, -0.2500 ),
									vec2( -0.0000, -0.5000 ),
									vec2(  0.4330, -0.2500 ),
									vec2(  0.6495,  0.3750 ),
									vec2(  0.0000,  0.7500 ),
									vec2( -0.6495,  0.3750 ),
									vec2( -0.6495, -0.3750 ),
									vec2( -0.0000, -0.7500 ),
									vec2(  0.6495, -0.3750 ),
									vec2(  0.8660,  0.5000 ),
									vec2(  0.0000,  1.0000 ),
									vec2( -0.8660,  0.5000 ),
									vec2( -0.8660, -0.5000 ),
									vec2( -0.0000, -1.0000 ),
									vec2(  0.8660, -0.5000 ),
									vec2(  0.2163,  0.3754 ),
									vec2( -0.2170,  0.3750 ),
									vec2( -0.4333, -0.0004 ),
									vec2( -0.2163, -0.3754 ),
									vec2(  0.2170, -0.3750 ),
									vec2(  0.4333,  0.0004 ),
									vec2(  0.4328,  0.5004 ),
									vec2( -0.2170,  0.6250 ),
									vec2( -0.6498,  0.1246 ),
									vec2( -0.4328, -0.5004 ),
									vec2(  0.2170, -0.6250 ),
									vec2(  0.6498, -0.1246 ),
									vec2(  0.6493,  0.6254 ),
									vec2( -0.2170,  0.8750 ),
									vec2( -0.8663,  0.2496 ),
									vec2( -0.6493, -0.6254 ),
									vec2(  0.2170, -0.8750 ),
									vec2(  0.8663, -0.2496 ),
									vec2(  0.2160,  0.6259 ),
									vec2( -0.4340,  0.5000 ),
									vec2( -0.6500, -0.1259 ),
									vec2( -0.2160, -0.6259 ),
									vec2(  0.4340, -0.5000 ),
									vec2(  0.6500,  0.1259 ),
									vec2(  0.4325,  0.7509 ),
									vec2( -0.4340,  0.7500 ),
									vec2( -0.8665, -0.0009 ),
									vec2( -0.4325, -0.7509 ),
									vec2(  0.4340, -0.7500 ),
									vec2(  0.8665,  0.0009 ),
									vec2(  0.2158,  0.8763 ),
									vec2( -0.6510,  0.6250 ),
									vec2( -0.8668, -0.2513 ),
									vec2( -0.2158, -0.8763 ),
									vec2(  0.6510, -0.6250 ),
									vec2(  0.8668,  0.2513 ));

#endif

//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////

float distratio(vec2 pos, vec2 pos2, float ratio) {
float xvect = pos.x*ratio-pos2.x*ratio;
float yvect = pos.y-pos2.y;
return sqrt(xvect*xvect + yvect*yvect);
}

//circle position pattern (vec2 coordinate, size)
const vec3 pattern[16] = vec3[16](	vec3(0.1,0.1,0.02),
								vec3(-0.12,0.07,0.02),
								vec3(-0.11,-0.13,0.02),
								vec3(0.1,-0.1,0.02),
								
								vec3(0.07,0.15,0.02),
								vec3(-0.08,0.17,0.02),
								vec3(-0.14,-0.07,0.02),
								vec3(0.15,-0.19,0.02),
								
								vec3(0.012,0.15,0.02),
								vec3(-0.08,0.17,0.02),
								vec3(-0.14,-0.07,0.02),
								vec3(0.02,-0.17,0.021),
								
								vec3(0.10,0.05,0.02),
								vec3(-0.13,0.09,0.02),
								vec3(-0.05,-0.1,0.02),
								vec3(0.1,0.01,0.02)
								);
								
float gen_circular_lens(vec2 center, float size) {
return 1.0-pow(min(distratio(texcoord.xy,center,aspectRatio),size)/size,3.0);
}

vec2 noisepattern(vec2 pos) {
return vec2(abs(fract(sin(dot(pos ,vec2(18.9898f,28.633f))) * 4378.5453f)),abs(fract(sin(dot(pos.yx ,vec2(18.9898f,28.633f))) * 4378.5453f)));
} 
void main() {
	vec2 fake_refract = vec2(sin(worldTime/15.0 + texcoord.x*100.0 + texcoord.y*50.0),cos(worldTime/15.0 + texcoord.y*100.0 + texcoord.x*50.0)) * isEyeInWater;
	vec3 color = texture2D(gaux2, texcoord.st + fake_refract * 0.005).rgb;
	
/*
#ifdef DOF
	float focal = ld(texture2D(depthtex0,vec2(0.5)).x);
		#ifdef DISTANT_BLUR
	pcoc = min(fog*pw*20.0,pw*20.0);
	#endif
	float ddiff;
	float mult = 1.0;
	vec3 bcolor = vec3(0.0);
	vec2 samplecoord;
	bcolor = color.rgb;
	for (int i = -3; i < 4; i++) {
		for (int j = -3; j < 4; j++) {
			samplecoord = vec2(pw*i*2.0f,pw*cos(j/3.0f)*6.0f);
			ddiff = ld(texture2D(depthtex0, texcoord.xy + samplecoord).x);
			if (ddiff - ld(depth) < 0.0) {
				ddiff -= -focal;
				bcolor += texture2D(gaux2,texcoord.xy + samplecoord).rgb*ddiff;
				mult += ddiff;
			}
		}
		#ifdef HEXAGONAL_BOKEH
	
		for ( int i = 0; i < 60; i++) {
			bcolor += pow(texture2D(gaux2, newTC.xy + hex_offsets[i]*pcoc*vec2(1.0,aspectRatio)).rgb,vec3(2.2));
			
		}
		color.rgb = bcolor/61.0*MAX_COLOR_RANGE;
	#else

		for ( int i = 0; i < 60; i++) {
		bcolor += pow(texture2D(gaux2, newTC.xy + offsets[i]*pcoc*vec2(1.0,aspectRatio)).rgb,vec3(2.2));
		}
color.rgb = bcolor/61.0*MAX_COLOR_RANGE;
	#endif
	}
	color.rgb = bcolor/mult;
	
#endif
*/


#ifdef DOF
	
	//Calculate pixel Circle of Confusion that will be used for bokeh depth of field
	float z = ld(texture2D(depthtex0, texcoord.st).r)*far;
	float focus = ld(texture2D(depthtex0, vec2(0.5)).r)*far;
	float pcoc = min(abs(aperture * (focal * (z - focus)) / (z * (focus - focal)))*sizemult,pw*10.0);		
	
	vec4 sample = vec4(0.0);
	vec3 bcolor = vec3(0.0);
	float nb = 0.0;
	vec2 bcoord = vec2(0.0);

	for ( int i = 0; i < 60; i++) {
		sample = texture2D(gaux2, texcoord.xy + hex_offsets[i]*pcoc*vec2(1.0,aspectRatio));
		bcolor += sample.rgb;
	}
	
	color.rgb = bcolor/60.0;
	
#endif
	
	float plum = luma(color.rgb);

#ifdef BLOOM
const int GL_LINEAR = 9729;
const int GL_EXP = 2048;
	//color.rgb = color.rgb*(1.0+(luma(color.rgb)-texture2D(gaux2,vec2(1.0)).a));
	vec3 blur = vec3(0.0);
	float depth_diff = clamp(pow(ld(texture2D(depthtex0, texcoord.st).r)*4.0,0.8),0.0,1.0)+0.1;
	float fog = 0.0;
	fog = 1.0-clamp(exp(-ld(texture2D(depthtex0, texcoord.st).r)),0.0,1.0);
	#ifdef B_LQ
			float scale = length(vec2(pw,ph));
			vec3 csample = vec3(0.0);
				for (int i=0; i < 25; i++) {
				vec2 coords = offsets[i];
				vec3 sample = texture2D(gaux2,texcoord.xy + coords*B_RAD*scale).rgb;
				csample += max(texture2D(gaux2,texcoord.xy + coords*B_RAD*scale).rgb-plum*0.75-B_TRESH,0.0) * (length(coords)+0.6)/2.0;
				blur += sample;
			}
			
		
		//fog blurring with the distance
		color.rgb = mix(color,blur/25.0,depth_diff*isEyeInWater*0.4+fog*(1.0-isEyeInWater)*rainStrength);
		color += csample/25.0*B_INTENSITY;
	#endif

	#ifdef B_HQ
			float scale = length(vec2(pw,ph));
			vec3 csample = vec3(0.0);
				for (int i=0; i < 60; i++) {
				vec2 coords = offsets[i];
				vec3 sample = texture2D(gaux2,texcoord.xy + coords*B_RAD*scale).rgb;
				csample += max(texture2D(gaux2,texcoord.xy + coords*B_RAD*scale).rgb-plum*0.75-B_TRESH,0.0) * (length(coords)+0.6)/2.0;
				blur += sample;
			}
			
		
		//fog blurring with the distance
		color.rgb = mix(color,blur/60.0,depth_diff*isEyeInWater*0.4+fog*(1.0-isEyeInWater)*rainStrength);
		color += csample/60.0*B_INTENSITY;
	#endif
	
#endif


color.rgb += texture2D(gaux4,texcoord.xy).rgb*sqrt(texture2D(gaux4,texcoord.xy).a);

	vec4 tpos = vec4(sunPosition,1.0)*gbufferProjection;
		tpos = vec4(tpos.xyz/tpos.w,1.0);
	vec2 lightPos = tpos.xy/tpos.z;
		lightPos = (lightPos + 1.0f)/2.0f;
		
#ifdef LENS_EFFECTS
float xdist = abs(lightPos.x-texcoord.x);
float ydist = abs(lightPos.y-texcoord.y);
float xydist = distance(lightPos.xy,texcoord.xy);
float xydistratio = distratio(lightPos.xy,texcoord.xy,aspectRatio);

float distof = min(min(1.0-lightPos.x,lightPos.x),min(1.0-lightPos.y,lightPos.y));
float fading = clamp(1.0-step(distof,0.1)+pow(distof*10.0,5.0),0.0,1.0);

float time = float(worldTime);
float transition_fading = 1.0-(clamp((time-12000.0)/300.0,0.0,1.0)-clamp((time-13000.0)/300.0,0.0,1.0) + clamp((time-22800.0)/200.0,0.0,1.0)-clamp((time-23400.0)/200.0,0.0,1.0));

float sunvisibility = min(texture2D(gaux2,vec2(0.0)).a*2.5,1.0) * (1.0-rainStrength*0.9) * fading * transition_fading;


//float anamorphic_lens = clamp( 0.75-(pow(ydist,0.1)) - pow(xdist*2.0,2.0),0.0,1.0)*5.0;


float centerdist = distance(lightPos.xy,vec2(0.5))/1.412;
float sizemult = 1.0 + centerdist;
float noise = fract(sin(dot(texcoord.st ,vec2(18.9898f,28.633f))) * 4378.5453f)*0.1 + 0.9;
							
float circles_lens = 0.0;


if (sunvisibility > 0.05) {
/*
if (xydist < 0.35) {
vec2 sun_to_center = lightPos-vec2(0.5);
float dir = abs(sin(length(sun_to_center)))*0.25+0.75;

for (int i = 0; i < 8; i++) {
vec3 carac = pattern[i]*1.25;

carac.z *= 1.0/1.25;
carac.x /= aspectRatio;
carac *= (1.0 + dir)/2.0;

vec2 coord = carac.xy * sizemult+ lightPos.xy;
float strength = sin(length(coord-vec2(0.5))*40.0)*0.5+0.5;
circles_lens += gen_circular_lens(coord,carac.z*0.75)*strength;

carac = pattern[i];
carac.x /= aspectRatio;
carac.yx *= (2.0 - dir)/2.5;

coord = -carac.yx * sizemult + lightPos.xy;
strength = sin(length(coord-vec2(0.5))*40.0)*0.5+0.5;
circles_lens += gen_circular_lens(coord,carac.z*0.66)*strength;
}
color += sunlight*vec3(circles_lens) * sunvisibility * noise * 0.25 ;
}

*/

}


/*
float chroma_circle = pow(xydistratio/1.412,0.5)*0.5;

vec3 circle_color = clamp(sin(xydistratio*5.5+4.7)*vec3(1.0,0.5,0.1)*chroma_circle,0.0,1.0);

color+= sunlight*vec3(circle_color)*LENS_STRENGTH*sunvisibility;
*/

vec3 sP = sunPosition;

			vec2 lPos = lightPos;

			if (fading > 0.01 && TimeMidnight < 1.0) {

			
			float sunmask = 0.0f;
			float sunstep = -4.5f;
			float masksize = 0.004f;
					
/*
					for (int a = 0; a < 16; a++) {
							sunmask += 1.0f - texture2D(gaux3, lPos + offsets[a]*4.0).a;
						}
						sunmask /= 16.0;
*/
sunmask = texture2D(gaux2,vec2(0.0)).a;
					sunmask *= LENS_STRENGTH * (2.0f - TimeMidnight)*fading;
					sunmask *= 1.0 - rainx;
			if (sunmask > 0.02) {
			
				const float flaremultR = 2.0f;
				const float flaremultG = 2.0f;
				const float flaremultB = 2.0f;
			
				float flarescale = 1.0f;
				const float flarescaleconst = 0.75f;	
					
	//--//far rings around the sun//--//	
					
	//far red ring
			  vec2 flare4ARscale = vec2(1.0f*flarescale, 1.0f*flarescale);
			  float flare4ARpow = 0.3f;
			  float flare4ARfill = 10.0f;
			  float flare4ARoffset = -2.0f;
			vec2 flare4ARpos = vec2(  ((1.0 - lPos.x)*(flare4ARoffset + 1.0) - (flare4ARoffset*0.5))  *aspectRatio*flare4ARscale.x,  ((1.0 - lPos.y)*(flare4ARoffset + 1.0) - (flare4ARoffset*0.5))  *flare4ARscale.y);
			
			
			float flare4AR = distance(flare4ARpos, vec2(texcoord.s*aspectRatio*flare4ARscale.x, texcoord.t*flare4ARscale.y));
				  flare4AR = 0.5 - flare4AR;
				  flare4AR = clamp(flare4AR*flare4ARfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare4AR = pow(flare4AR, 1.6f);
				  flare4AR = sin(flare4AR*3.1415);
				  flare4AR *= sunmask;

				  
				  flare4AR *= flare4ARpow;
				  
				  	color.r += flare4AR*0.4f*flaremultR;
					color.g += flare4AR*0.0f*flaremultG;
					color.b += flare4AR*0.0f*flaremultB;

	//far green ring

			  vec2 flare8ARscale = vec2(0.94f*flarescale, 0.94f*flarescale);
			  float flare8ARpow = 0.3f;
			  float flare8ARfill = 10.0f;
			  float flare8ARoffset = -2.0f;
			vec2 flare8ARpos = vec2(  ((1.0 - lPos.x)*(flare8ARoffset + 1.0) - (flare8ARoffset*0.5))  *aspectRatio*flare8ARscale.x,  ((1.0 - lPos.y)*(flare8ARoffset + 1.0) - (flare8ARoffset*0.5))  *flare8ARscale.y);
			
			
			float flare8AR = distance(flare8ARpos, vec2(texcoord.s*aspectRatio*flare8ARscale.x, texcoord.t*flare8ARscale.y));
				  flare8AR = 0.5 - flare8AR;
				  flare8AR = clamp(flare8AR*flare8ARfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare8AR = pow(flare8AR, 1.9f);
				  flare8AR = sin(flare8AR*3.1415);
				  flare8AR *= sunmask;

				  
				  flare8AR *= flare8ARpow;
				  
				  	color.r += flare8AR*0.0f*flaremultR;
					color.g += flare8AR*0.4f*flaremultG;
					color.b += flare8AR*0.0f*flaremultB;	

	//far blue ring

			  vec2 flare9ARscale = vec2(0.86f*flarescale, 0.86*flarescale);
			  float flare9ARpow = 0.3f;
			  float flare9ARfill = 10.0f;
			  float flare9ARoffset = -2.0f;
			vec2 flare9ARpos = vec2(  ((1.0 - lPos.x)*(flare9ARoffset + 1.0) - (flare9ARoffset*0.5))  *aspectRatio*flare9ARscale.x,  ((1.0 - lPos.y)*(flare9ARoffset + 1.0) - (flare9ARoffset*0.5))  *flare9ARscale.y);
			
			
			float flare9AR = distance(flare9ARpos, vec2(texcoord.s*aspectRatio*flare9ARscale.x, texcoord.t*flare9ARscale.y));
				  flare9AR = 0.5 - flare9AR;
				  flare9AR = clamp(flare9AR*flare9ARfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare9AR = pow(flare9AR, 1.9f);
				  flare9AR = sin(flare9AR*3.1415);
				  flare9AR *= sunmask;

				  
				  flare9AR *= flare9ARpow;
				  
				  	color.r += flare9AR*0.0f*flaremultR;
					color.g += flare9AR*0.0f*flaremultG;
					color.b += flare9AR*0.4*flaremultB;

	//-//far lens flares//-//
					
	//far small flare 3AF
			  vec2 flare3AFscale = vec2(10.5f*flarescale, 10.5f*flarescale);
			  float flare3AFpow = 1.0f;
			  float flare3AFfill = 1.0f;
			  float flare3AFoffset = -1.6231f;
			vec2 flare3AFpos = vec2(  ((1.0 - lPos.x)*(flare3AFoffset + 1.0) - (flare3AFoffset*0.5))  *aspectRatio*flare3AFscale.x,  ((1.0 - lPos.y)*(flare3AFoffset + 1.0) - (flare3AFoffset*0.5))  *flare3AFscale.y);
			
			
			float flare3AF = distance(flare3AFpos, vec2(texcoord.s*aspectRatio*flare3AFscale.x, texcoord.t*flare3AFscale.y));
				  flare3AF = 0.5 - flare3AF;
				  flare3AF = clamp(flare3AF*flare3AFfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare3AF = sin(flare3AF*1.57075);
				  flare3AF *= sunmask;
				  flare3AF = pow(flare3AF, 1.1f);
				  
				  flare3AF *= flare3AFpow;
				  
				  	color.r += flare3AF*0.5f*flaremultR;
					color.g += flare3AF*0.25f*flaremultG;
					color.b += flare3AF*0.0f*flaremultB;	
					
	//far small flare 2AF
			  vec2 flare2AFscale = vec2(5.5f*flarescale, 5.5f*flarescale);
			  float flare2AFpow = 0.5f;
			  float flare2AFfill = 1.0f;
			  float flare2AFoffset = -1.3231f;
			vec2 flare2AFpos = vec2(  ((1.0 - lPos.x)*(flare2AFoffset + 1.0) - (flare2AFoffset*0.5))  *aspectRatio*flare2AFscale.x,  ((1.0 - lPos.y)*(flare2AFoffset + 1.0) - (flare2AFoffset*0.5))  *flare2AFscale.y);
			
			
			float flare2AF = distance(flare2AFpos, vec2(texcoord.s*aspectRatio*flare2AFscale.x, texcoord.t*flare2AFscale.y));
				  flare2AF = 0.5 - flare2AF;
				  flare2AF = clamp(flare2AF*flare2AFfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare2AF = sin(flare2AF*1.57075);
				  flare2AF *= sunmask;
				  flare2AF = pow(flare2AF, 1.1f);
				  
				  flare2AF *= flare2AFpow;
				  
				  	color.r += flare2AF*0.5f*flaremultR;
					color.g += flare2AF*0.25f*flaremultG;
					color.b += flare2AF*0.0f*flaremultB;						

	//far small flare 1AF
			  vec2 flare1AFscale = vec2(9.5f*flarescale, 9.5f*flarescale);
			  float flare1AFpow = 1.0f;
			  float flare1AFfill = 0.5f;
			  float flare1AFoffset = -1.1231f;
			vec2 flare1AFpos = vec2(  ((1.0 - lPos.x)*(flare1AFoffset + 1.0) - (flare1AFoffset*0.5))  *aspectRatio*flare1AFscale.x,  ((1.0 - lPos.y)*(flare1AFoffset + 1.0) - (flare1AFoffset*0.5))  *flare1AFscale.y);
			
			
			float flare1AF = distance(flare1AFpos, vec2(texcoord.s*aspectRatio*flare1AFscale.x, texcoord.t*flare1AFscale.y));
				  flare1AF = 0.5 - flare1AF;
				  flare1AF = clamp(flare1AF*flare1AFfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare1AF = sin(flare1AF*1.57075);
				  flare1AF *= sunmask;
				  flare1AF = pow(flare1AF, 1.1f);
				  
				  flare1AF *= flare1AFpow;
				  
				  	color.r += flare1AF*0.0f*flaremultR;
					color.g += flare1AF*0.25f*flaremultG;
					color.b += flare1AF*0.05f*flaremultB;		

	//-//middle lens flares//-//		
								
	//middle flare
			  vec2 flare1scale = vec2(11.0f*flarescale, 11.0f*flarescale);
			  float flare1pow = 1.0f;
			  float flare1fill = 1.0f;
			  float flare1offset = -1.0f;
			vec2 flare1pos = vec2(  ((1.0 - lPos.x)*(flare1offset + 1.0) - (flare1offset*0.5))  *aspectRatio*flare1scale.x,  ((1.0 - lPos.y)*(flare1offset + 1.0) - (flare1offset*0.5))  *flare1scale.y);
			
			
			float flare1 = distance(flare1pos, vec2(texcoord.s*aspectRatio*flare1scale.x, texcoord.t*flare1scale.y));
				  flare1 = 0.5 - flare1;
				  flare1 = clamp(flare1*flare1fill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare1 = sin(flare1*1.57075);
				  flare1 *= sunmask;
				  flare1 = pow(flare1, 1.1f);
				  
				  flare1 *= flare1pow;
				  
				  	color.r += flare1*0.05f*flaremultR;
					color.g += flare1*0.1f*flaremultG;
					color.b += flare1*0.25f*flaremultB;		
					
	//-//close lens flares//-//

	//close small flare 1A
			  vec2 flare1Ascale = vec2(12.5f*flarescale, 12.5f*flarescale);
			  float flare1Apow = 1.0f;
			  float flare1Afill = 1.0f;
			  float flare1Aoffset = -0.7231f;
			vec2 flare1Apos = vec2(  ((1.0 - lPos.x)*(flare1Aoffset + 1.0) - (flare1Aoffset*0.5))  *aspectRatio*flare1Ascale.x,  ((1.0 - lPos.y)*(flare1Aoffset + 1.0) - (flare1Aoffset*0.5))  *flare1Ascale.y);
			
			
			float flare1A = distance(flare1Apos, vec2(texcoord.s*aspectRatio*flare1Ascale.x, texcoord.t*flare1Ascale.y));
				  flare1A = 0.5 - flare1A;
				  flare1A = clamp(flare1A*flare1Afill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare1A = sin(flare1A*1.57075);
				  flare1A *= sunmask;
				  flare1A = pow(flare1A, 1.1f);
				  
				  flare1A *= flare1Apow;
				  
				  	color.r += flare1A*0.2f*flaremultR;
					color.g += flare1A*0.0f*flaremultG;
					color.b += flare1A*0.2f*flaremultB;	
					
	//close small flare 2A
			  vec2 flare2Ascale = vec2(14.5f*flarescale, 14.5f*flarescale);
			  float flare2Apow = 1.0f;
			  float flare2Afill = 0.5f;
			  float flare2Aoffset = -0.4231f;
			vec2 flare2Apos = vec2(  ((1.0 - lPos.x)*(flare2Aoffset + 1.0) - (flare2Aoffset*0.5))  *aspectRatio*flare2Ascale.x,  ((1.0 - lPos.y)*(flare2Aoffset + 1.0) - (flare2Aoffset*0.5))  *flare2Ascale.y);
			
			
			float flare2A = distance(flare2Apos, vec2(texcoord.s*aspectRatio*flare2Ascale.x, texcoord.t*flare2Ascale.y));
				  flare2A = 0.5 - flare2A;
				  flare2A = clamp(flare2A*flare2Afill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare2A = sin(flare2A*1.57075);
				  flare2A *= sunmask;
				  flare2A = pow(flare2A, 1.1f);
				  
				  flare2A *= flare2Apow;
				  
				  	color.r += flare2A*0.5f*flaremultR;
					color.g += flare2A*0.0f*flaremultG;
					color.b += flare2A*0.5f*flaremultB;	
					
	//close small flare 3A
			  vec2 flare3Ascale = vec2(16.5f*flarescale, 16.5f*flarescale);
			  float flare3Apow = 1.0f;
			  float flare3Afill = 1.0f;
			  float flare3Aoffset = -0.2231f;
			vec2 flare3Apos = vec2(  ((1.0 - lPos.x)*(flare3Aoffset + 1.0) - (flare3Aoffset*0.5))  *aspectRatio*flare3Ascale.x,  ((1.0 - lPos.y)*(flare3Aoffset + 1.0) - (flare3Aoffset*0.5))  *flare3Ascale.y);
			
			
			float flare3A = distance(flare3Apos, vec2(texcoord.s*aspectRatio*flare3Ascale.x, texcoord.t*flare3Ascale.y));
				  flare3A = 0.5 - flare3A;
				  flare3A = clamp(flare3A*flare3Afill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare3A = sin(flare3A*1.57075);
				  flare3A *= sunmask;
				  flare3A = pow(flare3A, 1.1f);
				  
				  flare3A *= flare3Apow;
				  
				  	color.r += flare3A*0.35f*flaremultR;
					color.g += flare3A*0.2f*flaremultG;
					color.b += flare3A*0.1f*flaremultB;	
					
	//close small flare 4A
			  vec2 flare4Ascale = vec2(2.5f*flarescale, 2.5f*flarescale);
			  float flare4Apow = 4.0f;
			  float flare4Afill = 0.5f;
			  float flare4Aoffset = -0.0231f;
			vec2 flare4Apos = vec2(  ((1.0 - lPos.x)*(flare4Aoffset + 1.0) - (flare4Aoffset*0.5))  *aspectRatio*flare4Ascale.x,  ((1.0 - lPos.y)*(flare4Aoffset + 1.0) - (flare4Aoffset*0.5))  *flare4Ascale.y);
			
			
			float flare4A = distance(flare4Apos, vec2(texcoord.s*aspectRatio*flare4Ascale.x, texcoord.t*flare4Ascale.y));
				  flare4A = 0.5 - flare4A;
				  flare4A = clamp(flare4A*flare4Afill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare4A = sin(flare4A*1.57075);
				  flare4A *= sunmask;
				  flare4A = pow(flare4A, 1.1f);
				  
				  flare4A *= flare4Apow;
				  
				  	color.r += flare4A*0.25f*flaremultR;
					color.g += flare4A*0.0f*flaremultG;
					color.b += flare4A*0.1f*flaremultB;	
					
	//close smaller flare in small flare 4A
			  vec2 flare4ASscale = vec2(20.5f*flarescale, 20.5f*flarescale);
			  float flare4ASpow = 1.0f;
			  float flare4ASfill = 1.0f;
			  float flare4ASoffset = -0.015f;
			vec2 flare4ASpos = vec2(  ((1.0 - lPos.x)*(flare4ASoffset + 1.0) - (flare4ASoffset*0.5))  *aspectRatio*flare4ASscale.x,  ((1.0 - lPos.y)*(flare4ASoffset + 1.0) - (flare4ASoffset*0.5))  *flare4ASscale.y);
			
			
			float flare4AS = distance(flare4ASpos, vec2(texcoord.s*aspectRatio*flare4ASscale.x, texcoord.t*flare4ASscale.y));
				  flare4AS = 0.5 - flare4AS;
				  flare4AS = clamp(flare4AS*flare4ASfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare4AS = sin(flare4AS*1.57075);
				  flare4AS *= sunmask;
				  flare4AS = pow(flare4AS, 1.1f);
				  
				  flare4AS *= flare4ASpow;
				  
				  	color.r += flare4AS*0.25f*flaremultR;
					color.g += flare4AS*0.375f*flaremultG;
					color.b += flare4AS*0.25f*flaremultB;	

	//-//far rings around the sun//-//				
					
	//close red ring

			  vec2 flare5ARscale = vec2(0.4f*flarescale, 0.4f*flarescale);
			  float flare5ARpow = 1.0f;
			  float flare5ARfill = 15.0f;
			  float flare5ARoffset = 2.6f;
			vec2 flare5ARpos = vec2(  ((1.0 - lPos.x)*(flare5ARoffset + 1.0) - (flare5ARoffset*0.5))  *aspectRatio*flare5ARscale.x,  ((1.0 - lPos.y)*(flare5ARoffset + 1.0) - (flare5ARoffset*0.5))  *flare5ARscale.y);
			
			
			float flare5AR = distance(flare5ARpos, vec2(texcoord.s*aspectRatio*flare5ARscale.x, texcoord.t*flare5ARscale.y));
				  flare5AR = 0.5 - flare5AR;
				  flare5AR = clamp(flare5AR*flare5ARfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare5AR = pow(flare5AR, 1.9f);
				  flare5AR = sin(flare5AR*3.1415);
				  flare5AR *= sunmask;

				  
				  flare5AR *= flare5ARpow;
				  
				  	color.r += flare5AR*0.2f*flaremultR;
					color.g += flare5AR*0.0f*flaremultG;
					color.b += flare5AR*0.0f*flaremultB;

			//close green ring

			  vec2 flare6ARscale = vec2(0.41f*flarescale, 0.41f*flarescale);
			  float flare6ARpow = 1.0f;
			  float flare6ARfill = 15.0f;
			  float flare6ARoffset = 2.6f;
			vec2 flare6ARpos = vec2(  ((1.0 - lPos.x)*(flare6ARoffset + 1.0) - (flare6ARoffset*0.5))  *aspectRatio*flare6ARscale.x,  ((1.0 - lPos.y)*(flare6ARoffset + 1.0) - (flare6ARoffset*0.5))  *flare6ARscale.y);
			
			
			float flare6AR = distance(flare6ARpos, vec2(texcoord.s*aspectRatio*flare6ARscale.x, texcoord.t*flare6ARscale.y));
				  flare6AR = 0.5 - flare6AR;
				  flare6AR = clamp(flare6AR*flare6ARfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare6AR = pow(flare6AR, 1.9f);
				  flare6AR = sin(flare6AR*3.1415);
				  flare6AR *= sunmask;

				  
				  flare6AR *= flare6ARpow;
				  
				  	color.r += flare6AR*0.0f*flaremultR;
					color.g += flare6AR*0.15f*flaremultG;
					color.b += flare6AR*0.0f*flaremultB;	

			//close blue ring

			  vec2 flare7ARscale = vec2(0.42f*flarescale, 0.42f*flarescale);
			  float flare7ARpow = 1.0f;
			  float flare7ARfill = 15.0f;
			  float flare7ARoffset = 2.6f;
			vec2 flare7ARpos = vec2(  ((1.0 - lPos.x)*(flare7ARoffset + 1.0) - (flare7ARoffset*0.5))  *aspectRatio*flare7ARscale.x,  ((1.0 - lPos.y)*(flare7ARoffset + 1.0) - (flare7ARoffset*0.5))  *flare7ARscale.y);
			
			
			float flare7AR = distance(flare7ARpos, vec2(texcoord.s*aspectRatio*flare7ARscale.x, texcoord.t*flare7ARscale.y));
				  flare7AR = 0.5 - flare7AR;
				  flare7AR = clamp(flare7AR*flare7ARfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare7AR = pow(flare7AR, 1.9f);
				  flare7AR = sin(flare7AR*3.1415);
				  flare7AR *= sunmask;

				  
				  flare7AR *= flare7ARpow;
				  
				  	color.r += flare7AR*0.0f*flaremultR;
					color.g += flare7AR*0.0f*flaremultG;
					color.b += flare7AR*0.2*flaremultB;					
					
	//-//end of the flares//-//
				
					
										
					

			}
}

if (sunvisibility > 0.05) {

//little dots on screen

if (xydist < 1.25) {
vec2 sun_to_center = lightPos-vec2(1.5);
float dir = abs(sin(length(sun_to_center)))*-0.0+-2.0;

for (int i = 0; i < 8; i++) {
vec3 carac = pattern[i]*1.25;
carac.z *= 1.0/1.25;
carac.x /= aspectRatio;
carac *= (0.1 + dir)/0.5;
vec2 coord = carac.xy * sizemult+ lightPos.xy;
float strength = sin(length(coord-vec2(0.5))*40.0)*0.5+0.5;
circles_lens += gen_circular_lens(coord,carac.z*1.0)*strength;

carac = pattern[i];
carac.x /= aspectRatio;
carac.yx *= (2.0 - dir)/2.5;

coord = carac.yx * sizemult + lightPos.xy;
strength = sin(length(coord-vec2(0.5))*40.0)*0.5+0.5;
circles_lens += gen_circular_lens(coord,carac.z*1.0)*strength;


carac = pattern[i];
carac.x /= aspectRatio;
carac.yx *= (1.0 - dir)/5.5;
coord = carac.yx * sizemult + lightPos.xy;
strength = sin(length(coord-vec2(0.5))*40.0)*0.5+0.5;
circles_lens += gen_circular_lens(coord,carac.z*1.0)*strength;
}
color += sunlight*vec3(circles_lens) * sunvisibility * noise * 0.5 ;
}
}

#endif

#ifdef VIGNETTE

float dv = distance(texcoord.st, vec2(0.5, 0.5));

dv *= VIGNETTE_STRENGTH;

dv = 0.9 - dv;

dv = pow(dv, 0.25);

dv *= 2.3;
dv -= 0.9;

color *= dv;
#endif

color = color * BRIGHTMULT;

#ifdef CROSSPROCESS

	color = color * (BRIGHTMULT) + 0.03;
	
	color = color+0.029;
 
	float dbr = -color.r + 1.4;
	float dbg = -color.g + 1.4;
	float dbb = -color.b + 1.4;
	
	float pr = mix(dbr, 0.65, 0.5);
	float pg = mix(dbg, 0.65, 0.5);
	float pb = mix(dbb, 0.65, 0.5);
	
	color.r = pow((color.r * 0.95 - 0.002), pr);
	color.g = pow((color.g * 0.95 - 0.002), pg);
	color.b = pow((color.b * 0.99 + 0.000), pb);
#endif

	//Color boosting
	color.r = (color.r)*(COLOR_BOOST + 1.0) + (color.g + color.b)*(-COLOR_BOOST);
	color.g = (color.g)*(COLOR_BOOST + 1.0) + (color.r + color.b)*(-COLOR_BOOST);
	color.b = (color.b)*(COLOR_BOOST + 1.0) + (color.r + color.g)*(-COLOR_BOOST);

#ifdef HIGHDESATURATE


	//average
	float rgb = max(color.r, max(color.g, color.b))/2 + min(color.r, min(color.g, color.b))/2;

	//adjust black and white image to be brighter
	float bw = pow(rgb, 0.7);

	//mix between per-channel analysis and average analysis
	float rgbr = mix(rgb, color.r, 0.7);
	float rgbg = mix(rgb, color.g, 0.7);
	float rgbb = mix(rgb, color.b, 0.7);

	//calculate crossfade based on lum
	float mixfactorr = max(0.0, (rgbr*2 - 1));
	float mixfactorg = max(0.0, (rgbg*2 - 1));
	float mixfactorb = max(0.0, (rgbb*2 - 1));

	//crossfade between saturated and desaturated image
	float mixr = mix(color.r, bw, mixfactorr);
	float mixg = mix(color.g, bw, mixfactorg);
	float mixb = mix(color.b, bw, mixfactorb);
	
	//undo artifact compensation
	color = max(((color*1.10) - 0.06), 0.0);
	
	//color = color * BRIGHTMULT;

	color.r = pow(color.r, GAMMA);
	color.g = pow(color.g, GAMMA);
	color.b = pow(color.b, GAMMA);
	
	color = color*(1.0 + DARKMULT) - DARKMULT;
	
#endif
	
color = clamp(color,0.0,1.0);

float white = luma(color);
color = color*(1.0+pow(white,CONTRAST))/(2.0-CONTRAST);

color = pow(color,vec3(2.2));
#ifdef TONEMAP

color = color / (color + TONEMAP_CURVE) * (1.0+TONEMAP_CURVE);


#endif

#ifdef COLOR_SAT
vec3 input = color;
float rdist = max(color.r*sqrt(2.0)-length(color.gb),0.0)*(1.0/length(color));
float gdist = max(color.g*sqrt(2.0)-length(color.rb),0.0)*(1.0/length(color));
float bdist = max(color.b*sqrt(2.0)-length(color.rg),0.0)*(1.0/length(color));
color *= (vec3(rdist,gdist,bdist)+SAT)/SAT;

#endif
color = pow(color,vec3(1.0/2.0));
/*
	if (texcoord.x < 0.1 && texcoord.y < 0.1) color.rgb = vec3(texture2D(gaux2,vec2(1.0)).a);
*/

	color.r = color.r*1.10;
    color.g = color.g*1.10; 
    color.b = color.b*1.10;	

	gl_FragColor = vec4(color,1.0);
	
}
