#version 120

varying vec4 color;
varying vec4 texcoord;
varying vec3 depth;

uniform float near;
uniform float far;

void main() {
	vec4 position = gl_ModelViewMatrix * gl_Vertex;

	depth.r = (-position.z - near) / (far - near);

	depth.g = dot(normalize(gl_NormalMatrix * gl_Normal), normalize(vec3(-position.x, -position.y, -position.z)));

	depth.b = 0.0;
	
	gl_Position = gl_ProjectionMatrix * position;
	
	color = gl_Color;
	
	texcoord = gl_TextureMatrix[0] * gl_MultiTexCoord0;

	gl_FogFragCoord = gl_Position.z;
}