#version 120

varying vec4 color;
varying vec4 texcoord;
varying vec4 lmcoord;
varying vec3 depth;
varying float diffuse;

uniform float near;
uniform float far;

attribute vec4 mc_Entity;

void main() {	
	vec4 position = gl_ModelViewMatrix * gl_Vertex;

	depth.r = (-position.z - near) / (far - near);

	vec3 normal = normalize(gl_NormalMatrix * gl_Normal);
	
	if(floor(gl_Vertex.xz) - gl_Vertex.xz != vec2(0.0)){
		if(mc_Entity.x == 50 || mc_Entity.x == 51.0 || mc_Entity.x == 59 || mc_Entity.x == 69 || 
		mc_Entity.x == 75 || mc_Entity.x == 76 || mc_Entity.x == 101 || mc_Entity.x == 102 || 		
		mc_Entity.x == 104 || mc_Entity.x == 105 || mc_Entity.x == 115 || mc_Entity.x == 117 || 
		mc_Entity.x == 127 || mc_Entity.x == 141 || mc_Entity.x == 142){ 
			depth.g = 1.0; 
		}else{
			depth.g = dot(normal, normalize(-position.xyz));
		}
	}else{
		if(mc_Entity.x == 51.0){
			depth.g = 1.0;
		}else{
			depth.g = dot(normal, normalize(-position.xyz));
		}
	}
	depth.b = 0.0;
	
	gl_Position = gl_ProjectionMatrix * position;
	
	texcoord = gl_TextureMatrix[0] * gl_MultiTexCoord0;
	
	color = gl_Color;
	
	lmcoord = gl_TextureMatrix[1] * gl_MultiTexCoord1;
	
	gl_FogFragCoord = gl_Position.z;

}