#version 120

uniform sampler2D texture;
uniform sampler2D lightmap;

varying vec4 color;
varying vec4 texcoord;
varying vec4 lmcoord;
varying vec3 depth;

const int GL_LINEAR = 9729;
const int GL_EXP = 2048;

uniform int fogMode;

vec4 quantize(){
	return vec4(texture2D(lightmap, (floor(12.0 * pow(lmcoord.st, vec2(0.8))) + 0.5) / 12.0).rgb, 1.0);
}


void main() {

	gl_FragData[0] = texture2D(texture, texcoord.st) * color * quantize();

	if (fogMode == GL_EXP) {
		gl_FragData[0].rgb = mix(gl_FragData[0].rgb, gl_Fog.color.rgb, 1.0 - clamp(exp(-gl_Fog.density * gl_FogFragCoord), 0.0, 1.0));
	} else if (fogMode == GL_LINEAR) {
		gl_FragData[0].rgb = mix(gl_FragData[0].rgb, gl_Fog.color.rgb, clamp((gl_FogFragCoord - gl_Fog.start) * gl_Fog.scale, 0.0, 1.0));
	}
	gl_FragData[1] = vec4(depth, 1.0);	
		
}