#version 120

varying vec4 color;
varying vec4 texcoord;
varying vec4 lmcoord;
varying vec4 normal;

varying float distance;

void main() {
	texcoord.st = (gl_TextureMatrix[0] * gl_MultiTexCoord0).st;
	lmcoord.st = (gl_TextureMatrix[1] * gl_MultiTexCoord1).st;

	color = gl_Color;

	vec4 viewVertex = gl_ModelViewMatrix * gl_Vertex;

	distance = length(viewVertex);

	gl_Position = gl_ProjectionMatrix * viewVertex;

	//gl_FogFragCoord = gl_Position.z;
	gl_FogFragCoord = distance;

	normal.xyz = normalize(gl_NormalMatrix * gl_Normal);
}
