#version 120

uniform float rainStrength;
uniform float frameTimeCounter;
uniform vec3 cameraPosition;
uniform mat4 gbufferModelView;
uniform mat4 gbufferModelViewInverse;

attribute vec4 at_tangent;
attribute vec4 mc_Entity;
attribute vec4 mc_midTexCoord;

// entity  8 = flowing water. 9 = still water. 79 = ice.

varying vec4 color;
varying vec4 lmcoord;
varying vec4 vtexcoordam; // .st for add, .pq for mul
varying vec4 vtexcoord;

varying vec4 viewVector;
varying vec4 normal;
varying vec4 tangent1;
varying vec4 tangent2;

varying float distance;

const float PI = 3.1415927;

void main() {
	vec2 texcoord = (gl_TextureMatrix[0] * gl_MultiTexCoord0).st;
	vec2 midcoord = (gl_TextureMatrix[0] * mc_midTexCoord).st;
	vec2 texcoordminusmid = texcoord-midcoord;
	vtexcoordam.pq  = abs(texcoordminusmid)*2;
	vtexcoordam.st  = min(texcoord,midcoord-texcoordminusmid);
	vtexcoord.st    = sign(texcoordminusmid)*0.5+0.5;

	lmcoord.st = (gl_TextureMatrix[1] * gl_MultiTexCoord1).st;

	color = gl_Color;

	vec4 position = gl_ModelViewMatrix * gl_Vertex;
	//vec4 viewpos = gl_ModelViewMatrix * gl_Vertex;

	/* un-rotate */
	vec4 viewpos = gbufferModelViewInverse * position;

	vec3 worldpos = viewpos.xyz + cameraPosition;

	if(mc_Entity.x == 8.0 || mc_Entity.x == 9.0) { 
		vec3 pos = worldpos;
	    float fy = fract(pos.y + 0.001);
	    if (fy > 0.002)
		{
		    /* animate */
		float wave = 0.05 * sin(2*PI/4*frameTimeCounter + 2*PI*2/16*pos.x + 2*PI*5/16*pos.z)
				   + 0.05 * sin(2*PI/3*frameTimeCounter - 2*PI*3/16*pos.x + 2*PI*4/16*pos.z);
			viewpos.y += clamp(wave, -fy, 1.0-fy);
		}
	}

	/* re-rotate */
	vec4 viewVertex = gbufferModelView * viewpos;

	distance = length(viewVertex);

	/* projectify */
	gl_Position = gl_ProjectionMatrix * viewVertex;

	//gl_FogFragCoord = gl_Position.z;
	gl_FogFragCoord = distance;

	normal.xyz = normalize(gl_NormalMatrix * gl_Normal);
	tangent1.xyz = normalize(gl_NormalMatrix * at_tangent.xyz);
	tangent2.xyz = normalize(gl_NormalMatrix * cross(at_tangent.xyz,gl_Normal.xyz) * at_tangent.w);

	mat3 tbnMatrix = mat3(tangent1.x, tangent2.x, normal.x,
                          tangent1.y, tangent2.y, normal.y,
                          tangent1.z, tangent2.z, normal.z);
	
	viewVector.xyz = normalize(tbnMatrix * (gl_ModelViewMatrix * gl_Vertex).xyz);
}
