/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.oredict;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.logging.log4j.Level;

public class OreDictionary {
    private static boolean hasInit = false;
    private static List<String> idToName = new ArrayList<String>();
    private static Map<String, Integer> nameToId = new HashMap<String, Integer>(128);
    private static List<List<adq>> idToStack = Lists.newArrayList();
    private static List<List<adq>> idToStackUn = Lists.newArrayList();
    private static Map<Integer, List<Integer>> stackToId = Maps.newHashMapWithExpectedSize((int)96);
    public static final ImmutableList<adq> EMPTY_LIST = ImmutableList.of();
    public static final int WILDCARD_VALUE = Short.MAX_VALUE;

    private static void initVanillaEntries() {
        if (!hasInit) {
            OreDictionary.registerOre("logWood", new adq(aju.r, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("logWood", new adq(aju.s, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("plankWood", new adq(aju.f, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("slabWood", new adq((ajt)aju.bM, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("stairWood", aju.ad);
            OreDictionary.registerOre("stairWood", aju.bU);
            OreDictionary.registerOre("stairWood", aju.bV);
            OreDictionary.registerOre("stairWood", aju.bW);
            OreDictionary.registerOre("stairWood", aju.cC);
            OreDictionary.registerOre("stairWood", aju.cD);
            OreDictionary.registerOre("stickWood", ads.A);
            OreDictionary.registerOre("treeSapling", new adq(aju.g, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("treeLeaves", new adq((ajt)aju.t, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("treeLeaves", new adq((ajt)aju.u, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("vine", aju.bn);
            OreDictionary.registerOre("oreGold", aju.o);
            OreDictionary.registerOre("oreIron", aju.p);
            OreDictionary.registerOre("oreLapis", aju.x);
            OreDictionary.registerOre("oreDiamond", aju.ag);
            OreDictionary.registerOre("oreRedstone", aju.aC);
            OreDictionary.registerOre("oreEmerald", aju.bP);
            OreDictionary.registerOre("oreQuartz", aju.co);
            OreDictionary.registerOre("oreCoal", aju.q);
            OreDictionary.registerOre("ingotIron", ads.l);
            OreDictionary.registerOre("ingotGold", ads.m);
            OreDictionary.registerOre("ingotBrick", ads.aO);
            OreDictionary.registerOre("ingotBrickNether", ads.cp);
            OreDictionary.registerOre("nuggetGold", ads.bE);
            OreDictionary.registerOre("gemDiamond", ads.k);
            OreDictionary.registerOre("gemEmerald", ads.bY);
            OreDictionary.registerOre("gemQuartz", ads.cq);
            OreDictionary.registerOre("gemPrismarine", ads.cM);
            OreDictionary.registerOre("dustPrismarine", ads.cN);
            OreDictionary.registerOre("dustRedstone", ads.aE);
            OreDictionary.registerOre("dustGlowstone", ads.ba);
            OreDictionary.registerOre("gemLapis", new adq(ads.bd, 1, 4));
            OreDictionary.registerOre("blockGold", aju.R);
            OreDictionary.registerOre("blockIron", aju.S);
            OreDictionary.registerOre("blockLapis", aju.y);
            OreDictionary.registerOre("blockDiamond", aju.ah);
            OreDictionary.registerOre("blockRedstone", aju.cn);
            OreDictionary.registerOre("blockEmerald", aju.bT);
            OreDictionary.registerOre("blockQuartz", aju.cq);
            OreDictionary.registerOre("blockCoal", aju.cA);
            OreDictionary.registerOre("cropWheat", ads.Q);
            OreDictionary.registerOre("cropPotato", ads.cc);
            OreDictionary.registerOre("cropCarrot", ads.cb);
            OreDictionary.registerOre("cropNetherWart", ads.bF);
            OreDictionary.registerOre("sugarcane", ads.aQ);
            OreDictionary.registerOre("blockCactus", (ajt)aju.aK);
            OreDictionary.registerOre("dye", new adq(ads.bd, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("paper", new adq(ads.aR));
            OreDictionary.registerOre("slimeball", ads.aT);
            OreDictionary.registerOre("enderpearl", ads.bB);
            OreDictionary.registerOre("bone", ads.be);
            OreDictionary.registerOre("gunpowder", ads.J);
            OreDictionary.registerOre("string", ads.H);
            OreDictionary.registerOre("netherStar", ads.cj);
            OreDictionary.registerOre("leather", ads.aM);
            OreDictionary.registerOre("feather", ads.I);
            OreDictionary.registerOre("egg", ads.aW);
            OreDictionary.registerOre("record", ads.cA);
            OreDictionary.registerOre("record", ads.cB);
            OreDictionary.registerOre("record", ads.cC);
            OreDictionary.registerOre("record", ads.cD);
            OreDictionary.registerOre("record", ads.cE);
            OreDictionary.registerOre("record", ads.cF);
            OreDictionary.registerOre("record", ads.cG);
            OreDictionary.registerOre("record", ads.cH);
            OreDictionary.registerOre("record", ads.cI);
            OreDictionary.registerOre("record", ads.cJ);
            OreDictionary.registerOre("record", ads.cK);
            OreDictionary.registerOre("record", ads.cL);
            OreDictionary.registerOre("dirt", aju.d);
            OreDictionary.registerOre("grass", (ajt)aju.c);
            OreDictionary.registerOre("stone", aju.b);
            OreDictionary.registerOre("cobblestone", aju.e);
            OreDictionary.registerOre("gravel", aju.n);
            OreDictionary.registerOre("sand", new adq((ajt)aju.m, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("sandstone", new adq(aju.A, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("sandstone", new adq(aju.cM, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("netherrack", aju.aV);
            OreDictionary.registerOre("obsidian", aju.Z);
            OreDictionary.registerOre("glowstone", aju.aX);
            OreDictionary.registerOre("endstone", aju.bH);
            OreDictionary.registerOre("torch", aju.aa);
            OreDictionary.registerOre("workbench", aju.ai);
            OreDictionary.registerOre("blockSlime", aju.cE);
            OreDictionary.registerOre("blockPrismarine", new adq(aju.cI, 1, anp.a.a.a()));
            OreDictionary.registerOre("blockPrismarineBrick", new adq(aju.cI, 1, anp.a.b.a()));
            OreDictionary.registerOre("blockPrismarineDark", new adq(aju.cI, 1, anp.a.c.a()));
            OreDictionary.registerOre("stoneGranite", new adq(aju.b, 1, 1));
            OreDictionary.registerOre("stoneGranitePolished", new adq(aju.b, 1, 2));
            OreDictionary.registerOre("stoneDiorite", new adq(aju.b, 1, 3));
            OreDictionary.registerOre("stoneDioritePolished", new adq(aju.b, 1, 4));
            OreDictionary.registerOre("stoneAndesite", new adq(aju.b, 1, 5));
            OreDictionary.registerOre("stoneAndesitePolished", new adq(aju.b, 1, 6));
            OreDictionary.registerOre("blockGlassColorless", aju.w);
            OreDictionary.registerOre("blockGlass", aju.w);
            OreDictionary.registerOre("blockGlass", new adq((ajt)aju.cG, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("paneGlassColorless", aju.bj);
            OreDictionary.registerOre("paneGlass", aju.bj);
            OreDictionary.registerOre("paneGlass", new adq((ajt)aju.cH, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("chest", (ajt)aju.ae);
            OreDictionary.registerOre("chest", aju.bQ);
            OreDictionary.registerOre("chest", aju.cg);
            OreDictionary.registerOre("chestWood", (ajt)aju.ae);
            OreDictionary.registerOre("chestEnder", aju.bQ);
            OreDictionary.registerOre("chestTrapped", aju.cg);
        }
        HashMap<adq, String> replacements = new HashMap<adq, String>();
        replacements.put(new adq(ads.A), "stickWood");
        replacements.put(new adq(aju.f), "plankWood");
        replacements.put(new adq(aju.f, 1, Short.MAX_VALUE), "plankWood");
        replacements.put(new adq((ajt)aju.bM, 1, Short.MAX_VALUE), "slabWood");
        replacements.put(new adq(ads.m), "ingotGold");
        replacements.put(new adq(ads.l), "ingotIron");
        replacements.put(new adq(ads.k), "gemDiamond");
        replacements.put(new adq(ads.bY), "gemEmerald");
        replacements.put(new adq(ads.cM), "gemPrismarine");
        replacements.put(new adq(ads.cN), "dustPrismarine");
        replacements.put(new adq(ads.aE), "dustRedstone");
        replacements.put(new adq(ads.ba), "dustGlowstone");
        replacements.put(new adq(ads.aQ), "sugarcane");
        replacements.put(new adq((ajt)aju.aK), "blockCactus");
        replacements.put(new adq(ads.aR), "paper");
        replacements.put(new adq(ads.aT), "slimeball");
        replacements.put(new adq(ads.H), "string");
        replacements.put(new adq(ads.aM), "leather");
        replacements.put(new adq(ads.bB), "enderpearl");
        replacements.put(new adq(ads.J), "gunpowder");
        replacements.put(new adq(ads.cj), "netherStar");
        replacements.put(new adq(ads.I), "feather");
        replacements.put(new adq(ads.be), "bone");
        replacements.put(new adq(ads.aW), "egg");
        replacements.put(new adq(aju.b), "stone");
        replacements.put(new adq(aju.e), "cobblestone");
        replacements.put(new adq(aju.e, 1, Short.MAX_VALUE), "cobblestone");
        replacements.put(new adq(aju.aX), "glowstone");
        replacements.put(new adq(aju.w), "blockGlassColorless");
        replacements.put(new adq(aju.cI), "prismarine");
        replacements.put(new adq(aju.b, 1, 1), "stoneGranite");
        replacements.put(new adq(aju.b, 1, 2), "stoneGranitePolished");
        replacements.put(new adq(aju.b, 1, 3), "stoneDiorite");
        replacements.put(new adq(aju.b, 1, 4), "stoneDioritePolished");
        replacements.put(new adq(aju.b, 1, 5), "stoneAndesite");
        replacements.put(new adq(aju.b, 1, 6), "stoneAndesitePolished");
        replacements.put(new adq((ajt)aju.ae), "chestWood");
        replacements.put(new adq(aju.bQ), "chestEnder");
        replacements.put(new adq(aju.cg), "chestTrapped");
        String[] dyes = new String[]{"Black", "Red", "Green", "Brown", "Blue", "Purple", "Cyan", "LightGray", "Gray", "Pink", "Lime", "Yellow", "LightBlue", "Magenta", "Orange", "White"};
        for (int i = 0; i < 16; ++i) {
            adq dye = new adq(ads.bd, 1, i);
            adq block = new adq((ajt)aju.cG, 1, 15 - i);
            adq pane = new adq((ajt)aju.cH, 1, 15 - i);
            if (!hasInit) {
                OreDictionary.registerOre("dye" + dyes[i], dye);
                OreDictionary.registerOre("blockGlass" + dyes[i], block);
                OreDictionary.registerOre("paneGlass" + dyes[i], pane);
            }
            replacements.put(dye, "dye" + dyes[i]);
            replacements.put(block, "blockGlass" + dyes[i]);
            replacements.put(pane, "paneGlass" + dyes[i]);
        }
        hasInit = true;
        adq[] replaceStacks = replacements.keySet().toArray(new adq[replacements.keySet().size()]);
        adq[] exclusions = new adq[]{new adq(aju.y), new adq(ads.bj), new adq(aju.bf), new adq((ajt)aju.U, 1, Short.MAX_VALUE), new adq(aju.aw), new adq(aju.bZ), new adq(aju.aO), new adq(aju.bo), new adq(aju.ad), new adq(aju.aP), new adq(aju.bp), new adq(aju.bU), new adq(aju.bV), new adq(aju.bq), new adq(aju.bV), new adq(aju.aR), new adq(aju.br), new adq(aju.bW), new adq(aju.aT), new adq(aju.bt), new adq(aju.cC), new adq(aju.aS), new adq(aju.bs), new adq(aju.cD), new adq((ajt)aju.bM), new adq(aju.bj), null};
        List recipes = afv.a().b();
        ArrayList<Object> recipesToRemove = new ArrayList<Object>();
        ArrayList<Object> recipesToAdd = new ArrayList<Object>();
        for (Object obj : recipes) {
            adq output;
            afx recipe;
            if (obj.getClass() == afx.class) {
                recipe = (afx)obj;
                output = recipe.b();
                if (output != null && OreDictionary.containsMatch(false, exclusions, output) || !OreDictionary.containsMatch(true, recipe.c, replaceStacks)) continue;
                recipesToRemove.add(recipe);
                recipesToAdd.add(new ShapedOreRecipe(recipe, replacements));
                continue;
            }
            if (obj.getClass() != afy.class || (output = (recipe = (afy)obj).b()) != null && OreDictionary.containsMatch(false, exclusions, output) || !OreDictionary.containsMatch(true, recipe.b.toArray(new adq[recipe.b.size()]), replaceStacks)) continue;
            recipesToRemove.add((afu)obj);
            ShapelessOreRecipe newRecipe = new ShapelessOreRecipe((afy)recipe, replacements);
            recipesToAdd.add(newRecipe);
        }
        recipes.removeAll(recipesToRemove);
        recipes.addAll(recipesToAdd);
        if (recipesToRemove.size() > 0) {
            FMLLog.info("Replaced %d ore recipes", recipesToRemove.size());
        }
    }

    public static int getOreID(String name) {
        Integer val = nameToId.get(name);
        if (val == null) {
            idToName.add(name);
            val = idToName.size() - 1;
            nameToId.put(name, val);
            ArrayList back = Lists.newArrayList();
            idToStack.add(back);
            idToStackUn.add(Collections.unmodifiableList(back));
        }
        return val;
    }

    public static String getOreName(int id) {
        return id >= 0 && id < idToName.size() ? idToName.get(id) : "Unknown";
    }

    public static int[] getOreIDs(adq stack) {
        if (stack == null || stack.b() == null) {
            throw new IllegalArgumentException("Stack can not be null!");
        }
        HashSet<Integer> set = new HashSet<Integer>();
        kl registryName = stack.b().delegate.name();
        if (registryName == null) {
            FMLLog.log(Level.DEBUG, "Attempted to find the oreIDs for an unregistered object (%s). This won't work very well.", stack);
            return new int[0];
        }
        int id = GameData.getItemRegistry().getId(registryName);
        List<Integer> ids = stackToId.get(id);
        if (ids != null) {
            set.addAll(ids);
        }
        if ((ids = stackToId.get(id | stack.h() + 1 << 16)) != null) {
            set.addAll(ids);
        }
        Integer[] tmp = set.toArray(new Integer[set.size()]);
        int[] ret = new int[tmp.length];
        for (int x = 0; x < tmp.length; ++x) {
            ret[x] = tmp[x];
        }
        return ret;
    }

    public static List<adq> getOres(String name) {
        return OreDictionary.getOres(OreDictionary.getOreID(name));
    }

    public static List<adq> getOres(String name, boolean alwaysCreateEntry) {
        if (alwaysCreateEntry) {
            return OreDictionary.getOres(OreDictionary.getOreID(name));
        }
        return nameToId.get(name) != null ? OreDictionary.getOres(OreDictionary.getOreID(name)) : EMPTY_LIST;
    }

    public static boolean doesOreNameExist(String name) {
        return nameToId.get(name) != null;
    }

    public static String[] getOreNames() {
        return idToName.toArray(new String[idToName.size()]);
    }

    private static List<adq> getOres(int id) {
        return idToStackUn.size() > id ? idToStackUn.get(id) : EMPTY_LIST;
    }

    private static boolean containsMatch(boolean strict, adq[] inputs, adq ... targets) {
        for (adq input : inputs) {
            for (adq target : targets) {
                if (!OreDictionary.itemMatches(target, input, strict)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsMatch(boolean strict, List<adq> inputs, adq ... targets) {
        for (adq input : inputs) {
            for (adq target : targets) {
                if (!OreDictionary.itemMatches(target, input, strict)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean itemMatches(adq target, adq input, boolean strict) {
        if (input == null && target != null || input != null && target == null) {
            return false;
        }
        return target.b() == input.b() && (target.h() == Short.MAX_VALUE && !strict || target.h() == input.h());
    }

    public static void registerOre(String name, ado ore) {
        OreDictionary.registerOre(name, new adq(ore));
    }

    public static void registerOre(String name, ajt ore) {
        OreDictionary.registerOre(name, new adq(ore));
    }

    public static void registerOre(String name, adq ore) {
        OreDictionary.registerOreImpl(name, ore);
    }

    private static void registerOreImpl(String name, adq ore) {
        ArrayList ids;
        int hash;
        if ("Unknown".equals(name)) {
            return;
        }
        if (ore == null || ore.b() == null) {
            FMLLog.bigWarning("Invalid registration attempt for an Ore Dictionary item with name %s has occurred. The registration has been denied to prevent crashes. The mod responsible for the registration needs to correct this.", name);
            return;
        }
        int oreID = OreDictionary.getOreID(name);
        kl registryName = ore.b().delegate.name();
        if (registryName == null) {
            FMLLog.bigWarning("A broken ore dictionary registration with name %s has occurred. It adds an item (type: %s) which is currently unknown to the game registry. This dictionary item can only support a single value when registered with ores like this, and NO I am not going to turn this spam off. Just register your ore dictionary entries after the GameRegistry.\nTO USERS: YES this is a BUG in the mod " + Loader.instance().activeModContainer().getName() + " report it to them!", name, ore.b().getClass());
            hash = -1;
        } else {
            hash = GameData.getItemRegistry().getId(registryName);
        }
        if (ore.h() != Short.MAX_VALUE) {
            hash |= ore.h() + 1 << 16;
        }
        if ((ids = stackToId.get(hash)) != null && ids.contains(oreID)) {
            return;
        }
        if (ids == null) {
            ids = Lists.newArrayList();
            stackToId.put(hash, ids);
        }
        ids.add(oreID);
        ore = ore.k();
        idToStack.get(oreID).add(ore);
        MinecraftForge.EVENT_BUS.post(new OreRegisterEvent(name, ore));
    }

    public static void rebakeMap() {
        stackToId.clear();
        for (int id = 0; id < idToStack.size(); ++id) {
            List<adq> ores = idToStack.get(id);
            if (ores == null) continue;
            for (adq ore : ores) {
                ArrayList ids;
                int hash;
                kl name = ore.b().delegate.name();
                if (name == null) {
                    FMLLog.log(Level.DEBUG, "Defaulting unregistered ore dictionary entry for ore dictionary %s: type %s to -1", OreDictionary.getOreName(id), ore.b().getClass());
                    hash = -1;
                } else {
                    hash = GameData.getItemRegistry().getId(name);
                }
                if (ore.h() != Short.MAX_VALUE) {
                    hash |= ore.h() + 1 << 16;
                }
                if ((ids = stackToId.get(hash)) == null) {
                    ids = Lists.newArrayList();
                    stackToId.put(hash, ids);
                }
                ids.add(id);
            }
        }
    }

    static {
        OreDictionary.initVanillaEntries();
    }

    public static class OreRegisterEvent
    extends Event {
        private final String Name;
        private final adq Ore;

        public OreRegisterEvent(String name, adq ore) {
            this.Name = name;
            this.Ore = ore;
        }

        public String getName() {
            return this.Name;
        }

        public adq getOre() {
            return this.Ore;
        }
    }
}

