/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.registry;

import com.google.common.base.Function;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.fml.common.EnhancedRuntimeException;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.StartupQuery;
import net.minecraftforge.fml.common.ZipperUtil;
import net.minecraftforge.fml.common.event.FMLMissingMappingsEvent;
import net.minecraftforge.fml.common.registry.FMLControlledNamespacedRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.common.registry.ObjectHolderRegistry;
import net.minecraftforge.fml.common.registry.RegistryDelegate;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import org.apache.logging.log4j.Level;

public class PersistentRegistryManager {
    public static final kl BLOCKS = new kl("minecraft:blocks");
    public static final kl ITEMS = new kl("minecraft:items");
    public static final kl POTIONS = new kl("minecraft:potions");
    public static final kl BIOMES = new kl("minecraft:biomes");
    public static final kl SOUNDEVENTS = new kl("minecraft:soundevents");
    public static final kl POTIONTYPES = new kl("minecraft:potiontypes");
    public static final kl ENCHANTMENTS = new kl("minecraft:enchantments");

    public static <T extends IForgeRegistryEntry<T>> FMLControlledNamespacedRegistry<T> createRegistry(kl registryName, Class<T> registryType, kl optionalDefaultKey, int minId, int maxId, boolean hasDelegates, IForgeRegistry.AddCallback<T> addCallback, IForgeRegistry.ClearCallback<T> clearCallback, IForgeRegistry.CreateCallback<T> createCallback) {
        return PersistentRegistry.ACTIVE.createRegistry(registryName, registryType, optionalDefaultKey, minId, maxId, addCallback, clearCallback, createCallback);
    }

    static <V extends IForgeRegistryEntry<V>> IForgeRegistry<V> findRegistry(IForgeRegistryEntry<?> entry) {
        Class<?> registryType = entry.getRegistryType();
        FMLControlledNamespacedRegistry<?> registry = PersistentRegistry.ACTIVE.getRegistry(registryType);
        if (registry == null) {
            FMLLog.getLogger().log(Level.ERROR, "Unable to locate registry for registered object of type {}", new Object[]{entry.getClass().getName()});
            throw new IllegalArgumentException("Unable to locate registry for registered object");
        }
        return registry;
    }

    static <V extends IForgeRegistryEntry<V>> IForgeRegistry<V> findRegistryByType(Class<V> registryType) {
        return PersistentRegistry.ACTIVE.getRegistry(registryType);
    }

    public static List<String> injectSnapshot(GameDataSnapshot snapshot, boolean injectFrozenData, boolean isLocalWorld) {
        Class registrySuperType;
        FMLLog.info("Injecting existing block and item data into this %s instance", FMLCommonHandler.instance().getEffectiveSide().isServer() ? "server" : "client");
        HashMap remaps = Maps.newHashMap();
        LinkedHashMap missing = Maps.newLinkedHashMap();
        PersistentRegistryManager.forAllRegistries(PersistentRegistry.ACTIVE, ValidateRegistryFunction.OPERATION);
        PersistentRegistryManager.forAllRegistries(PersistentRegistry.ACTIVE, DumpRegistryFunction.OPERATION);
        PersistentRegistryManager.forAllRegistries(PersistentRegistry.ACTIVE, ResetDelegatesFunction.OPERATION);
        for (Map.Entry<kl, GameDataSnapshot.Entry> snapshotEntry : snapshot.entries.entrySet()) {
            Class registrySuperType2 = PersistentRegistry.ACTIVE.getRegistrySuperType(snapshotEntry.getKey());
            PersistentRegistryManager.loadPersistentDataToStagingRegistry(injectFrozenData, remaps, missing, snapshotEntry, registrySuperType2);
        }
        for (kl dummy : snapshot.entries.get((Object)PersistentRegistryManager.BLOCKS).dummied) {
            Integer id;
            if (((Map)missing.get(BLOCKS)).containsKey(dummy)) {
                id = (Integer)((Map)missing.get(BLOCKS)).remove(dummy);
                PersistentRegistry.STAGING.getRegistry(PersistentRegistryManager.BLOCKS, ajt.class).markDummy(dummy, id, new BlockDummyAir());
                continue;
            }
            if (isLocalWorld) {
                if (!FMLControlledNamespacedRegistry.DEBUG) continue;
                FMLLog.log(Level.DEBUG, "Registry: Resuscitating dummy block %s", dummy);
                continue;
            }
            id = PersistentRegistry.STAGING.getRegistry(PersistentRegistryManager.BLOCKS, ajt.class).getId(dummy);
            FMLLog.log(Level.WARN, "The ID %d is currently locally mapped - it will be replaced with air for this session", id);
            PersistentRegistry.STAGING.getRegistry(PersistentRegistryManager.BLOCKS, ajt.class).markDummy(dummy, id, new BlockDummyAir());
        }
        List<String> missedMappings = Loader.instance().fireMissingMappingEvent((Map)missing.get(BLOCKS), (Map)missing.get(ITEMS), isLocalWorld, (Map)remaps.get(BLOCKS), (Map)remaps.get(ITEMS));
        if (!missedMappings.isEmpty()) {
            return missedMappings;
        }
        if (injectFrozenData) {
            for (Map.Entry missingBlock : ((Map)missing.get(BLOCKS)).entrySet()) {
                kl rl = (kl)missingBlock.getKey();
                Integer id = (Integer)missingBlock.getValue();
                FMLLog.log(Level.DEBUG, "Replacing id %s named as %s with air block. If the mod becomes available again later, it can reload here", id, rl);
                PersistentRegistry.STAGING.getRegistry(PersistentRegistryManager.BLOCKS, ajt.class).markDummy(rl, id, new BlockDummyAir());
            }
        }
        if (injectFrozenData) {
            for (Map.Entry r2 : PersistentRegistry.ACTIVE.registries.entrySet()) {
                registrySuperType = PersistentRegistry.ACTIVE.getRegistrySuperType((kl)r2.getKey());
                PersistentRegistryManager.loadFrozenDataToStagingRegistry(remaps, (kl)r2.getKey(), registrySuperType);
            }
        }
        PersistentRegistryManager.forAllRegistries(PersistentRegistry.STAGING, ValidateRegistryFunction.OPERATION);
        for (Map.Entry r2 : PersistentRegistry.ACTIVE.registries.entrySet()) {
            registrySuperType = PersistentRegistry.ACTIVE.getRegistrySuperType((kl)r2.getKey());
            PersistentRegistryManager.loadRegistry((kl)r2.getKey(), PersistentRegistry.STAGING, PersistentRegistry.ACTIVE, registrySuperType);
        }
        PersistentRegistryManager.forAllRegistries(PersistentRegistry.ACTIVE, DumpRegistryFunction.OPERATION);
        Loader.instance().fireRemapEvent((Map)remaps.get(BLOCKS), (Map)remaps.get(ITEMS), false);
        ObjectHolderRegistry.INSTANCE.applyObjectHolders();
        PersistentRegistry.STAGING.clean();
        return ImmutableList.of();
    }

    private static void forAllRegistries(PersistentRegistry registrySet, Function<Map.Entry<kl, FMLControlledNamespacedRegistry<?>>, Void> operation) {
        for (Map.Entry r2 : registrySet.registries.entrySet()) {
            operation.apply((Object)r2);
        }
    }

    private static <T extends IForgeRegistryEntry<T>> void loadRegistry(final kl registryName, final PersistentRegistry from, final PersistentRegistry to, Class<T> regType) {
        FMLControlledNamespacedRegistry fromRegistry = from.getRegistry(registryName, regType);
        if (fromRegistry == null) {
            FMLControlledNamespacedRegistry toRegistry = to.getRegistry(registryName, regType);
            if (toRegistry == null) {
                throw new EnhancedRuntimeException("Could not find registry to load: " + registryName){
                    private static final long serialVersionUID = 1L;

                    @Override
                    protected void printStackTrace(EnhancedRuntimeException.WrappedPrintStream stream) {
                        stream.println("Looking For: " + registryName);
                        stream.println("Found From:");
                        for (kl name : from.registries.keySet()) {
                            stream.println("  " + name);
                        }
                        stream.println("Found To:");
                        for (kl name : to.registries.keySet()) {
                            stream.println("  " + name);
                        }
                    }
                };
            }
            toRegistry.notifyCallbacks();
        } else {
            FMLControlledNamespacedRegistry toRegistry = to.getOrShallowCopyRegistry(registryName, regType, fromRegistry);
            toRegistry.set(fromRegistry);
        }
    }

    private static <T extends IForgeRegistryEntry<T>> void loadFrozenDataToStagingRegistry(Map<kl, Map<kl, Integer[]>> remaps, kl registryName, Class<T> regType) {
        FMLControlledNamespacedRegistry frozenRegistry = PersistentRegistry.FROZEN.getRegistry(registryName, regType);
        FMLControlledNamespacedRegistry newRegistry = PersistentRegistry.STAGING.getOrShallowCopyRegistry(registryName, regType, frozenRegistry);
        newRegistry.loadIds(frozenRegistry.getEntriesNotIn(newRegistry), Maps.newLinkedHashMap(), remaps.get(registryName), frozenRegistry, registryName);
    }

    private static <T extends IForgeRegistryEntry<T>> void loadPersistentDataToStagingRegistry(boolean injectFrozenData, Map<kl, Map<kl, Integer[]>> remaps, LinkedHashMap<kl, Map<kl, Integer>> missing, Map.Entry<kl, GameDataSnapshot.Entry> snapEntry, Class<T> regType) {
        kl registryName = snapEntry.getKey();
        if ("fml:blocks".equals(registryName.toString())) {
            registryName = BLOCKS;
        } else if ("fml:items".equals(registryName.toString())) {
            registryName = ITEMS;
        } else if ("fmlgr:villagerprofessions".equals(registryName.toString())) {
            registryName = VillagerRegistry.PROFESSIONS;
        }
        FMLControlledNamespacedRegistry currentRegistry = PersistentRegistry.ACTIVE.getRegistry(registryName, regType);
        if (currentRegistry == null) {
            FMLLog.severe("An unknown persistent registry type \"%s\" has been encountered. This Forge instance cannot understand it.", registryName);
            StartupQuery.abort();
            return;
        }
        FMLControlledNamespacedRegistry newRegistry = PersistentRegistry.STAGING.getOrShallowCopyRegistry(registryName, regType, currentRegistry);
        newRegistry.getPersistentSubstitutions().putAll(currentRegistry.getPersistentSubstitutions());
        GameDataSnapshot.Entry snapshotEntry = snapEntry.getValue();
        Sets.SetView substitutions = snapshotEntry.substitutions;
        if (injectFrozenData) {
            substitutions = Sets.union(snapshotEntry.substitutions, currentRegistry.getActiveSubstitutions());
        }
        newRegistry.loadAliases(snapshotEntry.aliases);
        newRegistry.loadBlocked(snapshotEntry.blocked);
        missing.put(registryName, Maps.newLinkedHashMap());
        remaps.put(registryName, Maps.newHashMap());
        newRegistry.loadDummied(snapshotEntry.dummied);
        newRegistry.loadIds(snapshotEntry.ids, missing.get(registryName), remaps.get(registryName), currentRegistry, registryName);
        newRegistry.loadSubstitutions((Set<kl>)substitutions);
    }

    public static boolean isFrozen(FMLControlledNamespacedRegistry<?> registry) {
        return PersistentRegistry.FROZEN.containsRegistry(registry);
    }

    public static void revertToFrozen() {
        if (!PersistentRegistry.FROZEN.isPopulated()) {
            FMLLog.warning("Can't revert to frozen GameData state without freezing first.", new Object[0]);
            return;
        }
        FMLLog.fine("Reverting to frozen data state.", new Object[0]);
        for (Map.Entry r2 : PersistentRegistry.ACTIVE.registries.entrySet()) {
            Class registrySuperType = PersistentRegistry.ACTIVE.getRegistrySuperType((kl)r2.getKey());
            PersistentRegistryManager.loadRegistry((kl)r2.getKey(), PersistentRegistry.FROZEN, PersistentRegistry.ACTIVE, registrySuperType);
        }
        Loader.instance().fireRemapEvent((Map<kl, Integer[]>)ImmutableMap.of(), (Map<kl, Integer[]>)ImmutableMap.of(), true);
        ObjectHolderRegistry.INSTANCE.applyObjectHolders();
        FMLLog.fine("Frozen state restored.", new Object[0]);
    }

    public static void freezeData() {
        FMLLog.fine("Freezing block and item id maps", new Object[0]);
        for (Map.Entry r2 : PersistentRegistry.ACTIVE.registries.entrySet()) {
            Class registrySuperType = PersistentRegistry.ACTIVE.getRegistrySuperType((kl)r2.getKey());
            PersistentRegistryManager.loadRegistry((kl)r2.getKey(), PersistentRegistry.ACTIVE, PersistentRegistry.FROZEN, registrySuperType);
        }
        PersistentRegistryManager.forAllRegistries(PersistentRegistry.FROZEN, ValidateRegistryFunction.OPERATION);
    }

    public static void freezeVanilla() {
        FMLLog.fine("Creating vanilla freeze snapshot", new Object[0]);
        for (Map.Entry r2 : PersistentRegistry.ACTIVE.registries.entrySet()) {
            Class registrySuperType = PersistentRegistry.ACTIVE.getRegistrySuperType((kl)r2.getKey());
            PersistentRegistryManager.loadRegistry((kl)r2.getKey(), PersistentRegistry.ACTIVE, PersistentRegistry.VANILLA, registrySuperType);
        }
        PersistentRegistryManager.forAllRegistries(PersistentRegistry.VANILLA, ValidateRegistryFunction.OPERATION);
        FMLLog.fine("Vanilla freeze snapshot created", new Object[0]);
    }

    public static List<String> processIdRematches(Iterable<FMLMissingMappingsEvent.MissingMapping> missedMappings, boolean isLocalWorld, Map<kl, Integer> missingBlocks, Map<kl, Integer> missingItems, Map<kl, Integer[]> remapBlocks, Map<kl, Integer[]> remapItems) {
        ArrayList failed = Lists.newArrayList();
        ArrayList ignored = Lists.newArrayList();
        ArrayList warned = Lists.newArrayList();
        ArrayList defaulted = Lists.newArrayList();
        PersistentRegistry staging = PersistentRegistry.STAGING;
        PersistentRegistry active = PersistentRegistry.ACTIVE;
        for (FMLMissingMappingsEvent.MissingMapping remap : missedMappings) {
            FMLMissingMappingsEvent.Action action = remap.getAction();
            if (action == FMLMissingMappingsEvent.Action.REMAP) {
                kl newName;
                int currId = -1;
                int newId = -1;
                if (remap.type == GameRegistry.Type.BLOCK) {
                    currId = staging.getRegistry(PersistentRegistryManager.BLOCKS, ajt.class).getId((ajt)remap.getTarget());
                    newName = active.getRegistry(PersistentRegistryManager.BLOCKS, ajt.class).getNameForObject((ajt)remap.getTarget());
                    FMLLog.fine("The Block %s is being remapped to %s.", remap.name, newName);
                    missingBlocks.remove(new kl(remap.name));
                    newId = staging.getRegistry(PersistentRegistryManager.BLOCKS, ajt.class).add(remap.id, newName, (ajt)remap.getTarget());
                    staging.getRegistry(PersistentRegistryManager.BLOCKS, ajt.class).addAlias(remap.resourceLocation, newName);
                } else {
                    if (remap.type != GameRegistry.Type.ITEM) continue;
                    currId = staging.getRegistry(PersistentRegistryManager.ITEMS, ado.class).getId((ado)remap.getTarget());
                    newName = active.getRegistry(PersistentRegistryManager.ITEMS, ado.class).getNameForObject((ado)remap.getTarget());
                    FMLLog.fine("The Item %s is being remapped to %s.", remap.name, newName);
                    missingItems.remove(new kl(remap.name));
                    newId = staging.getRegistry(PersistentRegistryManager.ITEMS, ado.class).add(remap.id, newName, (ado)remap.getTarget());
                    staging.getRegistry(PersistentRegistryManager.ITEMS, ado.class).addAlias(remap.resourceLocation, newName);
                }
                if (newId != remap.id) {
                    throw new IllegalStateException();
                }
                if (currId == newId) continue;
                FMLLog.info("Fixed %s id mismatch %s: %d (init) -> %d (map).", remap.type == GameRegistry.Type.BLOCK ? "block" : "item", newName, currId, newId);
                (remap.type == GameRegistry.Type.BLOCK ? remapBlocks : remapItems).put(newName, new Integer[]{currId, newId});
                continue;
            }
            if (action == FMLMissingMappingsEvent.Action.BLOCKONLY) {
                FMLLog.fine("The ItemBlock %s is no longer present in the game. The residual block will remain", remap.name);
                continue;
            }
            if (action == FMLMissingMappingsEvent.Action.DEFAULT) {
                defaulted.add(remap.name);
            } else if (action == FMLMissingMappingsEvent.Action.IGNORE) {
                ignored.add(remap.name);
            } else if (action == FMLMissingMappingsEvent.Action.FAIL) {
                failed.add(remap.name);
            } else if (action == FMLMissingMappingsEvent.Action.WARN) {
                warned.add(remap.name);
            }
            if (remap.type == GameRegistry.Type.BLOCK) {
                staging.getRegistry(PersistentRegistryManager.BLOCKS, ajt.class).blockId(remap.id);
                continue;
            }
            if (remap.type != GameRegistry.Type.ITEM) continue;
            staging.getRegistry(PersistentRegistryManager.ITEMS, ado.class).blockId(remap.id);
        }
        if (!defaulted.isEmpty()) {
            String text = "Forge Mod Loader detected missing blocks/items.\n\nThere are " + defaulted.size() + " missing blocks and items in this save.\n" + "If you continue the missing blocks/items will get removed.\n" + "A world backup will be automatically created in your saves directory.\n\n" + "Missing Blocks/Items:\n";
            for (String s : defaulted) {
                text = text + s + "\n";
            }
            boolean confirmed = StartupQuery.confirm(text);
            if (!confirmed) {
                StartupQuery.abort();
            }
            try {
                String skip = System.getProperty("fml.doNotBackup");
                if (skip == null || !"true".equals(skip)) {
                    ZipperUtil.backupWorld();
                } else {
                    for (int x = 0; x < 10; ++x) {
                        FMLLog.severe("!!!!!!!!!! UPDATING WORLD WITHOUT DOING BACKUP !!!!!!!!!!!!!!!!", new Object[0]);
                    }
                }
            }
            catch (IOException e2) {
                StartupQuery.notify("The world backup couldn't be created.\n\n" + e2);
                StartupQuery.abort();
            }
            warned.addAll(defaulted);
        }
        if (!failed.isEmpty()) {
            FMLLog.severe("This world contains blocks and items that refuse to be remapped. The world will not be loaded", new Object[0]);
            return failed;
        }
        if (!warned.isEmpty()) {
            FMLLog.warning("This world contains block and item mappings that may cause world breakage", new Object[0]);
            return failed;
        }
        if (!ignored.isEmpty()) {
            FMLLog.fine("There were %d missing mappings that have been ignored", ignored.size());
        }
        return failed;
    }

    public static GameDataSnapshot takeSnapshot() {
        final GameDataSnapshot snap = new GameDataSnapshot();
        PersistentRegistryManager.forAllRegistries(PersistentRegistry.ACTIVE, new Function<Map.Entry<kl, FMLControlledNamespacedRegistry<?>>, Void>(){

            public Void apply(Map.Entry<kl, FMLControlledNamespacedRegistry<?>> input) {
                snap.entries.put(input.getKey(), new GameDataSnapshot.Entry(input.getValue()));
                return null;
            }
        });
        return snap;
    }

    public static <T extends IForgeRegistryEntry<T>> RegistryDelegate<T> makeDelegate(T obj, Class<T> rootClass) {
        return PersistentRegistry.ACTIVE.getRegistry(rootClass).getDelegate(obj, rootClass);
    }

    private static class ResetDelegatesFunction
    implements Function<Map.Entry<kl, FMLControlledNamespacedRegistry<?>>, Void> {
        static final ResetDelegatesFunction OPERATION = new ResetDelegatesFunction();

        private ResetDelegatesFunction() {
        }

        public Void apply(Map.Entry<kl, FMLControlledNamespacedRegistry<?>> input) {
            input.getValue().resetSubstitutionDelegates();
            return null;
        }
    }

    private static class ValidateRegistryFunction
    implements Function<Map.Entry<kl, FMLControlledNamespacedRegistry<?>>, Void> {
        static final ValidateRegistryFunction OPERATION = new ValidateRegistryFunction();

        private ValidateRegistryFunction() {
        }

        public Void apply(Map.Entry<kl, FMLControlledNamespacedRegistry<?>> input) {
            input.getValue().validateContent(input.getKey());
            return null;
        }
    }

    private static class DumpRegistryFunction
    implements Function<Map.Entry<kl, FMLControlledNamespacedRegistry<?>>, Void> {
        static final DumpRegistryFunction OPERATION = new DumpRegistryFunction();

        private DumpRegistryFunction() {
        }

        public Void apply(Map.Entry<kl, FMLControlledNamespacedRegistry<?>> input) {
            input.getValue().dump(input.getKey());
            return null;
        }
    }

    public static class GameDataSnapshot {
        public final Map<kl, Entry> entries = Maps.newHashMap();

        public static class Entry {
            public final Map<kl, Integer> ids;
            public final Set<kl> substitutions;
            public final Map<kl, kl> aliases;
            public final Set<Integer> blocked;
            public final Set<kl> dummied;

            public Entry() {
                this(new HashMap<kl, Integer>(), new HashSet<kl>(), new HashMap<kl, kl>(), new HashSet<Integer>(), new HashSet<kl>());
            }

            public Entry(Map<kl, Integer> ids, Set<kl> substitutions, Map<kl, kl> aliases, Set<Integer> blocked, Set<kl> dummies) {
                this.ids = ids;
                this.substitutions = substitutions;
                this.aliases = aliases;
                this.blocked = blocked;
                this.dummied = dummies;
            }

            public Entry(FMLControlledNamespacedRegistry<?> registry) {
                this.ids = Maps.newHashMap();
                this.substitutions = Sets.newHashSet();
                this.aliases = Maps.newHashMap();
                this.blocked = Sets.newHashSet();
                this.dummied = Sets.newHashSet();
                registry.serializeIds(this.ids);
                registry.serializeSubstitutions(this.substitutions);
                registry.serializeAliases(this.aliases);
                registry.serializeBlockList(this.blocked);
                registry.serializeDummied(this.dummied);
            }
        }
    }

    private static class BlockDummyAir
    extends ajj {
        private BlockDummyAir() {
            this.c("air");
        }
    }

    private static enum PersistentRegistry {
        ACTIVE,
        VANILLA,
        FROZEN,
        STAGING;

        private final BiMap<kl, FMLControlledNamespacedRegistry<?>> registries = HashBiMap.create();
        private final BiMap<Class<? extends IForgeRegistryEntry<?>>, kl> registrySuperTypes = HashBiMap.create();

        private <T extends IForgeRegistryEntry<T>> Class<T> getRegistrySuperType(kl key) {
            return (Class)this.registrySuperTypes.inverse().get((Object)key);
        }

        private <T extends IForgeRegistryEntry<T>> FMLControlledNamespacedRegistry<T> getRegistry(kl key, Class<T> regType) {
            return (FMLControlledNamespacedRegistry)this.registries.get((Object)key);
        }

        private <T extends IForgeRegistryEntry<T>> FMLControlledNamespacedRegistry<T> getOrShallowCopyRegistry(kl key, Class<T> regType, FMLControlledNamespacedRegistry<T> other) {
            if (!this.registries.containsKey((Object)key)) {
                this.registries.put((Object)key, other.makeShallowCopy());
                this.registrySuperTypes.put(regType, (Object)key);
            }
            return this.getRegistry(key, regType);
        }

        private <T extends IForgeRegistryEntry<T>> FMLControlledNamespacedRegistry<T> createRegistry(kl registryName, Class<T> type, kl defaultObjectKey, int minId, int maxId, IForgeRegistry.AddCallback<T> addCallback, IForgeRegistry.ClearCallback<T> clearCallback, IForgeRegistry.CreateCallback<T> createCallback) {
            HashSet parents = Sets.newHashSet();
            this.findSuperTypes(type, parents);
            Sets.SetView overlappedTypes = Sets.intersection((Set)parents, (Set)this.registrySuperTypes.keySet());
            if (!overlappedTypes.isEmpty()) {
                Class foundType = (Class)overlappedTypes.iterator().next();
                FMLLog.severe("Found existing registry of type %1s named %2s, you cannot create a new registry (%3s) with type %4s, as %4s has a parent of that type", foundType, this.registrySuperTypes.get((Object)foundType), registryName, type);
                throw new IllegalArgumentException("Duplicate registry parent type found - you can only have one registry for a particular super type");
            }
            FMLControlledNamespacedRegistry<T> fmlControlledNamespacedRegistry = new FMLControlledNamespacedRegistry<T>(defaultObjectKey, minId, maxId, type, addCallback, clearCallback, createCallback);
            this.registries.put((Object)registryName, fmlControlledNamespacedRegistry);
            this.registrySuperTypes.put(type, (Object)registryName);
            return this.getRegistry(registryName, type);
        }

        private void findSuperTypes(Class<?> type, Set<Class<?>> types) {
            if (type == null || type == Object.class) {
                return;
            }
            types.add(type);
            for (Class<?> interfac : type.getInterfaces()) {
                this.findSuperTypes(interfac, types);
            }
            this.findSuperTypes(type.getSuperclass(), types);
        }

        void clean() {
            this.registries.clear();
            this.registrySuperTypes.clear();
        }

        boolean isPopulated() {
            return !this.registries.isEmpty();
        }

        boolean containsRegistry(FMLControlledNamespacedRegistry<?> registry) {
            return this.registries.containsValue(registry);
        }

        public <T extends IForgeRegistryEntry<T>> FMLControlledNamespacedRegistry<T> getRegistry(Class<T> rootClass) {
            kl rl = (kl)this.registrySuperTypes.get(rootClass);
            return this.getRegistry(rl, rootClass);
        }
    }
}

