/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import com.google.common.base.Strings;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.RegistryDelegate;
import org.apache.logging.log4j.Level;

public abstract class FluidRegistry {
    static int maxID = 0;
    static BiMap<String, Fluid> fluids = HashBiMap.create();
    static BiMap<Fluid, Integer> fluidIDs = HashBiMap.create();
    static BiMap<Integer, String> fluidNames = HashBiMap.create();
    static BiMap<ajt, Fluid> fluidBlocks;
    static BiMap<String, Fluid> masterFluidReference;
    static BiMap<String, String> defaultFluidName;
    static Map<Fluid, FluidDelegate> delegates;
    static boolean universalBucketEnabled;
    static Set<Fluid> bucketFluids;
    public static final Fluid WATER;
    public static final Fluid LAVA;

    private FluidRegistry() {
    }

    public static void initFluidIDs(BiMap<Fluid, Integer> newfluidIDs, Set<String> defaultNames) {
        maxID = newfluidIDs.size();
        FluidRegistry.loadFluidDefaults(newfluidIDs, defaultNames);
    }

    private static void loadFluidDefaults(BiMap<Fluid, Integer> localFluidIDs, Set<String> defaultNames) {
        if (defaultNames.isEmpty()) {
            defaultNames.addAll(defaultFluidName.values());
        }
        HashBiMap localFluids = HashBiMap.create(fluids);
        for (String defaultName : defaultNames) {
            Fluid fluid = (Fluid)masterFluidReference.get((Object)defaultName);
            if (fluid == null) {
                String derivedName = defaultName.split(":", 2)[1];
                String localDefault = (String)defaultFluidName.get((Object)derivedName);
                if (localDefault == null) {
                    FMLLog.getLogger().log(Level.ERROR, "The fluid {} (specified as {}) is missing from this instance - it will be removed", new Object[]{derivedName, defaultName});
                    continue;
                }
                fluid = (Fluid)masterFluidReference.get((Object)localDefault);
                FMLLog.getLogger().log(Level.ERROR, "The fluid {} specified as default is not present - it will be reverted to default {}", new Object[]{defaultName, localDefault});
            }
            FMLLog.getLogger().log(Level.DEBUG, "The fluid {} has been selected as the default fluid for {}", new Object[]{defaultName, fluid.getName()});
            Fluid oldFluid = (Fluid)localFluids.put((Object)fluid.getName(), (Object)fluid);
            Integer id = (Integer)localFluidIDs.remove((Object)oldFluid);
            localFluidIDs.put((Object)fluid, (Object)id);
        }
        HashBiMap localFluidNames = HashBiMap.create();
        for (Map.Entry e : localFluidIDs.entrySet()) {
            localFluidNames.put(e.getValue(), (Object)((Fluid)e.getKey()).getName());
        }
        fluidIDs = localFluidIDs;
        fluids = localFluids;
        fluidNames = localFluidNames;
        fluidBlocks = null;
        for (FluidDelegate fd2 : delegates.values()) {
            fd2.rebind();
        }
    }

    public static boolean registerFluid(Fluid fluid) {
        masterFluidReference.put((Object)FluidRegistry.uniqueName(fluid), (Object)fluid);
        delegates.put(fluid, new FluidDelegate(fluid, fluid.getName()));
        if (fluids.containsKey((Object)fluid.getName())) {
            return false;
        }
        fluids.put((Object)fluid.getName(), (Object)fluid);
        fluidIDs.put((Object)fluid, (Object)(++maxID));
        fluidNames.put((Object)maxID, (Object)fluid.getName());
        defaultFluidName.put((Object)fluid.getName(), (Object)FluidRegistry.uniqueName(fluid));
        MinecraftForge.EVENT_BUS.post(new FluidRegisterEvent(fluid.getName(), maxID));
        return true;
    }

    private static String uniqueName(Fluid fluid) {
        ModContainer activeModContainer = Loader.instance().activeModContainer();
        String activeModContainerName = activeModContainer == null ? "minecraft" : activeModContainer.getModId();
        return activeModContainerName + ":" + fluid.getName();
    }

    public static boolean isFluidDefault(Fluid fluid) {
        return fluids.containsValue((Object)fluid);
    }

    public static boolean isFluidRegistered(Fluid fluid) {
        return fluid != null && fluids.containsKey((Object)fluid.getName());
    }

    public static boolean isFluidRegistered(String fluidName) {
        return fluids.containsKey((Object)fluidName);
    }

    public static Fluid getFluid(String fluidName) {
        return (Fluid)fluids.get((Object)fluidName);
    }

    @Deprecated
    public static Fluid getFluid(int fluidID) {
        return (Fluid)fluidIDs.inverse().get((Object)fluidID);
    }

    @Deprecated
    public static int getFluidID(Fluid fluid) {
        Integer ret = (Integer)fluidIDs.get((Object)fluid);
        if (ret == null) {
            throw new RuntimeException("Attempted to access ID for unregistered fluid, Stop using this method modder!");
        }
        return ret;
    }

    @Deprecated
    public static int getFluidID(String fluidName) {
        Integer ret = (Integer)fluidIDs.get((Object)FluidRegistry.getFluid(fluidName));
        if (ret == null) {
            throw new RuntimeException("Attempted to access ID for unregistered fluid, Stop using this method modder!");
        }
        return ret;
    }

    public static String getFluidName(Fluid fluid) {
        return (String)fluids.inverse().get((Object)fluid);
    }

    public static String getFluidName(FluidStack stack) {
        return FluidRegistry.getFluidName(stack.getFluid());
    }

    public static FluidStack getFluidStack(String fluidName, int amount) {
        if (!fluids.containsKey((Object)fluidName)) {
            return null;
        }
        return new FluidStack(FluidRegistry.getFluid(fluidName), amount);
    }

    public static Map<String, Fluid> getRegisteredFluids() {
        return ImmutableMap.copyOf(fluids);
    }

    @Deprecated
    public static Map<Fluid, Integer> getRegisteredFluidIDs() {
        return ImmutableMap.copyOf(fluidIDs);
    }

    public static void enableUniversalBucket() {
        if (Loader.instance().hasReachedState(LoaderState.PREINITIALIZATION)) {
            FMLLog.getLogger().log(Level.ERROR, "Trying to activate the universal filled bucket too late. Call it statically in your Mods class. Mod: {}", new Object[]{Loader.instance().activeModContainer().getName()});
        } else {
            universalBucketEnabled = true;
        }
    }

    public static boolean isUniversalBucketEnabled() {
        return universalBucketEnabled;
    }

    public static boolean addBucketForFluid(Fluid fluid) {
        if (fluid == null) {
            return false;
        }
        if (!FluidRegistry.isFluidRegistered(fluid)) {
            FluidRegistry.registerFluid(fluid);
        }
        return bucketFluids.add(fluid);
    }

    public static Set<Fluid> getBucketFluids() {
        return ImmutableSet.copyOf(bucketFluids);
    }

    public static Fluid lookupFluidForBlock(ajt block) {
        if (fluidBlocks == null) {
            HashBiMap tmp = HashBiMap.create();
            for (Fluid fluid : fluids.values()) {
                if (!fluid.canBePlacedInWorld() || fluid.getBlock() == null) continue;
                tmp.put((Object)fluid.getBlock(), (Object)fluid);
            }
            fluidBlocks = tmp;
        }
        return (Fluid)fluidBlocks.get((Object)block);
    }

    public static int getMaxID() {
        return maxID;
    }

    public static String getDefaultFluidName(Fluid key) {
        String name = (String)masterFluidReference.inverse().get((Object)key);
        if (Strings.isNullOrEmpty((String)name)) {
            FMLLog.getLogger().log(Level.ERROR, "The fluid registry is corrupted. A fluid {} {} is not properly registered. The mod that registered this is broken", new Object[]{key.getClass().getName(), key.getName()});
            throw new IllegalStateException("The fluid registry is corrupted");
        }
        return name;
    }

    public static void loadFluidDefaults(dq tag) {
        HashSet defaults = Sets.newHashSet();
        if (tag.b("DefaultFluidList", 9)) {
            FMLLog.getLogger().log(Level.DEBUG, "Loading persistent fluid defaults from world");
            dw tl = tag.c("DefaultFluidList", 8);
            for (int i = 0; i < tl.c(); ++i) {
                defaults.add(tl.g(i));
            }
        } else {
            FMLLog.getLogger().log(Level.DEBUG, "World is missing persistent fluid defaults - using local defaults");
        }
        FluidRegistry.loadFluidDefaults((BiMap<Fluid, Integer>)HashBiMap.create(fluidIDs), defaults);
    }

    public static void writeDefaultFluidList(dq forgeData) {
        dw tagList = new dw();
        for (Map.Entry def : fluids.entrySet()) {
            tagList.a((ed)new ec(FluidRegistry.getDefaultFluidName((Fluid)def.getValue())));
        }
        forgeData.a("DefaultFluidList", (ed)tagList);
    }

    public static void validateFluidRegistry() {
        HashSet illegalFluids = Sets.newHashSet();
        for (Fluid f : fluids.values()) {
            if (masterFluidReference.containsValue((Object)f)) continue;
            illegalFluids.add(f);
        }
        if (!illegalFluids.isEmpty()) {
            FMLLog.getLogger().log(Level.FATAL, "The fluid registry is corrupted. Something has inserted a fluid without registering it");
            FMLLog.getLogger().log(Level.FATAL, "There is {} unregistered fluids", new Object[]{illegalFluids.size()});
            for (Fluid f : illegalFluids) {
                FMLLog.getLogger().log(Level.FATAL, "  Fluid name : {}, type: {}", new Object[]{f.getName(), f.getClass().getName()});
            }
            FMLLog.getLogger().log(Level.FATAL, "The mods that own these fluids need to register them properly");
            throw new IllegalStateException("The fluid map contains fluids unknown to the master fluid registry");
        }
    }

    static RegistryDelegate<Fluid> makeDelegate(Fluid fl) {
        return delegates.get(fl);
    }

    static {
        masterFluidReference = HashBiMap.create();
        defaultFluidName = HashBiMap.create();
        delegates = Maps.newHashMap();
        universalBucketEnabled = false;
        bucketFluids = Sets.newHashSet();
        WATER = new Fluid("water", new kl("blocks/water_still"), new kl("blocks/water_flow")){

            @Override
            public String getLocalizedName(FluidStack fs) {
                return dk.a((String)"tile.water.name");
            }
        }.setBlock((ajt)aju.j).setUnlocalizedName(aju.j.a());
        LAVA = new Fluid("lava", new kl("blocks/lava_still"), new kl("blocks/lava_flow")){

            @Override
            public String getLocalizedName(FluidStack fs) {
                return dk.a((String)"tile.lava.name");
            }
        }.setBlock((ajt)aju.l).setLuminosity(15).setDensity(3000).setViscosity(6000).setTemperature(1300).setUnlocalizedName(aju.l.a());
        FluidRegistry.registerFluid(WATER);
        FluidRegistry.registerFluid(LAVA);
    }

    private static class FluidDelegate
    implements RegistryDelegate<Fluid> {
        private String name;
        private Fluid fluid;

        FluidDelegate(Fluid fluid, String name) {
            this.fluid = fluid;
            this.name = name;
        }

        @Override
        public Fluid get() {
            return this.fluid;
        }

        @Override
        public kl name() {
            return new kl(this.name);
        }

        @Override
        public Class<Fluid> type() {
            return Fluid.class;
        }

        void rebind() {
            this.fluid = (Fluid)fluids.get((Object)this.name);
        }
    }

    public static class FluidRegisterEvent
    extends Event {
        private final String fluidName;
        private final int fluidID;

        public FluidRegisterEvent(String fluidName, int fluidID) {
            this.fluidName = fluidName;
            this.fluidID = fluidID;
        }

        public String getFluidName() {
            return this.fluidName;
        }

        public int getFluidID() {
            return this.fluidID;
        }
    }
}

