/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.world;

import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.List;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BlockEvent
extends Event {
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("forge.debugBlockEvent", "false"));
    private final aht world;
    private final cl pos;
    private final ard state;

    public BlockEvent(aht world, cl pos, ard state) {
        this.pos = pos;
        this.world = world;
        this.state = state;
    }

    public aht getWorld() {
        return this.world;
    }

    public cl getPos() {
        return this.pos;
    }

    public ard getState() {
        return this.state;
    }

    @Cancelable
    public static class NeighborNotifyEvent
    extends BlockEvent {
        private final EnumSet<cs> notifiedSides;

        public NeighborNotifyEvent(aht world, cl pos, ard state, EnumSet<cs> notifiedSides) {
            super(world, pos, state);
            this.notifiedSides = notifiedSides;
        }

        public EnumSet<cs> getNotifiedSides() {
            return this.notifiedSides;
        }
    }

    @Cancelable
    public static class MultiPlaceEvent
    extends PlaceEvent {
        private final List<BlockSnapshot> blockSnapshots;

        public MultiPlaceEvent(List<BlockSnapshot> blockSnapshots, ard placedAgainst, zj player) {
            super(blockSnapshots.get(0), placedAgainst, player);
            this.blockSnapshots = ImmutableList.copyOf(blockSnapshots);
            if (DEBUG) {
                System.out.printf("Created MultiPlaceEvent - [PlacedAgainst: %s ][ItemInHand: %s ][Player: %s ]\n", placedAgainst, this.getItemInHand(), player);
            }
        }

        public List<BlockSnapshot> getReplacedBlockSnapshots() {
            return this.blockSnapshots;
        }
    }

    @Cancelable
    public static class PlaceEvent
    extends BlockEvent {
        private final zj player;
        private final adq itemInHand;
        private final BlockSnapshot blockSnapshot;
        private final ard placedBlock;
        private final ard placedAgainst;

        public PlaceEvent(BlockSnapshot blockSnapshot, ard placedAgainst, zj player) {
            super(blockSnapshot.getWorld(), blockSnapshot.getPos(), blockSnapshot.getCurrentBlock());
            this.player = player;
            this.itemInHand = player.cc();
            this.blockSnapshot = blockSnapshot;
            this.placedBlock = blockSnapshot.getCurrentBlock();
            this.placedAgainst = placedAgainst;
            if (DEBUG) {
                System.out.printf("Created PlaceEvent - [PlacedBlock: %s ][PlacedAgainst: %s ][ItemStack: %s ][Player: %s ]\n", this.getPlacedBlock(), placedAgainst, this.getItemInHand(), player);
            }
        }

        public zj getPlayer() {
            return this.player;
        }

        public adq getItemInHand() {
            return this.itemInHand;
        }

        public BlockSnapshot getBlockSnapshot() {
            return this.blockSnapshot;
        }

        public ard getPlacedBlock() {
            return this.placedBlock;
        }

        public ard getPlacedAgainst() {
            return this.placedAgainst;
        }
    }

    @Cancelable
    public static class BreakEvent
    extends BlockEvent {
        private final zj player;
        private int exp;

        public BreakEvent(aht world, cl pos, ard state, zj player) {
            super(world, pos, state);
            this.player = player;
            if (state == null || !ForgeHooks.canHarvestBlock(state.t(), player, (ahx)world, pos) || state.t().canSilkHarvest(world, pos, world.o(pos), player) && ago.a((agm)agq.r, (adq)player.cc()) > 0) {
                this.exp = 0;
            } else {
                int bonusLevel = ago.a((agm)agq.t, (adq)player.cc());
                this.exp = state.t().getExpDrop(state, (ahx)world, pos, bonusLevel);
            }
        }

        public zj getPlayer() {
            return this.player;
        }

        public int getExpToDrop() {
            return this.isCanceled() ? 0 : this.exp;
        }

        public void setExpToDrop(int exp) {
            this.exp = exp;
        }
    }

    public static class HarvestDropsEvent
    extends BlockEvent {
        private final int fortuneLevel;
        private final List<adq> drops;
        private final boolean isSilkTouching;
        private float dropChance;
        private final zj harvester;

        public HarvestDropsEvent(aht world, cl pos, ard state, int fortuneLevel, float dropChance, List<adq> drops, zj harvester, boolean isSilkTouching) {
            super(world, pos, state);
            this.fortuneLevel = fortuneLevel;
            this.setDropChance(dropChance);
            this.drops = drops;
            this.isSilkTouching = isSilkTouching;
            this.harvester = harvester;
        }

        public int getFortuneLevel() {
            return this.fortuneLevel;
        }

        public List<adq> getDrops() {
            return this.drops;
        }

        public boolean isSilkTouching() {
            return this.isSilkTouching;
        }

        public float getDropChance() {
            return this.dropChance;
        }

        public void setDropChance(float dropChance) {
            this.dropChance = dropChance;
        }

        public zj getHarvester() {
            return this.harvester;
        }
    }
}

