/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.entity.player;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;

public class PlayerInteractEvent
extends PlayerEvent {
    private final qm hand;
    private final adq stack;
    private final cl pos;
    private final cs face;

    private PlayerInteractEvent(zj player, qm hand, adq stack, cl pos, cs face) {
        super((zj)Preconditions.checkNotNull((Object)player, (Object)"Null player in PlayerInteractEvent!"));
        this.hand = (qm)Preconditions.checkNotNull((Object)hand, (Object)"Null hand in PlayerInteractEvent!");
        this.stack = stack;
        this.pos = (cl)Preconditions.checkNotNull((Object)pos, (Object)"Null position in PlayerInteractEvent!");
        this.face = face;
    }

    public qm getHand() {
        return this.hand;
    }

    @Nullable
    public adq getItemStack() {
        return this.stack;
    }

    public cl getPos() {
        return this.pos;
    }

    @Nullable
    public cs getFace() {
        return this.face;
    }

    public aht getWorld() {
        return this.getEntityPlayer().e();
    }

    public Side getSide() {
        return this.getWorld().E ? Side.CLIENT : Side.SERVER;
    }

    @Cancelable
    public static class LeftClickBlock
    extends PlayerInteractEvent {
        private Event.Result useBlock = Event.Result.DEFAULT;
        private Event.Result useItem = Event.Result.DEFAULT;
        private final bbh hitVec;

        public LeftClickBlock(zj player, cl pos, cs face, bbh hitVec) {
            super(player, qm.a, player.b(qm.a), pos, face);
            this.hitVec = hitVec;
        }

        public bbh getHitVec() {
            return this.hitVec;
        }

        public Event.Result getUseBlock() {
            return this.useBlock;
        }

        public Event.Result getUseItem() {
            return this.useItem;
        }

        public void setUseBlock(Event.Result triggerBlock) {
            this.useBlock = triggerBlock;
        }

        public void setUseItem(Event.Result triggerItem) {
            this.useItem = triggerItem;
        }

        @Override
        public void setCanceled(boolean canceled) {
            super.setCanceled(canceled);
            this.useBlock = Event.Result.DENY;
            this.useItem = Event.Result.DENY;
        }
    }

    public static class RightClickEmpty
    extends PlayerInteractEvent {
        public RightClickEmpty(zj player, qm hand) {
            super(player, hand, null, new cl((rr)player), null);
        }
    }

    @Cancelable
    public static class RightClickItem
    extends PlayerInteractEvent {
        public RightClickItem(zj player, qm hand, adq stack) {
            super(player, hand, stack, new cl((rr)player), null);
        }
    }

    @Cancelable
    public static class RightClickBlock
    extends PlayerInteractEvent {
        private Event.Result useBlock = Event.Result.DEFAULT;
        private Event.Result useItem = Event.Result.DEFAULT;
        private final bbh hitVec;

        public RightClickBlock(zj player, qm hand, adq stack, cl pos, cs face, bbh hitVec) {
            super(player, hand, stack, pos, face);
            this.hitVec = hitVec;
        }

        public bbh getHitVec() {
            return this.hitVec;
        }

        public Event.Result getUseBlock() {
            return this.useBlock;
        }

        public Event.Result getUseItem() {
            return this.useItem;
        }

        public void setUseBlock(Event.Result triggerBlock) {
            this.useBlock = triggerBlock;
        }

        public void setUseItem(Event.Result triggerItem) {
            this.useItem = triggerItem;
        }

        @Override
        public void setCanceled(boolean canceled) {
            super.setCanceled(canceled);
            this.useBlock = Event.Result.DENY;
            this.useItem = Event.Result.DENY;
        }
    }

    @Cancelable
    public static class EntityInteract
    extends PlayerInteractEvent {
        private final rr target;

        public EntityInteract(zj player, qm hand, adq stack, rr target) {
            super(player, hand, stack, new cl(target), null);
            this.target = target;
        }

        public rr getTarget() {
            return this.target;
        }
    }

    @Cancelable
    public static class EntityInteractSpecific
    extends PlayerInteractEvent {
        private final bbh localPos;
        private final rr target;

        public EntityInteractSpecific(zj player, qm hand, adq stack, rr target, bbh localPos) {
            super(player, hand, stack, new cl(target), null);
            this.localPos = localPos;
            this.target = target;
        }

        public bbh getLocalPos() {
            return this.localPos;
        }

        public rr getTarget() {
            return this.target;
        }
    }
}

