/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.entity.player;

import java.io.File;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.Cancelable;

public class PlayerEvent
extends LivingEvent {
    private final zj entityPlayer;

    public PlayerEvent(zj player) {
        super((sa)player);
        this.entityPlayer = player;
    }

    public zj getEntityPlayer() {
        return this.entityPlayer;
    }

    public static class SaveToFile
    extends PlayerEvent {
        private final File playerDirectory;
        private final String playerUUID;

        public SaveToFile(zj player, File originDirectory, String playerUUID) {
            super(player);
            this.playerDirectory = originDirectory;
            this.playerUUID = playerUUID;
        }

        public File getPlayerFile(String suffix) {
            if ("dat".equals(suffix)) {
                throw new IllegalArgumentException("The suffix 'dat' is reserved");
            }
            return new File(this.getPlayerDirectory(), this.getPlayerUUID() + "." + suffix);
        }

        public File getPlayerDirectory() {
            return this.playerDirectory;
        }

        public String getPlayerUUID() {
            return this.playerUUID;
        }
    }

    public static class LoadFromFile
    extends PlayerEvent {
        private final File playerDirectory;
        private final String playerUUID;

        public LoadFromFile(zj player, File originDirectory, String playerUUID) {
            super(player);
            this.playerDirectory = originDirectory;
            this.playerUUID = playerUUID;
        }

        public File getPlayerFile(String suffix) {
            if ("dat".equals(suffix)) {
                throw new IllegalArgumentException("The suffix 'dat' is reserved");
            }
            return new File(this.getPlayerDirectory(), this.getPlayerUUID() + "." + suffix);
        }

        public File getPlayerDirectory() {
            return this.playerDirectory;
        }

        public String getPlayerUUID() {
            return this.playerUUID;
        }
    }

    public static class StopTracking
    extends PlayerEvent {
        private final rr target;

        public StopTracking(zj player, rr target) {
            super(player);
            this.target = target;
        }

        public rr getTarget() {
            return this.target;
        }
    }

    public static class StartTracking
    extends PlayerEvent {
        private final rr target;

        public StartTracking(zj player, rr target) {
            super(player);
            this.target = target;
        }

        public rr getTarget() {
            return this.target;
        }
    }

    public static class Clone
    extends PlayerEvent {
        private final zj original;
        private final boolean wasDeath;

        public Clone(zj _new, zj oldPlayer, boolean wasDeath) {
            super(_new);
            this.original = oldPlayer;
            this.wasDeath = wasDeath;
        }

        public zj getOriginal() {
            return this.original;
        }

        public boolean isWasDeath() {
            return this.wasDeath;
        }
    }

    public static class NameFormat
    extends PlayerEvent {
        private final String username;
        private String displayname;

        public NameFormat(zj player, String username) {
            super(player);
            this.username = username;
            this.setDisplayname(username);
        }

        public String getUsername() {
            return this.username;
        }

        public String getDisplayname() {
            return this.displayname;
        }

        public void setDisplayname(String displayname) {
            this.displayname = displayname;
        }
    }

    @Cancelable
    public static class BreakSpeed
    extends PlayerEvent {
        private final ard state;
        private final float originalSpeed;
        private float newSpeed = 0.0f;
        private final cl pos;

        public BreakSpeed(zj player, ard state, float original, cl pos) {
            super(player);
            this.state = state;
            this.originalSpeed = original;
            this.setNewSpeed(original);
            this.pos = pos;
        }

        public ard getState() {
            return this.state;
        }

        public float getOriginalSpeed() {
            return this.originalSpeed;
        }

        public float getNewSpeed() {
            return this.newSpeed;
        }

        public void setNewSpeed(float newSpeed) {
            this.newSpeed = newSpeed;
        }

        public cl getPos() {
            return this.pos;
        }
    }

    public static class HarvestCheck
    extends PlayerEvent {
        private final ard state;
        private boolean success;

        public HarvestCheck(zj player, ard state, boolean success) {
            super(player);
            this.state = state;
            this.success = success;
        }

        public ard getTargetBlock() {
            return this.state;
        }

        public boolean canHarvest() {
            return this.success;
        }

        public void setCanHarvest(boolean success) {
            this.success = success;
        }
    }
}

